/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.result.STSConfigGroupNameTree;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;

public class ListSTSConfigurationGroups
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(ListSTSConfigurationGroups.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSConfigurationGroups(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSConfigurationGroups(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        ListSTSConfigurationGroups.trEntry(method);
        String[] namePath = (String[])this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            ListSTSConfigurationGroups.trExit(method);
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (namePath != null && (subRoot = ListSTSConfigurationGroups.getConfiguration(configGroup, namePath)) == null) {
            this.processError(ListSTSConfigurationGroups.instantiateCommandException("wssecurity.admin.sts.CWWSI9054W"));
            ListSTSConfigurationGroups.trExit(method);
            return;
        }
        STSConfigGroupNameTree nameTree = new STSConfigGroupNameTree(subRoot);
        this.setResult(nameTree);
        ListSTSConfigurationGroups.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

