/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.List;
import java.util.NoSuchElementException;

public class EditSTSEndpointTrustAuthenticationRule
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(EditSTSEndpointTrustAuthenticationRule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public EditSTSEndpointTrustAuthenticationRule(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public EditSTSEndpointTrustAuthenticationRule(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        String issuerURI = null;
        String newIssuer = null;
        String tokenTypeURI = null;
        String newTokenTypeURI = null;
        String newJAASConfigName = null;
        String newCallbackHandler = null;
        try {
            issuerURI = (String)this.getParameter("issuer");
            newIssuer = (String)this.getParameter("newIssuer");
            tokenTypeURI = (String)this.getParameter("tokenTypeURI");
            newTokenTypeURI = (String)this.getParameter("newTokenTypeURI");
            newJAASConfigName = (String)this.getParameter("newJAASConfigName");
            newCallbackHandler = (String)this.getParameter("newCallbackHandler");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
            Tr.debug(tc, "Command arg (newIssuer) - " + newIssuer);
            Tr.debug(tc, "Command arg (tokenTypeURI) - " + tokenTypeURI);
            Tr.debug(tc, "Command arg (newTokenTypeURI) - " + newTokenTypeURI);
            Tr.debug(tc, "Command arg (newJAASConfigName) - " + newJAASConfigName);
            Tr.debug(tc, "Command arg (newCallbackHandler) - " + newCallbackHandler);
        }
        if (newIssuer == null && newTokenTypeURI == null && newJAASConfigName == null && newCallbackHandler == null) {
            this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9067W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (newIssuer != null && issuerURI == null) {
            this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9065W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if ((newTokenTypeURI != null || newJAASConfigName != null || newCallbackHandler != null) && tokenTypeURI == null) {
            this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9064W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Target startTarget = null;
        try {
            startTarget = this.findTarget(targetMap, endpointURI);
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find Target: " + e.getMessage());
            }
            this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        List<TokenTypeRule> ttRules = null;
        if (issuerURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issuer parameter is null. Looking through DefaultIssuerRule.");
            }
            DefaultIssuerRule defaultRule = null;
            try {
                defaultRule = this.findDefaultIssuerRule(targetMap, startTarget, null);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find DefaultIssuerRule: " + e.getLocalizedMessage());
                }
                this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            ttRules = defaultRule.getTokenTypeRule();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issuer parameter is not null. Looking through IssuerRule elements.");
            }
            IssuerRule iRule = null;
            try {
                iRule = this.findIssuerRule(targetMap, startTarget, null, issuerURI);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find IssuerRule: " + e.getLocalizedMessage());
                }
                this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            ttRules = iRule.getTokenTypeRule();
            if (newIssuer != null) {
                try {
                    this.findIssuerRule(targetMap, startTarget, null, newIssuer);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Issuer URI exists. Cannot perform the edit.");
                    }
                    this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9073W"));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                catch (NoSuchElementException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Issuer URI does not yet exist. Ok to update original issuer rule.");
                        Tr.debug(tc, "Updating issuerURI to: " + newIssuer);
                    }
                    iRule.setIssuerURI(newIssuer);
                }
            }
        }
        if (tokenTypeURI != null) {
            TokenTypeRule ttRule = null;
            try {
                ttRule = this.findRule(targetMap, ttRules, null, null, tokenTypeURI);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find TokenTypeRule: " + e.getLocalizedMessage());
                }
                this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException(e.getMessage()));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            if (newTokenTypeURI != null) {
                try {
                    this.findRule(targetMap, ttRules, null, null, newTokenTypeURI);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Specified newTokenTypeURI already exists. Cannot perform the edit.");
                    }
                    this.processError(EditSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9073W"));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                catch (NoSuchElementException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating RequiredTokenTypeURI to: " + newTokenTypeURI);
                    }
                    ttRule.setRequiredTokenTypeURI(newTokenTypeURI);
                }
            }
            if (newJAASConfigName != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating JAASConfigName to: " + newJAASConfigName);
                }
                ttRule.setJAASConfigName(newJAASConfigName);
            }
            if (newCallbackHandler != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating CallbackHandler to: " + newCallbackHandler);
                }
                ttRule.setCallbackHandler(newCallbackHandler);
            }
        }
        try {
            this.updateTargets(targetMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(EditSTSEndpointTrustAuthenticationRule.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

