/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.result.STSPropertyList;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class EditSTSConfigurationProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(EditSTSConfigurationProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public EditSTSConfigurationProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public EditSTSConfigurationProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String[] groupPath = (String[])this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (groupPath != null && (subRoot = EditSTSConfigurationProperty.getConfiguration(configGroup, groupPath)) == null) {
            CommandException e = EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9055W");
            this.processError(e);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String propertyName = null;
        String propertyType = null;
        String newPropertyName = null;
        String newPropertyType = null;
        String newPropertyValue = null;
        boolean nullPropertyType = false;
        try {
            propertyName = (String)this.getParameter("propertyName");
            propertyType = (String)this.getParameter("propertyType");
            newPropertyName = (String)this.getParameter("newPropertyName");
            newPropertyType = (String)this.getParameter("newPropertyType");
            newPropertyValue = (String)this.getParameter("newPropertyValue");
            nullPropertyType = (Boolean)this.getParameter("nullPropertyType");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propertyName to match: " + propertyName);
            Tr.debug(tc, "propertyType to match: " + (nullPropertyType ? null : propertyType));
        }
        List<STSProperty> properties = subRoot.getSTSProperty();
        Iterator<STSProperty> iter = properties.iterator();
        Vector<UniqueKey> currentProps = new Vector<UniqueKey>();
        while (iter.hasNext()) {
            STSProperty current = iter.next();
            currentProps.add(new UniqueKey(current.getName(), current.getType()));
        }
        boolean newNameIsNull = newPropertyName == null;
        boolean newTypeIsNull = newPropertyType == null;
        iter = properties.iterator();
        int loopIndex = 0;
        boolean propertyMatched = false;
        while (iter.hasNext()) {
            STSProperty current = iter.next();
            String currentName = current.getName();
            String currentType = current.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to match property: " + new STSPropertyList(new STSProperty[]{current}));
            }
            if (Pattern.matches(propertyName, currentName) && (nullPropertyType ? currentType == null : Pattern.matches(propertyType, currentType == null ? "" : currentType))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property matched.");
                }
                propertyMatched = true;
                if (newNameIsNull && newTypeIsNull) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No new name and no new type are provided. OK to edit property.");
                    }
                    if (newPropertyValue != null) {
                        current.setValue(newPropertyValue);
                    }
                } else {
                    UniqueKey newKey = new UniqueKey(newNameIsNull ? currentName : newPropertyName, newTypeIsNull ? currentType : newPropertyType);
                    if (currentProps.contains(newKey)) {
                        CommandException e = EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9060W");
                        this.processError(e);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, e.getMessage());
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, method);
                        }
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No conflict detected. OK to edit property.");
                    }
                    currentProps.set(loopIndex, newKey);
                    if (!newNameIsNull) {
                        current.setName(newPropertyName);
                    }
                    if (!newTypeIsNull) {
                        current.setType(newPropertyType);
                    }
                    if (newPropertyValue != null) {
                        current.setValue(newPropertyValue);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property not matched.");
            }
            ++loopIndex;
        }
        if (!propertyMatched) {
            this.processError(EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9059W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(EditSTSConfigurationProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    private static class UniqueKey {
        private String key1;
        private String key2;

        public UniqueKey(String key1, String key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public boolean equals(Object other) {
            boolean equals = false;
            if (other instanceof UniqueKey) {
                equals = true;
                UniqueKey otherKey = (UniqueKey)other;
                if (this.key1 == null) {
                    equals = equals && otherKey.key1 == null;
                } else {
                    boolean bl = equals = equals && this.key1.equals(otherKey.key1);
                }
                equals = this.key2 == null ? equals && otherKey.key2 == null : equals && this.key2.equals(otherKey.key2);
            }
            return equals;
        }
    }
}

