/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class AddSTSEndpointTrustAuthenticationRule
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(AddSTSEndpointTrustAuthenticationRule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AddSTSEndpointTrustAuthenticationRule(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AddSTSEndpointTrustAuthenticationRule(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        try {
            new URL(endpointURI);
        }
        catch (MalformedURLException e) {
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("WSEC0003E", new String[]{e.toString()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String issuerURI = null;
        String tokenTypeURI = null;
        String jaasConfigName = null;
        String callbackHandler = null;
        Properties identity = null;
        try {
            issuerURI = (String)this.getParameter("issuer");
            tokenTypeURI = (String)this.getParameter("tokenTypeURI");
            jaasConfigName = (String)this.getParameter("jaasConfigName");
            callbackHandler = (String)this.getParameter("callbackHandler");
            identity = (Properties)this.getParameter("identity");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (issuer) - " + issuerURI);
            Tr.debug(tc, "Command arg (tokenTypeURI) - " + tokenTypeURI);
            Tr.debug(tc, "Command arg (jaasConfigName) - " + jaasConfigName);
            Tr.debug(tc, "Command arg (callbackHandler) - " + callbackHandler);
            Tr.debug(tc, "Command arg (identity) - " + identity);
        }
        if (identity.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity parameter should not be empty.");
            }
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9068W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Target specifiedTarget = null;
        try {
            specifiedTarget = this.findTarget(targetMap, endpointURI);
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target does not exist. Creating.");
            }
            specifiedTarget = new Target();
            List<Target> targets = targetMap.getTarget();
            targets.add(specifiedTarget);
        }
        List<TokenTypeRule> ttRules = null;
        if (issuerURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issuer is null. Finding rules in DefaultIssuerRule.");
            }
            DefaultIssuerRule defaultRule = null;
            try {
                defaultRule = this.findDefaultIssuerRule(targetMap, specifiedTarget, null);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DefaultIssuerRule does not exist. Creating.");
                }
                defaultRule = new DefaultIssuerRule();
                specifiedTarget.setDefaultIssuerRule(defaultRule);
            }
            ttRules = defaultRule.getTokenTypeRule();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking rules in specified IssuerRule.");
            }
            IssuerRule iRule = null;
            try {
                iRule = this.findIssuerRule(targetMap, specifiedTarget, null, issuerURI);
            }
            catch (NoSuchElementException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Specified IssuerRule not found. Creating.");
                }
                iRule = new IssuerRule();
                iRule.setIssuerURI(issuerURI);
                List<IssuerRule> iRules = specifiedTarget.getIssuerRule();
                iRules.add(iRule);
            }
            ttRules = iRule.getTokenTypeRule();
        }
        TokenTypeRule ttRule = null;
        try {
            ttRule = this.findRule(targetMap, ttRules, null, null, tokenTypeURI);
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenTypeRule does not exist. Creating.");
            }
            if (jaasConfigName == null) {
                this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9063W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            ttRule = new TokenTypeRule();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting requiredTokenTypeURI to " + tokenTypeURI);
            }
            ttRule.setRequiredTokenTypeURI(tokenTypeURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting jaasConfigName to " + jaasConfigName);
            }
            ttRule.setJAASConfigName(jaasConfigName);
            if (callbackHandler != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting callbackHandler to " + callbackHandler);
                }
                ttRule.setCallbackHandler(callbackHandler);
            }
            ttRules.add(ttRule);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching rule for identities.");
        }
        Identity id = null;
        try {
            id = this.findIdentity(targetMap, ttRule, null, null, null, identity);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Specified identity already exists.");
            }
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9070W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating Identity element.");
            }
            id = new Identity();
            IdentityList idList = ttRule.getIdentityList();
            if (idList == null) {
                idList = new IdentityList();
                ttRule.setIdentityList(idList);
            }
            List<Identity> ids = idList.getIdentity();
            ids.add(id);
            List<IdentityPart> idParts = id.getIdentityPart();
            Set<Object> keys = identity.keySet();
            for (String string : keys) {
                String value = identity.getProperty(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding IdentityPart with name: " + string + " and value: " + value);
                }
                IdentityPart idPart = new IdentityPart();
                idPart.setName(string);
                idPart.setValue(value);
                idParts.add(idPart);
            }
            try {
                this.updateTargets(targetMap);
            }
            catch (Exception e2) {
                this.processError(e2);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            this.setResult(AddSTSEndpointTrustAuthenticationRule.getMessage("wssecurity.admin.sts.CWWSI9075I"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
    }
}

