/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import java.util.Iterator;
import java.util.List;

public class AddSTSConfigurationGroup
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(AddSTSConfigurationGroup.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AddSTSConfigurationGroup(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AddSTSConfigurationGroup(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        AddSTSConfigurationGroup.trEntry(method);
        String groupName = (String)this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            AddSTSConfigurationGroup.trExit(method);
            return;
        }
        String[] groupPath = null;
        try {
            groupPath = (String[])this.getParameter("groupPath");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            AddSTSConfigurationGroup.trExit(method);
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (groupPath != null && (subRoot = AddSTSConfigurationGroup.getConfiguration(configGroup, groupPath)) == null) {
            this.processError(AddSTSConfigurationGroup.instantiateCommandException("wssecurity.admin.sts.CWWSI9055W"));
            AddSTSConfigurationGroup.trExit(method);
            return;
        }
        List<STSConfigGroup> childrenGroups = subRoot.getSTSConfigGroup();
        Iterator<STSConfigGroup> iter = childrenGroups.iterator();
        while (iter.hasNext()) {
            if (!groupName.equals(iter.next().getName())) continue;
            this.processError(AddSTSConfigurationGroup.instantiateCommandException("wssecurity.admin.sts.CWWSI9056W"));
            AddSTSConfigurationGroup.trExit(method);
            return;
        }
        STSConfigGroup newGroup = new STSConfigGroup();
        newGroup.setName(groupName);
        childrenGroups.add(newGroup);
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            AddSTSConfigurationGroup.trExit(method);
            return;
        }
        this.setResult(AddSTSConfigurationGroup.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        AddSTSConfigurationGroup.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

