/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSCommand
extends AbstractAdminCommand {
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    public static final String FFDC_ID_7 = "FFDC-7";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    private static HashSet<String> defaultPropertyNames;
    private static final TraceComponent tc;
    private static final String CLASS_NAME;
    private static final ResourceBundle resourceBundle;

    public AbstractSTSCommand(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
        this.reset();
    }

    public AbstractSTSCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
        this.reset();
    }

    @Override
    public Object getParameter(String parameterName) throws InvalidParameterNameException {
        Object parameter = super.getParameter(parameterName);
        if (parameter != null && parameter instanceof String) {
            parameter = ((String)parameter).trim();
        }
        return parameter;
    }

    @Override
    public Object getTargetObject() {
        Object targetObject = super.getTargetObject();
        if (targetObject != null && targetObject instanceof String) {
            targetObject = ((String)targetObject).trim();
        }
        return targetObject;
    }

    public static String getMessage(String key) {
        String ret = key;
        if (resourceBundle != null) {
            try {
                ret = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                ret = key;
            }
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        String ret = AbstractSTSCommand.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        return ret;
    }

    protected void setup() {
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void processError(Throwable t) {
        if (t instanceof InvalidParameterNameException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_1);
        } else if (t instanceof CommandException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_2);
        } else if (t instanceof NoSuchElementException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_7);
        } else if (t instanceof FileNotFoundException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_3);
        } else if (t instanceof JAXBException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_4);
        } else if (t instanceof WorkSpaceException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(t, "WSEC0005E", new String[]{t.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable t, String errorCode, String[] args, String ffdcID) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl result = (CommandResultImpl)this.getCommandResult();
        result.setException(t);
        if (t != null) {
            Tr.processException(t, CLASS_NAME, ffdcID);
        }
        Tr.error(tc, errorCode, args);
    }

    protected void setResult(Object result) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        cmdResult.setResult(result);
    }

    protected void addWarning(String warning) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        cmdResult.addWarnings(warning);
    }

    protected STSExtensionMap loadPlugins() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = CLASS_NAME + ".loadPlugins()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String absolutePath = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "stsplugins.xml");
        Unmarshaller um = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        STSExtensionMap map = (STSExtensionMap)um.unmarshal(new File(absolutePath));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return map;
    }

    protected STSTargetMap loadTargets() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = CLASS_NAME + ".loadTargets()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String absolutePath = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "ststargets.xml");
        Unmarshaller um = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets");
        STSTargetMap map = (STSTargetMap)um.unmarshal(new File(absolutePath));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return map;
    }

    protected STSConfigGroup loadConfig() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = "loadConfig";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String absolutePath = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "stsconfig.xml");
        Unmarshaller um = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice");
        STSConfigGroup config2 = (STSConfigGroup)um.unmarshal(new File(absolutePath));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return config2;
    }

    protected void udpatePlugins(STSExtensionMap extensionMap) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = CLASS_NAME + ".updatePlugins(" + STSExtensionMap.class.getName() + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String pluginsFile = Constants.PATH_FROM_CELL + "stsplugins.xml";
        String absolutePath = this.extractFileFromWorkspace(pluginsFile);
        Marshaller m = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        m.marshal((Object)extensionMap, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(pluginsFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    protected void updateTargets(STSTargetMap targetMap) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = CLASS_NAME + ".updateTargets(" + STSExtensionMap.class.getName() + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String targetsFile = Constants.PATH_FROM_CELL + "ststargets.xml";
        String absolutePath = this.extractFileFromWorkspace(targetsFile);
        Marshaller m = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets");
        m.marshal((Object)targetMap, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(targetsFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    protected void updateConfig(STSConfigGroup group) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String method = "updateConfig";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String configFile = Constants.PATH_FROM_CELL + "stsconfig.xml";
        String absolutePath = this.extractFileFromWorkspace(configFile);
        Marshaller m = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice");
        m.marshal((Object)group, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(configFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    protected boolean isDefaultProperty(String propertyName) {
        if (defaultPropertyNames == null) {
            this.loadDefaultPropertyNames();
        }
        return defaultPropertyNames.contains(propertyName);
    }

    protected static STSConfigGroup getConfiguration(STSConfigGroup root, String[] namePath) {
        String method = "getConfiguration";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (root == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Root element is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        for (String name : namePath) {
            Pattern namePattern = Pattern.compile(name);
            List<STSConfigGroup> configs = root.getSTSConfigGroup();
            Iterator<STSConfigGroup> iter = configs.iterator();
            root = null;
            while (iter.hasNext()) {
                STSConfigGroup current = iter.next();
                Matcher match = namePattern.matcher(current.getName());
                if (!match.matches()) continue;
                root = current;
                break;
            }
            if (root != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, name + " was not found in the configuration path.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return root;
    }

    protected static List<STSProperty> getProperties(STSConfigGroup root, String[] namePath) {
        STSConfigGroup config2 = AbstractSTSCommand.getConfiguration(root, namePath);
        if (config2 == null) {
            return null;
        }
        return config2.getSTSProperty();
    }

    protected static CommandException instantiateCommandException(String messageKey) {
        return new CommandException(AbstractSTSCommand.getMessage(messageKey));
    }

    protected static CommandException instantiateCommandException(String messageKey, String[] args) {
        return new CommandException(AbstractSTSCommand.getMessage(messageKey, args));
    }

    private Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller um = jc.createUnmarshaller();
        return um;
    }

    private Marshaller getMarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    private String extractFileFromWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            if (!this.repContext.isExtracted(fileName)) {
                this.repContext.extract(fileName, true);
            }
        } else {
            throw new FileNotFoundException(fileName);
        }
        return AbstractSTSCommand.constructAbsolutePath(this.repContext, fileName);
    }

    private void updateFileInWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            this.repContext.notifyChanged(1, fileName);
        }
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        RepositoryMetaData metaData;
        RepositoryContextType contextType;
        WorkSpace ws;
        Collection col;
        Iterator iter;
        String method = CLASS_NAME + ".getRepositoryContext(" + Session.class.getName() + "=" + session.toString() + ")";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (!(iter = (col = (ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName())).findContext(contextType = (metaData = ws.getMetaData()).getContextType("cells"))).iterator()).hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iter.next();
        this.repContextLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    private void loadDefaultPropertyNames() {
        Field[] fields;
        defaultPropertyNames = new HashSet();
        for (Field field : fields = Constants.class.getFields()) {
            if (!field.getName().startsWith("DEFAULT_PROPERTY_")) continue;
            try {
                defaultPropertyNames.add((String)field.get(null));
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not read in default property: " + field.getName());
            }
        }
    }

    private static String constructAbsolutePath(RepositoryContext rc, String uri) {
        return rc.getPath() + File.separator + uri;
    }

    static {
        tc = Tr.register(AbstractSTSCommand.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        CLASS_NAME = AbstractSTSCommand.class.getName();
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    }
}

