/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sc.SCCommonCommandProvider;
import com.ibm.ws.wssecurity.admin.sc.WSSCCacheCommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property;
import java.util.Iterator;
import java.util.List;

public class DeleteSCClientCacheConfigurationCustomProperties
extends SCCommonCommandProvider {
    private static TraceComponent tc = Tr.register(WSSCCacheCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public DeleteSCClientCacheConfigurationCustomProperties(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public DeleteSCClientCacheConfigurationCustomProperties(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        Configuration cfg = null;
        try {
            cfg = this.loadConfiguration();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load SC Cache configuration.", e);
            }
            Tr.error(tc, "Fail to load SC Ccahe configuration.", e);
            return;
        }
        if (cfg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no SC Cache configuration.");
            }
            Tr.error(tc, "Could not find SC Cache configuration.");
            return;
        }
        String[] customProperties = null;
        try {
            customProperties = (String[])this.getParameter("propertyNames");
        }
        catch (InvalidParameterNameException e) {
            Tr.error(tc, "Could not find SC Cache custom configuration.");
            return;
        }
        Configuration cfg1 = new Configuration();
        List<Property> listProps = cfg.getProperty();
        Iterator<Property> propIter = listProps.iterator();
        boolean removed = false;
        while (propIter.hasNext()) {
            Property current = propIter.next();
            String name = current.getName();
            String value = current.getValue();
            removed = false;
            if (customProperties != null) {
                int leng = customProperties.length;
                for (int i = 0; i < leng; ++i) {
                    if (!name.equalsIgnoreCase(customProperties[i]) || preDefinedProps[0].equalsIgnoreCase(name) || preDefinedProps[1].equalsIgnoreCase(name) || preDefinedProps[2].equalsIgnoreCase(name)) continue;
                    removed = true;
                }
            }
            if (removed) continue;
            Property prop = new Property();
            prop.setName(name);
            prop.setValue(value);
            cfg1.getProperty().add(prop);
        }
        try {
            this.udpateConfiguration(cfg1);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to update SC Cache configuration.", e);
            }
            this.processError(e);
            return;
        }
        this.setResult("The configuration was successfully updated. Use $AdminConfig save to commit the changes.");
    }
}

