/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.distcache;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class WSSCacheCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(WSSCacheCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static String className = WSSCacheCommandProvider.class.getName();
    private HashMap classMap = new HashMap();
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";

    public WSSCacheCommandProvider() {
        this.classMap.put("queryWSSDistributedCacheConfig", "com.ibm.ws.wssecurity.admin.distcache.QueryWSSDistributedCacheConfig");
        this.classMap.put("queryWSSDistributedCacheCustomConfig", "com.ibm.ws.wssecurity.admin.distcache.QueryWSSDistributedCacheCustomConfig");
        this.classMap.put("updateWSSDistributedCacheConfig", "com.ibm.ws.wssecurity.admin.distcache.UpdateWSSDistributedCacheConfig");
        this.classMap.put("updateWSSDistributedCacheCustomConfig", "com.ibm.ws.wssecurity.admin.distcache.UpdateWSSDistributedCacheCustomConfig");
        this.classMap.put("deleteWSSDistributedCacheConfigCustomProperties", "com.ibm.ws.wssecurity.admin.distcache.DeleteWSSDistributedCacheConfigCustomProperties");
        this.classMap.put("updateDistributedCacheProperty", "com.ibm.ws.wssecurity.admin.distcache.UpdateDistributedCacheProperty");
        this.classMap.put("getDistributedCacheProperty", "com.ibm.ws.wssecurity.admin.distcache.GetDistributedCacheProperty");
    }

    public AbstractAdminCommand createCommand(CommandMetadata metadata) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", metadata.getName());
        }
        String cmdName = metadata.getName();
        AbstractAdminCommand command = null;
        try {
            String cmdClassName = (String)this.classMap.get(cmdName);
            Class<?> cmdClass = Class.forName(cmdClassName);
            Class[] arg = new Class[]{Class.forName("com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata")};
            Constructor<?> constructor = cmdClass.getConstructor(arg);
            Object[] param = new Object[]{metadata};
            command = (AbstractAdminCommand)constructor.newInstance(param);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to create Command:" + cmdName, t);
            }
            FFDCFilter.processException(t, className, FFDC_ID_1);
            Tr.error(tc, "WSEC0002E", cmdName);
            throw new CommandNotFoundException(t.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommand", metadata.getName());
        }
        return command;
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand", cmdData.getName());
        }
        String cmdName = cmdData.getName();
        AbstractAdminCommand command = null;
        try {
            String cmdClassName = (String)this.classMap.get(cmdName);
            Class<?> cmdClass = Class.forName(cmdClassName);
            Class[] arg = new Class[]{Class.forName("com.ibm.websphere.management.cmdframework.commanddata.CommandData")};
            Constructor<?> constructor = cmdClass.getConstructor(arg);
            Object[] param = new Object[]{cmdData};
            command = (AbstractAdminCommand)constructor.newInstance(param);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load command:" + cmdName, t);
            }
            FFDCFilter.processException(t, className, FFDC_ID_2);
            Tr.error(tc, "WSEC0002E", t);
            throw new CommandNotFoundException(t.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommand", cmdData.getName());
        }
        return command;
    }
}

