/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.distcache;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.distcache.WSSCacheCommonCommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Configuration;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property;
import java.util.List;
import java.util.Properties;

public class UpdateWSSDistributedCacheCustomConfig
extends WSSCacheCommonCommandProvider {
    private static TraceComponent tc = Tr.register(UpdateWSSDistributedCacheCustomConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public UpdateWSSDistributedCacheCustomConfig(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public UpdateWSSDistributedCacheCustomConfig(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        Configuration cfg = null;
        try {
            cfg = this.loadConfiguration();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load WSS Distributed Cache configuration." + e.getMessage());
            }
            this.processError(e);
            return;
        }
        if (cfg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no WSS Distributed Cache configuration.");
            }
            return;
        }
        Properties props = new Properties();
        Configuration cfg1 = new Configuration();
        List<Property> listProps = cfg.getProperty();
        for (Property current : listProps) {
            String name = current.getName();
            String string = current.getValue();
            props.put(name, string);
            Property prop = new Property();
            prop.setName(name);
            prop.setValue(string);
            cfg1.getProperty().add(prop);
        }
        Properties updatedValues = null;
        try {
            updatedValues = (Properties)this.getParameter("customProperties");
            if (updatedValues != null && !updatedValues.isEmpty()) {
                for (String string : updatedValues.keySet()) {
                    if (preDefinedProps[0].equalsIgnoreCase(string) || preDefinedProps[1].equalsIgnoreCase(string) || preDefinedProps[2].equalsIgnoreCase(string) || preDefinedProps[3].equalsIgnoreCase(string) || preDefinedProps[4].equalsIgnoreCase(string) || preDefinedProps[5].equalsIgnoreCase(string)) continue;
                    String value = updatedValues.getProperty(string);
                    Property prop = new Property();
                    prop.setName(string);
                    prop.setValue(value);
                    cfg1.getProperty().add(prop);
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to update configuration due to invalid parameters " + e.getMessage());
            }
            this.processError(e);
            return;
        }
        try {
            this.udpateConfiguration(cfg1);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to update WSS Distributed Cache configuration." + e.getMessage());
            }
            this.processError(e);
            return;
        }
        this.setResult("The configuration was successfully updated. Use $AdminConfig save to commit the changes.");
    }
}

