/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.distcache;

import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.distcache.WSSCacheCommonCommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Configuration;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class UpdateWSSDistributedCacheConfig
extends WSSCacheCommonCommandProvider {
    private static TraceComponent tc = Tr.register(UpdateWSSDistributedCacheConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public UpdateWSSDistributedCacheConfig(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public UpdateWSSDistributedCacheConfig(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String name;
        Configuration cfg = null;
        com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration oldcfg = new com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration();
        try {
            cfg = this.loadConfiguration();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load WSS Distributed Cache configuration." + e.getMessage());
            }
            this.processError(e);
            return;
        }
        if (cfg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no WSS Distributed Cache configuration.");
            }
            return;
        }
        Properties props = new Properties();
        Configuration cfg1 = new Configuration();
        List<Property> listProps = cfg.getProperty();
        Iterator<Property> propIter = listProps.iterator();
        boolean isClusterUpdate = true;
        boolean isDistCache = false;
        boolean isTokenRecovery = false;
        boolean isDataSource = false;
        boolean isDistCacheUsed = false;
        boolean isClusterUpdateUsed = false;
        boolean isTokenRecoveryUsed = false;
        while (propIter.hasNext()) {
            Object parValue;
            Property current;
            block32: {
                current = propIter.next();
                name = current.getName();
                parValue = null;
                try {
                    parValue = this.getParameter(name);
                }
                catch (InvalidParameterNameException e) {
                    if (!tc.isDebugEnabled()) break block32;
                    Tr.debug(tc, "Fail to get Command parameter.", e);
                }
            }
            String value = null;
            value = parValue == null ? current.getValue() : parValue.toString();
            if (preDefinedProps[0].equalsIgnoreCase(name) || preDefinedProps[1].equalsIgnoreCase(name) || preDefinedProps[2].equalsIgnoreCase(name) || preDefinedProps[3].equalsIgnoreCase(name) || preDefinedProps[4].equalsIgnoreCase(name) || preDefinedProps[5].equalsIgnoreCase(name)) {
                if (preDefinedProps[1].equalsIgnoreCase(name) && Integer.parseInt(value) < 10) {
                    this.processError(UpdateWSSDistributedCacheConfig.instantiateCommandException("wssecurity.admin.sts.CWWSI9086E", new String[]{name, "10"}));
                }
                props.put(name, value);
                if (preDefinedProps[0].equalsIgnoreCase(name) || preDefinedProps[1].equalsIgnoreCase(name) || preDefinedProps[2].equalsIgnoreCase(name)) {
                    com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property prop1 = new com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property();
                    prop1.setName(name);
                    prop1.setValue(value);
                    oldcfg.getProperty().add(prop1);
                }
                if (preDefinedProps[3].equalsIgnoreCase(name)) {
                    isClusterUpdateUsed = true;
                    if (!"true".equalsIgnoreCase(value)) {
                        isClusterUpdate = false;
                    }
                }
                if (preDefinedProps[2].equalsIgnoreCase(name)) {
                    isDistCacheUsed = true;
                    if ("true".equalsIgnoreCase(value)) {
                        isDistCache = true;
                    }
                }
                if (preDefinedProps[4].equalsIgnoreCase(name)) {
                    isTokenRecoveryUsed = true;
                    if ("true".equalsIgnoreCase(value)) {
                        isTokenRecovery = true;
                    }
                }
                if (!preDefinedProps[5].equalsIgnoreCase(name) || value == null || value.length() == 0) continue;
                isDataSource = true;
                continue;
            }
            props.put(name, value);
        }
        for (Property current : listProps) {
            Property prop;
            name = current.getName();
            if (preDefinedProps[2].equalsIgnoreCase(name)) {
                if (isDistCache && isClusterUpdate && isTokenRecovery) {
                    this.processError(new Throwable("Both synchronousClusterUpdate and tokenRecovery cannot be true "));
                    return;
                }
                prop = new Property();
                prop.setName(name);
                prop.setValue(props.getProperty(name));
                cfg1.getProperty().add(prop);
                continue;
            }
            if (preDefinedProps[4].equalsIgnoreCase(name)) {
                if (isTokenRecovery && !isDataSource) {
                    this.processError(new Throwable("Missing Datasource Name"));
                    return;
                }
                prop = new Property();
                prop.setName(name);
                prop.setValue(props.getProperty(name));
                cfg1.getProperty().add(prop);
                continue;
            }
            prop = new Property();
            prop.setName(name);
            prop.setValue(props.getProperty(name));
            cfg1.getProperty().add(prop);
        }
        try {
            if (isDistCacheUsed) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Distributed Cache parameter is used, update other configs : " + isDistCache);
                }
                try {
                    String cmdName = "updateDistributedCacheProperty";
                    CommandMetadata cmd1 = CommandMgr.getCommandMgr().getCommandMetadata(cmdName);
                    AdminCommand cmd = CommandMgr.getCommandMgr().createCommand(cmdName);
                    cmd.setParameter("notUpdate", "WSSDistributedCache.xml");
                    cmd.setParameter("distributedCache", isDistCache);
                    cmd.setConfigSession(this.getConfigSession());
                    cmd.execute();
                    CommandResult createCommandResult = cmd.getCommandResult();
                    if (!createCommandResult.isSuccessful()) {
                        Tr.warning(tc, "Fail to run updateDistributedCacheProperty command. All the necessary configurations might not have been updated successfully!!");
                    }
                }
                catch (Exception e) {
                    Tr.warning(tc, "Fail to run updateDistributedCacheProperty command. All the necessary configurations might not have been updated successfully!!" + e);
                }
            }
            this.udpateConfiguration(cfg1);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to update WSS Distributed Cache configuration." + e.getMessage());
            }
            this.processError(e);
            return;
        }
        try {
            this.udpateOldConfiguration(oldcfg);
        }
        catch (Exception e) {
            Tr.warning(tc, "Fail to update old SC cache configuration");
        }
        this.setResult("The configuration was successfully updated. Use $AdminConfig save to commit the changes.");
    }
}

