/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.distcache;

import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.SCClientCache;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.WSSDistributedCacheConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.emf.ecore.resource.Resource;

public class UpdateDistributedCacheProperty
extends AbstractAdminCommand {
    private static final String CacheConfigFile = "WSSDistributedCache.xml";
    private static final String SCConfigFile = "WSSCCache.xml";
    private static final String TrustConfigFile = "stsplugins.xml";
    private static final String Package_Namespace = "com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache";
    protected static final String RESULT_MSG_SUCCESS_UPDATED = "The configuration was successfully updated. Use $AdminConfig save to commit the changes.";
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    protected static final String[] preDefinedProps = new String[]{"renewIntervalBeforeTimeoutMinutes", "minutesInCacheAfterTimeout", "distributedCache", "notUpdate", "clockSkewToleranceInMinutes"};
    private static final TraceComponent tc = Tr.register(UpdateDistributedCacheProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    public UpdateDistributedCacheProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
        this.reset();
    }

    public UpdateDistributedCacheProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
        this.reset();
    }

    protected void setup() {
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void setResult(Object result) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        cmdResult.setResult(result);
    }

    protected void udpateOldConfiguration(Configuration cfg) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpateOldConfiguration");
        }
        String absolutePath = this.extractFileFromWorkspace(SCConfigFile);
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache");
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        SCClientCache cache = new SCClientCache();
        cache.getConfiguration().add(cfg);
        m.marshal((Object)cache, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(SCConfigFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpateOldConfiguration");
        }
    }

    protected STSExtensionMap loadTrustPlugins() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTrustPlugins()");
        }
        String absolutePath = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + TrustConfigFile);
        Unmarshaller um = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        STSExtensionMap map = (STSExtensionMap)um.unmarshal(new File(absolutePath));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustPlugins()");
        }
        return map;
    }

    protected void udpateTrustPlugins(STSExtensionMap extensionMap) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpateTrustPlugins");
        }
        String pluginsFile = Constants.PATH_FROM_CELL + TrustConfigFile;
        String absolutePath = this.extractFileFromWorkspace(pluginsFile);
        Marshaller m = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        m.marshal((Object)extensionMap, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(pluginsFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpateTrustPlugins");
        }
    }

    protected void udpateConfiguration(com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Configuration cfg) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpateConfiguration");
        }
        String absolutePath = this.extractFileFromWorkspace(CacheConfigFile);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        WSSDistributedCacheConfig cache = new WSSDistributedCacheConfig();
        cache.getConfiguration().add(cfg);
        m.marshal((Object)cache, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(CacheConfigFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpateConfiguration");
        }
    }

    private Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller um = jc.createUnmarshaller();
        return um;
    }

    private Marshaller getMarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    private String extractFileFromWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            if (!this.repContext.isExtracted(fileName)) {
                this.repContext.extract(fileName, true);
            }
        } else {
            throw new FileNotFoundException(fileName);
        }
        return UpdateDistributedCacheProperty.constructAbsolutePath(this.repContext, fileName);
    }

    private void updateFileInWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            this.repContext.notifyChanged(1, fileName);
        }
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        RepositoryContextType contextType;
        WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection col = ws.findContext(contextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells"));
        Iterator iter = col.iterator();
        if (!iter.hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iter.next();
        this.repContextLoaded = true;
    }

    private static String constructAbsolutePath(RepositoryContext rc, String uri) {
        return rc.getPath() + File.separator + uri;
    }

    public static String getMessage(String key) {
        String ret = key;
        if (resourceBundle != null) {
            try {
                ret = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                ret = key;
            }
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        String ret = UpdateDistributedCacheProperty.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        return ret;
    }

    protected static CommandException instantiateCommandException(String messageKey) {
        return new CommandException(UpdateDistributedCacheProperty.getMessage(messageKey));
    }

    protected static CommandException instantiateCommandException(String messageKey, String[] args) {
        return new CommandException(UpdateDistributedCacheProperty.getMessage(messageKey, args));
    }

    protected void processError(Throwable t) {
        if (t instanceof InvalidParameterNameException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_1);
        } else if (t instanceof CommandException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_2);
        } else if (t instanceof FileNotFoundException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_3);
        } else if (t instanceof JAXBException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_4);
        } else if (t instanceof WorkSpaceException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(t, "WSEC0005E", new String[]{t.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable t, String errorCode, String[] args, String ffdcID) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl result = (CommandResultImpl)this.getCommandResult();
        result.setException(t);
        Tr.error(tc, errorCode, args);
    }

    protected void updateTrustConfig() {
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadTrustPlugins();
        }
        catch (Exception ex) {
            this.processError(ex);
        }
        List<Extension> extensionList = extensionMap.getExtension();
        Iterator<Extension> extensionIter = extensionList.iterator();
        Extension extension = null;
        while (extensionIter.hasNext()) {
            Extension currentExtension = extensionIter.next();
            if (!"Security Context Token".equals(currentExtension.getLocalName())) continue;
            extension = currentExtension;
        }
        if (extension == null) {
            this.processError(UpdateDistributedCacheProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
        } else {
            Properties trustProperties = new Properties();
            Object parValue = null;
            try {
                parValue = this.getParameter(preDefinedProps[2]);
            }
            catch (InvalidParameterNameException e) {
                Tr.warning(tc, "Fail to get Command parameter." + e);
            }
            if (parValue != null) {
                trustProperties.setProperty(preDefinedProps[2], parValue.toString());
            }
            com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration config2 = extension.getConfiguration();
            List<Property> properties = config2.getProperty();
            for (Property currentProperty : properties) {
                String propName = currentProperty.getName();
                String newPropValue = (String)trustProperties.remove(propName);
                if (newPropValue == null) continue;
                currentProperty.setValue(newPropValue);
            }
            Enumeration<Object> newProperties = trustProperties.keys();
            while (newProperties.hasMoreElements()) {
                Property newProperty = new Property();
                String newPropName = (String)newProperties.nextElement();
                newProperty.setName(newPropName);
                newProperty.setValue(trustProperties.getProperty(newPropName));
                properties.add(newProperty);
            }
            try {
                this.udpateTrustPlugins(extensionMap);
            }
            catch (Exception ex2) {
                this.processError(ex2);
            }
        }
    }

    public void updateWSSecurity() {
        block23: {
            WSSecurity wssec = null;
            Repository repository = null;
            ConfigRoot cfgRoot = null;
            Resource r1 = null;
            Resource r2 = null;
            boolean ndEnvironment = false;
            try {
                String processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null && processType.length() > 0 && (processType.equals("ManagedProcess") || processType.equals("DeploymentManager") || processType.equals("NodeAgent"))) {
                    ndEnvironment = true;
                }
                repository = WsServiceRegistry.getService(this, Repository.class);
                cfgRoot = repository.getConfigRoot();
                if (!ndEnvironment) break block23;
                try {
                    r1 = cfgRoot.getResource(0, "ws-security.xml");
                }
                catch (Exception e) {
                    String path = cfgRoot.getAbsolutePath(0, "ws-security.xml");
                    Tr.warning(tc, "Cannot load cell level wssecurity.xml" + path);
                }
                if (r1 != null) {
                    wssec = (WSSecurity)r1.getContents().get(0);
                    if (wssec != null) {
                        if (wssec.getNonceCaching() != null) {
                            try {
                                wssec.getNonceCaching().setDistributed((Boolean)this.getParameter(preDefinedProps[2]));
                                r1.save(new HashMap());
                            }
                            catch (InvalidParameterNameException e) {
                                Tr.warning(tc, "Fail to get Command parameter." + e);
                            }
                            catch (Exception e) {
                                Tr.warning(tc, "Fail to update ws-security.xml with nonce cache distributed property" + e);
                            }
                        } else {
                            Tr.warning(tc, "Nonce Caching does not exist. Cannot update nonce distributed cache property");
                        }
                    } else {
                        Tr.warning(tc, "Failed to extract cell level ws-security config. Cannot update nonce distributed cache property.");
                    }
                }
                String path = null;
                try {
                    r2 = cfgRoot.getResource(4, "ws-security.xml");
                    path = cfgRoot.getAbsolutePath(4, "ws-security.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (r2 != null) {
                    wssec = (WSSecurity)r2.getContents().get(0);
                    if (wssec != null) {
                        if (wssec.getNonceCaching() != null) {
                            try {
                                wssec.getNonceCaching().setDistributed((Boolean)this.getParameter(preDefinedProps[2]));
                                r2.save(new HashMap());
                            }
                            catch (InvalidParameterNameException e) {
                                Tr.warning(tc, "Fail to get Command parameter." + e);
                            }
                            catch (Exception e) {
                                Tr.warning(tc, "Fail to update server level ws-security.xml with nonce cache distributed property: " + e);
                            }
                        } else {
                            Tr.warning(tc, "Nonce Caching does not exist. Cannot update nonce distributed cache property");
                        }
                    } else {
                        Tr.warning(tc, "Cannot extract server level ws-security config. Not updating nonce distributed cache property.");
                    }
                }
            }
            catch (Exception ex) {
                Tr.warning(tc, "Failed to extract ws-security config. Cannot update nonce distributed cache property : " + ex);
            }
        }
    }

    public void updateCommonDistributedCache() throws Exception {
        String absolutePath = this.extractFileFromWorkspace(CacheConfigFile);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller um = jc.createUnmarshaller();
        WSSDistributedCacheConfig cache = (WSSDistributedCacheConfig)um.unmarshal(new File(absolutePath));
        com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Configuration cfg = cache.getConfiguration().get(0);
        Properties props = new Properties();
        Object parValue = null;
        try {
            parValue = this.getParameter(preDefinedProps[0]);
            if (parValue != null) {
                props.setProperty(preDefinedProps[0], parValue.toString());
            }
            if ((parValue = this.getParameter(preDefinedProps[1])) != null) {
                props.setProperty(preDefinedProps[1], parValue.toString());
            }
            if ((parValue = this.getParameter(preDefinedProps[2])) != null) {
                props.setProperty(preDefinedProps[2], parValue.toString());
            }
            if ((parValue = this.getParameter(preDefinedProps[4])) != null) {
                props.setProperty(preDefinedProps[4], parValue.toString());
            }
            List<com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property> properties = cfg.getProperty();
            for (com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property currentProperty : properties) {
                String propName = currentProperty.getName();
                String newPropValue = (String)props.remove(propName);
                if (newPropValue == null) continue;
                currentProperty.setValue(newPropValue);
            }
            Enumeration<Object> newProperties = props.keys();
            while (newProperties.hasMoreElements()) {
                com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property newProperty = new com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property();
                String newPropName = (String)newProperties.nextElement();
                newProperty.setName(newPropName);
                newProperty.setValue(props.getProperty(newPropName));
                properties.add(newProperty);
            }
            this.udpateConfiguration(cfg);
        }
        catch (InvalidParameterNameException ex) {
            Tr.warning(tc, "Fail to get Command parameter." + ex);
            throw ex;
        }
        catch (Exception e3) {
            throw e3;
        }
    }

    protected Configuration loadOldConfiguration() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldConfiguration()");
        }
        String absolutePath = this.extractFileFromWorkspace(SCConfigFile);
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache");
        Unmarshaller um = jc.createUnmarshaller();
        SCClientCache cache = (SCClientCache)um.unmarshal(new File(absolutePath));
        Configuration cfg = cache.getConfiguration().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldConfiguration()");
        }
        return cfg;
    }

    protected void updateSCCacheConfig() {
        Configuration oldcfg = null;
        Properties props = new Properties();
        Object parValue = null;
        try {
            parValue = this.getParameter(preDefinedProps[0]);
            if (parValue != null) {
                props.setProperty(preDefinedProps[0], parValue.toString());
            }
            if ((parValue = this.getParameter(preDefinedProps[1])) != null) {
                props.setProperty(preDefinedProps[1], parValue.toString());
            }
            if ((parValue = this.getParameter(preDefinedProps[2])) != null) {
                props.setProperty(preDefinedProps[2], parValue.toString());
            }
            oldcfg = this.loadOldConfiguration();
            List<com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property> properties = oldcfg.getProperty();
            for (com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property currentProperty : properties) {
                String propName = currentProperty.getName();
                String newPropValue = (String)props.remove(propName);
                if (newPropValue == null) continue;
                currentProperty.setValue(newPropValue);
            }
            this.udpateOldConfiguration(oldcfg);
        }
        catch (InvalidParameterNameException e) {
            Tr.warning(tc, "Cannot get Command parameter. Cannot update SC Cache configuration." + e);
        }
        catch (Exception ex) {
            Tr.warning(tc, "Cannot update old SC cache configuration" + ex);
        }
    }

    public void execute() {
        block25: {
            Object parValue = null;
            String name = null;
            name = preDefinedProps[3];
            try {
                parValue = this.getParameter(name);
            }
            catch (InvalidParameterNameException e) {
                Tr.warning(tc, "Cannot get command parameter : " + e);
            }
            if (parValue != null) {
                if (((String)parValue).equals(CacheConfigFile)) {
                    try {
                        if (this.getParameter(preDefinedProps[2]) != null) {
                            this.updateTrustConfig();
                            this.updateWSSecurity();
                        }
                    }
                    catch (InvalidParameterNameException e) {
                        Tr.warning(tc, "Cannot get command parameter : " + e);
                    }
                } else if (((String)parValue).equals(SCConfigFile)) {
                    try {
                        this.updateCommonDistributedCache();
                    }
                    catch (Exception e) {
                        this.processError(e);
                        return;
                    }
                    try {
                        if (this.getParameter(preDefinedProps[2]) != null) {
                            this.updateTrustConfig();
                            this.updateWSSecurity();
                        }
                    }
                    catch (InvalidParameterNameException e) {
                        Tr.warning(tc, "Cannot get command parameter : " + e);
                    }
                } else if (((String)parValue).equals(TrustConfigFile)) {
                    try {
                        if (this.getParameter(preDefinedProps[2]) == null) break block25;
                        try {
                            this.updateCommonDistributedCache();
                        }
                        catch (Exception e) {
                            this.processError(e);
                            return;
                        }
                        this.updateSCCacheConfig();
                        this.updateWSSecurity();
                    }
                    catch (InvalidParameterNameException e) {
                        Tr.warning(tc, "Cannot get command parameter : " + e);
                    }
                }
            } else {
                try {
                    if (this.getParameter(preDefinedProps[2]) == null) break block25;
                    try {
                        this.updateCommonDistributedCache();
                    }
                    catch (Exception e) {
                        this.processError(e);
                        return;
                    }
                    this.updateSCCacheConfig();
                    this.updateTrustConfig();
                    this.updateWSSecurity();
                }
                catch (InvalidParameterNameException e) {
                    Tr.warning(tc, "Cannot get command parameter : " + e);
                }
            }
        }
        this.setResult(RESULT_MSG_SUCCESS_UPDATED);
    }
}

