/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.distcache;

import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.SCClientCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.emf.ecore.resource.Resource;

public class GetDistributedCacheProperty
extends AbstractAdminCommand {
    private static final String CacheConfigFile = "WSSDistributedCache.xml";
    private static final String SCConfigFile = "WSSCCache.xml";
    protected static final String RESULT_MSG_SUCCESS_UPDATED = "The configuration was successfully updated. Use $AdminConfig save to commit the changes.";
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    protected static final String[] preDefinedProps = new String[]{"renewIntervalBeforeTimeoutMinutes", "minutesInCacheAfterTimeout", "distributedCache", "notUpdate", "clockSkewToleranceInMinutes"};
    private static final TraceComponent tc = Tr.register(GetDistributedCacheProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    public GetDistributedCacheProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
        this.reset();
    }

    public GetDistributedCacheProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
        this.reset();
    }

    protected void setup() {
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void setResult(Object result) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        cmdResult.setResult(result);
    }

    protected STSExtensionMap loadTrustPlugins() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTrustPlugins()");
        }
        String absolutePath = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "stsplugins.xml");
        Unmarshaller um = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        STSExtensionMap map = (STSExtensionMap)um.unmarshal(new File(absolutePath));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTrustPlugins()");
        }
        return map;
    }

    private Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller um = jc.createUnmarshaller();
        return um;
    }

    private String extractFileFromWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            if (!this.repContext.isExtracted(fileName)) {
                this.repContext.extract(fileName, true);
            }
        } else {
            throw new FileNotFoundException(fileName);
        }
        return GetDistributedCacheProperty.constructAbsolutePath(this.repContext, fileName);
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        RepositoryContextType contextType;
        WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection col = ws.findContext(contextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells"));
        Iterator iter = col.iterator();
        if (!iter.hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iter.next();
        this.repContextLoaded = true;
    }

    private static String constructAbsolutePath(RepositoryContext rc, String uri) {
        return rc.getPath() + File.separator + uri;
    }

    public static String getMessage(String key) {
        String ret = key;
        if (resourceBundle != null) {
            try {
                ret = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                ret = key;
            }
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        String ret = GetDistributedCacheProperty.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        return ret;
    }

    protected static CommandException instantiateCommandException(String messageKey) {
        return new CommandException(GetDistributedCacheProperty.getMessage(messageKey));
    }

    protected static CommandException instantiateCommandException(String messageKey, String[] args) {
        return new CommandException(GetDistributedCacheProperty.getMessage(messageKey, args));
    }

    protected void processError(Throwable t) {
        if (t instanceof InvalidParameterNameException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_1);
        } else if (t instanceof CommandException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_2);
        } else if (t instanceof FileNotFoundException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_3);
        } else if (t instanceof JAXBException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_4);
        } else if (t instanceof WorkSpaceException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(t, "WSEC0005E", new String[]{t.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable t, String errorCode, String[] args, String ffdcID) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl result = (CommandResultImpl)this.getCommandResult();
        result.setException(t);
        Tr.error(tc, errorCode, args);
    }

    protected boolean searchTrustConfig() {
        boolean result = false;
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadTrustPlugins();
        }
        catch (Exception ex) {
            Tr.warning(tc, "Cannot load trust plugins config to look at distributed cache property.");
            return false;
        }
        List<Extension> extensionList = extensionMap.getExtension();
        Iterator<Extension> extensionIter = extensionList.iterator();
        Extension extension = null;
        while (extensionIter.hasNext()) {
            Extension currentExtension = extensionIter.next();
            if (!"Security Context Token".equals(currentExtension.getLocalName())) continue;
            extension = currentExtension;
        }
        if (extension == null) {
            Tr.warning(tc, "Cannot load trust plugins config to look at distributed cache property.");
            return false;
        }
        com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration config2 = extension.getConfiguration();
        List<Property> properties = config2.getProperty();
        for (Property currentProperty : properties) {
            String propName = currentProperty.getName();
            if (!propName.equals("distributedCache")) continue;
            if ("true".equals(currentProperty.getValue())) {
                result = true;
                continue;
            }
            result = false;
        }
        return result;
    }

    protected boolean searchWSSecurity() {
        boolean result;
        block16: {
            WSSecurity wssec = null;
            Repository repository = null;
            ConfigRoot cfgRoot = null;
            Resource r1 = null;
            Resource r2 = null;
            boolean ndEnvironment = false;
            result = false;
            try {
                String processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null && processType.length() > 0 && (processType.equals("ManagedProcess") || processType.equals("DeploymentManager") || processType.equals("NodeAgent"))) {
                    ndEnvironment = true;
                }
                repository = WsServiceRegistry.getService(this, Repository.class);
                cfgRoot = repository.getConfigRoot();
                if (!ndEnvironment) break block16;
                try {
                    r1 = cfgRoot.getResource(0, "ws-security.xml");
                }
                catch (Exception e) {
                    String path = cfgRoot.getAbsolutePath(0, "ws-security.xml");
                    Tr.warning(tc, "Cannot load cell level wssecurity.xml" + path);
                }
                if (r1 != null) {
                    wssec = (WSSecurity)r1.getContents().get(0);
                    if (wssec != null) {
                        if (wssec.getNonceCaching() != null) {
                            result = wssec.getNonceCaching().isDistributed();
                        }
                    } else {
                        Tr.warning(tc, "Failed to extract cell level ws-security config.");
                    }
                }
                try {
                    r2 = cfgRoot.getResource(4, "ws-security.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (r2 != null) {
                    wssec = (WSSecurity)r2.getContents().get(0);
                    if (wssec != null) {
                        if (wssec.getNonceCaching() != null) {
                            result = wssec.getNonceCaching().isDistributed();
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot extract server level ws-security config");
                    }
                }
            }
            catch (Exception ex) {
                Tr.warning(tc, "Failed to extract ws-security config." + ex);
            }
        }
        return result;
    }

    protected Configuration loadOldConfiguration() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldConfiguration()");
        }
        String absolutePath = this.extractFileFromWorkspace(SCConfigFile);
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache");
        Unmarshaller um = jc.createUnmarshaller();
        SCClientCache cache = (SCClientCache)um.unmarshal(new File(absolutePath));
        Configuration cfg = cache.getConfiguration().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldConfiguration()");
        }
        return cfg;
    }

    protected boolean searchSCCacheConfig() {
        Configuration oldcfg = null;
        boolean result = false;
        try {
            oldcfg = this.loadOldConfiguration();
            List<com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property> properties = oldcfg.getProperty();
            for (com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property currentProperty : properties) {
                String propName = currentProperty.getName();
                if (!preDefinedProps[2].equals(propName)) continue;
                if ("true".equals(currentProperty.getValue())) {
                    result = true;
                    continue;
                }
                result = false;
            }
        }
        catch (Exception ex) {
            Tr.warning(tc, "Cannot get distributed cache property value from old SC cache configuration" + ex);
        }
        return result;
    }

    public void execute() {
        Boolean result = new Boolean(false);
        result = this.searchTrustConfig();
        if (!result.booleanValue()) {
            result = this.searchSCCacheConfig();
        }
        if (!result.booleanValue()) {
            result = this.searchWSSecurity();
        }
        this.setResult(result);
    }
}

