/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ws.wssecurity.admin.Wss10Assertion;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class Wss11Assertion
extends Wss10Assertion {
    private static TraceComponent tc = Tr.register(Wss11Assertion.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    Wss11Assertion() {
    }

    public boolean isSupported(String assertion) {
        if (super.isSupported(assertion)) {
            return true;
        }
        for (int i = 0; i < wss11_supportedAssertions.length; ++i) {
            if (!wss11_supportedAssertions[i].equals(assertion)) continue;
            return true;
        }
        return false;
    }

    static Wss11Assertion getInstance(Policy policy) {
        Wss11Assertion assertion = new Wss11Assertion();
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : list) {
            if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if (!((obj = ((JAXBElement)obj).getValue()) instanceof QNameAssertionType)) continue;
                assertion.addAssertion(name);
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "Wss11"});
        }
        return assertion;
    }
}

