/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class Token
implements PolicyAttributesConstants {
    protected String _name = null;
    private String _includeToken = null;
    private List _modifiers = new ArrayList();
    private SecureConversationToken sctAssertion = null;
    private WssCustomToken wssCT = null;
    private static TraceComponent tc = Tr.register(Token.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    Token() {
    }

    static Token getInstance(String name, TokenAssertionType tat) {
        Token token = new Token();
        token._name = name;
        token._includeToken = tat.getIncludeToken();
        List<Object> any = tat.getAny();
        if (!any.isEmpty()) {
            Policy policy = (Policy)any.get(0);
            List<Object> list = policy.getPolicyOrAllOrExactlyOne();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj instanceof JAXBElement) {
                    token._modifiers.add(((JAXBElement)obj).getName().getLocalPart());
                    continue;
                }
                if (obj instanceof WssCustomToken) {
                    token.wssCT = (WssCustomToken)obj;
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), name});
            }
        }
        return token;
    }

    static Token getInstance(String name, SecureConversationTokenType sct) {
        Token token = new Token();
        token._name = name;
        token._includeToken = sct.getIncludeToken();
        token.sctAssertion = SecureConversationToken.getInstance(sct);
        return token;
    }

    String getName() {
        return this._name;
    }

    AttributeList getAttributes() {
        return this.getAttributes(-1);
    }

    AttributeList getAttributes(int subscript) {
        AttributeList list = new AttributeList();
        AttributeList sublist = new AttributeList();
        if (this.sctAssertion != null) {
            sublist = this.sctAssertion.getAttributes();
        }
        if (subscript < 0) {
            list.add(new Attribute(this._name, sublist));
        } else {
            list.add(new Attribute(this._name + "_" + subscript, sublist));
        }
        if (this._includeToken != null) {
            sublist.add(new Attribute("IncludeToken", this._includeToken));
        }
        for (int i = 0; i < this._modifiers.size(); ++i) {
            sublist.add(new Attribute((String)this._modifiers.get(i), "true"));
        }
        if (this.wssCT != null) {
            AttributeList sublist2 = new AttributeList();
            sublist.add(new Attribute("WssCustomToken", sublist2));
            if (this.wssCT.getUri() != null) {
                sublist2.add(new Attribute("uri", this.wssCT.getUri()));
            }
            if (this.wssCT.getLocalname() != null) {
                sublist2.add(new Attribute("localname", this.wssCT.getLocalname()));
            }
        }
        return list;
    }
}

