/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.AsymmetricBinding;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class SymmetricBinding
extends BindingAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(AsymmetricBinding.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Token _signatureToken = null;
    private Token _encryptionToken = null;
    private Token _protectionToken = null;
    public static final String[] supportedTokes = new String[]{"SignatureToken", "EncryptionToken", "ProtectionToken"};

    SymmetricBinding() {
    }

    void parsePolicy(Policy policy, boolean sctAllowed) {
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : list) {
            if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if ("IncludeTimestamp".equals(name) || "AlgorithmSuite".equals(name) || "Layout".equals(name)) {
                    this.parseObject((JAXBElement)obj);
                    continue;
                }
                NestedPolicyType np = (NestedPolicyType)((JAXBElement)obj).getValue();
                List<Object> sublist = np.getPolicy().getPolicyOrAllOrExactlyOne();
                if (SymmetricBinding.hasErrorInSymBinding(sublist, sctAllowed)) continue;
                JAXBElement element = (JAXBElement)sublist.get(0);
                Token token = null;
                if (element.getValue() instanceof SecureConversationTokenType) {
                    token = Token.getInstance(element.getName().getLocalPart(), (SecureConversationTokenType)element.getValue());
                } else if (element.getValue() instanceof TokenAssertionType) {
                    token = Token.getInstance(element.getName().getLocalPart(), (TokenAssertionType)element.getValue());
                } else {
                    Tr.warning(tc, "CWWSI9001W", new Object[]{name, "SymmetricBinding"});
                    continue;
                }
                if ("SignatureToken".equals(name)) {
                    this._signatureToken = token;
                    continue;
                }
                if ("EncryptionToken".equals(name)) {
                    this._encryptionToken = token;
                    continue;
                }
                if ("ProtectionToken".equals(name)) {
                    this._protectionToken = token;
                    continue;
                }
                Tr.warning(tc, "CWWSI9002W", new Object[]{name, "SymmetricBinding"});
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "SymmetricBinding"});
        }
    }

    AttributeList getAttributes() {
        AttributeList list = new AttributeList();
        if (this._signatureToken != null || this._encryptionToken != null) {
            if (this._signatureToken != null) {
                list.add(new Attribute("SignatureToken", this._signatureToken.getAttributes()));
            }
            if (this._encryptionToken != null) {
                list.add(new Attribute("EncryptionToken", this._encryptionToken.getAttributes()));
            }
        } else if (this._protectionToken != null) {
            list.add(new Attribute("ProtectionToken", this._protectionToken.getAttributes()));
        }
        list.addAll(super.getAttributes());
        return list;
    }

    static boolean hasErrorInSymBinding(List sublist, boolean sctAllowed) {
        JAXBElement element;
        if (sublist.isEmpty()) {
            Tr.warning(tc, "CWWSI9003W", new Object[]{"SymmetricBinding"});
            return true;
        }
        if (sublist.size() > 1) {
            Tr.warning(tc, "CWWSI9004W", new Object[]{"SymmetricBinding"});
            return true;
        }
        if (!(sublist.get(0) instanceof JAXBElement)) {
            Tr.warning(tc, "CWWSI9001W", new Object[]{sublist.get(0).getClass().getName(), "SymmetricBinding"});
            return true;
        }
        if (!sctAllowed && (element = (JAXBElement)sublist.get(0)).getValue() instanceof SecureConversationTokenType) {
            Tr.warning(tc, "CWWSI9011W");
            return true;
        }
        return false;
    }
}

