/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.ObjectModelHelper;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SymmetricBinding;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.xmlsoap.schemas.ws._2004._08.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class SecureConversationTokenHelper
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static TraceComponent tc = Tr.register(SecureConversationTokenHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static SecureConversationTokenHelper helper = new SecureConversationTokenHelper();
    public static final String JAXBELEMENT_CLASS_NAME = "javax.xml.bind.JAXBElement";

    public static SecureConversationTokenHelper getInstance() {
        return helper;
    }

    public SecureConversationTokenType getSecureConversationToken(Policy policy) {
        return this.getSecureConversationToken(policy, null);
    }

    public SecureConversationTokenType getSecureConversationToken(Policy policy, List isInvalidList) {
        ArrayList<Object> sctList = new ArrayList<Object>();
        List<Object> topList = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < topList.size(); ++i) {
            JAXBElement element;
            Object topObj = topList.get(i);
            if (!(topObj instanceof JAXBElement) || !"SymmetricBinding".equals((element = (JAXBElement)topObj).getName().getLocalPart())) continue;
            NestedPolicyType np = (NestedPolicyType)element.getValue();
            List<Object> list = np.getPolicy().getPolicyOrAllOrExactlyOne();
            for (int k = 0; k < list.size(); ++k) {
                JAXBElement element2;
                Object obj = list.get(k);
                if (!(obj instanceof JAXBElement)) continue;
                Object valueObj = ((JAXBElement)obj).getValue();
                if (!(valueObj instanceof NestedPolicyType)) {
                    Tr.warning(tc, "CWWSI9001W", new Object[]{valueObj.getClass().getName(), ((JAXBElement)obj).getName().getLocalPart()});
                    continue;
                }
                NestedPolicyType np2 = (NestedPolicyType)valueObj;
                List<Object> list2 = np2.getPolicy().getPolicyOrAllOrExactlyOne();
                if (SymmetricBinding.hasErrorInSymBinding(list2, true) || !((element2 = (JAXBElement)list2.get(0)).getValue() instanceof SecureConversationTokenType)) continue;
                sctList.add(element2.getValue());
            }
            if (sctList.size() > 1) {
                Tr.warning(tc, "CWWSI9005W", new Object[]{"SymmetricBinding"});
                if (isInvalidList != null) {
                    isInvalidList.add(new Boolean(false));
                }
                return null;
            }
            if (sctList.size() == 1) {
                return (SecureConversationTokenType)sctList.get(0);
            }
            return null;
        }
        return null;
    }

    public boolean setSCTAttributes(SecureConversationTokenType sct, AttributeList attrList) throws Exception {
        if (attrList.size() == 0) {
            return false;
        }
        Attribute attr = null;
        boolean hasBootstrapPolicy = false;
        boolean hasOtherPolicy = false;
        AttributeList bootstrapAttrList = null;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if ("IncludeToken".equals(attr.getName())) {
                sct.setIncludeToken((String)attr.getValue());
                continue;
            }
            if ("Issuer".equals(attr.getName())) {
                this.setIssuer(sct, (AttributeList)attr.getValue());
                continue;
            }
            if (attr.getName().equals("BootstrapPolicy")) {
                hasBootstrapPolicy = true;
                bootstrapAttrList = (AttributeList)attr.getValue();
                continue;
            }
            hasOtherPolicy = true;
        }
        if (hasOtherPolicy) {
            List<Object> anyList = sct.getAny();
            Policy sctPolicy = new Policy();
            anyList.add(sctPolicy);
            ObjectModelHelper.getInstance().addList(sctPolicy.getPolicyOrAllOrExactlyOne(), attrList, "IncludeToken");
        }
        if (hasBootstrapPolicy) {
            this.setBootstrapPolicy(sct, bootstrapAttrList);
        }
        return true;
    }

    private void setIssuer(SecureConversationTokenType sct, AttributeList attrList) throws Exception {
        if (attrList.isEmpty() && sct.getIssuer() == null) {
            return;
        }
        if (sct.getIssuer() == null) {
            sct.setIssuer(new EndpointReferenceType());
        }
        List<Object> anyList = sct.getIssuer().getAny();
        JAXBElement element = new JAXBElement(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference"), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new EndpointReferenceType());
        anyList.add(element);
        EndpointReferenceType endpointRef = (EndpointReferenceType)element.getValue();
        Attribute addressAttr = (Attribute)attrList.get(0);
        String value = (String)addressAttr.getValue();
        if ("Address".equals(addressAttr.getName())) {
            if (endpointRef.getAddress() == null) {
                endpointRef.setAddress(new AttributedURI());
            }
            endpointRef.getAddress().setValue((String)addressAttr.getValue());
        }
    }

    private void setBootstrapPolicy(SecureConversationTokenType sct, AttributeList bootstrapAttrList) throws Exception {
        List<Object> anyList = sct.getAny();
        OperatorContentType sctPolicy = null;
        if (!anyList.isEmpty()) {
            sctPolicy = (Policy)anyList.get(0);
        }
        if (sctPolicy == null) {
            sctPolicy = new Policy();
            anyList.add(sctPolicy);
        }
        List<Object> list = sctPolicy.getPolicyOrAllOrExactlyOne();
        NestedPolicyType bootstrapNP = new NestedPolicyType();
        bootstrapNP.setPolicy(new Policy());
        list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "BootstrapPolicy"), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)bootstrapNP));
        ObjectModelHelper.getInstance().setAttributes(bootstrapNP.getPolicy(), bootstrapAttrList);
    }
}

