/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyBean;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class SecureConversationToken
implements PolicyAttributesConstants {
    private String issuer_address = null;
    private PolicyBean bootstrap = null;
    private ArrayList assertions = new ArrayList();
    private static TraceComponent tc = Tr.register(SecureConversationTokenHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    SecureConversationToken() {
    }

    static SecureConversationToken getInstance(SecureConversationTokenType sct) {
        JAXBElement element;
        SecureConversationToken sctAssertion = new SecureConversationToken();
        EndpointReferenceType issuer = sct.getIssuer();
        if (issuer != null && !issuer.getAny().isEmpty() && (issuer = (EndpointReferenceType)(element = (JAXBElement)issuer.getAny().get(0)).getValue()).getAddress() != null) {
            sctAssertion.issuer_address = issuer.getAddress().getValue();
        }
        List<Object> anyList = sct.getAny();
        Object obj = null;
        JAXBElement element2 = null;
        for (int i = 0; i < anyList.size(); ++i) {
            obj = anyList.get(i);
            if (obj instanceof Policy) {
                List<Object> list = ((Policy)obj).getPolicyOrAllOrExactlyOne();
                for (int k = 0; k < list.size(); ++k) {
                    if (list.get(k) instanceof JAXBElement) {
                        element2 = (JAXBElement)list.get(k);
                        if (element2.getValue() instanceof NestedPolicyType) {
                            if ("BootstrapPolicy".equals(element2.getName().getLocalPart())) {
                                NestedPolicyType np = (NestedPolicyType)element2.getValue();
                                sctAssertion.bootstrap = new PolicyBean();
                                sctAssertion.bootstrap.init(np.getPolicy(), null, false);
                                continue;
                            }
                            Tr.warning(tc, "CWWSI9002W", new Object[]{element2.getName().getLocalPart(), "SecureConversationToken"});
                            continue;
                        }
                        sctAssertion.assertions.add(element2.getName().getLocalPart());
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9001W", new Object[]{list.get(k).getClass().getName(), "SecureConversationToken policy assertion"});
                }
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "SecureConversationToken"});
        }
        return sctAssertion;
    }

    AttributeList getAttributes() {
        AttributeList attrList = new AttributeList();
        if (this.issuer_address != null) {
            AttributeList subList = new AttributeList();
            subList.add(new Attribute("Address", this.issuer_address));
            attrList.add(new Attribute("Issuer", subList));
        }
        if (this.bootstrap != null) {
            attrList.add(new Attribute("BootstrapPolicy", this.bootstrap.getAttributes(null)));
        }
        for (int i = 0; i < this.assertions.size(); ++i) {
            attrList.add(new Attribute((String)this.assertions.get(i), "true"));
        }
        return attrList;
    }
}

