/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.EncryptionProtectionAssertion;
import com.ibm.ws.wssecurity.admin.PartsElement;
import com.ibm.ws.wssecurity.admin.PartsType;
import com.ibm.ws.wssecurity.admin.SignatureProtectionAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class ProtectionAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(Token.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private String _id = null;
    private String _typeName = null;
    private PartsType _partsType = null;
    private String _elementName = null;
    private PartsElement _partsElement = null;

    ProtectionAssertion() {
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public PartsElement getPartsElement() {
        return this._partsElement;
    }

    public void setPartsElement(PartsElement element) {
        this._partsElement = element;
    }

    public PartsType getPartsType() {
        return this._partsType;
    }

    public void setPartsType(PartsType type) {
        this._partsType = type;
    }

    AttributeList getAttributes() {
        AttributeList list = new AttributeList();
        AttributeList sublist = new AttributeList();
        list.add(new Attribute(this._id, sublist));
        if (this._partsType != null) {
            sublist.add(new Attribute(this._typeName, this._partsType.getAttributes()));
        }
        if (this._partsElement != null) {
            sublist.add(new Attribute(this._elementName, this._partsElement.getAttributes()));
        }
        return list;
    }

    static ProtectionAssertion getInstance(Policy policy) {
        ProtectionAssertion assertion = null;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        if (!list.isEmpty()) {
            JAXBElement element = (JAXBElement)list.get(0);
            if (element.getName().getLocalPart().startsWith("Signed")) {
                assertion = new SignatureProtectionAssertion();
            } else if (element.getName().getLocalPart().startsWith("Encrypted")) {
                assertion = new EncryptionProtectionAssertion();
            } else {
                Tr.warning(tc, "CWWSI9002W", new Object[]{element.getName().getLocalPart(), "Protection assertion"});
                return null;
            }
            ((ProtectionAssertion)assertion).setId(policy.getId());
            for (Object obj : list) {
                if (obj instanceof JAXBElement) {
                    element = (JAXBElement)obj;
                    String name = element.getName().getLocalPart();
                    if (name.endsWith("Parts")) {
                        assertion._typeName = name;
                        assertion._partsType = PartsType.getInstance((SePartsType)element.getValue());
                        continue;
                    }
                    if (name.endsWith("Elements")) {
                        assertion._elementName = name;
                        assertion._partsElement = PartsElement.getInstance((SerElementsType)element.getValue());
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9002W", new Object[]{name, "Protection assertion"});
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "Protection assertion"});
            }
        }
        return assertion;
    }
}

