/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.AttributesValidation;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class PolicyValidation
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static PolicyValidation instance = new PolicyValidation();
    private static TraceComponent tc = Tr.register(PolicyValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";

    PolicyValidation() {
    }

    public static PolicyValidation getInstance() {
        return instance;
    }

    public boolean validateFullPolicy(Policy policy, boolean sctAllowed) {
        boolean valid = true;
        int bindingCount = 0;
        int wss10Count = 0;
        int wss11Count = 0;
        int trust10Count = 0;
        boolean oneValid = true;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : list) {
            if (obj instanceof Policy) {
                oneValid = this.validateProtection((Policy)obj);
            } else if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if ((obj = ((JAXBElement)obj).getValue()) instanceof NestedPolicyType) {
                    if ("AsymmetricBinding".equals(name)) {
                        oneValid = this.validateBinding((NestedPolicyType)obj, name, asymbinding_supportedTokens, false);
                        ++bindingCount;
                    } else if ("SymmetricBinding".equals(name)) {
                        oneValid = this.validateBinding((NestedPolicyType)obj, name, symbinding_supportedTokens, sctAllowed);
                        ++bindingCount;
                        ArrayList isInvalidList = new ArrayList();
                        SecureConversationTokenType sct = SecureConversationTokenHelper.getInstance().getSecureConversationToken(policy, isInvalidList);
                        if (!isInvalidList.isEmpty()) {
                            oneValid = false;
                        } else if (sct != null && !this.validateSCT(sct)) {
                            oneValid = false;
                        }
                    } else if ("Wss10".equals(name)) {
                        oneValid = this.validateWssOrTrust(((NestedPolicyType)obj).getPolicy(), name, wss10_supportedAssertions);
                        ++wss10Count;
                    } else if ("Wss11".equals(name)) {
                        oneValid = this.validateWssOrTrust(((NestedPolicyType)obj).getPolicy(), name, wss11_supportedAssertions);
                        ++wss11Count;
                    } else if ("Trust10".equals(name)) {
                        oneValid = this.validateWssOrTrust(((NestedPolicyType)obj).getPolicy(), name, trust10_supportedAssertions);
                        ++trust10Count;
                    } else if ("SupportingTokens".equals(name)) {
                        oneValid = this.validateSupportTokens(((NestedPolicyType)obj).getPolicy());
                    } else {
                        Tr.warning(tc, "CWWSI9002W", new Object[]{name, "Top level assertions"});
                        valid = false;
                    }
                } else {
                    Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), name});
                    valid = false;
                }
            } else {
                Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "Top level assertions"});
                valid = false;
            }
            if (oneValid) continue;
            valid = false;
        }
        if (bindingCount > 1) {
            Tr.warning(tc, "CWWSI9019W");
            valid = false;
        }
        if (wss10Count > 1) {
            Tr.warning(tc, "CWWSI9020W", new Object[]{"Wss10"});
            valid = false;
        }
        if (wss11Count > 1) {
            Tr.warning(tc, "CWWSI9020W", new Object[]{"Wss11"});
            valid = false;
        }
        if (trust10Count > 1) {
            Tr.warning(tc, "CWWSI9020W", new Object[]{"Trust10"});
            valid = false;
        }
        return valid;
    }

    private boolean validateProtection(Policy p) {
        boolean valid = true;
        try {
            if (!this.validateID(p.getId(), "Protection assertion")) {
                valid = false;
            }
            List<Object> list = p.getPolicyOrAllOrExactlyOne();
            JAXBElement element = null;
            String name = null;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof JAXBElement) {
                    element = (JAXBElement)list.get(i);
                    name = element.getName().getLocalPart();
                    if (!AttributesValidation.isSupported(name, supportedProtectionTokens)) {
                        Tr.warning(tc, "CWWSI9002W", new Object[]{name, "Protection assertion"});
                        valid = false;
                        continue;
                    }
                    if (name.endsWith("Parts")) {
                        if (!(element.getValue() instanceof SePartsType)) {
                            Tr.warning(tc, "CWWSI9001W", new Object[]{element.getValue().getClass().getName(), name});
                            valid = false;
                            continue;
                        }
                        valid &= this.validateHeaderValue((SePartsType)element.getValue(), p.getId());
                        continue;
                    }
                    if (!name.endsWith("Elements")) continue;
                    if (!(element.getValue() instanceof SerElementsType)) {
                        Tr.warning(tc, "CWWSI9001W", new Object[]{element.getValue().getClass().getName(), name});
                        valid = false;
                        continue;
                    }
                    valid &= this.validateXPathValue((SerElementsType)element.getValue(), p.getId());
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{list.get(i).getClass().getName(), "Protection assertion"});
                valid = false;
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".validateProtection", FFDC_ID_1);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateProtection returns " + valid);
        }
        return valid;
    }

    private boolean validateHeaderValue(SePartsType sp, String parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateHeaderValue for " + parent);
        }
        boolean valid = true;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<HeaderType> headerList = sp.getHeader();
        HeaderType header = null;
        String value = null;
        StringBuffer buf = null;
        for (int i = 0; i < headerList.size(); ++i) {
            header = headerList.get(i);
            buf = new StringBuffer();
            buf.append("Namespace=").append(header.getNamespace());
            if (header.getName() != null) {
                buf.append(", Name=").append(header.getName());
            }
            if (map.containsKey(value = buf.toString())) {
                Integer idObj = (Integer)map.get(value);
                Tr.warning(tc, "CWWSI9030W", "Header_" + idObj + " and Header_" + i + " have same value: " + value + ", under id " + parent);
                valid = false;
                continue;
            }
            map.put(value, new Integer(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateHeaderValue returns " + valid);
        }
        return valid;
    }

    private boolean validateXPathValue(SerElementsType se, String parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateXPathValue for " + parent);
        }
        boolean valid = true;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> xpathList = se.getXPath();
        String value = null;
        for (int i = 0; i < xpathList.size(); ++i) {
            value = xpathList.get(i);
            if (map.containsKey(value)) {
                Integer idObj = (Integer)map.get(value);
                Tr.warning(tc, "CWWSI9029W", "XPath_" + idObj + " and XPath_" + i + " have same value " + value + ", under id " + parent);
                valid = false;
                continue;
            }
            map.put(value, new Integer(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateXPathValue returns " + valid);
        }
        return valid;
    }

    private boolean validateWssOrTrust(Policy p, String type, String[] supportedAssertions) {
        boolean valid = true;
        try {
            List<Object> list = p.getPolicyOrAllOrExactlyOne();
            valid = this.validateJAXBElementList(list, type, supportedAssertions, false);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".validateWssOrTrust", FFDC_ID_2);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateWssOrTrust returns " + valid);
        }
        return valid;
    }

    private boolean validateSupportTokens(Policy p) {
        boolean valid = true;
        try {
            List<Object> list;
            if (!this.validateID(p.getId(), "SupportingToken")) {
                valid = false;
            }
            if (this.validateJAXBElementList(list = p.getPolicyOrAllOrExactlyOne(), "SupportingTokens", supportingTokens_supportedSubTokens, true)) {
                JAXBElement element = (JAXBElement)list.get(0);
                if (!this.validateTokenAssertion(element.getValue(), element.getName().getLocalPart(), null)) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FFDCFilter.processException(ex, this.className + ".validateSupportTokens", FFDC_ID_3);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSupportTokens returns " + valid);
        }
        return valid;
    }

    private boolean validateBinding(NestedPolicyType np, String type, String[] supportedTokens, boolean sctAllowed) {
        boolean valid = true;
        try {
            boolean singleElement = false;
            if ("SymmetricBinding".equals(type)) {
                singleElement = true;
            }
            List<Object> policyList = np.getPolicy().getPolicyOrAllOrExactlyOne();
            JAXBElement element = null;
            String name = null;
            NestedPolicyType np2 = null;
            List<Object> list2 = null;
            if (!this.validateJAXBElementList(policyList, type, supportedTokens, false)) {
                valid = false;
            } else {
                for (int k = 0; k < policyList.size(); ++k) {
                    if (!(policyList.get(k) instanceof JAXBElement)) continue;
                    element = (JAXBElement)policyList.get(k);
                    name = element.getName().getLocalPart();
                    if ("AlgorithmSuite".equals(name)) {
                        np2 = (NestedPolicyType)element.getValue();
                        list2 = np2.getPolicy().getPolicyOrAllOrExactlyOne();
                        if (this.validateJAXBElementList(list2, "AlgorithmSuite", algorithmSuite_supportedValues, false)) continue;
                        valid = false;
                        continue;
                    }
                    if ("Layout".equals(name)) {
                        np2 = (NestedPolicyType)element.getValue();
                        list2 = np2.getPolicy().getPolicyOrAllOrExactlyOne();
                        if (this.validateJAXBElementList(list2, "Layout", layout_supportedValues, true)) continue;
                        valid = false;
                        continue;
                    }
                    if ("IncludeTimestamp".equals(name) || this.validateSubTokens((NestedPolicyType)element.getValue(), type, name, singleElement, sctAllowed)) continue;
                    valid = false;
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".validateBinding", FFDC_ID_4);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateBinding returns " + valid);
        }
        return valid;
    }

    private boolean validateSubTokens(NestedPolicyType np, String type, String subToken, boolean singleElement, boolean sctAllowed) {
        boolean valid = true;
        try {
            String[] supportedTokens = null;
            HashMap x509Map = null;
            if ("SymmetricBinding".equals(type)) {
                supportedTokens = symbinding_supportedSubTokens;
            } else {
                supportedTokens = asymbinding_supportedSubTokens;
                x509Map = new HashMap();
            }
            List<Object> list = np.getPolicy().getPolicyOrAllOrExactlyOne();
            if (!this.validateJAXBElementList(list, subToken, supportedTokens, singleElement)) {
                valid = false;
            } else {
                JAXBElement element = null;
                String name = null;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof JAXBElement)) continue;
                    element = (JAXBElement)list.get(i);
                    name = element.getName().getLocalPart();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validateSubTokens, type=" + type + ", subToken=" + subToken + ", name=" + name);
                    }
                    if ("SecureConversationToken".equals(name)) {
                        if (sctAllowed || !"SymmetricBinding".equals(type)) continue;
                        Tr.warning(tc, "CWWSI9011W");
                        valid = false;
                        continue;
                    }
                    if (this.validateTokenAssertion(element.getValue(), name, x509Map)) continue;
                    valid = false;
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".validateSubTokens", FFDC_ID_6);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSubTokens returns " + valid + " type=" + type + ", subTokne=" + subToken);
        }
        return valid;
    }

    private boolean validateSCT(SecureConversationTokenType sct) {
        boolean valid = true;
        try {
            List<Object> anyList = sct.getAny();
            Object obj = null;
            JAXBElement element = null;
            for (int i = 0; i < anyList.size(); ++i) {
                obj = anyList.get(i);
                if (obj instanceof Policy) {
                    List<Object> list = ((Policy)obj).getPolicyOrAllOrExactlyOne();
                    if (!this.validateJAXBElementList(list, "SecureConversationToken", sct_supportedSubAssertions, false)) {
                        valid = false;
                    }
                    for (int k = 0; k < list.size(); ++k) {
                        if (!(list.get(k) instanceof JAXBElement) || !((element = (JAXBElement)list.get(k)).getValue() instanceof NestedPolicyType)) continue;
                        if ("BootstrapPolicy".equals(element.getName().getLocalPart())) {
                            NestedPolicyType np = (NestedPolicyType)element.getValue();
                            if (this.validateFullPolicy(np.getPolicy(), false)) continue;
                            valid = false;
                            continue;
                        }
                        Tr.warning(tc, "CWWSI9002W", new Object[]{element.getName().getLocalPart(), "SecureConversationToken"});
                        valid = false;
                    }
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "SecureConversationToken"});
                valid = false;
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className + ".validateSecureConversationTokens", FFDC_ID_5);
            Tr.error(tc, "CWWSI9033E", ex);
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSCT returns " + valid);
        }
        return valid;
    }

    private boolean validateID(String id, String parent) {
        if (id == null || !id.startsWith("request:") && !id.startsWith("response:")) {
            Tr.warning(tc, "CWWSI9009W", new Object[]{id, parent});
            return false;
        }
        return true;
    }

    private boolean validateJAXBElementList(List list, String parent, String[] supportedAssertions, boolean singleElement) {
        boolean valid = true;
        if (list.isEmpty()) {
            Tr.warning(tc, "CWWSI9003W", new Object[]{parent});
            valid = false;
        } else if (singleElement && list.size() > 1) {
            Tr.warning(tc, "CWWSI9004W", new Object[]{parent});
            valid = false;
        }
        Object obj = null;
        for (int i = 0; i < list.size(); ++i) {
            obj = list.get(i);
            if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if (supportedAssertions == null || AttributesValidation.isSupported(name, supportedAssertions)) continue;
                Tr.warning(tc, "CWWSI9002W", new Object[]{name, parent});
                valid = false;
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), parent});
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateJAXBElementList returns " + valid + " for " + parent);
        }
        return valid;
    }

    private boolean validateTokenAssertion(Object obj, String parentName, HashMap x509Map) {
        boolean valid = true;
        if (!(obj instanceof TokenAssertionType)) {
            Tr.warning(tc, "CWWSI9001W", new Object[]{parentName + ".TokenAssertionType"});
            valid = false;
        } else {
            List<Object> anyList;
            TokenAssertionType tat = (TokenAssertionType)obj;
            String includeToken = tat.getIncludeToken();
            if (!AttributesValidation.isSupported(includeToken, includeToken_supportedValues)) {
                Tr.warning(tc, "CWWSI9010W", new Object[]{"IncludeToken", parentName});
                valid = false;
            }
            if ((anyList = tat.getAny()).isEmpty()) {
                if (!"LTPAToken".equals(parentName) && !"LTPAPropagationToken".equals(parentName)) {
                    Tr.warning(tc, "CWWSI9003W", parentName);
                    valid = false;
                }
            } else {
                List<Object> assertionList = ((Policy)anyList.get(0)).getPolicyOrAllOrExactlyOne();
                if ("CustomToken".equals(parentName)) {
                    if (assertionList.isEmpty()) {
                        Tr.warning(tc, "CWWSI9003W", parentName);
                        valid = false;
                    } else if (!(assertionList.get(0) instanceof WssCustomToken)) {
                        Tr.warning(tc, "CWWSI9001W", new Object[]{"CustomToken"});
                        valid = false;
                    }
                } else if ("UsernameToken".equals(parentName)) {
                    if (!this.validateJAXBElementList(assertionList, parentName, usernameToken_supportedSubAssertions, false)) {
                        valid = false;
                    }
                } else if ("X509Token".equals(parentName)) {
                    if (!this.validateJAXBElementList(assertionList, parentName, x509Token_supportedSubAssertions, false)) {
                        valid = false;
                    }
                    if (x509Map != null && !assertionList.isEmpty()) {
                        String assertionName = null;
                        if (assertionList.get(0) instanceof JAXBElement) {
                            assertionName = ((JAXBElement)assertionList.get(0)).getName().getLocalPart();
                            if (x509Map.containsKey(assertionName)) {
                                Tr.warning(tc, "CWWSI9020W", new Object[]{assertionName, parentName});
                                valid = false;
                            } else {
                                x509Map.put(assertionName, assertionName);
                            }
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateTokenAssertion returns " + valid + " for " + parentName);
        }
        return valid;
    }
}

