/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.EncryptionProtectionAssertion;
import com.ibm.ws.wssecurity.admin.ProtectionAssertion;
import com.ibm.ws.wssecurity.admin.SignatureProtectionAssertion;
import com.ibm.ws.wssecurity.admin.SupportingTokens;
import com.ibm.ws.wssecurity.admin.Trust10Assertion;
import com.ibm.ws.wssecurity.admin.Wss10Assertion;
import com.ibm.ws.wssecurity.admin.Wss11Assertion;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class PolicyBean
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(PolicyBean.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Policy _policy = null;
    private BindingAssertion _bindingAssertion = null;
    private Wss10Assertion _wss10Assertion = null;
    private Wss11Assertion _wss11Assertion = null;
    private Trust10Assertion _trust10Assertion = null;
    private List _signatureProtectionAssertions = new ArrayList();
    private List _encryptionProtectionAssertions = new ArrayList();
    private List _supportingTokens = new ArrayList();
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();

    PolicyBean() {
    }

    void init(Policy policy, Properties p, boolean sctAllowed) {
        this._policy = policy;
        this.parseObjects(p, sctAllowed);
    }

    AttributeList getAttributes(Properties p) {
        AttributeList list = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAttributes: _bindingAssertion=" + this._bindingAssertion);
        }
        if (this._bindingAssertion != null) {
            list.add(new Attribute(this._bindingAssertion.getName(), this._bindingAssertion.getAttributes()));
        }
        if (this._wss10Assertion != null) {
            list.add(new Attribute("Wss10", this._wss10Assertion.getAttributes()));
        }
        if (this._wss11Assertion != null) {
            list.add(new Attribute("Wss11", this._wss11Assertion.getAttributes()));
        }
        if (this._trust10Assertion != null) {
            list.add(new Attribute("Trust10", this._trust10Assertion.getAttributes()));
        }
        Iterator items = this._signatureProtectionAssertions.iterator();
        while (items.hasNext()) {
            list.add(new Attribute("SignatureProtection", ((ProtectionAssertion)items.next()).getAttributes()));
        }
        items = this._encryptionProtectionAssertions.iterator();
        while (items.hasNext()) {
            list.add(new Attribute("EncryptionProtection", ((ProtectionAssertion)items.next()).getAttributes()));
        }
        items = this._supportingTokens.iterator();
        while (items.hasNext()) {
            list.add(new Attribute("SupportingTokens", ((SupportingTokens)items.next()).getAttributes()));
        }
        return list;
    }

    void parseObjects(Properties p, boolean sctAllowed) {
        boolean[] propertyRequested = new boolean[TOP_ASSERTION_TYPES.length];
        this.setRequestedArray(propertyRequested, p);
        List<Object> list = this._policy.getPolicyOrAllOrExactlyOne();
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Policy) {
                    ProtectionAssertion assertion = ProtectionAssertion.getInstance((Policy)obj);
                    if (assertion != null && assertion instanceof SignatureProtectionAssertion) {
                        if (!this.isRequested("SignatureProtection", propertyRequested)) continue;
                        this._signatureProtectionAssertions.add(assertion);
                        continue;
                    }
                    if (assertion == null || !(assertion instanceof EncryptionProtectionAssertion) || !this.isRequested("EncryptionProtection", propertyRequested)) continue;
                    this._encryptionProtectionAssertions.add(assertion);
                    continue;
                }
                if (obj instanceof JAXBElement) {
                    String name = ((JAXBElement)obj).getName().getLocalPart();
                    if (!this.isRequested(name, propertyRequested)) continue;
                    if ((obj = ((JAXBElement)obj).getValue()) instanceof NestedPolicyType) {
                        if ("AsymmetricBinding".equals(name)) {
                            this._bindingAssertion = BindingAssertion.getInstance(name, (NestedPolicyType)obj, false);
                            continue;
                        }
                        if ("SymmetricBinding".equals(name)) {
                            this._bindingAssertion = BindingAssertion.getInstance(name, (NestedPolicyType)obj, sctAllowed);
                            continue;
                        }
                        if ("Wss10".equals(name)) {
                            this._wss10Assertion = Wss10Assertion.getInstance(((NestedPolicyType)obj).getPolicy());
                            continue;
                        }
                        if ("Wss11".equals(name)) {
                            this._wss11Assertion = Wss11Assertion.getInstance(((NestedPolicyType)obj).getPolicy());
                            continue;
                        }
                        if ("Trust10".equals(name)) {
                            this._trust10Assertion = Trust10Assertion.getInstance(((NestedPolicyType)obj).getPolicy());
                            continue;
                        }
                        if ("SupportingTokens".equals(name)) {
                            this._supportingTokens.add(SupportingTokens.getInstance(((NestedPolicyType)obj).getPolicy()));
                            continue;
                        }
                        Tr.warning(tc, "CWWSI9002W", new Object[]{name, "Top level assertions"});
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), name});
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "Top level assertions"});
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                FFDCFilter.processException(ex, this.className + ".parsePolicy", FFDC_ID_1);
                Tr.error(tc, "CWWSI9033E", ex);
            }
        }
    }

    private void setRequestedArray(boolean[] propertyRequested, Properties p) {
        if (p == null || p.size() == 0) {
            for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                propertyRequested[i] = true;
            }
        } else {
            for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                propertyRequested[i] = false;
            }
            Enumeration<?> keys = p.propertyNames();
            String key = null;
            block2: while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                    if (!key.startsWith(TOP_ASSERTION_TYPES[i])) continue;
                    propertyRequested[i] = true;
                    continue block2;
                }
            }
        }
    }

    private boolean isRequested(String type, boolean[] propertyRequested) {
        for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
            if (!TOP_ASSERTION_TYPES[i].equals(type)) continue;
            return propertyRequested[i];
        }
        Tr.warning(tc, "CWWSI9033E", new Object[]{type, "Top level assertions"});
        return false;
    }
}

