/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.EmptyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class ObjectModelHelper
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static TraceComponent tc = Tr.register(ObjectModelHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static ObjectModelHelper helper = new ObjectModelHelper();
    private SecureConversationTokenHelper sctHelper = SecureConversationTokenHelper.getInstance();
    public static final String JAXBELEMENT_CLASS_NAME = "javax.xml.bind.JAXBElement";

    public static ObjectModelHelper getInstance() {
        return helper;
    }

    protected boolean setAttributes(Policy policy, AttributeList attrList) throws Exception {
        Attribute attr = null;
        String name = null;
        Attribute subAttr = null;
        AttributeList subList = null;
        AttributeList newList = null;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            name = attr.getName();
            if (name.equals("SupportingTokens") || name.equals("EncryptionProtection") || name.equals("SignatureProtection")) {
                subList = (AttributeList)attr.getValue();
                for (int k = 0; k < subList.size(); ++k) {
                    subAttr = (Attribute)subList.get(k);
                    newList = new AttributeList();
                    newList.add(subAttr);
                    list.add(this.createObject(new Attribute(name, newList)));
                }
                continue;
            }
            list.add(this.createObject(attr));
        }
        return true;
    }

    public Object createObject(Attribute attr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObject, " + attr.getName());
        }
        Object retObj = null;
        String type = attr.getName();
        AttributeList attrList = (AttributeList)attr.getValue();
        if ("AsymmetricBinding".equals(type) || "SymmetricBinding".equals(type)) {
            retObj = this.createBinding(attr, type);
        } else if ("Wss10".equals(type) || "Wss11".equals(type) || "Trust10".equals(type)) {
            retObj = this.createWssOrTrust(attr, type);
        } else if ("SignatureProtection".equals(type) || "EncryptionProtection".equals(type)) {
            retObj = this.createProtection(attr);
        } else if ("SupportingTokens".equals(type)) {
            retObj = this.createSupportingTokens(attr);
        } else {
            Tr.warning(tc, "CWWSI9014W", type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createObject, " + retObj);
        }
        return retObj;
    }

    private Object createWssOrTrust(Attribute attr, String type) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWssOrTrust type=" + type);
        }
        NestedPolicyType np = new NestedPolicyType();
        np.setPolicy(new Policy());
        JAXBElement obj = new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", type), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)np);
        this.addList(np.getPolicy().getPolicyOrAllOrExactlyOne(), (AttributeList)attr.getValue(), "");
        return obj;
    }

    private Object createProtection(Attribute attr) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createProtection");
        }
        AttributeList attrList = (AttributeList)attr.getValue();
        Attribute attr2 = (Attribute)attrList.get(0);
        String id = attr2.getName();
        AttributeList attr2List = (AttributeList)attr2.getValue();
        Policy policy = new Policy();
        policy.setId(id);
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < attr2List.size(); ++i) {
            attr2 = (Attribute)attr2List.get(i);
            if (attr2.getName().equals("EncryptedParts") || attr2.getName().equals("SignedParts")) {
                this.setSePartsType(list, attr2);
                continue;
            }
            if (!attr2.getName().equals("EncryptedElements") && !attr2.getName().equals("SignedElements")) continue;
            this.setSerElementsType(list, attr2);
        }
        return policy;
    }

    private void setSePartsType(List list, Attribute attr) throws ClassNotFoundException {
        AttributeList attrList = (AttributeList)attr.getValue();
        Attribute subAttr = null;
        SePartsType partsType = null;
        partsType = new SePartsType();
        list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attr.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)partsType));
        for (int i = 0; i < attrList.size(); ++i) {
            subAttr = (Attribute)attrList.get(i);
            if (!subAttr.getName().equals("Body")) continue;
            partsType.setBody(new EmptyType());
            break;
        }
        this.addNoKeyList(partsType.getHeader(), attrList);
    }

    private void setSerElementsType(List list, Attribute attr) throws ClassNotFoundException {
        AttributeList attrList = (AttributeList)attr.getValue();
        Attribute subAttr = null;
        SerElementsType elementsType = null;
        elementsType = new SerElementsType();
        list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attr.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)elementsType));
        for (int i = 0; i < attrList.size(); ++i) {
            subAttr = (Attribute)attrList.get(i);
            if (!subAttr.getName().equals("XPathVersion")) continue;
            elementsType.setXPathVersion((String)subAttr.getValue());
            break;
        }
        this.addNoKeyList(elementsType.getXPath(), attrList);
    }

    private Object createSupportingTokens(Attribute attr) throws Exception {
        AttributeList attrList = (AttributeList)attr.getValue();
        NestedPolicyType np = new NestedPolicyType();
        np.setPolicy(new Policy());
        JAXBElement retObj = new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SupportingTokens"), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)np);
        Attribute attr2 = (Attribute)attrList.get(0);
        AttributeList attr2List = (AttributeList)attr2.getValue();
        np.getPolicy().setId(attr2.getName());
        this.setSubTokenAttributes(np.getPolicy().getPolicyOrAllOrExactlyOne(), (Attribute)attr2List.get(0), "SupportingTokens");
        return retObj;
    }

    private Object createBinding(Attribute attr, String type) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createBinding, type=" + type);
        }
        NestedPolicyType value = new NestedPolicyType();
        value.setPolicy(new Policy());
        JAXBElement jaxbObj = new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", type), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)value);
        List<Object> policyList = value.getPolicy().getPolicyOrAllOrExactlyOne();
        AttributeList attrList = (AttributeList)attr.getValue();
        Attribute subAttr = null;
        for (int i = 0; i < attrList.size(); ++i) {
            subAttr = (Attribute)attrList.get(i);
            if (subAttr.getName().endsWith("Token")) {
                this.setBindingToken(policyList, subAttr, type);
                continue;
            }
            this.setBindingInfo(policyList, subAttr);
        }
        return jaxbObj;
    }

    private void setBindingToken(List list, Attribute attr, String type) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBindingToken, attr=" + attr.getName());
        }
        AttributeList attrList = (AttributeList)attr.getValue();
        AttributeList sortedAttrList = this.getSortedAttrList(attrList);
        NestedPolicyType np = new NestedPolicyType();
        np.setPolicy(new Policy());
        JAXBElement element = new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attr.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)np);
        list.add(element);
        np = (NestedPolicyType)element.getValue();
        for (int i = 0; i < sortedAttrList.size(); ++i) {
            this.setSubTokenAttributes(np.getPolicy().getPolicyOrAllOrExactlyOne(), (Attribute)sortedAttrList.get(i), type);
        }
    }

    private boolean setSubTokenAttributes(List userTokenList, Attribute attr, String type) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setSubTokenAttributes, attr=" + attr.getName());
        }
        AttributeList attrList = (AttributeList)attr.getValue();
        String attrName = attr.getName();
        TokenAssertionType tat = null;
        if (userTokenList.size() > 0 && !"AsymmetricBinding".equals(type)) {
            Tr.warning(tc, "CWWSI9007W", new Object[]{type});
            return false;
        }
        JAXBElement element = null;
        element = "SecureConversationToken".equals(attrName) ? new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attrName), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new SecureConversationTokenType()) : ("UsernameToken".equals(attrName) ? new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attrName), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new TokenAssertionType()) : (attrName.startsWith("X509Token") ? new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "X509Token"), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new TokenAssertionType()) : (attrName.startsWith("CustomToken") ? new JAXBElement(new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", "CustomToken"), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new TokenAssertionType()) : new JAXBElement(new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", attrName), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new TokenAssertionType()))));
        userTokenList.add(element);
        if ("SecureConversationToken".equals(attrName)) {
            SecureConversationTokenType sct = (SecureConversationTokenType)element.getValue();
            this.sctHelper.setSCTAttributes(sct, attrList);
        } else {
            List<Object> anyList;
            tat = (TokenAssertionType)element.getValue();
            Attribute subAttr = null;
            for (int i = 0; i < attrList.size(); ++i) {
                subAttr = (Attribute)attrList.get(i);
                if (!subAttr.getName().equals("IncludeToken")) continue;
                tat.setIncludeToken((String)subAttr.getValue());
                break;
            }
            if ((anyList = tat.getAny()).size() == 0) {
                anyList.add(new Policy());
            }
            List<Object> subList = ((Policy)anyList.get(0)).getPolicyOrAllOrExactlyOne();
            if (attrName.startsWith("CustomToken")) {
                this.setCustomToken(subList, attrList);
            } else if (!"LTPAToken".equals(attrName) && !"LTPAPropagationToken".equals(attrName)) {
                this.addList(subList, attrList, "IncludeToken");
            }
        }
        return true;
    }

    private void setCustomToken(List list, AttributeList attrList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCustomToken");
        }
        Attribute attr = null;
        Attribute subAttr = null;
        AttributeList subAttrList = null;
        WssCustomToken wssCT = null;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if (!"WssCustomToken".equals(attr.getName())) continue;
            subAttrList = (AttributeList)attr.getValue();
            list.add(new WssCustomToken());
            wssCT = (WssCustomToken)list.get(0);
            for (int k = 0; k < subAttrList.size(); ++k) {
                subAttr = (Attribute)subAttrList.get(k);
                if ("uri".equals(subAttr.getName())) {
                    wssCT.setUri((String)subAttr.getValue());
                }
                if (!"localname".equals(subAttr.getName())) continue;
                wssCT.setLocalname((String)subAttr.getValue());
            }
        }
    }

    private boolean setBindingInfo(List list, Attribute attr) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBindingInfo attr name=" + attr.getName());
        }
        String name = attr.getName();
        NestedPolicyType np = null;
        if ("AlgorithmSuite".equals(name)) {
            np = new NestedPolicyType();
            np.setPolicy(new Policy());
            list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", name), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)np));
            this.addList(np.getPolicy().getPolicyOrAllOrExactlyOne(), (AttributeList)attr.getValue(), "");
        } else if ("Layout".equals(name)) {
            np = new NestedPolicyType();
            np.setPolicy(new Policy());
            list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", name), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)np));
            List<Object> list3 = np.getPolicy().getPolicyOrAllOrExactlyOne();
            list3.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", (String)attr.getValue()), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new QNameAssertionType()));
        } else if ("IncludeTimestamp".equals(name)) {
            list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", name), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new QNameAssertionType()));
        }
        return true;
    }

    protected void addList(List list, AttributeList attrList, String excludedName) throws ClassNotFoundException {
        Attribute attr = null;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            if (!(attr.getValue() instanceof String) || attr.getName().equals(excludedName)) continue;
            list.add(new JAXBElement(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attr.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), (Object)new QNameAssertionType()));
        }
    }

    private void addNoKeyList(List list, AttributeList attrList) throws ClassNotFoundException {
        list.clear();
        Attribute attr = null;
        String name = null;
        HeaderType htype = null;
        AttributeList attr2List = null;
        Attribute attr2 = null;
        AttributeList sortedAttrList = this.getSortedAttrList(attrList);
        for (int i = 0; i < sortedAttrList.size(); ++i) {
            attr = (Attribute)sortedAttrList.get(i);
            name = attr.getName();
            if (name.startsWith("Header")) {
                String headerCntString = name.substring(name.lastIndexOf(95) + 1);
                int headerCnt = new Integer(headerCntString);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addNoKeyList, name=" + name + ", headerCnt=" + headerCnt);
                }
                htype = new HeaderType();
                list.add(htype);
                attr2List = (AttributeList)attr.getValue();
                for (int i2 = 0; i2 < attr2List.size(); ++i2) {
                    attr2 = (Attribute)attr2List.get(i2);
                    if (attr2.getName().equals("Name")) {
                        htype.setName(new QName(null, (String)attr2.getValue()));
                        continue;
                    }
                    if (!attr2.getName().equals("Namespace")) continue;
                    htype.setNamespace((String)attr2.getValue());
                }
                continue;
            }
            if (!name.startsWith("XPath") || name.equals("XPathVersion")) continue;
            String xpathCntString = name.substring(name.lastIndexOf(95) + 1);
            int xpathCnt = new Integer(xpathCntString);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addNoKeyList, name=" + name + ", xpathCnt=" + xpathCnt);
            }
            list.add((String)attr.getValue());
        }
    }

    private AttributeList getSortedAttrList(AttributeList attrList) {
        AttributeList sortedList = new AttributeList();
        Attribute attr = null;
        String name = null;
        int inserted_index = -1;
        for (int i = 0; i < attrList.size(); ++i) {
            attr = (Attribute)attrList.get(i);
            name = attr.getName();
            inserted_index = -1;
            for (int k = 0; k < sortedList.size(); ++k) {
                Attribute otherAttr = (Attribute)sortedList.get(k);
                String otherName = otherAttr.getName();
                if (name.compareTo(otherName) >= 0 && name.length() >= otherName.length()) continue;
                inserted_index = k;
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSortedAttrList, add name=" + name + ", index=" + inserted_index);
            }
            if (inserted_index == -1) {
                sortedList.add(attr);
                continue;
            }
            sortedList.add(inserted_index, attr);
        }
        return sortedList;
    }
}

