/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingValidation;
import com.ibm.ws.wssecurity.admin.BindingValidationWSFP;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBindings;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class BindingWriter
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(BindingWriter.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";
    private static final String FFDC_ID_13 = "FFDC-13";
    private static final String FFDC_ID_14 = "FFDC-14";
    private static final String FFDC_ID_15 = "FFDC-15";
    private static final String FFDC_ID_16 = "FFDC-16";
    private Object _binding = null;
    private Object _applicationBinding = null;
    private Object _bootstrapBinding = null;
    private String _namespace = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";

    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingWriter.setBinding", new Object[]{bindingFileName, attributes, new Boolean(replace), context});
        }
        Properties props = null;
        BindingReader reader = new BindingReader();
        props = reader.getBinding(bindingFileName, new Properties());
        if (!props.isEmpty()) {
            this._namespace = reader.getNameSpace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingWriter.setBinding, existing binding, namespace is " + this._namespace);
            }
        } else {
            String version = null;
            if (context != null) {
                version = (String)context.get("version");
            }
            if (version == null || version.startsWith("7.0")) {
                this._namespace = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
            } else if (version.startsWith("6.1")) {
                this._namespace = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
            } else {
                Tr.error(tc, "CWWSI9104E", version);
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingWriter.setBinding, new binding, namespace is " + this._namespace);
            }
        }
        if (replace) {
            props = new Properties();
        }
        return this.processPropertiesAndWrite(bindingFileName, null, attributes, props, false);
    }

    protected boolean replaceBinding(OutputStream os, Properties attributes, String namespace, boolean tolerateValidationError) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingWriter.replaceBinding, use OutputStream", new Object[]{attributes, namespace});
        }
        this._namespace = namespace;
        return this.processPropertiesAndWrite(null, os, attributes, new Properties(), tolerateValidationError);
    }

    private boolean processPropertiesAndWrite(String bindingFileName, OutputStream os, Properties newAttributes, Properties existingProps, boolean tolerateValidationError) throws Exception {
        ArrayList<String> orderList = new ArrayList<String>();
        ArrayList<String> callerList = new ArrayList<String>();
        Enumeration<?> e = newAttributes.propertyNames();
        while (e.hasMoreElements()) {
            String anAttribute = e.nextElement().toString();
            if (!anAttribute.endsWith(".order")) continue;
            if (anAttribute.contains("caller_")) {
                callerList.add(anAttribute);
                break;
            }
            orderList.add(anAttribute);
            break;
        }
        if (!orderList.isEmpty()) {
            this.resolveOrder(existingProps, newAttributes, orderList, false);
        }
        if (!callerList.isEmpty()) {
            this.resolveOrder(existingProps, newAttributes, callerList, true);
        }
        this.handleDeleteItems(existingProps, newAttributes);
        existingProps.putAll((Map<?, ?>)newAttributes);
        this.checkIfPassword(existingProps);
        AttributeList attrList = this.propertiesToAttributeList(existingProps);
        return this.setBindingInternal(bindingFileName, os, attrList, tolerateValidationError);
    }

    private void resolveOrder(Properties oldProps, Properties newAttributes, List orderList, boolean isCaller) {
        HashMap<String, String> attributesMappedByOrder = new HashMap<String, String>();
        HashMap<String, String> processedOrders = new HashMap<String, String>();
        Properties updatedOrderAttributes = new Properties();
        Enumeration<?> e = oldProps.propertyNames();
        while (e.hasMoreElements()) {
            String anAttribute = e.nextElement().toString();
            if (!anAttribute.endsWith(".order") || isCaller && !anAttribute.contains("caller_") || !isCaller && anAttribute.contains("caller_")) continue;
            String order = oldProps.getProperty(anAttribute);
            attributesMappedByOrder.put(order, anAttribute);
            updatedOrderAttributes.setProperty(anAttribute, order);
        }
        for (String orderKey : orderList) {
            int oldOrder;
            String newOrderNumber = newAttributes.getProperty(orderKey);
            String oldOrderNumber = updatedOrderAttributes.getProperty(orderKey);
            if (oldOrderNumber == null || newOrderNumber == null) continue;
            int newOrder = Integer.parseInt(newOrderNumber);
            if (newOrder != (oldOrder = Integer.parseInt(oldOrderNumber))) {
                String anAttribute;
                boolean processAttribute;
                int i;
                if (newOrder < oldOrder) {
                    for (i = oldOrder; i > newOrder; --i) {
                        processAttribute = false;
                        anAttribute = (String)attributesMappedByOrder.get(Integer.toString(i - 1));
                        if (anAttribute == null) continue;
                        if (processedOrders.get(anAttribute) != null && i - 1 < newOrder) {
                            while (processedOrders.get(anAttribute) != null && i - 1 > newOrder) {
                                processAttribute = processedOrders.get(anAttribute = (String)attributesMappedByOrder.get(Integer.toString(--i - 1))) != null;
                            }
                        } else {
                            processAttribute = true;
                        }
                        if (processAttribute) {
                            attributesMappedByOrder.put(Integer.toString(i), anAttribute);
                            updatedOrderAttributes.setProperty(anAttribute, Integer.toString(i));
                            newAttributes.setProperty(anAttribute, Integer.toString(i));
                            continue;
                        }
                        if (processAttribute) continue;
                        anAttribute = (String)attributesMappedByOrder.get(Integer.toString(--i));
                        attributesMappedByOrder.put(oldOrderNumber, anAttribute);
                        updatedOrderAttributes.setProperty(anAttribute, oldOrderNumber);
                        newAttributes.setProperty(anAttribute, oldOrderNumber);
                    }
                } else if (newOrder > oldOrder) {
                    for (i = oldOrder; i < newOrder; ++i) {
                        processAttribute = false;
                        anAttribute = (String)attributesMappedByOrder.get(Integer.toString(i + 1));
                        if (anAttribute == null) continue;
                        if (processedOrders.get(anAttribute) != null && i + 1 < newOrder) {
                            while (processedOrders.get(anAttribute) != null && i + 1 < newOrder) {
                                processAttribute = processedOrders.get(anAttribute = (String)attributesMappedByOrder.get(Integer.toString(++i + 1))) != null;
                            }
                        } else {
                            processAttribute = true;
                        }
                        if (processAttribute) {
                            attributesMappedByOrder.put(Integer.toString(i), anAttribute);
                            updatedOrderAttributes.setProperty(anAttribute, Integer.toString(i));
                            newAttributes.setProperty(anAttribute, Integer.toString(i));
                            continue;
                        }
                        if (processAttribute) continue;
                        anAttribute = (String)attributesMappedByOrder.get(Integer.toString(++i));
                        attributesMappedByOrder.put(oldOrderNumber, anAttribute);
                        updatedOrderAttributes.setProperty(anAttribute, oldOrderNumber);
                        newAttributes.setProperty(anAttribute, oldOrderNumber);
                    }
                }
            }
            attributesMappedByOrder.put(newOrderNumber, orderKey);
            updatedOrderAttributes.setProperty(orderKey, newOrderNumber);
            newAttributes.setProperty(orderKey, newOrderNumber);
            processedOrders.put(orderKey, newOrderNumber);
        }
    }

    private void handleDeleteItems(Properties oldProps, Properties newProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleDeleteItems", new Object[]{oldProps, newProps});
        }
        Iterator<Object> names = newProps.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = (String)newProps.get(name);
            if ((value = this.trim(name, value)).length() != 0 || name.endsWith(".uri") || name.endsWith(".password") || name.endsWith(".storepass") || name.endsWith(".keypass")) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (String string : oldProps.keySet()) {
                if (!string.startsWith(name)) continue;
                list.add(string);
            }
            for (String string : list) {
                oldProps.remove(string);
            }
            names.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleDeleteItems", new Object[]{oldProps, newProps});
        }
    }

    private String trim(String property, String value) {
        if (value == null) {
            value = "";
        }
        value = value.trim();
        while (value.startsWith("\"")) {
            value = value.substring(1);
        }
        while (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        int ndx = property.lastIndexOf(46);
        String attrName = property.substring(ndx + 1);
        if ((attrName.equalsIgnoreCase("nonce") || attrName.equalsIgnoreCase("timestamp") || attrName.equalsIgnoreCase("trustanycertificate") || attrName.equalsIgnoreCase("requireExplicitDerivedKeys") || attrName.equalsIgnoreCase("requireImpliedDerivedKeys") || attrName.equalsIgnoreCase("requireDerivedKeys") || attrName.equalsIgnoreCase("enforceTokenVersion") || attrName.equalsIgnoreCase("explicitlyProtectSignatureConfirmation") || attrName.equalsIgnoreCase("onlySignEntireHeadersAndBody")) && !value.equalsIgnoreCase("true")) {
            value = "";
        }
        return value;
    }

    private void checkIfPassword(Properties props) {
        for (String string : props.keySet()) {
            String originalPassword;
            if (!string.contains("password") && !string.contains("storepass") && !string.contains("keypass") || (originalPassword = props.getProperty(string)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingWriter.checkIfPassword() - originalPassword=" + originalPassword);
            }
            props.put(string, PasswordUtilFactory.getInstance().passwordEncode(originalPassword));
        }
    }

    private boolean setBindingInternal(String bindingFileName, OutputStream os, AttributeList list, boolean tolerateValidationError) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingWriter.setBindingInternal, namespace=" + this._namespace + ", bindingFileName=" + bindingFileName);
        }
        boolean bSuccess = true;
        if ("com.ibm.xmlns.prod.websphere._200710.ws_securitybinding".equals(this._namespace)) {
            SecurityBindings bindingRoot = new SecurityBindings();
            this._binding = bindingRoot;
            for (Attribute attribute : list) {
                if (attribute.getName().equals("application")) {
                    this.setBindingName("application", (AttributeList)attribute.getValue());
                    this._applicationBinding = new com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding();
                    bSuccess &= this.setBinding(attribute.getName(), this._applicationBinding, (AttributeList)attribute.getValue());
                    bindingRoot.getSecurityBinding().add((com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding)this._applicationBinding);
                    continue;
                }
                if (attribute.getName().equals("bootstrap")) {
                    this.setBindingName("bootstrap", (AttributeList)attribute.getValue());
                    this._bootstrapBinding = new com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding();
                    bSuccess &= this.setBinding(attribute.getName(), this._bootstrapBinding, (AttributeList)attribute.getValue());
                    bindingRoot.getSecurityBinding().add((com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding)this._bootstrapBinding);
                    continue;
                }
                Tr.warning(tc, "CWWSI9031W", new Object[]{attribute.getName()});
                bSuccess = false;
            }
            bSuccess = bindingFileName != null ? (bSuccess &= this.validate(bindingRoot, bindingFileName)) : (bSuccess &= this.validate(bindingRoot, "not default binding"));
        } else if ("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding".equals(this._namespace)) {
            com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings bindingRoot = new com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings();
            this._binding = bindingRoot;
            for (Attribute attribute : list) {
                if (attribute.getName().equals("application")) {
                    this.setBindingName("application", (AttributeList)attribute.getValue());
                    this._applicationBinding = new SecurityBinding();
                    bSuccess &= this.setBinding(attribute.getName(), this._applicationBinding, (AttributeList)attribute.getValue());
                    bindingRoot.getSecurityBinding().add((SecurityBinding)this._applicationBinding);
                    continue;
                }
                if (attribute.getName().equals("bootstrap")) {
                    this.setBindingName("bootstrap", (AttributeList)attribute.getValue());
                    this._bootstrapBinding = new SecurityBinding();
                    bSuccess &= this.setBinding(attribute.getName(), this._bootstrapBinding, (AttributeList)attribute.getValue());
                    bindingRoot.getSecurityBinding().add((SecurityBinding)this._bootstrapBinding);
                    continue;
                }
                Tr.warning(tc, "CWWSI9031W", new Object[]{attribute.getName()});
                bSuccess = false;
            }
            bSuccess &= this.validateWSFP(bindingRoot);
        } else {
            Tr.warning(tc, "CWWSI9105E", new Object[]{this._namespace});
            return false;
        }
        if (bSuccess || tolerateValidationError) {
            if (bindingFileName != null) {
                os = new FileOutputStream(bindingFileName);
            }
            this.write(os);
            if (bindingFileName != null) {
                os.close();
            }
        }
        return bSuccess;
    }

    private void setBindingName(String name, AttributeList list) {
        Attribute attr = new Attribute("name", name);
        if (!list.contains(attr)) {
            list.add(attr);
        }
    }

    private boolean validateWSFP(com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings bindings) {
        return BindingValidationWSFP.getInstance().validate(bindings);
    }

    private boolean validate(SecurityBindings bindings, String bindingLocation) {
        return BindingValidation.getInstance().validate(bindings, bindingLocation);
    }

    private boolean setBinding(String parentName, Object obj, AttributeList list) {
        boolean result = true;
        for (Attribute attribute : list) {
            Object child;
            boolean isList;
            String attrName = attribute.getName();
            Object attrValue = attribute.getValue();
            if (attrName.equalsIgnoreCase("nonce") || attrName.equalsIgnoreCase("timestamp") || attrName.equalsIgnoreCase("trustanycertificate") || attrName.equalsIgnoreCase("requireExplicitDerivedKeys") || attrName.equalsIgnoreCase("requireImpliedDerivedKeys") || attrName.equalsIgnoreCase("requireDerivedKeys") || attrName.equalsIgnoreCase("enforceTokenVersion") || attrName.equalsIgnoreCase("explicitlyProtectSignatureConfirmation") || attrName.equalsIgnoreCase("onlySignEntireHeadersAndBody")) {
                if (((String)attrValue).equalsIgnoreCase("true")) {
                    attrValue = new AttributeList();
                } else {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Value for " + parentName + "." + attrName + " of \"" + attrValue + "\" is not recognized and will be treated as false");
                    continue;
                }
            }
            if (attrValue instanceof String) {
                if (this.setChildObject(obj, attrName, attrValue)) continue;
                Tr.warning(tc, "CWWSI9031W", new Object[]{parentName + "." + attrName});
                result = false;
                continue;
            }
            if (!(attrValue instanceof AttributeList)) continue;
            int ndx = attrName.lastIndexOf("_");
            int listNdx = 0;
            boolean bl = isList = ndx != -1;
            if (isList) {
                listNdx = Integer.parseInt(attrName.substring(ndx + 1));
                attrName = attrName.substring(0, ndx);
            }
            if ((child = this.getObject(obj, attrName)) != null) {
                result &= this.setBinding(parentName + "." + attribute.getName(), child, (AttributeList)attrValue);
                if (!isList) {
                    if (this.setChildObject(obj, attrName, child)) continue;
                    Tr.warning(tc, "CWWSI9024W", new Object[]{attrName, obj.getClass().getName()});
                    result = false;
                    continue;
                }
                List objList = this.getList(obj, attrName);
                if (objList != null) {
                    objList.add(child);
                    continue;
                }
                Tr.warning(tc, "CWWSI9026W", new Object[]{attribute.getName(), obj.getClass().getName()});
                result = false;
                continue;
            }
            Tr.warning(tc, "CWWSI9031W", new Object[]{parentName + "." + attrName});
            result = false;
        }
        return result;
    }

    private List getList(Object parent, String name) {
        List list = null;
        Method getMethod = this.getMethodFromName(parent, name, true);
        if (getMethod != null) {
            try {
                list = (List)getMethod.invoke(parent, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_2);
            }
            catch (InvocationTargetException ex) {
                FFDCFilter.processException(ex.getCause(), this.getClass().getName(), FFDC_ID_3);
            }
        }
        return list;
    }

    private boolean setChildObject(Object parent, String name, Object child) {
        boolean bSuccess = false;
        Method setMethod = this.getMethodFromName(parent, name, false);
        if (setMethod != null) {
            Object[] args = new Object[]{child};
            try {
                setMethod.invoke(parent, args);
                bSuccess = true;
            }
            catch (IllegalArgumentException ex) {
                FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_4);
            }
            catch (IllegalAccessException ex) {
                FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_5);
            }
            catch (InvocationTargetException ex) {
                FFDCFilter.processException(ex.getCause(), this.getClass().getName(), FFDC_ID_6);
            }
        }
        return bSuccess;
    }

    private Method getMethodFromName(Object obj, String name, boolean forList) {
        int i;
        Method method = null;
        Class<?> objClass = obj.getClass();
        String methodName = (forList ? "get" : "set") + name;
        Method[] methods = objClass.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            for (i = 0; i < methods.length; ++i) {
                int ndx = methods[i].getName().toLowerCase().indexOf(name.toLowerCase());
                if (ndx == -1 || !methods[i].getName().startsWith("get")) continue;
                method = methods[i];
                break;
            }
        }
        return method;
    }

    private Object getObject(Object obj, String name) {
        Object child = null;
        Class<?> objClass = obj.getClass();
        String methodName = "get" + name;
        Method method = null;
        Method[] methods = objClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            method = methods[i];
            break;
        }
        if (method != null) {
            Class<?> retClass = method.getReturnType();
            if (retClass.isInstance(new ArrayList())) {
                String childName = method.getName().substring(3);
                try {
                    retClass = Class.forName(this._namespace + "." + childName);
                }
                catch (ClassNotFoundException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_7);
                    retClass = null;
                }
            }
            if (retClass != null) {
                try {
                    Constructor<?> constructor = retClass.getConstructor(new Class[0]);
                    child = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_8);
                }
                catch (InstantiationException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_9);
                }
                catch (IllegalAccessException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_10);
                }
                catch (InvocationTargetException ex) {
                    FFDCFilter.processException(ex.getCause(), this.getClass().getName(), FFDC_ID_11);
                }
            }
        } else {
            String childName = null;
            for (int i = 0; i < methods.length; ++i) {
                int ndx = methods[i].getName().toLowerCase().indexOf(name.toLowerCase());
                if (ndx == -1) continue;
                childName = methods[i].getName().substring(ndx, ndx + name.length());
                break;
            }
            if (childName != null) {
                try {
                    Class<?> retClass = Class.forName(this._namespace + "." + childName);
                    Constructor<?> constructor = retClass.getConstructor(new Class[0]);
                    child = constructor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_12);
                }
                catch (NoSuchMethodException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_13);
                }
                catch (InstantiationException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_14);
                }
                catch (IllegalAccessException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_15);
                }
                catch (InvocationTargetException ex) {
                    FFDCFilter.processException(ex.getCause(), this.getClass().getName(), FFDC_ID_16);
                }
            }
        }
        return child;
    }

    private boolean write(OutputStream os) throws Exception {
        try {
            JAXBContext jcBinding = JAXBContext.newInstance((String)this._namespace, (ClassLoader)PolicyInboundConfig.class.getClassLoader());
            Marshaller m = jcBinding.createMarshaller();
            try {
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal(this._binding, os);
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.getClass().getName(), FFDC_ID_1);
            Tr.error(tc, "CWWSI9036E", (Object)jaxe);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingReader.load - caught JAXBException while reading bindings file");
                jaxe.printStackTrace();
            }
            throw jaxe;
        }
        return true;
    }

    private boolean write(String filename) throws Exception {
        return this.write(new FileOutputStream(filename));
    }

    private AttributeList propertiesToAttributeList(Properties props) {
        AttributeList list = new AttributeList();
        for (String string : props.keySet()) {
            AttributeList sublist = list;
            StringTokenizer tokenizer = new StringTokenizer(string, ".");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int ndx = this.indexOf(sublist, token);
                if (ndx == -1) {
                    int sortedIndex = this.getIndexInSortedList(sublist, token);
                    if (tokenizer.hasMoreTokens()) {
                        AttributeList newlist = new AttributeList();
                        if (sortedIndex == -1) {
                            sublist.add(new Attribute(token, newlist));
                        } else {
                            sublist.add(sortedIndex, new Attribute(token, newlist));
                        }
                        sublist = newlist;
                        continue;
                    }
                    if (sortedIndex == -1) {
                        sublist.add(new Attribute(token, props.get(string)));
                        continue;
                    }
                    sublist.add(sortedIndex, new Attribute(token, props.get(string)));
                    continue;
                }
                if (tokenizer.hasMoreTokens()) {
                    Attribute attr = (Attribute)sublist.get(ndx);
                    sublist = (AttributeList)attr.getValue();
                    continue;
                }
                sublist.add(new Attribute(token, props.get(string)));
            }
        }
        return list;
    }

    private int getIndexInSortedList(AttributeList sortedList, String name) {
        Attribute otherAttr = null;
        String otherName = null;
        int inserted_index = -1;
        int ndx = name.lastIndexOf("_");
        int baseNdx = 0;
        String baseName = name;
        if (ndx != -1) {
            baseNdx = Integer.parseInt(name.substring(ndx + 1));
            baseName = name.substring(0, ndx);
        }
        for (int k = 0; k < sortedList.size(); ++k) {
            otherAttr = (Attribute)sortedList.get(k);
            otherName = otherAttr.getName();
            ndx = otherName.lastIndexOf("_");
            int otherNdx = -1;
            if (ndx != -1) {
                otherNdx = Integer.parseInt(otherName.substring(ndx + 1));
                otherName = otherName.substring(0, ndx);
            }
            if (baseName.compareTo(otherName) >= 0 && (!baseName.equals(otherName) || baseNdx >= otherNdx)) continue;
            inserted_index = k;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIndexInSortedList, add name=" + name + ", index=" + inserted_index);
        }
        return inserted_index;
    }

    private int indexOf(AttributeList list, String name) {
        int ndx = -1;
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = (Attribute)list.get(i);
            if (!attribute.getName().equals(name)) continue;
            ndx = i;
            break;
        }
        return ndx;
    }
}

