/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Caller;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallerIdentity;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Consumerbindingref;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Generatorbindingref;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapServer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.RequiredSigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustedIdentity;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.ValueType;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.util.HashMap;
import java.util.Iterator;

public class BindingValidationWSFP
implements PolicyAttributesConstants {
    private static BindingValidationWSFP instance = new BindingValidationWSFP();
    private static TraceComponent tc = Tr.register(BindingValidationWSFP.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private HashMap orderMap = new HashMap();

    public static BindingValidationWSFP getInstance() {
        return instance;
    }

    public boolean validate(SecurityBindings bindings) {
        boolean isValid = true;
        if (bindings.getSecurityBinding().isEmpty()) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"securityBinding", "SecurityBindings"});
            isValid = false;
        }
        Iterator<SecurityBinding> it = bindings.getSecurityBinding().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SecurityBinding binding) {
        boolean isValid = true;
        isValid &= binding.getSecurityInboundBindingConfig() == null || this.validate(binding.getSecurityInboundBindingConfig());
        return isValid &= binding.getSecurityOutboundBindingConfig() == null || this.validate(binding.getSecurityOutboundBindingConfig());
    }

    private boolean validate(SecurityOutboundBindingConfig config2) {
        Iterator<Object> it;
        boolean isValid = true;
        this.orderMap.clear();
        if (config2.getGeneratorbindingref() != null) {
            isValid &= this.validate(config2.getGeneratorbindingref());
            if (!(config2.getSigningInfo().isEmpty() && config2.getEncryptionInfo().isEmpty() && config2.getKeyInfo().isEmpty() && config2.getTokenGenerator().isEmpty() && config2.getCertStoreList() == null && config2.getTimestampExpires() == null && config2.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", new Object[]{"signingInfo", "generatorbindingref"});
                isValid = false;
            }
        } else {
            it = config2.getSigningInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate(it.next(), true);
            }
            it = config2.getEncryptionInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((EncryptionInfo)it.next(), true);
            }
            it = config2.getKeyInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((KeyInfo)it.next(), false);
            }
            it = config2.getTokenGenerator().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((TokenGenerator)it.next());
            }
            isValid &= config2.getCertStoreList() == null || this.validate(config2.getCertStoreList());
            isValid &= config2.getTimestampExpires() == null || this.validate(config2.getTimestampExpires());
        }
        it = config2.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(Generatorbindingref bindingRef) {
        boolean isValid = true;
        if (bindingRef.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Generatorbindingref"});
            isValid = false;
        }
        if (bindingRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "Generatorbindingref"});
            isValid = false;
        }
        Iterator<Properties> it = bindingRef.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SigningInfo signingInfo, boolean outboundBinding) {
        boolean isValid = true;
        if (signingInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "signingInfo"});
            isValid = false;
        }
        if (outboundBinding) {
            String order = signingInfo.getOrder();
            if (order != null) {
                if (this.orderMap.get(order) == null) {
                    this.orderMap.put(order, signingInfo.getName());
                } else {
                    Tr.warning(tc, "SigningInfo " + signingInfo.getName() + " has order number " + order + ". This is the same order number than " + (String)this.orderMap.get(order) + ". Duplicate order numbers are not allowed.");
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        }
        Iterator<Object> it = signingInfo.getSigningKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        it = signingInfo.getSigningPartReference().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((SigningPartReference)it.next());
        }
        it = signingInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(EncryptionInfo encryptionInfo, boolean outboundBinding) {
        boolean isValid = true;
        if (encryptionInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "encryptionInfo"});
            isValid = false;
        }
        if (outboundBinding) {
            String order = encryptionInfo.getOrder();
            if (order != null) {
                if (this.orderMap.get(order) == null) {
                    this.orderMap.put(order, encryptionInfo.getName());
                } else {
                    Tr.warning(tc, "EncryptionInfo " + encryptionInfo.getName() + " has order number " + order + ". This is the same order number than " + (String)this.orderMap.get(order) + ". Duplicate order numbers are not allowed.");
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        }
        isValid &= encryptionInfo.getEncryptionPartReference() == null || this.validate(encryptionInfo.getEncryptionPartReference());
        Iterator<Object> it = encryptionInfo.getKeyEncryptionKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        it = encryptionInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(EncryptionPartReference encryptionPartReference) {
        boolean isValid = true;
        Iterator<DataEncryptionKeyInfo> it = encryptionPartReference.getDataEncryptionKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(KeyEncryptionKeyInfo keyEncryptionKeyInfo) {
        boolean isValid = true;
        if (keyEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "KeyEncryptionKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(DataEncryptionKeyInfo dataEncryptionKeyInfo) {
        boolean isValid = true;
        if (dataEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "DataEncryptionKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(KeyInfo keyInfo, boolean inboundBinding) {
        boolean isValid = true;
        if (keyInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "KeyInfo"});
            isValid = false;
        }
        if (keyInfo.getType() == null) {
            if (!inboundBinding) {
                Tr.warning(tc, "CWWSI9027W", new Object[]{"type", "KeyInfo"});
                isValid = false;
            }
        } else if (!(keyInfo.getType().equals("EMB") || keyInfo.getType().equals("THUMBPRINT") || keyInfo.getType().equals("KEYID") || keyInfo.getType().equals("STRREF") || keyInfo.getType().equals("X509ISSUER"))) {
            Tr.warning(tc, "CWWSI9010W", new Object[]{"Type", "KeyInfo"});
            isValid = false;
        }
        if (keyInfo.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"classname", "KeyInfo"});
            isValid = false;
        }
        isValid &= keyInfo.getTokenReference() == null || this.validate(keyInfo.getTokenReference());
        Iterator<Properties> it = keyInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(TokenReference tokenReference) {
        boolean isValid = true;
        if (tokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "TokenReference"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TokenGenerator tokenGenerator) {
        boolean isValid = true;
        if (tokenGenerator.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "TokenGenerator"});
            isValid = false;
        }
        if (tokenGenerator.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"valueType", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenGenerator.getValueType());
        }
        isValid &= tokenGenerator.getSecurityTokenReference() == null || this.validate(tokenGenerator.getSecurityTokenReference());
        if (tokenGenerator.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenGenerator.getJAASConfig());
        }
        if (tokenGenerator.getCallbackHandler() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"callbackHandler", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenGenerator.getCallbackHandler());
        }
        Iterator<Properties> it = tokenGenerator.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(ValueType valueType) {
        boolean isValid = true;
        if (valueType.getLocalName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"localName", "ValueType"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(SecurityTokenReference securityTokenReference) {
        boolean isValid = true;
        if (securityTokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "SecurityTokenReference"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(JAASConfig jAASConfig) {
        boolean isValid = true;
        if (jAASConfig.getConfigName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"configName", "JAASConfig"});
            isValid = false;
        }
        Iterator<Properties> it = jAASConfig.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(CallbackHandler callbackHandler) {
        boolean isValid = true;
        if (callbackHandler.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"classname", "CallbackHandler"});
            isValid = false;
        }
        isValid &= callbackHandler.getKeyStore() == null || this.validate(callbackHandler.getKeyStore());
        isValid &= callbackHandler.getKey() == null || this.validate(callbackHandler.getKey());
        isValid &= callbackHandler.getCertPathSettings() == null || this.validate(callbackHandler.getCertPathSettings());
        isValid &= callbackHandler.getBasicAuth() == null || this.validate(callbackHandler.getBasicAuth());
        Iterator<Properties> it = callbackHandler.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(KeyStore keyStore) {
        boolean isValid = true;
        if (keyStore.getKeyStoreRef() == null && keyStore.getPath() == null && keyStore.getStorepass() == null && keyStore.getType() == null) {
            Tr.warning(tc, "CWWSI9028W");
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(Key key) {
        boolean isValid = true;
        if (key.getAlias() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"alias", "Key"});
            isValid = false;
        }
        if (key.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Key"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertPathSettings certPathSettings) {
        boolean isValid = true;
        isValid &= certPathSettings.getTrustAnchorRef() == null || this.validate(certPathSettings.getTrustAnchorRef());
        return isValid &= certPathSettings.getCertStoreRef() == null || this.validate(certPathSettings.getCertStoreRef());
    }

    private boolean validate(TrustAnchorRef trustAnchorRef) {
        boolean isValid = true;
        if (trustAnchorRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "TrustAnchorRef"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertStoreRef certStoreRef) {
        boolean isValid = true;
        if (certStoreRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "CertStoreRef"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(BasicAuth basicAuth) {
        boolean isValid = true;
        if (basicAuth.getUserid() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"userid", "BasicAuth"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertStoreList certStoreList) {
        boolean isValid = true;
        for (Object obj : certStoreList.getLdapCertStoresOrCollectionCertStores()) {
            if (obj instanceof LdapCertStores) {
                isValid &= this.validate((LdapCertStores)obj);
                continue;
            }
            if (!(obj instanceof CollectionCertStores)) continue;
            isValid &= this.validate((CollectionCertStores)obj);
        }
        return isValid;
    }

    private boolean validate(LdapCertStores ldapCertStores) {
        boolean isValid = true;
        if (ldapCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "LdapCertStores"});
            isValid = false;
        }
        if (ldapCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"provider", "LdapCertStores"});
            isValid = false;
        }
        if (ldapCertStores.getLdapServer() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"ldapServer", "LdapCertStores"});
            isValid = false;
        } else {
            isValid &= this.validate(ldapCertStores.getLdapServer());
        }
        return isValid;
    }

    private boolean validate(LdapServer ldapServer) {
        boolean isValid = true;
        if (ldapServer.getHost() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"host", "LdapServer"});
            isValid = false;
        }
        if (ldapServer.getPort() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"port", "LdapServer"});
            isValid = false;
        }
        Iterator<Properties> it = ldapServer.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(Properties properties) {
        boolean isValid = true;
        if (properties.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Properties"});
            isValid = false;
        }
        if (properties.getValue() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"value", "Properties"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CollectionCertStores collectionCertStores) {
        boolean isValid = true;
        if (collectionCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "CollectionCertStores"});
            isValid = false;
        }
        if (collectionCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"provider", "CollectionCertStores"});
            isValid = false;
        }
        for (Object obj : collectionCertStores.getX509CertificatesOrCRL()) {
            if (obj instanceof X509Certificates) {
                isValid &= this.validate((X509Certificates)obj);
                continue;
            }
            if (!(obj instanceof CRL)) continue;
            isValid &= this.validate((CRL)obj);
        }
        return isValid;
    }

    private boolean validate(X509Certificates cert) {
        boolean isValid = true;
        if (cert.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Path", "X509Certificates"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CRL crl) {
        boolean isValid = true;
        if (crl.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Path", "CRL"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TimestampExpires timestampExpires) {
        boolean isValid = true;
        Iterator<Properties> it = timestampExpires.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SigningKeyInfo signingKeyInfo) {
        boolean isValid = true;
        if (signingKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "SigningKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(SigningPartReference signingPartReference) {
        boolean isValid = true;
        Iterator<Transform> it = signingPartReference.getTransform().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(Transform transform) {
        boolean isValid = true;
        if (transform.getAlgorithm() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Algorithm", "Transform"});
            isValid = false;
        }
        Iterator<Properties> it = transform.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SecurityInboundBindingConfig config2) {
        Iterator<Object> it;
        boolean isValid = true;
        if (config2.getConsumerbindingref() != null) {
            isValid &= this.validate(config2.getConsumerbindingref());
            if (!(config2.getSigningInfo().isEmpty() && config2.getEncryptionInfo().isEmpty() && config2.getKeyInfo().isEmpty() && config2.getTokenConsumer().isEmpty() && config2.getTrustAnchor().isEmpty() && config2.getCertStoreList() == null && config2.getCaller() == null && config2.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", new Object[]{"signingInfo", "consumerbindingref"});
                isValid = false;
            }
        } else {
            it = config2.getSigningInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate(it.next(), false);
            }
            it = config2.getEncryptionInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((EncryptionInfo)it.next(), false);
            }
            it = config2.getKeyInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((KeyInfo)it.next(), true);
            }
            it = config2.getTokenConsumer().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((TokenConsumer)it.next());
            }
            it = config2.getTrustAnchor().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((TrustAnchor)it.next());
            }
            isValid &= config2.getCertStoreList() == null || this.validate(config2.getCertStoreList());
            it = config2.getCaller().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((Caller)it.next());
            }
        }
        it = config2.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(Consumerbindingref consumerbindingref) {
        boolean isValid = true;
        if (consumerbindingref.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "Consumerbindingref"});
            isValid = false;
        }
        if (consumerbindingref.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "Consumerbindingref"});
            isValid = false;
        }
        Iterator<Properties> it = consumerbindingref.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(TokenConsumer tokenConsumer) {
        boolean isValid = true;
        if (tokenConsumer.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "tokenConsumer"});
            isValid = false;
        }
        if (tokenConsumer.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"valueType", "TokenConsumer"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenConsumer.getValueType());
        }
        isValid &= tokenConsumer.getSecurityTokenReference() == null || this.validate(tokenConsumer.getSecurityTokenReference());
        if (tokenConsumer.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "TokenConsumer"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenConsumer.getJAASConfig());
        }
        isValid &= tokenConsumer.getCallbackHandler() == null || this.validate(tokenConsumer.getCallbackHandler());
        Iterator<Properties> it = tokenConsumer.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(TrustAnchor trustAnchor) {
        boolean isValid = true;
        if (trustAnchor.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "TrustAnchor"});
            isValid = false;
        }
        if (trustAnchor.getKeyStore() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"KeyStore", "TrustAnchor"});
            isValid = false;
        } else {
            isValid &= this.validate(trustAnchor.getKeyStore());
        }
        return isValid;
    }

    private boolean validate(Caller caller) {
        boolean isValid = true;
        if (caller.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "caller"});
            isValid = false;
        }
        if (caller.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "caller"});
            isValid = false;
        } else {
            isValid &= this.validate(caller.getJAASConfig());
        }
        isValid &= caller.getCallbackHandler() == null || this.validate(caller.getCallbackHandler());
        if (caller.getCallerIdentity() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"callerIdentity", "caller"});
            isValid = false;
        } else {
            isValid &= this.validate(caller.getCallerIdentity());
        }
        isValid &= caller.getTrustedIdentity() == null || this.validate(caller.getTrustedIdentity());
        return isValid &= caller.getRequiredSigningPartReference() == null || this.validate(caller.getRequiredSigningPartReference());
    }

    private boolean validate(CallerIdentity callerIdentity) {
        boolean isValid = true;
        if (callerIdentity.getLocalName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"localName", "caller"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TrustedIdentity trustedIdentity) {
        boolean isValid = true;
        return isValid;
    }

    private boolean validate(RequiredSigningPartReference requiredSigningPartReference) {
        boolean isValid = true;
        if (requiredSigningPartReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "requiredSigningPartReference"});
            isValid = false;
        }
        return isValid;
    }
}

