/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class AttributesValidation
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private List invalidValueList = new ArrayList();
    private List invalidNameList = new ArrayList();
    private List invalidIDList = new ArrayList();
    private List duplicateSCTList = new ArrayList();
    private List duplicateBindingList = new ArrayList();
    private List duplicateXpathValueList = new ArrayList();
    private List duplicateHeaderValueList = new ArrayList();
    private static TraceComponent tc = Tr.register(AttributesValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs", Locale.getDefault());
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";

    public boolean validateProperties(Properties p) throws Exception {
        this.validateSingleBinding(p);
        Properties sctProps = new Properties();
        Properties nonSctProps = new Properties();
        this.splitSCTProps(p, sctProps, nonSctProps);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateProperties, before validateNames: nonSctProps=" + nonSctProps);
            Tr.debug(tc, "validateProperties, before validationNames: sctProps=" + sctProps);
        }
        this.validatePropertyNames(nonSctProps);
        this.validateSCTPropertyNames(sctProps);
        this.validateXPathAndHeaderValue(nonSctProps, sctProps);
        this.reportErrors();
        return this.invalidValueList.isEmpty() && this.invalidNameList.isEmpty() && this.invalidIDList.isEmpty() && this.duplicateSCTList.isEmpty() && this.duplicateBindingList.isEmpty() && this.duplicateXpathValueList.isEmpty() && this.duplicateHeaderValueList.isEmpty();
    }

    public void reportErrors() {
        this.printErrorForList(this.invalidValueList, "CWWSI9013W");
        this.printErrorForList(this.invalidNameList, "CWWSI9014W");
        this.printErrorForList(this.invalidIDList, "CWWSI9015W");
        this.printErrorForList(this.duplicateSCTList, "CWWSI9018W");
        this.printErrorForList(this.duplicateBindingList, "CWWSI9012W");
        this.printErrorForList(this.duplicateXpathValueList, "CWWSI9029W");
        this.printErrorForList(this.duplicateHeaderValueList, "CWWSI9030W");
    }

    private void printErrorForList(List list, String trCode) {
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Tr.warning(tc, trCode, new Object[]{list.get(i)});
            }
        }
    }

    public void validatePropertyNames(Properties props) {
        Enumeration<Object> names = props.keys();
        String name = null;
        StringTokenizer tokens = null;
        ArrayList<String> tokenList = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            tokens = new StringTokenizer(name, ".");
            tokenList = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                tokenList.add(tokens.nextToken());
            }
            this.validateOneProperty(props, name, tokenList);
        }
    }

    public void validateSCTPropertyNames(Properties sctProps) {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        Enumeration<Object> names = sctProps.keys();
        String name = null;
        String value = null;
        StringTokenizer tokens = null;
        ArrayList<String> tokenList = null;
        String token = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = sctProps.getProperty(name);
            tokens = new StringTokenizer(name, ".");
            tokenList = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                tokenList.add(tokens.nextToken());
            }
            if (tokenList.size() >= 3 && "SymmetricBinding".equals((String)tokenList.get(0))) {
                tokenMap.put((String)tokenList.get(1), "SymmetricBinding." + (String)tokenList.get(1));
            }
            if (tokenMap.size() > 1) break;
            if (tokenList.size() < 3) {
                this.invalidNameList.add(name + "=" + value);
                sctProps.remove(name);
                continue;
            }
            if (!("SymmetricBinding".equals((String)tokenList.get(0)) && AttributesValidation.isSupported((String)tokenList.get(1), symbinding_supportedTokens) && "SecureConversationToken".equals((String)tokenList.get(2)))) {
                this.invalidNameList.add(name + "=" + value);
                sctProps.remove(name);
                continue;
            }
            if (tokenList.size() == 3) {
                this.handleNonLeafProperty(sctProps, name, value);
                continue;
            }
            if (tokenList.size() == 4) {
                token = (String)tokenList.get(3);
                if ("IncludeToken".equals(token)) {
                    if (AttributesValidation.isSupported(value, includeToken_supportedValues)) continue;
                    this.invalidValueList.add(name + "=" + value);
                    sctProps.remove(name);
                    continue;
                }
                if ("Issuer".equals(token) || "BootstrapPolicy".equals(token)) {
                    this.handleNonLeafProperty(sctProps, name, value);
                    continue;
                }
                if (AttributesValidation.isSupported(token, sct_supportedSubAssertions) || AttributesValidation.isSupported(token, sct_derivedKeyAssertions)) continue;
                this.invalidNameList.add(name + "=" + value);
                sctProps.remove(name);
                continue;
            }
            if (tokenList.size() <= 4) continue;
            token = (String)tokenList.get(3);
            if ("BootstrapPolicy".equals(token)) {
                this.validateBootstrap(sctProps, name);
                continue;
            }
            if ("Issuer".equals(token) && "Address".equals((String)tokenList.get(4))) continue;
            this.invalidNameList.add(name + "=" + value);
            sctProps.remove(name);
        }
        if (tokenMap.size() > 1) {
            names = sctProps.keys();
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                value = sctProps.getProperty(name);
                this.duplicateSCTList.add(name + "=" + value);
            }
            sctProps.clear();
        }
    }

    private void validateBootstrap(Properties sctProps, String name) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateBootstrap, name=" + name);
        }
        String part = name.substring(name.indexOf("BootstrapPolicy") + "BootstrapPolicy".length() + 1);
        StringTokenizer tokens = new StringTokenizer(part, ".");
        ArrayList<String> tokenList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            tokenList.add(tokens.nextToken());
        }
        this.validateOneProperty(sctProps, name, tokenList);
    }

    private void validateOneProperty(Properties props, String name, List tokenList) {
        String token = (String)tokenList.get(0);
        if ("AsymmetricBinding".equals(token)) {
            this.validateBindingProps(props, name, tokenList, asymbinding_supportedTokens, false);
        } else if ("SymmetricBinding".equals(token)) {
            this.validateBindingProps(props, name, tokenList, symbinding_supportedTokens, true);
        } else if ("Wss10".equals(token)) {
            this.validateWssOrTrustProps(props, name, tokenList, wss10_supportedAssertions);
        } else if ("Wss11".equals(token)) {
            this.validateWssOrTrustProps(props, name, tokenList, wss11_supportedAssertions);
        } else if ("Trust10".equals(token)) {
            this.validateWssOrTrustProps(props, name, tokenList, trust10_supportedAssertions);
        } else if ("SupportingTokens".equals(token)) {
            this.validateSupportingTokens(props, name, tokenList, supportingTokens_supportedSubTokens);
        } else if ("EncryptionProtection".equals(token)) {
            this.validateProtection(props, name, tokenList, supportedEncryptedProtections);
        } else if ("SignatureProtection".equals(token)) {
            this.validateProtection(props, name, tokenList, supportedSignedProtections);
        } else {
            this.invalidNameList.add(name + "=" + props.getProperty(name));
            props.remove(name);
        }
    }

    private void validateSingleBinding(Properties props) {
        boolean hasAsymBinding = false;
        boolean hasSymBinding = false;
        String key = null;
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (key.startsWith("AsymmetricBinding")) {
                hasAsymBinding = true;
                continue;
            }
            if (!key.startsWith("SymmetricBinding")) continue;
            hasSymBinding = true;
        }
        Enumeration<Object> newKeys = props.keys();
        while (newKeys.hasMoreElements()) {
            key = (String)newKeys.nextElement();
            if ((!hasAsymBinding || !key.startsWith("SymmetricBinding")) && (!hasSymBinding || !key.startsWith("AsymmetricBinding"))) continue;
            this.duplicateBindingList.add(key + "=" + props.getProperty(key));
            props.remove(key);
        }
    }

    private void validateWssOrTrustProps(Properties props, String name, List tokenList, String[] supportedAssertions) {
        String value = props.getProperty(name);
        if (tokenList.size() == 1) {
            this.handleNonLeafProperty(props, name, value);
        } else if (tokenList.size() == 2 && !AttributesValidation.isSupported((String)tokenList.get(1), supportedAssertions)) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        }
    }

    private void validateBindingProps(Properties props, String name, List tokenList, String[] supportedTokens, boolean isSymmetricBinding) {
        String value = props.getProperty(name);
        if (tokenList.size() == 1) {
            this.handleNonLeafProperty(props, name, value);
        } else if (tokenList.size() == 2) {
            if ("Layout".equals((String)tokenList.get(1))) {
                if (!AttributesValidation.isSupported(value, layout_supportedValues)) {
                    this.invalidValueList.add(name + "=" + value);
                    props.remove(name);
                }
            } else if (!"IncludeTimestamp".equals((String)tokenList.get(1))) {
                this.handleNonLeafProperty(props, name, value);
            }
        } else if (tokenList.size() == 3) {
            if ("AlgorithmSuite".equals((String)tokenList.get(1))) {
                if (!AttributesValidation.isSupported((String)tokenList.get(2), algorithmSuite_supportedValues)) {
                    this.invalidNameList.add(name + "=" + value);
                    props.remove(name);
                }
            } else {
                this.handleNonLeafProperty(props, name, value);
            }
        } else if (tokenList.size() > 5 || tokenList.size() == 5 && !((String)tokenList.get(2)).startsWith("CustomToken")) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        } else {
            if (tokenList.size() >= 2 && !AttributesValidation.isSupported((String)tokenList.get(1), supportedTokens)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
                return;
            }
            if (tokenList.size() >= 3) {
                String[] supportedSubTokens = null;
                supportedSubTokens = isSymmetricBinding ? symbinding_supportedSubTokens : asymbinding_supportedSubTokens;
                String tokenName = (String)tokenList.get(2);
                if (!isSymmetricBinding && tokenName.startsWith("X509Token")) {
                    if (!this.isAttrWithNumberValid(tokenName, "X509Token")) {
                        this.invalidNameList.add(name + "=" + value);
                        props.remove(name);
                    }
                } else if (!isSymmetricBinding && tokenName.startsWith("CustomToken")) {
                    if (!this.isAttrWithNumberValid(tokenName, "CustomToken")) {
                        this.invalidNameList.add(name + "=" + value);
                        props.remove(name);
                    }
                } else if (!AttributesValidation.isSupported(tokenName, supportedSubTokens)) {
                    this.invalidNameList.add(name + "=" + value);
                    props.remove(name);
                    return;
                }
            }
            if (tokenList.size() >= 4) {
                this.validateSubAssertion(props, name, tokenList);
            }
        }
    }

    private void validateProtection(Properties props, String name, List tokenList, String[] supportedProtections) {
        String id;
        String value = props.getProperty(name);
        if (tokenList.size() >= 2 && !(id = (String)tokenList.get(1)).startsWith("request:") && !id.startsWith("response:")) {
            this.invalidIDList.add(name + "=" + value);
            props.remove(name);
        }
        if (tokenList.size() <= 3) {
            this.handleNonLeafProperty(props, name, value);
        }
        if (tokenList.size() > 5) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        } else if (tokenList.size() == 5 && !name.contains("Header")) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        } else {
            String protectionType;
            if (tokenList.size() >= 3 && !AttributesValidation.isSupported((String)tokenList.get(2), supportedProtections)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
                return;
            }
            if (tokenList.size() == 4) {
                protectionType = (String)tokenList.get(2);
                String protectionSubAttr = (String)tokenList.get(3);
                if (protectionType.endsWith("Parts")) {
                    if (!protectionSubAttr.equals("Body")) {
                        this.invalidNameList.add(name + "=" + value);
                        props.remove(name);
                    }
                } else if (protectionType.endsWith("Elements")) {
                    if (!protectionSubAttr.equals("XPathVersion") && !this.isAttrWithNumberValid(protectionSubAttr, "XPath")) {
                        this.invalidNameList.add(name + "=" + value);
                        props.remove(name);
                    }
                } else {
                    this.invalidNameList.add(name + "=" + value);
                    props.remove(name);
                }
            } else if (tokenList.size() == 5) {
                protectionType = (String)tokenList.get(2);
                String protectionSubAttr = (String)tokenList.get(3);
                String token5 = (String)tokenList.get(4);
                if (protectionType.endsWith("Parts")) {
                    if (!this.isAttrWithNumberValid(protectionSubAttr, "Header") || !token5.equals("Name") && !token5.equals("Namespace")) {
                        this.invalidNameList.add(name + "=" + value);
                        props.remove(name);
                    }
                } else {
                    this.invalidNameList.add(name + "=" + value);
                    props.remove(name);
                }
            }
        }
    }

    private boolean isAttrWithNumberValid(String attrName, String prefix) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isAttrWithNumberValid, attrName=" + attrName + ", prefix=" + prefix);
        }
        if (!attrName.startsWith(prefix + "_")) {
            return false;
        }
        try {
            String headerCntString = attrName.substring(attrName.lastIndexOf(95) + 1);
            int headerCnt = new Integer(headerCntString);
            if (headerCnt < 0) {
                Tr.warning(tc, "CWWSI9023W", new Object[]{attrName});
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            FFDCFilter.processException(ex, this.className + ".isAttrWithNumberValid", FFDC_ID_1);
            Tr.error(tc, "CWWSI9033E", ex);
            return false;
        }
    }

    private void validateSupportingTokens(Properties props, String name, List tokenList, String[] supportedSubTokens) {
        String value = props.getProperty(name);
        if (tokenList.size() >= 2) {
            String id = (String)tokenList.get(1);
            if (!id.startsWith("request:") && !id.startsWith("response:")) {
                this.invalidIDList.add(name + "=" + value);
                props.remove(name);
            }
        } else if (tokenList.size() <= 3) {
            this.handleNonLeafProperty(props, name, value);
        } else if (tokenList.size() > 5 || tokenList.size() > 4 && !"CustomToken".equals((String)tokenList.get(2))) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        } else {
            if (tokenList.size() >= 3 && !AttributesValidation.isSupported((String)tokenList.get(2), supportedSubTokens)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
                return;
            }
            if (tokenList.size() >= 4) {
                this.validateSubAssertion(props, name, tokenList);
            }
        }
    }

    private void validateSubAssertion(Properties props, String name, List tokenList) {
        if (tokenList.size() != 4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateSubAssertion is called in a wrong way, tokenList size is " + tokenList);
            }
            return;
        }
        String subToken = (String)tokenList.get(2);
        String subAssertion = (String)tokenList.get(3);
        String value = props.getProperty(name);
        if ("IncludeToken".equals(subAssertion)) {
            if (!AttributesValidation.isSupported(value, includeToken_supportedValues)) {
                this.invalidValueList.add(name + "=" + value);
                props.remove(name);
            }
        } else if ("UsernameToken".equals(subToken)) {
            if (!AttributesValidation.isSupported(subAssertion, usernameToken_supportedSubAssertions)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
            }
        } else if (subToken.startsWith("X509Token")) {
            if (!AttributesValidation.isSupported(subAssertion, x509Token_supportedSubAssertions)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
            }
        } else if (subToken.startsWith("CustomToken")) {
            if (!AttributesValidation.isSupported(subAssertion, customToken_supportedSubAssertions)) {
                this.invalidNameList.add(name + "=" + value);
                props.remove(name);
            } else if (tokenList.size() == 4) {
                this.handleNonLeafProperty(props, name, value);
            }
        } else if ("LTPAToken".equals(subToken) || "LTPAPropagationToken".equals(subToken)) {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        } else {
            this.invalidNameList.add(name + "=" + value);
            props.remove(name);
        }
    }

    public static boolean isSupported(String name, String[] supportedNames) {
        for (int i = 0; i < supportedNames.length; ++i) {
            if (!supportedNames[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private void handleNonLeafProperty(Properties props, String name, String value) {
        if (!"".equals(value)) {
            this.invalidValueList.add(name + "=" + value);
            props.remove(name);
        }
    }

    private void splitSCTProps(Properties p, Properties sctProps, Properties nonSctProps) {
        if (p == null || p.size() == 0) {
            return;
        }
        Enumeration<Object> names = p.keys();
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (name.contains("SecureConversationToken")) {
                sctProps.put(name, p.getProperty(name));
                continue;
            }
            nonSctProps.put(name, p.getProperty(name));
        }
    }

    private void validateXPathAndHeaderValue(Properties nonSctProps, Properties sctProps) {
        try {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)nonSctProps);
            p.putAll((Map<?, ?>)sctProps);
            Enumeration<?> keyEnum = null;
            ArrayList<String> xpathKeyList = new ArrayList<String>();
            ArrayList<String> headerNSKeyList = new ArrayList<String>();
            String key = null;
            keyEnum = p.propertyNames();
            while (keyEnum.hasMoreElements()) {
                key = (String)keyEnum.nextElement();
                if (key.contains("XPath_")) {
                    xpathKeyList.add(key);
                    continue;
                }
                if (!key.contains("Header_") || !key.endsWith("Namespace")) continue;
                headerNSKeyList.add(key);
            }
            this.validateXPathValue(p, nonSctProps, sctProps, xpathKeyList);
            this.validateHeaderValue(p, nonSctProps, sctProps, headerNSKeyList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void validateXPathValue(Properties allProps, Properties nonSctProps, Properties sctProps, ArrayList xpathKeyList) {
        int lastIndex = -1;
        String prefix = null;
        String key = null;
        String otherKey = null;
        String value = null;
        String otherValue = null;
        StringBuffer buf = null;
        block0: for (int i = 0; i < xpathKeyList.size(); ++i) {
            key = (String)xpathKeyList.get(i);
            lastIndex = key.lastIndexOf("_");
            prefix = key.substring(0, lastIndex + 1);
            value = allProps.getProperty(key);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateXPathValue, key=" + key + ", prefix=" + prefix + ", value=" + value);
            }
            for (int k = i + 1; k < xpathKeyList.size(); ++k) {
                otherKey = (String)xpathKeyList.get(k);
                if (!otherKey.startsWith(prefix) || !value.equals(otherValue = allProps.getProperty(otherKey))) continue;
                buf = new StringBuffer();
                buf.append(key).append("=").append(value).append(", ").append(otherKey).append("=").append(otherValue);
                this.duplicateXpathValueList.add(buf.toString());
                if (key.contains("SecureConversationToken")) {
                    sctProps.remove(key);
                    sctProps.remove(otherKey);
                    continue block0;
                }
                nonSctProps.remove(key);
                nonSctProps.remove(otherKey);
                continue block0;
            }
        }
    }

    private void validateHeaderValue(Properties allProps, Properties nonSctProps, Properties sctProps, ArrayList headerNSKeyList) {
        int lastIndex = -1;
        String prefix = null;
        StringBuffer buf = null;
        String namespaceKey = null;
        String namespaceValue = null;
        String otherNamespaceKey = null;
        String otherNamespaceValue = null;
        String nameKey = null;
        String otherNameKey = null;
        String nameValue = null;
        String otherNameValue = null;
        block0: for (int i = 0; i < headerNSKeyList.size(); ++i) {
            namespaceKey = (String)headerNSKeyList.get(i);
            namespaceValue = allProps.getProperty(namespaceKey);
            lastIndex = namespaceKey.lastIndexOf("_");
            prefix = namespaceKey.substring(0, lastIndex + 1);
            lastIndex = namespaceKey.lastIndexOf(".Namespace");
            nameKey = namespaceKey.substring(0, lastIndex + 1) + "Name";
            nameValue = allProps.getProperty(nameKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateHeaderValue, validate header value: prefix=" + prefix + ", nameKey=" + nameKey + ", nameValue=" + nameValue + ", namespaceKey=" + namespaceKey + ", namespaceValue=" + namespaceValue);
            }
            for (int k = i + 1; k < headerNSKeyList.size(); ++k) {
                otherNamespaceKey = (String)headerNSKeyList.get(k);
                if (!otherNamespaceKey.startsWith(prefix) || !namespaceValue.equals(otherNamespaceValue = allProps.getProperty(otherNamespaceKey))) continue;
                lastIndex = otherNamespaceKey.lastIndexOf(".Namespace");
                otherNameKey = otherNamespaceKey.substring(0, lastIndex + 1) + "Name";
                otherNameValue = allProps.getProperty(otherNameKey);
                if ((nameValue != null || otherNameValue != null) && (nameValue == null || !nameValue.equals(otherNameValue))) continue;
                buf = new StringBuffer();
                buf.append(namespaceKey).append("=").append(namespaceValue);
                if (nameValue != null) {
                    buf.append(", ").append(nameKey).append("=").append(nameValue);
                }
                buf.append(", ").append(otherNamespaceKey).append("=").append(otherNamespaceValue);
                if (otherNameValue != null) {
                    buf.append(", ").append(otherNameKey).append("=").append(otherNameValue);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validateHeaderValue, find duplicate value for " + buf.toString());
                }
                this.duplicateHeaderValueList.add(buf.toString());
                if (namespaceKey.contains("SecureConversationToken")) {
                    sctProps.remove(namespaceKey);
                    sctProps.remove(otherNamespaceKey);
                    sctProps.remove(nameKey);
                    sctProps.remove(otherNameKey);
                    continue block0;
                }
                nonSctProps.remove(namespaceKey);
                nonSctProps.remove(otherNamespaceKey);
                nonSctProps.remove(nameKey);
                nonSctProps.remove(otherNameKey);
                continue block0;
            }
        }
    }

    private String getFormattedMessage(ResourceBundle bundle, String key, Object[] args, String msg) {
        String formattedMsg = null;
        try {
            String result = bundle.getString(key);
            formattedMsg = result == null ? msg : MessageFormat.format(result, args);
        }
        catch (Throwable t) {
            formattedMsg = msg;
        }
        return formattedMsg;
    }
}

