/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class AsymmetricBinding
extends BindingAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(AsymmetricBinding.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private List _initiatorSignatureToken = new ArrayList();
    private List _initiatorEncryptionToken = new ArrayList();
    private List _recipientSignatureToken = new ArrayList();
    private List _recipientEncryptionToken = new ArrayList();
    private List _initiatorToken = new ArrayList();
    private List _recipientToken = new ArrayList();
    public static final String[] supportedTokes = new String[]{"InitiatorSignatureToken", "InitiatorEncryptionToken", "RecipientSignatureToken", "RecipientEncryptionToken", "InitiatorToken", "RecipientToken"};

    AsymmetricBinding() {
    }

    void parsePolicy(Policy policy, boolean sctAllowed) {
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : list) {
            if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parsePolicy, name=" + name);
                }
                if ("IncludeTimestamp".equals(name) || "AlgorithmSuite".equals(name) || "Layout".equals(name)) {
                    this.parseObject((JAXBElement)obj);
                    continue;
                }
                NestedPolicyType np = (NestedPolicyType)((JAXBElement)obj).getValue();
                if (np == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "parsePolicy, NestedPolicy is null");
                    }
                    return;
                }
                List<Object> sublist = np.getPolicy().getPolicyOrAllOrExactlyOne();
                Object oneObj = null;
                Iterator<Object> elements = sublist.iterator();
                while (elements.hasNext()) {
                    oneObj = elements.next();
                    if (!(oneObj instanceof JAXBElement)) {
                        Tr.warning(tc, "CWWSI9001W", new Object[]{elements.next().getClass().getName(), "Top level assertions"});
                        continue;
                    }
                    JAXBElement element = (JAXBElement)oneObj;
                    Token token = Token.getInstance(element.getName().getLocalPart(), (TokenAssertionType)element.getValue());
                    if ("InitiatorSignatureToken".equals(name)) {
                        this._initiatorSignatureToken.add(token);
                        continue;
                    }
                    if ("InitiatorEncryptionToken".equals(name)) {
                        this._initiatorEncryptionToken.add(token);
                        continue;
                    }
                    if ("RecipientSignatureToken".equals(name)) {
                        this._recipientSignatureToken.add(token);
                        continue;
                    }
                    if ("RecipientEncryptionToken".equals(name)) {
                        this._recipientEncryptionToken.add(token);
                        continue;
                    }
                    if ("InitiatorToken".equals(name)) {
                        this._initiatorToken.add(token);
                        continue;
                    }
                    if ("RecipientToken".equals(name)) {
                        this._recipientToken.add(token);
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9002W", new Object[]{name, "AsymmetricBinding"});
                }
                continue;
            }
            if (obj instanceof Policy) continue;
            Tr.warning(tc, "CWWSI9002W", new Object[]{obj.getClass().getName(), "AsymmetricBinding"});
        }
    }

    private AttributeList getAttributeListForTokenType(List tokensList) {
        int x509Token_index = 0;
        int customToken_index = 0;
        Token token = null;
        AttributeList elementList = new AttributeList();
        for (int i = 0; i < tokensList.size(); ++i) {
            token = (Token)tokensList.get(i);
            if ("X509Token".equals(token._name)) {
                elementList.addAll(token.getAttributes(x509Token_index++));
                continue;
            }
            if ("CustomToken".equals(token._name)) {
                elementList.addAll(token.getAttributes(customToken_index++));
                continue;
            }
            elementList.addAll(token.getAttributes(-1));
        }
        return elementList;
    }

    AttributeList getAttributes() {
        AttributeList list = new AttributeList();
        if (!this._initiatorSignatureToken.isEmpty()) {
            list.add(new Attribute("InitiatorSignatureToken", this.getAttributeListForTokenType(this._initiatorSignatureToken)));
        }
        if (!this._initiatorEncryptionToken.isEmpty()) {
            list.add(new Attribute("InitiatorEncryptionToken", this.getAttributeListForTokenType(this._initiatorEncryptionToken)));
        }
        if (!this._recipientSignatureToken.isEmpty()) {
            list.add(new Attribute("RecipientSignatureToken", this.getAttributeListForTokenType(this._recipientSignatureToken)));
        }
        if (!this._recipientEncryptionToken.isEmpty()) {
            list.add(new Attribute("RecipientEncryptionToken", this.getAttributeListForTokenType(this._recipientEncryptionToken)));
        }
        if (!this._initiatorToken.isEmpty()) {
            list.add(new Attribute("InitiatorToken", this.getAttributeListForTokenType(this._initiatorToken)));
        }
        if (!this._recipientToken.isEmpty()) {
            list.add(new Attribute("RecipientToken", this.getAttributeListForTokenType(this._recipientToken)));
        }
        list.addAll(super.getAttributes());
        return list;
    }
}

