/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsrf.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsrf.RequestedTerminationTime;
import com.ibm.websphere.wsrf.SetTerminationTime;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarSerializer;
import com.ibm.ws.wsrf.binders.ElementIterator;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import com.ibm.wsspi.webservices.binding.CustomBindingContext;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class SetTerminationTimeBinder
implements CustomBinder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(SetTerminationTimeBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final String TYPENAME = "SetTerminationTime";
    protected static final String JAVATYPENAME = "com.ibm.websphere.wsrf.SetTerminationTime";
    private static final String FIELD_REQUESTED_TERMINATION_TIME = "RequestedTerminationTime";
    private static final String FIELD_REQUESTED_LIFETIME_DURATION = "RequestedLifetimeDuration";
    private static final String ATTRIBUTE_NIL = "xsi:nil";

    public QName getQName() {
        return new QName("http://docs.oasis-open.org/wsrf/rl-2", TYPENAME);
    }

    public String getQNameScope() {
        return "element";
    }

    public String getJavaName() {
        return JAVATYPENAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPElement serialize(Object data, SOAPElement rootNode, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "serialize", new Object[]{data, rootNode, context});
        }
        if (!(data instanceof SetTerminationTime)) {
            throw new SOAPException("Object to be serialized passed to SetTerminationTimeBinder was of incorrect type. Expected class implementingcom.ibm.websphere.wsrf.SetTerminationTime but found " + data.getClass().toString());
        }
        SetTerminationTime setTerminationTime = (SetTerminationTime)data;
        RequestedTerminationTime requestedTerminationTime = setTerminationTime.getRequestedTerminationTime();
        if (requestedTerminationTime != null) {
            SOAPElement requestedTerminationTimeElement = rootNode.addChildElement(FIELD_REQUESTED_TERMINATION_TIME, "wsrf-rl", "http://docs.oasis-open.org/wsrf/rl-2");
            Calendar terminationTime = requestedTerminationTime.getTerminationTime();
            if (terminationTime != null) {
                if (requestedTerminationTime.isNil()) throw new SOAPException("Object to be serialized passed to SetTerminationTimeBinder was of correct type but  'RequestedTerminationTime' field has a value when xsi:nil is true");
                String terminationTimeStr = CalendarSerializer.getDateTimeValueAsString(terminationTime);
                requestedTerminationTimeElement.addTextNode(terminationTimeStr);
            } else {
                if (!requestedTerminationTime.isNil()) {
                    throw new SOAPException("Object to be serialized passed to SetTerminationTimeBinder was of correct type but  'RequestedTerminationTime' field has no value when xsi:nil is false");
                }
                requestedTerminationTimeElement.setAttribute(ATTRIBUTE_NIL, "true");
            }
        } else {
            String requestedLifetimeDuration = setTerminationTime.getRequestedLifetimeDuration();
            if (requestedLifetimeDuration == null) throw new SOAPException("Object to be serialized passed to SetTerminationTimeBinder was of correct type but contained neither a 'RequestedTerminationTime' field nor a 'RequestedLifetimeDuration' field");
            SOAPElement requestedTerminationTimeElement = rootNode.addChildElement(FIELD_REQUESTED_LIFETIME_DURATION, "wsrf-rl", "http://docs.oasis-open.org/wsrf/rl-2");
            requestedTerminationTimeElement.addTextNode(requestedLifetimeDuration);
        }
        if (!TRACE_COMPONENT.isEntryEnabled()) return rootNode;
        Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        return rootNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deserialize(SOAPElement root, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserialize", new Object[]{root, context});
        }
        SetTerminationTime setTerminationTime = null;
        RequestedTerminationTime requestedTerminationTime = null;
        String requestedLifetimeDuration = null;
        ElementIterator elements = new ElementIterator(root.getChildElements());
        SOAPElement element = SetTerminationTimeBinder.getElement(elements);
        if (element == null) {
            throw new SOAPException("Object to be deserialized by SetTerminationTimeBinder contains no child elements");
        }
        if (SetTerminationTimeBinder.checkElement(element, FIELD_REQUESTED_TERMINATION_TIME, "http://docs.oasis-open.org/wsrf/rl-2")) {
            String requestedTerminationTimeString;
            boolean isNil = false;
            if (element.hasAttribute(ATTRIBUTE_NIL)) {
                String nilStr = element.getAttribute(ATTRIBUTE_NIL);
                isNil = Boolean.valueOf(nilStr);
            }
            if ((requestedTerminationTimeString = element.getValue()) != null) {
                if (isNil) {
                    throw new SOAPException("Object to be deserialized by SetTerminationTimeBinder contains a RequestedTerminationTime value when none was expected");
                }
                try {
                    Calendar terminationTime = (Calendar)CalendarDeserializer.makeDateTimeValue(requestedTerminationTimeString);
                    requestedTerminationTime = new RequestedTerminationTime(terminationTime);
                }
                catch (Exception exc) {
                    throw new SOAPException("Object to be deserialzied by SetTerminationTimeBinder contains an invalid RequestedTerminationTime field");
                }
            } else {
                if (!isNil) throw new SOAPException("Object to be deserialized by SetTerminationTimeBinder contains a null value for RequestedTerminationTime field");
                requestedTerminationTime = new RequestedTerminationTime();
            }
            setTerminationTime = new SetTerminationTime(requestedTerminationTime);
        } else {
            if (!SetTerminationTimeBinder.checkElement(element, FIELD_REQUESTED_LIFETIME_DURATION, "http://docs.oasis-open.org/wsrf/rl-2")) throw new SOAPException("Object to be deserialized by SetTerminationTimeBinder contains an unrecognized field");
            requestedLifetimeDuration = element.getValue();
            if (requestedLifetimeDuration == null) throw new SOAPException("Object to be deserialzied by SetTerminationTimeBinder contains a null value for RequestedLifetimeDuration field");
            setTerminationTime = new SetTerminationTime(requestedLifetimeDuration);
        }
        if (!TRACE_COMPONENT.isEntryEnabled()) return setTerminationTime;
        Tr.exit(TRACE_COMPONENT, "deserialize", setTerminationTime);
        return setTerminationTime;
    }

    public static SOAPElement getElement(ElementIterator source) {
        SOAPElement element = null;
        if (source.hasNext()) {
            element = source.next();
        }
        return element;
    }

    public static boolean checkElement(SOAPElement element, String local, String namespace) {
        Name name;
        boolean result = false;
        if (element != null && (name = element.getElementName()) != null) {
            String elementLocal = name.getLocalName();
            String elementNamespace = name.getURI();
            if (local.equals(elementLocal) && namespace.equals(elementNamespace)) {
                result = true;
            }
        }
        return result;
    }
}

