/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsrf.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsrf.Attribute;
import com.ibm.websphere.wsrf.BaseFault;
import com.ibm.websphere.wsrf.ErrorCode;
import com.ibm.websphere.wsrf.FaultDescription;
import com.ibm.websphere.wsrf.IOSerializableSOAPElement;
import com.ibm.websphere.wsrf.IOSerializableSOAPElementFactory;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CalendarSerializer;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsrf.binders.ElementIterator;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import com.ibm.wsspi.webservices.binding.CustomBindingContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class BaseFaultTypeBinder
implements CustomBinder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(BaseFaultTypeBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final String TYPENAME = "BaseFaultType";
    protected static final String JAVATYPENAME = "com.ibm.websphere.wsrf.BaseFault";
    private static final String FIELD_TIMESTAMP = "Timestamp";
    private static final String FIELD_ORIGINATOR = "Originator";
    private static final String FIELD_DESCRIPTION = "Description";
    private static final String FIELD_ERRORCODE = "ErrorCode";
    private static final String FIELD_FAULTCAUSE = "FaultCause";
    private static final String ATTRIBUTE_LANGUAGE = "xml:lang";
    private static final String ATTRIBUTE_DIALECT = "dialect";

    public QName getQName() {
        return new QName("http://docs.oasis-open.org/wsrf/bf-2", TYPENAME);
    }

    public String getQNameScope() {
        return "complexType";
    }

    public String getJavaName() {
        return JAVATYPENAME;
    }

    public SOAPElement serialize(Object data, SOAPElement rootNode, CustomBindingContext context) throws SOAPException {
        Attribute[] attributes;
        IOSerializableSOAPElement faultCause;
        FaultDescription[] faultDescriptions;
        int i;
        ErrorCode errorCode;
        Calendar timestamp;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "serialize", new Object[]{data, rootNode, context});
        }
        EndpointReferenceTypeBinder eprBinder = new EndpointReferenceTypeBinder();
        if (!(data instanceof BaseFault)) {
            throw new SOAPException("Object to be serialized passed to BaseFaultTypeBinder was of incorrect type. Expected class implementingcom.ibm.websphere.wsrf.BaseFault but found " + data.getClass().toString());
        }
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        BaseFault baseFault = (BaseFault)data;
        IOSerializableSOAPElement[] extensibilityElements = baseFault.getExtensibilityElements();
        if (extensibilityElements != null) {
            for (int e = 0; e < extensibilityElements.length; ++e) {
                rootNode.addChildElement(extensibilityElements[e].getSOAPElement());
            }
        }
        if ((timestamp = baseFault.getTimestamp()) == null) {
            throw new SOAPException("Object to be serialized passed to BaseFaultTypeBinder was of correct type but did not contain mandatory 'timestamp' field");
        }
        SOAPElement timestampElement = rootNode.addChildElement(FIELD_TIMESTAMP, "wsrf-bf", "http://docs.oasis-open.org/wsrf/bf-2");
        String timestampStr = CalendarSerializer.getDateTimeValueAsString(timestamp);
        timestampElement.addTextNode(timestampStr);
        EndpointReference originatorEPR = baseFault.getOriginator();
        if (originatorEPR != null) {
            SOAPElement originatorElement = rootNode.addChildElement(FIELD_ORIGINATOR, "wsrf-bf", "http://docs.oasis-open.org/wsrf/bf-2");
            eprBinder.serialize(originatorEPR, originatorElement, context);
        }
        if ((errorCode = baseFault.getErrorCode()) != null) {
            URI dialect = errorCode.getDialect();
            if (dialect == null) {
                throw new SOAPException("Missing attribute dialect on ErrorCode element");
            }
            SOAPElement errorCodeElement = rootNode.addChildElement(FIELD_ERRORCODE, "wsrf-bf", "http://docs.oasis-open.org/wsrf/bf-2");
            if (errorCode.getChildElements() != null) {
                IOSerializableSOAPElement[] errorCodeChildElements = errorCode.getChildElements();
                for (i = 0; i < errorCodeChildElements.length; ++i) {
                    errorCodeElement.addChildElement(errorCodeChildElements[i].getSOAPElement());
                }
            } else {
                errorCodeElement.addTextNode(errorCode.getValue());
            }
            errorCodeElement.setAttribute(ATTRIBUTE_DIALECT, dialect.toString());
        }
        if ((faultDescriptions = baseFault.getDescriptions()) != null) {
            for (int d = 0; d < faultDescriptions.length; ++d) {
                SOAPElement descriptionElement = rootNode.addChildElement(FIELD_DESCRIPTION, "wsrf-bf", "http://docs.oasis-open.org/wsrf/bf-2");
                descriptionElement.addTextNode(faultDescriptions[d].getDescription());
                if (faultDescriptions[d].getLanguage() == null) continue;
                descriptionElement.setAttribute(ATTRIBUTE_LANGUAGE, faultDescriptions[d].getLanguage());
            }
        }
        if ((faultCause = baseFault.getFaultCause()) != null) {
            SOAPElement faultCauseElement = rootNode.addChildElement(FIELD_FAULTCAUSE, "wsrf-bf", "http://docs.oasis-open.org/wsrf/bf-2");
            faultCauseElement.addChildElement(faultCause.getSOAPElement());
        }
        if ((attributes = baseFault.getAttributes()) != null) {
            for (i = 0; i < attributes.length; ++i) {
                Attribute attribute = attributes[i];
                Name name = soapFactory.createName(attribute.getName().getLocalPart(), attribute.getName().getPrefix(), attribute.getName().getNamespaceURI());
                rootNode.addAttribute(name, attribute.getValue());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", rootNode);
        }
        return rootNode;
    }

    public Object deserialize(SOAPElement root, CustomBindingContext context) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserialize", new Object[]{root, context});
        }
        BaseFault baseFault = new BaseFault();
        ElementIterator elements = new ElementIterator(root.getChildElements());
        this.deserialize(baseFault, root, elements, context, false);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", baseFault);
        }
        return baseFault;
    }

    public void deserialize(BaseFault target, SOAPElement root, ElementIterator elements, CustomBindingContext context, boolean superClass) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserialize", new Object[]{root, elements, context, superClass});
        }
        IOSerializableSOAPElement[] extensibilityElements = null;
        Calendar timestamp = null;
        EndpointReference originator = null;
        ErrorCode errorCode = null;
        FaultDescription[] faultDescriptions = null;
        IOSerializableSOAPElement faultCause = null;
        QName attributeName = null;
        String attributeValue = null;
        IOSerializableSOAPElementFactory serFactory = IOSerializableSOAPElementFactory.newInstance();
        EndpointReferenceTypeBinder eprBinder = new EndpointReferenceTypeBinder();
        SOAPElement element = BaseFaultTypeBinder.getElement(elements);
        if (element == null) {
            throw new SOAPException("Object to be deserialized by BaseFaultTypeBinder contains no child elements");
        }
        if (!BaseFaultTypeBinder.checkElement(element, FIELD_TIMESTAMP, "http://docs.oasis-open.org/wsrf/bf-2")) {
            ArrayList<IOSerializableSOAPElement> elementList = new ArrayList<IOSerializableSOAPElement>();
            while (element != null && !BaseFaultTypeBinder.checkElement(element, FIELD_TIMESTAMP, "http://docs.oasis-open.org/wsrf/bf-2")) {
                elementList.add(serFactory.createElement(element));
                element = BaseFaultTypeBinder.getElement(elements);
            }
            if (elementList.size() > 0) {
                extensibilityElements = new IOSerializableSOAPElement[elementList.size()];
                elementList.toArray(extensibilityElements);
            }
        }
        if (!BaseFaultTypeBinder.checkElement(element, FIELD_TIMESTAMP, "http://docs.oasis-open.org/wsrf/bf-2")) {
            throw new SOAPException("Object to be deserialized by BaseFaultTypeBinder does not contain the mandatory 'timestamp' field");
        }
        String timestampString = element.getValue();
        if (timestampString == null) {
            throw new SOAPException("Object to be deserialzied by BaseFaultTypeBinder contains a null timestamp field");
        }
        try {
            timestamp = (Calendar)CalendarDeserializer.makeDateTimeValue(timestampString);
        }
        catch (Exception exc) {
            throw new SOAPException("Object to be deserialzied by BaseFaultTypeBinder contains an invalid timestamp field");
        }
        element = BaseFaultTypeBinder.getElement(elements);
        if (BaseFaultTypeBinder.checkElement(element, FIELD_ORIGINATOR, "http://docs.oasis-open.org/wsrf/bf-2")) {
            originator = (EndpointReference)eprBinder.deserialize(element, context);
            element = BaseFaultTypeBinder.getElement(elements);
        }
        if (BaseFaultTypeBinder.checkElement(element, FIELD_ERRORCODE, "http://docs.oasis-open.org/wsrf/bf-2")) {
            if (!element.hasAttribute(ATTRIBUTE_DIALECT)) {
                throw new SOAPException("Missing required attribute dialect on ErrorCode element");
            }
            String dialectStr = element.getAttribute(ATTRIBUTE_DIALECT);
            try {
                URI dialectURI = new URI(dialectStr);
                Iterator errorCodeChildElements = element.getChildElements();
                if (errorCodeChildElements.hasNext()) {
                    Node child = (Node)errorCodeChildElements.next();
                    if (child instanceof SOAPElement) {
                        ArrayList<IOSerializableSOAPElement> elementList = new ArrayList<IOSerializableSOAPElement>();
                        elementList.add(serFactory.createElement((SOAPElement)child));
                        while (errorCodeChildElements.hasNext()) {
                            elementList.add(serFactory.createElement((SOAPElement)errorCodeChildElements.next()));
                        }
                        IOSerializableSOAPElement[] elementArr = new IOSerializableSOAPElement[elementList.size()];
                        elementArr = elementList.toArray(elementArr);
                        errorCode = new ErrorCode(dialectURI, elementArr);
                    } else {
                        errorCode = new ErrorCode(dialectURI, element.getValue());
                    }
                } else {
                    errorCode = new ErrorCode(dialectURI, "");
                }
            }
            catch (URISyntaxException use) {
                throw new SOAPException("dialect attribute has invalid URI value of " + dialectStr);
            }
            element = BaseFaultTypeBinder.getElement(elements);
        }
        if (BaseFaultTypeBinder.checkElement(element, FIELD_DESCRIPTION, "http://docs.oasis-open.org/wsrf/bf-2")) {
            ArrayList<FaultDescription> descriptions = new ArrayList<FaultDescription>();
            while (BaseFaultTypeBinder.checkElement(element, FIELD_DESCRIPTION, "http://docs.oasis-open.org/wsrf/bf-2")) {
                String description = element.getValue();
                String language = element.getAttribute(ATTRIBUTE_LANGUAGE);
                descriptions.add(new FaultDescription(description, language));
                element = BaseFaultTypeBinder.getElement(elements);
            }
            if (descriptions.size() > 0) {
                faultDescriptions = new FaultDescription[descriptions.size()];
                descriptions.toArray(faultDescriptions);
            }
        }
        if (BaseFaultTypeBinder.checkElement(element, FIELD_FAULTCAUSE, "http://docs.oasis-open.org/wsrf/bf-2")) {
            faultCause = serFactory.createElement(element);
            element = BaseFaultTypeBinder.getElement(elements);
        }
        if (element != null) {
            if (superClass) {
                elements.restore();
            } else {
                throw new SOAPException("BaseFaultTypeBinder has found unexpected elements in the fault message");
            }
        }
        Iterator attributeIterator = root.getAllAttributes();
        Attribute[] attributeArray = null;
        if (attributeIterator.hasNext()) {
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
            Name name = null;
            while (attributeIterator.hasNext()) {
                String prefix;
                name = (Name)attributeIterator.next();
                if (name == null || "xmlns".equalsIgnoreCase(prefix = name.getPrefix())) continue;
                attributeName = new QName(name.getURI(), name.getLocalName(), prefix);
                attributeValue = root.getAttributeValue(name);
                attributeList.add(new Attribute(attributeName, attributeValue));
            }
            if (attributeList.size() > 0) {
                attributeArray = new Attribute[attributeList.size()];
                attributeArray = attributeList.toArray(attributeArray);
            }
        }
        target.setTimestamp(timestamp);
        target.setOriginator(originator);
        target.setErrorCode(errorCode);
        target.setDescriptions(faultDescriptions);
        target.setFaultCause(faultCause);
        target.setExtensibilityElements(extensibilityElements);
        target.setAttributes(attributeArray);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserialize");
        }
    }

    public static SOAPElement getElement(ElementIterator source) {
        SOAPElement element = null;
        if (source.hasNext()) {
            element = source.next();
        }
        return element;
    }

    public static boolean checkElement(SOAPElement element, String local, String namespace) {
        Name name;
        boolean result = false;
        if (element != null && (name = element.getElementName()) != null) {
            String elementLocal = name.getLocalName();
            String elementNamespace = name.getURI();
            if (local.equals(elementLocal) && namespace.equals(elementNamespace)) {
                result = true;
            }
        }
        return result;
    }
}

