/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.wsmex.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.attachment.PolicyExtensionRegistry;
import com.ibm.ws.wspolicy.attachment.WSDLPostProcessorImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.xml.sax.InputSource;

public class WSDLDataLocator
implements AxisDataLocator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLDataLocator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final HashMap<String, Data[]> _resultCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getData");
        }
        Data[] result = null;
        String resourceRef = null;
        Definition outputWSDLDefinition = null;
        boolean useSeperateCopy = false;
        if (!request.getOutputForm().getType().equals(OutputForm.INLINE_FORM.getType())) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData returning null.  OutputForm Type is " + request.getOutputForm().getType());
            }
            return null;
        }
        EndpointReference epr = msgContext.getTo();
        String address = null;
        if (epr != null) {
            address = epr.getAddress();
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "null epr");
        }
        if (msgContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData with exception. MessageContext is null");
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{address});
            String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{address}, null);
            DataRetrievalException dre = new DataRetrievalException(msgStr);
            dre.addReason(msgStr);
            throw dre;
        }
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData with exception. AxisService is null");
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{address});
            String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{address}, null);
            DataRetrievalException dre = new DataRetrievalException(msgStr);
            dre.addReason(msgStr);
            throw dre;
        }
        QName serviceQName = null;
        Parameter parameter = service.getParameter("WSDL_SERVICE_QNAME");
        if (parameter == null) {
            parameter = service.getParameter("WSDL_SERVICE_QNAME");
        }
        if (parameter != null) {
            serviceQName = (QName)parameter.getValue();
        }
        Parameter appNameParam = service.getAxisConfiguration().getParameter("ApplicationName");
        String appName = (String)appNameParam.getValue();
        Parameter modNameParam = service.getAxisConfiguration().getParameter("ModuleName");
        String modName = (String)modNameParam.getValue();
        resourceRef = "WebService:/" + modName + ":" + serviceQName;
        Data[] dataArray = result = this.fetchResultHolderFromCache(resourceRef);
        synchronized (result) {
            ByteArrayOutputStream outputStream;
            WSDLWriter wsdlWriter;
            WSDLFactory wsdlFactory;
            if (result[0] != null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getData returning cached value", result);
                }
                // ** MonitorExit[var16_20] (shouldn't be in output)
                return result;
            }
            useSeperateCopy = true;
            Parameter p2 = service.getParameter("wsdl4jDefinition");
            if (useSeperateCopy) {
                Definition originalDefinition = (Definition)p2.getValue();
                try {
                    wsdlFactory = WSDLFactory.newInstance();
                    wsdlWriter = wsdlFactory.newWSDLWriter();
                    outputStream = new ByteArrayOutputStream();
                    String baseURI = originalDefinition.getDocumentBaseURI();
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "documentBaseURI is ", baseURI);
                    }
                    wsdlWriter.writeWSDL(originalDefinition, outputStream);
                    WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                    ByteArrayInputStream bais = new ByteArrayInputStream(outputStream.toByteArray());
                    InputSource is = new InputSource(bais);
                    ExtensionRegistry registry = originalDefinition.getExtensionRegistry();
                    PolicyExtensionRegistry.registerWSPSerializers(registry);
                    wsdlReader.setExtensionRegistry(registry);
                    outputWSDLDefinition = wsdlReader.readWSDL(baseURI, is);
                    WSDLPostProcessorImpl postProc = new WSDLPostProcessorImpl();
                    postProc.postProcessWSDL(outputWSDLDefinition, appName, modName, serviceQName, service, address);
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getData exception ", e);
                    }
                    Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{serviceQName});
                    String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{serviceQName}, null);
                    DataRetrievalException dre = new DataRetrievalException(msgStr);
                    dre.addReason(msgStr);
                    throw dre;
                }
            } else {
                outputWSDLDefinition = (Definition)p2.getValue();
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getData output wsdlDefinition", outputWSDLDefinition);
            }
            StAXOMBuilder builder = null;
            try {
                wsdlFactory = WSDLFactory.newInstance();
                wsdlWriter = wsdlFactory.newWSDLWriter();
                outputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(outputWSDLDefinition, outputStream);
                builder = new StAXOMBuilder(new ByteArrayInputStream(outputStream.toByteArray()));
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getData exception ", e);
                }
                Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{serviceQName});
                String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{serviceQName}, null);
                DataRetrievalException dre = new DataRetrievalException(msgStr);
                dre.addReason(msgStr);
                throw dre;
            }
            OMElement wsdlElement = builder.getDocumentElement();
            result[0] = new Data(wsdlElement, serviceQName.toString());
            // ** MonitorExit[var16_20] (shouldn't be in output)
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData", result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Data[] fetchResultHolderFromCache(String resourceRef) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fetchResultHolderFromCache", resourceRef);
        }
        HashMap<String, Data[]> hashMap = _resultCache;
        synchronized (hashMap) {
            Data[] dataArray = _resultCache.get(resourceRef);
            if (dataArray == null) {
                dataArray = new Data[1];
                _resultCache.put(resourceRef, dataArray);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "fetchResultHolderFromCache");
            }
            return dataArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearResultHolderFromCache(String resourceRef) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "clearResultHolderFromCache", resourceRef);
        }
        HashMap<String, Data[]> hashMap = _resultCache;
        synchronized (hashMap) {
            _resultCache.remove(resourceRef);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "clearResultHolderFromCache");
        }
    }
}

