/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.utils.om;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.PolicyConstants;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OMUtils {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(OMUtils.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public static OMElement toOM(Element element, QName qname, String namespace) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toOM", new Object[]{element, qname, namespace});
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement elem = null;
        OMNamespace ns = null;
        if (element != null) {
            if (qname != null) {
                ns = fac.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
                elem = fac.createOMElement(qname.getLocalPart(), ns);
            } else {
                ns = fac.createOMNamespace(element.getNamespaceURI(), element.getPrefix());
                elem = fac.createOMElement(element.getLocalName(), ns);
            }
            OMUtils.setAttributes(element, elem, fac);
            if (element.hasChildNodes()) {
                OMUtils.setChildren(element, elem, fac);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toOM", elem);
        }
        return elem;
    }

    public static void setAttributes(Element elem, OMElement omelem, OMFactory fac) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setAttributes", new Object[]{elem, omelem, fac});
        }
        OMAttribute attr = null;
        if (elem != null && omelem != null && fac != null && elem.hasAttributes()) {
            NamedNodeMap map = elem.getAttributes();
            for (int att = 0; att < map.getLength(); ++att) {
                String attValue = map.item(att).getNodeValue();
                String attName = map.item(att).getNodeName();
                attr = fac.createOMAttribute(map.item(att).getNodeName(), null, attValue);
                if (attr == null || attr.getLocalName() == null) continue;
                omelem.addAttribute(attr);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setAttributes");
        }
    }

    public static void setChildren(Element elem, OMElement omelem, OMFactory fac, OMElement currentElem, boolean parentNode) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setChildren", new Object[]{elem, omelem, fac, currentElem, parentNode});
        }
        if (elem != null) {
            NodeList elemChildren = elem.getChildNodes();
            Node elemChild = null;
            OMElement element = null;
            for (int l = 0; l < elemChildren.getLength(); ++l) {
                String nodeValue;
                elemChild = elemChildren.item(l);
                if (elemChild.getNodeType() == 1) {
                    if (currentElem != null && parentNode) {
                        element = fac.createOMElement(elemChild.getLocalName(), fac.createOMNamespace(elemChild.getNamespaceURI(), elemChild.getPrefix()), currentElem);
                        if (elemChild.getNodeName().indexOf(PolicyConstants.ELEMENT_POLICYREF) > -1) {
                            // empty if block
                        }
                    } else if (omelem != null) {
                        element = fac.createOMElement(elemChild.getLocalName(), fac.createOMNamespace(elemChild.getNamespaceURI(), elemChild.getPrefix()), omelem);
                    }
                }
                if ((nodeValue = elemChild.getNodeValue()) != null && nodeValue.length() > 0 && elemChild.getNodeType() == 1) {
                    element.addChild(fac.createOMText((OMContainer)element, nodeValue));
                }
                if (elemChild.hasAttributes()) {
                    OMUtils.setAttributes(elem, element, fac);
                }
                if (!elemChild.hasChildNodes()) continue;
                currentElem = element;
                parentNode = true;
                OMUtils.setChildren((Element)elemChild, omelem, fac, currentElem, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setChildren");
        }
    }

    private static void setChildren(Element elem, OMElement omelem, OMFactory fac) {
        OMUtils.setChildren(elem, omelem, fac, null, false);
    }

    public static OMElement createElement(QName qname, OMNamespace namespace) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement elem = null;
        OMNamespace ns = null;
        if (qname != null) {
            ns = fac.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
            elem = fac.createOMElement(qname.getLocalPart(), ns);
        }
        return elem;
    }
}

