/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.utils.dom;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionDeserializer;
import com.ibm.ws.wspolicy.assertions.AssertionExtensionRegistry;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import com.ibm.ws.wspolicy.operators.Operator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyDOMUtils {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyDOMUtils.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public static void parseAttributes(Policy policy, Element element) {
        if (element != null) {
            NamedNodeMap nnm = element.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                if (attr.getNodeType() != 2) continue;
                String attrName = attr.getNodeName();
                if (!(attrName = attrName.trim()).startsWith(PolicyConstants.TAG_XMLNS)) {
                    String localName = attr.getLocalName();
                    if (localName.equals("ID") || localName.equals("id")) {
                        localName = "Id";
                    }
                    policy.addAttribute(new QName(attr.getNamespaceURI(), localName), attr.getNodeValue());
                    continue;
                }
                policy.getNamespaces().put(attr.getNodeValue(), attr.getLocalName());
            }
        }
    }

    public static void parseChildAssertions(Element element, Operator operator) throws UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException, PolicyReferenceException {
        Vector<PolicyElement> result = null;
        AssertionExtensionRegistry aer = null;
        if (element == null) {
            result = new Vector<PolicyElement>(0);
            operator.setChildAssertions(result, false);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "parseChildAssertions");
            }
            return;
        }
        NodeList nl = element.getChildNodes();
        result = new Vector();
        int childElementCount = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            ++childElementCount;
            PolicyElement policyElement = null;
            Policy op = null;
            Element child = (Element)nl.item(i);
            String childNamespace = child.getNamespaceURI();
            if ("http://www.w3.org/ns/ws-policy".equals(childNamespace)) {
                policyElement = PolicyDOMUtils.getOperatorsFromElement(child, operator);
            } else if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(childNamespace)) {
                QName elementQN = new QName(childNamespace, child.getLocalName());
                throw new UnsupportedNamespaceException(elementQN);
            }
            if (policyElement == null) {
                op = operator.getOwningPolicy();
                aer = op != null ? op.getAssertionExtensionRegistry() : AssertionExtensionRegistry.getAssertionExtensionRegistry();
                policyElement = PolicyDOMUtils.getAssertionFromElement(child, operator, aer);
            }
            if (policyElement == null) continue;
            result.add(policyElement);
        }
        if (childElementCount == 0) {
            result = new Vector(0);
        }
        operator.setChildAssertions(result, false);
    }

    private static PolicyElement getOperatorsFromElement(Element child, Operator operator) throws UnsupportedPolicyElementException, UnsupportedNamespaceException, WSPolicyInternalException, PolicyReferenceException {
        Policy op = null;
        Operator policyElement = null;
        if (child.getLocalName().equalsIgnoreCase(PolicyConstants.OPERATOR_POLICY)) {
            PolicyReader pr = null;
            op = operator.getOwningPolicy();
            if (op != null) {
                pr = op.getReader();
            }
            if (pr == null) {
                pr = new PolicyFactory(operator.getContext()).newPolicyReader();
            }
            policyElement = pr.readPolicy(child);
            policyElement.setOwningPolicy(operator.getOwningPolicy());
        } else if (child.getLocalName().equalsIgnoreCase(PolicyConstants.OPERATOR_ALL)) {
            policyElement = new AllOperator(child, operator.getOwningPolicy(), operator.getContext());
            PolicyDOMUtils.parseChildAssertions(child, policyElement);
        } else if (child.getLocalName().equalsIgnoreCase(PolicyConstants.OPERATOR_EXACTLYONE)) {
            policyElement = new ExactlyOneOperator(child, operator.getOwningPolicy(), operator.getContext());
            PolicyDOMUtils.parseChildAssertions(child, policyElement);
        } else if (child.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICYREF)) {
            PolicyReference pfdi = new PolicyReference(operator.getContext(), operator.getOwningPolicy());
            PolicyDOMUtils.parseAttributes(pfdi, child);
            policyElement = pfdi;
        } else if (child.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy")) {
            throw new UnsupportedPolicyElementException(child.getLocalName());
        }
        return policyElement;
    }

    private static AssertionImpl getAssertionFromElement(Element child, Operator operator, AssertionExtensionRegistry aer) throws UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        AssertionImpl leaf = null;
        if (child != null && operator != null && aer != null) {
            QName vocabulary = new QName(child.getNamespaceURI(), child.getLocalName());
            AssertionDeserializer ad = aer.getDeserializer(vocabulary);
            if (ad != null) {
                leaf = ad.unmarshall(child, vocabulary, operator.getOwningPolicy());
                Iterator parameterNameIter = leaf.getAllParameterNames();
                while (parameterNameIter.hasNext()) {
                    QName paramQName = (QName)parameterNameIter.next();
                    if (paramQName == null) continue;
                    if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(paramQName.getNamespaceURI())) {
                        throw new UnsupportedNamespaceException(paramQName);
                    }
                    if (!"http://www.w3.org/ns/ws-policy".equals(paramQName.getNamespaceURI())) continue;
                    throw new UnsupportedPolicyElementException(paramQName.getLocalPart());
                }
                leaf.getPolicy();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to find default serializer for QName " + vocabulary.toString());
                }
                throw new WSPolicyInternalException();
            }
        }
        return leaf;
    }

    public static String getInnerXMLString(Element el) {
        StringBuffer retVal = new StringBuffer();
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                try {
                    StringWriter sw = new StringWriter();
                    XMLSerializer output = new XMLSerializer((Writer)sw, format);
                    output.serialize((Element)n);
                    retVal.append(sw.toString());
                }
                catch (IOException ioe) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getInnerXMLString", "IOException " + ioe.toString());
                    }
                    FFDCFilter.processException(ioe, "com.ibm.ws.wspolicy.PolicyDOMUtils.getInnerXMLString", "247");
                }
                continue;
            }
            if (n.getNodeType() != 3) continue;
            retVal.append(n.getNodeValue());
        }
        return retVal.toString();
    }

    public static String getComments(Element el) {
        StringBuffer retVal = new StringBuffer();
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 8) continue;
            String comment = n.getNodeValue();
            retVal.append(comment);
        }
        return retVal.toString();
    }

    public static boolean hasNestedPolicy(Element el) {
        boolean hasPolicy = false;
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY)) continue;
            hasPolicy = true;
            break;
        }
        return hasPolicy;
    }
}

