/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyCache;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.alternatives.AlternativesIterator;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.attachment.UsingPolicy;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.operators.Operator;
import com.ibm.ws.wspolicy.utils.dom.PolicyDOMUtils;
import com.ibm.wsdl.ImportImpl;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(InternalUtils.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensibilityElement extractUnknownElement(Definition definition, ExtensibilityElement extensibilityElements, PolicyReader reader, PolicyContext pContext) throws UnsupportedPolicyElementException, UnsupportedNamespaceException, WSPolicyInternalException, PolicyReferenceException {
        Element el;
        Policy result = null;
        if (!(extensibilityElements instanceof UnknownExtensibilityElement)) return result;
        UnknownExtensibilityElement uEE = (UnknownExtensibilityElement)extensibilityElements;
        QName elementType = uEE.getElementType();
        String elementNS = elementType.getNamespaceURI();
        String elementLocalName = elementType.getLocalPart();
        if ("http://www.w3.org/ns/ws-policy".equals(elementNS)) {
            Attr attr;
            if (!PolicyConstants.OPERATOR_POLICY.equals(elementLocalName)) {
                if (!PolicyConstants.ELEMENT_POLICYREF.equals(elementLocalName)) throw new UnsupportedPolicyElementException(elementLocalName);
            }
            if ((attr = (el = uEE.getElement()).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base")) == null) {
                Document d = el.getOwnerDocument();
                attr = d.createAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base");
                String base = definition.getDocumentBaseURI();
                if (base == null || base == "") {
                    base = definition.getTargetNamespace();
                }
                attr.setValue(base);
                el.setAttributeNode(attr);
            }
            if (elementType.equals(PolicyConstants.WSP_POL_ELEMENT_QNAME)) {
                return reader.readPolicy(el);
            }
        } else {
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(elementNS)) return result;
            throw new UnsupportedNamespaceException(elementType);
        }
        result = new PolicyReference(pContext, null);
        PolicyDOMUtils.parseAttributes(result, el);
        result.setReader(reader);
        return result;
    }

    public static PolicyReader getReader(Definition definition) {
        if (definition == null) {
            return null;
        }
        PolicyReader reader = null;
        List eeList = definition.getExtensibilityElements();
        if (eeList != null) {
            for (ExtensibilityElement ee : eeList) {
                if (!(ee instanceof UsingPolicy)) continue;
                UsingPolicy usingPolicy = (UsingPolicy)ee;
                reader = usingPolicy.getPolicyReader();
                return reader;
            }
        }
        Map imports = definition.getImports();
        for (Map.Entry entry : imports.entrySet()) {
            List lis = (List)entry.getValue();
            for (ImportImpl importImpl : lis) {
                Definition defImport = importImpl.getDefinition();
                if (defImport == null) continue;
                List extensibilityElements = defImport.getExtensibilityElements();
                for (ExtensibilityElement ee : extensibilityElements) {
                    if (!(ee instanceof UsingPolicy)) continue;
                    UsingPolicy usingPolicy = (UsingPolicy)ee;
                    reader = usingPolicy.getPolicyReader();
                    UsingPolicy usingPolicyRoot = new UsingPolicy();
                    usingPolicyRoot.setPolicyReader(reader);
                    usingPolicyRoot.setSerialize(false);
                    definition.addExtensibilityElement(usingPolicyRoot);
                    return reader;
                }
            }
        }
        return reader;
    }

    public static Map<QName, Service> getServices(Definition definition) {
        Map services = definition.getServices();
        Map imports = definition.getImports();
        if (imports != null) {
            for (List importList : imports.values()) {
                for (Object importObj : importList) {
                    Definition importDef;
                    Import i = (Import)importObj;
                    if (i == null || (importDef = i.getDefinition()) == null) continue;
                    services.putAll(InternalUtils.getServices(importDef));
                }
            }
        }
        return services;
    }

    public static Map<QName, Binding> getBindings(Definition definition) {
        Map bindings = definition.getBindings();
        Map imports = definition.getImports();
        if (imports != null) {
            for (List importList : imports.values()) {
                for (Object importObj : importList) {
                    Definition importDef;
                    Import i = (Import)importObj;
                    if (i == null || (importDef = i.getDefinition()) == null) continue;
                    bindings.putAll(InternalUtils.getBindings(importDef));
                }
            }
        }
        return bindings;
    }

    public static Map<QName, PortType> getPortTypes(Definition definition) {
        Map portTypes = definition.getPortTypes();
        Map imports = definition.getImports();
        if (imports != null) {
            for (List importList : imports.values()) {
                for (Object importObj : importList) {
                    Definition importDef;
                    Import i = (Import)importObj;
                    if (i == null || (importDef = i.getDefinition()) == null) continue;
                    portTypes.putAll(InternalUtils.getPortTypes(importDef));
                }
            }
        }
        return portTypes;
    }

    public static Map<QName, Message> getMessages(Definition definition) {
        Map messages = definition.getMessages();
        Map imports = definition.getImports();
        if (imports != null) {
            for (List importList : imports.values()) {
                for (Object importObj : importList) {
                    Definition importDefinition;
                    Import i = (Import)importObj;
                    if (i == null || (importDefinition = i.getDefinition()) == null) continue;
                    messages.putAll(InternalUtils.getMessages(importDefinition));
                }
            }
        }
        return messages;
    }

    public static Object[] traceStringWSDLNode(String nodeType, QName serviceQName, String portName, String operationName, String messageType) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "traceStringWSDLNode", new Object[]{nodeType, serviceQName, portName, operationName, messageType});
        }
        Object[] full = new Object[1];
        String node = nodeType;
        if (serviceQName != null) {
            node = node + "[service:" + serviceQName + "]";
        }
        if (portName != null) {
            node = node + "[port/portType/binding:" + portName + "]";
        }
        if (operationName != null) {
            node = node + "[operation:" + operationName + "]";
        }
        if (messageType != null) {
            node = node + "[" + messageType + "]";
        }
        full[0] = node;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "traceStringWSDLNode", full);
        }
        return full;
    }

    public static void addURI(AttributeExtensible baseObject, Policy policy, String tns) throws WSPolicyInternalException {
        String uri;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addURI", new Object[]{baseObject, policy, tns});
        }
        if ((uri = policy.getId()) == null) {
            InternalUtils.fixupPolicyURI(policy, tns);
            uri = policy.getName().toString();
        }
        Vector existingURIVector = InternalUtils.getPolicyURIs(baseObject);
        boolean alreadyDefined = false;
        for (int i = 0; i < existingURIVector.size(); ++i) {
            String tValue = (String)existingURIVector.elementAt(i);
            if (!tValue.equals(uri)) continue;
            alreadyDefined = true;
        }
        if (!alreadyDefined) {
            Map polURIAttributes = baseObject.getExtensionAttributes();
            if (polURIAttributes.containsKey(PolicyConstants.QNAME_POLICYURIS)) {
                String existingURIs = (String)baseObject.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
                baseObject.setExtensionAttribute(PolicyConstants.QNAME_POLICYURIS, existingURIs + " " + uri);
            } else {
                baseObject.setExtensionAttribute(PolicyConstants.QNAME_POLICYURIS, uri);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addURI");
        }
    }

    public static Vector getPolicyURIs(AttributeExtensible baseObject) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyURIs", baseObject);
        }
        Vector<String> uris = new Vector<String>();
        Map polURIAttributes = baseObject.getExtensionAttributes();
        if (polURIAttributes.containsKey(PolicyConstants.QNAME_POLICYURIS)) {
            String uriValues = (String)baseObject.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
            StringTokenizer attsST = new StringTokenizer(uriValues);
            while (attsST.hasMoreTokens()) {
                String tURI = attsST.nextToken();
                uris.add(tURI);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyURIs", uris);
        }
        return uris;
    }

    public static Vector getPoliciesFromURIs(List extensibilityElements, Vector uris) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPoliciesFromURIs", new Object[]{extensibilityElements, uris});
        }
        Vector<Policy> myPolicies = new Vector<Policy>();
        for (int i = 0; i < uris.size(); ++i) {
            boolean found = false;
            String eURI = (String)uris.elementAt(i);
            for (ExtensibilityElement ee : extensibilityElements) {
                URI tURI;
                if (!(ee instanceof Policy)) continue;
                Policy tPol = (Policy)ee;
                String uri = tPol.getId();
                if (uri == null && (tURI = tPol.getName()) != null) {
                    uri = tURI.toString();
                }
                if (!eURI.equals(uri)) continue;
                myPolicies.add((Policy)ee);
                found = true;
                break;
            }
            if (found) continue;
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "getPoliciesFromURIs", "Could not locate Policy with URI[" + eURI + "]");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPoliciesFromURIs", myPolicies);
        }
        return myPolicies;
    }

    private static void fixupPolicyURI(Policy pol, String tns) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fixupPolicyURI", new Object[]{pol, tns});
        }
        try {
            URI polURI = pol.getName();
            if (polURI == null) {
                if (tns.charAt(tns.length() - 1) != '/') {
                    tns = tns + "/";
                }
                InetAddress localIP = InetAddress.getLocalHost();
                String localAddress = "";
                if (localIP != null) {
                    localAddress = localIP.getHostAddress();
                }
                String newURI = tns + localAddress + pol.hashCode();
                polURI = new URI(newURI);
                pol.setId(polURI.toString());
            }
            if (!polURI.isAbsolute()) {
                String newURI = tns + polURI;
                polURI = new URI(newURI);
                pol.setId(polURI.toString());
            }
        }
        catch (UnknownHostException hostEx) {
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "fixupPolicyURI", "Unexpected UnknownHostException:" + hostEx);
            }
            FFDCFilter.processException(hostEx, "com.ibm.ws.wspolicy.InternalUtils.fixupPolicyURI", "632");
            throw new WSPolicyInternalException(hostEx);
        }
        catch (URISyntaxException uriEx) {
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "fixupPolicyURI", "Unexpected URISyntaxException:" + uriEx);
            }
            FFDCFilter.processException(uriEx, "com.ibm.ws.wspolicy.InternalUtils.fixupPolicyURI", "638");
            throw new WSPolicyInternalException(uriEx);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fixupPolicyURI");
        }
    }

    public static void addToDefinition(Definition definition, Policy extElement) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addToDefinition", new Object[]{definition, extElement});
        }
        definition.addExtensibilityElement(extElement);
        PolicyReader pReader = InternalUtils.getReader(definition);
        PolicyCache pCache = pReader.getPolicyCache();
        if (pCache == null) {
            pCache = new PolicyCache();
            pReader.setPolicyCache(pCache);
        }
        if (extElement.getName() != null) {
            pCache.deposit(extElement.getName().toString(), extElement);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addToDefinition");
        }
    }

    public static void updateAssertionScope(Policy pol, WSDLAttachPoint scope, boolean replace) throws WSPolicyInternalException {
        if (pol != null) {
            Vector children = pol.getChildAssertions();
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) instanceof Assertion) {
                    AssertionImpl tAssertion = (AssertionImpl)children.get(i);
                    if (replace) {
                        tAssertion.setScope(scope);
                        continue;
                    }
                    if (tAssertion.getScope() != null) continue;
                    tAssertion.setScope(scope);
                    continue;
                }
                if (!(children.get(i) instanceof Operator)) continue;
                InternalUtils.updateOperatorChildren((Operator)children.get(i), scope, replace);
            }
            pol.setChildAssertions(children);
        }
    }

    private static void updateOperatorChildren(Operator op, WSDLAttachPoint scope, boolean replace) throws WSPolicyInternalException {
        Vector children = op.getChildAssertions();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof Assertion) {
                AssertionImpl tAssertion = (AssertionImpl)children.get(i);
                if (replace) {
                    tAssertion.setScope(scope);
                    continue;
                }
                if (tAssertion.getScope() != null) continue;
                tAssertion.setScope(scope);
                continue;
            }
            if (!(children.get(i) instanceof Operator)) continue;
            InternalUtils.updateOperatorChildren((Operator)children.get(i), scope, replace);
        }
        op.setChildAssertions(children);
    }

    public static void dumpAssertionHashCode(AssertionImpl a) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "dumpAssertionHashCode", "<<< HASH CODE DUMP >>>");
        }
        InternalUtils.dumpHashCode(a, 0);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "dumpAssertionHashCode");
        }
    }

    private static void dumpHashCode(AssertionImpl a, int indent) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "dumpHashCode");
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
        String leader = buffer.toString();
        System.out.println(leader + a.getAssertionName().getLocalPart() + "[" + ((Object)a).hashCode() + "]");
        try {
            if (a.containsNestedAssertions()) {
                Policy tPol = a.getPolicy();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, leader + " " + "Policy[" + tPol.hashCode() + "]");
                }
                AlternativesIterator aIt = tPol.iterator();
                while (aIt.hasNext()) {
                    Alternative tA = (Alternative)aIt.next();
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, leader + "  " + "Alt[" + tA.hashCode() + "]");
                    }
                    Vector<Assertion> tAssertions = tA.getAssertions();
                    for (int j = 0; j < tAssertions.size(); ++j) {
                        AssertionImpl tAssertion = (AssertionImpl)tAssertions.get(j);
                        InternalUtils.dumpHashCode(tAssertion, indent + 3);
                    }
                }
            }
        }
        catch (WSPolicyException ex) {
            // empty catch block
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "dumpHashCode");
        }
    }

    public static String getElementAlias(DefaultAssertion assertion, HashMap existingNamespaces) {
        String elementAlias = assertion.getNamespaceDeclarations().get(assertion.getNamespaceURI());
        if (elementAlias != null && elementAlias.length() != 0) {
            return elementAlias;
        }
        if (existingNamespaces == null || !existingNamespaces.containsKey(assertion.getNamespaceURI())) {
            elementAlias = PolicyProviderRegistry.getInstance().getPreferredPrefix(assertion.getQName());
            if (elementAlias == null || elementAlias.equals("")) {
                elementAlias = assertion.getQName().getPrefix();
            }
            if (elementAlias == null || elementAlias.equals("")) {
                elementAlias = assertion.getQName().getLocalPart().toLowerCase();
            }
            String firstTry = elementAlias;
            int counter = 1;
            while (existingNamespaces != null && existingNamespaces.containsValue(elementAlias)) {
                elementAlias = firstTry + counter;
            }
        } else {
            elementAlias = (String)existingNamespaces.get(assertion.getNamespaceURI());
        }
        return elementAlias;
    }

    public static String formatString(DefaultAssertion assertion, String innards, String elementAlias, HashMap inScopeNamespaces, String indent) {
        boolean nonNullAssertionNS;
        String tString = null;
        StringBuffer buffer = new StringBuffer();
        String assertionNS = assertion.getQName().getNamespaceURI();
        boolean bl = assertionNS == null ? false : (nonNullAssertionNS = !assertionNS.equals(""));
        if (inScopeNamespaces == null) {
            inScopeNamespaces = new HashMap();
        }
        HashMap<String, String> localNamespaces = new HashMap<String, String>();
        if (nonNullAssertionNS && !inScopeNamespaces.containsValue(elementAlias)) {
            localNamespaces.put(assertionNS, elementAlias);
        }
        if (nonNullAssertionNS) {
            buffer.append(indent).append("<").append(elementAlias).append(":").append(assertion.getQName().getLocalPart());
        } else {
            buffer.append(indent).append("<").append(assertion.getQName().getLocalPart());
        }
        Vector<QName> attributeNames = assertion.getAllAttributeNames();
        for (int i = 0; i < attributeNames.size(); ++i) {
            QName tName = attributeNames.get(i);
            String attributelocalPart = tName.getLocalPart();
            String attributeNamespaceURI = tName.getNamespaceURI();
            String value = assertion.getAttribute(tName);
            String alias = null;
            if (attributeNamespaceURI != "") {
                if (!localNamespaces.containsKey(attributeNamespaceURI) && !inScopeNamespaces.containsKey(attributeNamespaceURI)) {
                    if (assertion.getNamespaceDeclarations().containsKey(attributeNamespaceURI)) {
                        alias = assertion.getNamespaceDeclarations().get(attributeNamespaceURI);
                    } else {
                        alias = attributelocalPart.toLowerCase();
                        int counter = 1;
                        while (inScopeNamespaces.containsValue(alias) || localNamespaces.containsValue(alias)) {
                            alias = attributelocalPart.toLowerCase() + counter++;
                        }
                    }
                    localNamespaces.put(attributeNamespaceURI, alias);
                } else {
                    alias = localNamespaces.get(attributeNamespaceURI) != null ? (String)localNamespaces.get(attributeNamespaceURI) : (String)inScopeNamespaces.get(attributeNamespaceURI);
                }
                buffer.append(" ").append(alias).append(":").append(attributelocalPart).append("=\"").append(value).append("\"");
                continue;
            }
            buffer.append(" ").append(attributelocalPart).append("=\"").append(value).append("\"");
        }
        localNamespaces.putAll(assertion.getNamespaceDeclarations());
        Set namespaces = localNamespaces.keySet();
        for (String namespace : namespaces) {
            if (inScopeNamespaces.containsKey(namespace)) continue;
            buffer.append(" xmlns:").append((String)localNamespaces.get(namespace)).append("=\"").append(namespace).append("\"");
        }
        if ((innards == null || innards.equals("")) && (assertion.getComment() == null || assertion.getComment().equals(""))) {
            buffer.append("/>\n");
        } else {
            buffer.append(">");
            if (assertion.getComment() != null && !assertion.getComment().equals("")) {
                buffer.append(indent).append("<!--").append(assertion.getComment()).append("-->\n");
            }
            buffer.append(innards);
            buffer.append("</").append(elementAlias).append(":").append(assertion.getQName().getLocalPart()).append(">\n");
        }
        tString = buffer.toString();
        return tString;
    }

    public static PolicyWriterContext getPolicyWriterContext(PolicyContext policyContext) {
        PolicyWriterContext result = null;
        if (policyContext != null) {
            result = (PolicyWriterContext)policyContext.getProperty("SerializerFormatting");
            if (result == null) {
                result = new PolicyWriterContext();
                policyContext.setProperty("SerializerFormatting", result);
            }
        } else {
            result = new PolicyWriterContext();
        }
        return result;
    }

    public static void parseAttributes(DefaultAssertion assertion, Element element) {
        if (element != null) {
            NamedNodeMap nnm = element.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                if (attr.getNodeType() != 2) continue;
                String attrName = attr.getNodeName();
                if (!(attrName = attrName.trim()).startsWith(PolicyConstants.TAG_XMLNS)) {
                    String localName = attr.getLocalName();
                    if (localName.equals("ID") || localName.equals("id")) {
                        localName = "Id";
                    }
                    assertion.addAttribute(new QName(attr.getNamespaceURI(), localName), attr.getNodeValue());
                    continue;
                }
                assertion.getNamespaceDeclarations().put(attr.getNodeValue(), attr.getLocalName());
            }
        }
    }

    public static PolicyContext buildPolicyContext(Policy policy) {
        PolicyReader reader;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildPolicyContext", policy);
        }
        PolicyContext result = null;
        if (policy != null && (reader = policy.getReader()) != null) {
            result = reader.getPolicyContext();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildPolicyContext", result);
        }
        return result;
    }

    public static String getIndentAsString(PolicyContext policyContext) {
        PolicyWriterContext format = InternalUtils.getPolicyWriterContext(policyContext);
        String indent = format.getIndent();
        return indent;
    }
}

