/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.runtime.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wspolicy.PolicyException;
import com.ibm.ws.policyset.runtime.InactivePolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationWrapper;
import com.ibm.ws.policyset.runtime.WSPolicyAttachmentsImpl;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.wspolicy.UnknownOperationException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.ThreadContextMigrator;

public class ClientWSPolicyHandler
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(ClientWSPolicyHandler.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public void cleanupContext(MessageContext arg0) {
    }

    public void cleanupThread(MessageContext arg0) {
    }

    public void migrateContextToThread(MessageContext arg0) throws AxisFault {
    }

    public void migrateThreadToContext(MessageContext msgContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext", msgContext);
        }
        if (msgContext != null) {
            PolicySetConfiguration psCfg;
            if (msgContext.getProperty("com.ibm.websphere.wspolicy.refreshProviderPolicy") != null) {
                ClientWSPolicyHandler.clearProviderPolicy(msgContext);
            }
            if ((psCfg = this.wsPolicyConfiguration(msgContext)) instanceof InactivePolicySetConfiguration) {
                PolicyException e = ((InactivePolicySetConfiguration)psCfg).getCause();
                if (e != null) {
                    throw new WebServiceException(e.getMessage(), (Throwable)e);
                }
                AxisService service = msgContext.getAxisService();
                WSPolicyInternalException wspie = new WSPolicyInternalException(nls.getFormattedMessage("CWPOL9999", new Object[]{service == null ? null : service.getName()}, "CWPOL9999E"));
                throw new WebServiceException(wspie.getMessage(), (Throwable)wspie);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    private static boolean isSoftError(Exception e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSoftError", e.getMessage());
        }
        boolean softError = false;
        if (e.getMessage().startsWith("CWPOL0002") || e.getMessage().startsWith("CWPOL0000")) {
            softError = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSoftError", softError);
        }
        return softError;
    }

    private static boolean isEligibleForRecalculation(PolicySetConfiguration psc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEligibleForRecalculation", psc);
        }
        boolean eligible = false;
        if (psc instanceof InactivePolicySetConfiguration) {
            InactivePolicySetConfiguration ipsc = (InactivePolicySetConfiguration)psc;
            PolicyException cause = ipsc.getCause();
            eligible = ClientWSPolicyHandler.isSoftError(cause);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEligibleForRecalculation", eligible);
        }
        return eligible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePolicySetConfigurations(MessageContext msgCtx) {
        AxisService service;
        PolicySetConfigurationWrapper serviceConfig;
        WSPolicyAttachmentsImpl psa;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generatePolicySetConfigurations");
        }
        if ((psa = (serviceConfig = ClientWSPolicyHandler.getWSPolicyConfiguration(service = msgCtx.getAxisService())).getWSPolicyAttachmentsImpl()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not continue - no WSPolicyAttachmentsImpl");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configure service " + service.getName());
        }
        try {
            WSPolicyAttachmentsImpl wSPolicyAttachmentsImpl = psa;
            synchronized (wSPolicyAttachmentsImpl) {
                if (psa.isRefreshRequired(msgCtx)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WS-Policy configuration start");
                    }
                    boolean doRetry = false;
                    Parameter emptyConfig = new Parameter();
                    emptyConfig.setName("WASAxis2PolicySet");
                    emptyConfig.setValue(null);
                    Iterator operIter = service.getOperations();
                    while (operIter.hasNext()) {
                        PolicySetConfigurationWrapper wsPolicyCfgWrapper;
                        AxisOperation operation = (AxisOperation)operIter.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Configure operation " + operation.getName());
                        }
                        if ((wsPolicyCfgWrapper = ClientWSPolicyHandler.getWSPolicyConfiguration(operation)) == null) continue;
                        String resourceName = wsPolicyCfgWrapper.getResourceName();
                        PolicySetConfiguration newPsConfig = psa.getPolicySet(msgCtx, resourceName);
                        if (newPsConfig instanceof InactivePolicySetConfiguration && ((InactivePolicySetConfiguration)newPsConfig).getCause() instanceof UnknownOperationException) {
                            operation.addParameter(emptyConfig);
                            continue;
                        }
                        wsPolicyCfgWrapper.setPolicySetConfiguration(newPsConfig);
                        if (doRetry) continue;
                        doRetry |= ClientWSPolicyHandler.isEligibleForRecalculation(newPsConfig);
                    }
                    PolicySetConfigurationWrapper servicePsCfgWrapper = ClientWSPolicyHandler.getWSPolicyConfiguration(service);
                    if (servicePsCfgWrapper != null) {
                        PolicySetConfiguration newPsConfig;
                        String resourceName = servicePsCfgWrapper.getResourceName();
                        String name = service.getName();
                        int portNameStart = name.lastIndexOf(46);
                        if (portNameStart != -1) {
                            resourceName = resourceName + '/' + name.substring(portNameStart + 1) + '/' + "anon";
                        }
                        if (!((newPsConfig = psa.getPolicySet(msgCtx, resourceName)) instanceof InactivePolicySetConfiguration)) {
                            servicePsCfgWrapper.setPolicySetConfiguration(newPsConfig);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "run Config Plugins", new Object[]{service});
                    }
                    Axis2ServiceConfigPluginManager configManager = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Locating Config Plugins");
                    }
                    configManager = new Axis2ServiceConfigPluginManager();
                    configManager.discoverAxis2ServiceConfigPlugins(false);
                    HashMap<String, AxisService> params = new HashMap<String, AxisService>();
                    params.put("com.ibm.wsspi.websvcs.AxisServiceKey", service);
                    configManager.runConfig(params);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Config Plugins complete");
                    }
                    serviceConfig.setInvalidServicePolicySetConfiguration(null);
                    if (psa != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting refresh to " + doRetry);
                        }
                        psa.setRefreshRequired(msgCtx, doRetry);
                        psa.refreshProviderPolicy(msgCtx);
                    }
                }
            }
        }
        catch (DeploymentException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration failure" + e.toString());
            }
            InactivePolicySetConfiguration invCfg = new InactivePolicySetConfiguration(new PolicyException(nls.getFormattedMessage("CWPOL9999", new Object[]{service.getName(), e}, "CWPOL9999E"), e));
            serviceConfig.setInvalidServicePolicySetConfiguration(invCfg);
        }
        catch (AxisFault e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generatePolicySetConfiguration");
        }
    }

    private static PolicySetConfigurationWrapper getWSPolicyConfiguration(AxisDescription axisDescription) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyConfiguration", axisDescription);
        }
        if (axisDescription == null) {
            return null;
        }
        Parameter param = axisDescription.getParameter("WASAxis2PolicySet");
        if (param == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getWSPolicyConfiguration parameter not found");
            }
            return null;
        }
        Object psc = param.getValue();
        if (psc == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getWSPolicyConfiguration parameter is null");
            }
            return null;
        }
        PolicySetConfigurationWrapper result = null;
        if (psc instanceof PolicySetConfigurationWrapper) {
            result = (PolicySetConfigurationWrapper)psc;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyConfiguration", result);
        }
        return result;
    }

    private static void clearProviderPolicy(MessageContext msgContext) {
        WSPolicyAttachmentsImpl wspsa;
        AxisService service;
        PolicySetConfigurationWrapper config2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Provider WS-Policy refresh explicitly requested");
        }
        if ((config2 = ClientWSPolicyHandler.getWSPolicyConfiguration(service = msgContext.getAxisService())) != null && (wspsa = config2.getWSPolicyAttachmentsImpl()) != null) {
            wspsa.setRefreshRequired(msgContext, true);
            wspsa.refreshProviderPolicy(msgContext);
        }
    }

    private PolicySetConfiguration wsPolicyConfiguration(MessageContext msgContext) {
        AxisService service = msgContext.getAxisService();
        PolicySetConfigurationWrapper config2 = ClientWSPolicyHandler.getWSPolicyConfiguration(service);
        if (config2 != null) {
            PolicySetConfiguration psCfg;
            WSPolicyAttachmentsImpl wspsa;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In WS-Policy mode");
            }
            if ((wspsa = config2.getWSPolicyAttachmentsImpl()) != null && wspsa.isRefreshRequired(msgContext)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configurations being generated");
                }
                ClientWSPolicyHandler.generatePolicySetConfigurations(msgContext);
            }
            if ((psCfg = config2.getInvalidServicePolicySetConfiguration()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InvalidPSConfig found for service");
                }
                return psCfg;
            }
            psCfg = config2.getPolicySetConfiguration();
            if (psCfg instanceof InactivePolicySetConfiguration) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InactivePSConfig found for service");
                }
                return psCfg;
            }
            config2 = ClientWSPolicyHandler.getWSPolicyConfiguration(msgContext.getAxisOperation());
            return config2.getPolicySetConfiguration();
        }
        return null;
    }
}

