/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.PolicyHolder;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.policyset.WSPolicyTransform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyTransformImpl
implements WSPolicyTransform {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyTransformImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final PolicyProviderRegistry _ppr;

    public WSPolicyTransformImpl() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSPolicyTransformImpl");
        }
        this._ppr = PolicyProviderRegistry.getInstance();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSPolicyTransformImpl");
        }
    }

    @Override
    public PolicyInputStreamHolder transform(PolicyInputStreamHolder policy, List<String> transformOptions) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transform");
        }
        PolicyHolder workingPolicy = new PolicyHolder(policy);
        boolean deNormalize = false;
        if (transformOptions.contains("com.ibm.ws.wspolicy.WSPolicyTransformUtility.Denormalize")) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "DENORMALIZE");
            }
            deNormalize = true;
        }
        PolicyInputStreamHolder result = workingPolicy.toPolicyInputStreamHolder(deNormalize);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transform");
        }
        return result;
    }

    @Override
    public InputStream transformForClientConfiguration(final PolicyInputStreamHolder policy, final Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        if (TRACE_COMPONENT.isDebugEnabled() && policy != null) {
            Tr.debug(TRACE_COMPONENT, "Before transformation Main: " + this.streamToString(policy.getMain()));
            Tr.debug(TRACE_COMPONENT, "Before transformation Input: " + this.streamToString(policy.getInput()));
            Tr.debug(TRACE_COMPONENT, "Before transformation Output: " + this.streamToString(policy.getOutput()));
        }
        InputStream result = null;
        final WSPolicyAssertionProcessor assertionProcessor = this._ppr.getAssertionProcessorByType(policyType);
        if (assertionProcessor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
            }
            if (policy != null) {
                return policy.getMain();
            }
            return null;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
        }
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
                    return assertionProcessor.transformForClientConfiguration(policy, transformOptions);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new WSPolicyInternalException(e);
        }
        if (result == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null so setting the Main Policy to be the source");
            }
            if (policy != null) {
                result = policy.getMain();
            }
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation " + this.streamToString(result));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        return result;
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(final InputStream policy, final Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientIntersection");
        }
        PolicyInputStreamHolder result = null;
        final WSPolicyAssertionProcessor assertionProcessor = this._ppr.getAssertionProcessorByType(policyType);
        if (assertionProcessor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
            }
            return null;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
        }
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<PolicyInputStreamHolder>(){

                @Override
                public PolicyInputStreamHolder run() throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
                    return assertionProcessor.transformForClientIntersection(policy, transformOptions);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new WSPolicyInternalException(e);
        }
        if (result == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null so setting the Main Policy to be the source");
            }
            result = new PolicyInputStreamHolder();
            result.setMain(policy);
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation Main: " + this.streamToString(result.getMain()));
            Tr.debug(TRACE_COMPONENT, "After transformation Input: " + this.streamToString(result.getInput()));
            Tr.debug(TRACE_COMPONENT, "After transformation Output: " + this.streamToString(result.getOutput()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientIntersection");
        }
        return result;
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForPublish");
        }
        PolicyInputStreamHolder result = null;
        WSPolicyAssertionProcessor assertionProcessor = this._ppr.getAssertionProcessorByType(policyType);
        if (assertionProcessor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
            }
            return null;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
        }
        if ((result = assertionProcessor.transformForPublish(transformOptions)) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null");
            }
            result = new PolicyInputStreamHolder();
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation Main: " + this.streamToString(result.getMain()));
            Tr.debug(TRACE_COMPONENT, "After transformation Input: " + this.streamToString(result.getInput()));
            Tr.debug(TRACE_COMPONENT, "After transformation Output: " + this.streamToString(result.getOutput()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForPublish");
        }
        return result;
    }

    private String streamToString(InputStream policy) {
        String result;
        block3: {
            result = "";
            if (policy != null && policy instanceof ByteArrayInputStream) {
                try {
                    int inBytes = policy.available();
                    byte[] inBuf = new byte[inBytes];
                    policy.read(inBuf, 0, inBytes);
                    result = new String(inBuf);
                    policy.reset();
                }
                catch (IOException e) {
                    if (!TRACE_COMPONENT.isDebugEnabled()) break block3;
                    Tr.debug(TRACE_COMPONENT, "Unable to read the policy InputStream");
                }
            }
        }
        return result;
    }
}

