/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wspolicy.NullPolicyException;
import com.ibm.websphere.wspolicy.PolicyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.policyset.runtime.WSPolicyAttachmentsImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyHolder;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.UnknownOperationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSDLProcessor;
import com.ibm.ws.wspolicy.WSPConstants;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicySetException;
import com.ibm.ws.wspolicy.acquisition.AcquireViaFile;
import com.ibm.ws.wspolicy.acquisition.AcquireViaMex;
import com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.operators.Operator;
import com.ibm.ws.wspolicy.policyset.WSPolicyFactory;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.ws.wspolicy.policyset.WSPolicyTransform;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.KeyValuePair;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.ProviderPolicyAcquisition;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.WSPolicyClientControlReference;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyProcessorImpl
implements WSPolicyProcessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyProcessorImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private boolean _wsPolicyProcessingRequired = false;
    private HashMap<String, WSDLProcessor> _wsdlProcessors;
    private PolicyFactory _factory;
    private PolicyReader _policyReader;
    private PolicyProviderRegistry _ppr;
    private String iterationType = PolicyConstants.FILTER_SUPPORTED;
    private String intersectionType = "Lax";
    private HashMap<String, Policy> _scopedRequesterPolicies;
    private HashMap<String, PolicyHolder> _calculatedPolicies;
    private HashMap<String, Object> _acquiredDefinitions = new HashMap();
    private String _clientControllerFileName;
    private WSPolicyClientControlHelper _clientController;
    private boolean _processingHalted;
    private HashMap<String, PolicyHolder> _sourceCache;
    private final Map<String, Set<QName>> _vocabs = new ConcurrentHashMap<String, Set<QName>>();
    private HashMap<String, Object> _bindings;
    private PolicyException _processingHaltedException;
    private WSPolicyTransform _transformer = null;
    private DefaultResourceEvaluator _defaultResourceEvaluator = new DefaultResourceEvaluator();
    private List<PolicySetReference> _referenceList;
    private String _serviceName = null;

    public WSPolicyProcessorImpl(String applicationPath, String serviceName, String moduleName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSPolicyProcessorImpl", new Object[]{applicationPath});
        }
        this._serviceName = serviceName;
        try {
            if (!applicationPath.endsWith("/")) {
                applicationPath = applicationPath + "/";
            }
            this._clientControllerFileName = applicationPath + "wsPolicyClientControl.xml";
            final String policySetAttachmentFileName = applicationPath + "clientPolicyAttachments.xml";
            boolean isPathBased = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    File file = new File(WSPolicyProcessorImpl.this._clientControllerFileName);
                    return file.exists();
                }
            });
            if (isPathBased) {
                this._clientController = WSPolicyClientControlHelperFactory.createHelper(this._clientControllerFileName, policySetAttachmentFileName);
            } else {
                InputStream istream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        InputStream stream = WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream(WSPolicyProcessorImpl.this._clientControllerFileName);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + WSPolicyProcessorImpl.this._clientControllerFileName);
                        }
                        if (stream == null) {
                            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(WSPolicyProcessorImpl.this._clientControllerFileName);
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + WSPolicyProcessorImpl.this._clientControllerFileName);
                            }
                        }
                        return stream;
                    }
                });
                if (istream == null) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Policy Control file not found. WSPolicyProcessorImpl: WS-Policy processing turned off for application " + applicationPath);
                    }
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
                    }
                    return;
                }
                InputStream policySetAttachmentIStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        InputStream stream = WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream(policySetAttachmentFileName);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + policySetAttachmentFileName);
                        }
                        if (stream == null) {
                            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(policySetAttachmentFileName);
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + policySetAttachmentFileName);
                            }
                        }
                        return stream;
                    }
                });
                this._clientController = WSPolicyClientControlHelperFactory.createHelper(istream, policySetAttachmentIStream);
            }
            String resourceKey = null;
            resourceKey = moduleName != null ? "WebService:/" + moduleName + ":" + serviceName : "WebService:/" + serviceName;
            this._wsPolicyProcessingRequired = this._clientController.isProviderPolicyEnabled(resourceKey);
            if (this._wsPolicyProcessingRequired) {
                this._ppr = PolicyProviderRegistry.getInstance();
                this._calculatedPolicies = new HashMap();
                this._sourceCache = new HashMap();
                this._factory = new PolicyFactory();
                this._policyReader = this._factory.newPolicyReader();
                this._wsdlProcessors = new HashMap();
            }
        }
        catch (FileNotFoundException e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Policy Control file not found. WSPolicyProcessorImpl: WS-Policy processing turned off for application " + applicationPath);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
            }
            return;
        }
        catch (RuntimeException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9998", new Object[]{applicationPath}, "CWPOL9998E"), e);
            this.handleTerminalFault("Unknown error:", pe);
            throw e;
        }
        catch (Exception e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9998", new Object[]{applicationPath}, "CWPOL9998E"), e);
            this.handleTerminalFault("Unknown error:", pe);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
        }
    }

    @Override
    public boolean isWSPolicyProcessingRequired() {
        return this._wsPolicyProcessingRequired;
    }

    @Override
    public PolicyInputStreamHolder calculatePolicy(String scopeKey, String policyType, MessageContext mc) throws NullPolicyException, PolicyException, UnknownOperationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "calculatePolicy", new Object[]{scopeKey, policyType, mc});
        }
        if (this._processingHalted) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "calculatePolicy failed");
            }
            FFDCFilter.processException(this._processingHaltedException, "WS-Policy processing halted due to an error", "1:201:1.3");
            throw this._processingHaltedException;
        }
        PolicyInputStreamHolder pish = null;
        try {
            PolicyHolder policy = this.calculatePolicyAtScopePoint(scopeKey, mc);
            pish = this.convertPolicyHolderToPolicyInputStreamHolder(policy, policyType, scopeKey);
        }
        catch (PolicyReferenceException pre) {
            String scopePoint = pre.getAttachPointName();
            if (scopePoint == null) {
                scopePoint = scopeKey;
            }
            Object[] args = new Object[]{this.getEndpointURIFromMsg(mc), pre.getReferenceURI(), scopePoint};
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to resolve PolicyReference", args);
            }
            throw new PolicyException(nls.getFormattedMessage("CWPOL0101", args, "CWPOL0101E"), pre);
        }
        catch (WSPolicyFormattedException wpfe) {
            throw new PolicyException(wpfe.getMessage(), wpfe.getCause());
        }
        catch (WSPolicyInternalException wspie) {
            AxisService service = mc.getAxisService();
            Object[] args = new Object[]{service == null ? null : service.getName(), wspie.getCause()};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), wspie);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "calculatePolicy", pish);
        }
        return pish;
    }

    private PolicyInputStreamHolder convertPolicyHolderToPolicyInputStreamHolder(PolicyHolder policy, String policyType, String scopeKey) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyFormattedException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder", new Object[]{policyType});
        }
        PolicyHolder chosenPolicy = new PolicyHolder();
        chosenPolicy.setMain(this.getPolicyForType(policyType, policy.getMain()));
        chosenPolicy.setInput(this.getPolicyForType(policyType, policy.getInput()));
        chosenPolicy.setOutput(this.getPolicyForType(policyType, policy.getOutput()));
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Alternative selected");
        }
        boolean policyTaggedWithVocab = false;
        Set<QName> vocabSet = this._vocabs.get(scopeKey);
        StringBuilder sb = null;
        if (vocabSet != null) {
            for (QName qn : vocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (sb == null) {
                    sb = new StringBuilder(qn.toString());
                    continue;
                }
                sb.append(" ").append(qn.toString());
            }
        }
        if (sb != null) {
            policyTaggedWithVocab = true;
            Policy main = chosenPolicy.getMain();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to main policy: ", sb.toString());
            }
            main.addAttribute(WSPConstants.providerVocabQName, sb.toString());
        }
        Set<QName> inputVocabSet = this._vocabs.get(scopeKey + " Input");
        StringBuilder inputSb = null;
        if (inputVocabSet != null) {
            for (QName qn : inputVocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (inputSb == null) {
                    inputSb = new StringBuilder(qn.toString());
                    continue;
                }
                inputSb.append(" ").append(qn.toString());
            }
        }
        if (inputSb != null) {
            policyTaggedWithVocab = true;
            Policy input = chosenPolicy.getInput();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to input policy: ", inputSb.toString());
            }
            input.addAttribute(WSPConstants.providerVocabQName, inputSb.toString());
        }
        Set<QName> outputVocabSet = this._vocabs.get(scopeKey + " Output");
        StringBuilder outputSb = null;
        if (outputVocabSet != null) {
            for (QName qn : outputVocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (outputSb == null) {
                    outputSb = new StringBuilder(qn.toString());
                    continue;
                }
                outputSb.append(" ").append(qn.toString());
            }
        }
        if (outputSb != null) {
            policyTaggedWithVocab = true;
            Policy output = chosenPolicy.getOutput();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to output policy: ", outputSb.toString());
            }
            output.addAttribute(WSPConstants.providerVocabQName, outputSb.toString());
        }
        if (!policyTaggedWithVocab && chosenPolicy.isAllEmpty()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder. Policy empty");
            }
            return null;
        }
        PolicyInputStreamHolder result = chosenPolicy.toPolicyInputStreamHolder(false);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder");
        }
        return result;
    }

    private Policy getPolicyForType(String policyType, Policy policy) throws PolicyReferenceException, WSPolicyFormattedException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyForType", new Object[]{policyType});
        }
        List<Assertion> assertions = null;
        assertions = policyType != null ? this._ppr.getAssertionsForPolicyTypeFromAlternative(policyType, policy.getAlternative()) : policy.getAlternative().getAssertions();
        Policy result = this._factory.newNormalizedPolicy(assertions);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyForType");
        }
        return result;
    }

    private PolicyHolder calculatePolicyAtScopePoint(String scopeKey, MessageContext mc) throws NullPolicyException, WSPolicyInternalException, WSPolicyFormattedException, UnknownOperationException {
        String namespace;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "calculatePolicyAtScopePoint", new Object[]{scopeKey, mc});
        }
        if (!this.isWSPolicyProcessingRequired()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "calculatePolicy", null);
            }
            return null;
        }
        WSDLProcessor wsdlProcessor = this.setWSDLProcessorForProviderPolicy(scopeKey, mc);
        Definition definition = wsdlProcessor.getDefinition();
        String providerNamespace = definition.getTargetNamespace();
        String address = this.getEndpointURIFromMsg(mc);
        if (address == null) {
            throw new WSPolicyInternalException("Cannot reolve target address");
        }
        PolicyHolder calculatedPolicy = this._calculatedPolicies.get(address + " " + scopeKey);
        if (calculatedPolicy != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Have previously cached Policy: " + calculatedPolicy);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getPolicyAttachedAtScopePoint", "Policy retrieved from cache");
            }
            return calculatedPolicy;
        }
        String operationName = null;
        String portName = null;
        String serviceName = null;
        if (providerNamespace == null) {
            throw new WSPolicyInternalException("Namespace of provider WSDL is null");
        }
        int openingIndex = scopeKey.indexOf(123);
        if (openingIndex != -1 && !providerNamespace.equals(namespace = scopeKey.substring(openingIndex + 1, scopeKey.indexOf(125))) && (namespace.charAt(namespace.length() - 1) == '/' ? namespace.length() != providerNamespace.length() + 1 || !namespace.startsWith(providerNamespace) : providerNamespace.length() != namespace.length() + 1 || !providerNamespace.startsWith(namespace))) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0006", new Object[]{wsdlProcessor.getObtainedFromAddress()}, null), null);
        }
        String scopeData = scopeKey.substring(scopeKey.indexOf(125) + 1, scopeKey.length());
        if (scopeData.indexOf(47) == -1) {
            serviceName = scopeData;
        } else {
            serviceName = scopeData.substring(0, scopeData.indexOf(47));
            if ((scopeData = scopeData.substring(scopeData.indexOf(47) + 1, scopeData.length())).indexOf(47) == -1) {
                portName = scopeData;
            } else {
                portName = scopeData.substring(0, scopeData.indexOf(47));
                operationName = scopeData.substring(scopeData.indexOf(47) + 1, scopeData.length());
            }
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "serviceName: " + serviceName);
            Tr.debug(TRACE_COMPONENT, "portName: " + portName);
            Tr.debug(TRACE_COMPONENT, "operationName: " + operationName);
        }
        QName serviceQName = new QName(providerNamespace, serviceName);
        try {
            calculatedPolicy = this.intersectAndMerge(scopeKey, operationName, portName, serviceQName, wsdlProcessor);
            this._calculatedPolicies.put(address + " " + scopeKey, calculatedPolicy);
        }
        catch (NullPolicyException nullWSPE) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw nullWSPE;
        }
        catch (WSPolicyFormattedException wspfe) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw wspfe;
        }
        catch (RuntimeException rte) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw rte;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "calculatePolicyAtScopePoint");
        }
        return calculatedPolicy;
    }

    private void addFailureToObtainWSDLForResourceKeyToCache(WSPolicyClientControlReference reference, MessageContext mc, WSPolicyFormattedException wspfe) {
        String address;
        if (reference != null && (address = this.getEndpointURIFromMsg(mc)) != null) {
            String defKey = address + reference.getResource();
            this._acquiredDefinitions.put(defKey, wspfe);
        }
    }

    private void addFailureToObtainWSDLForResourceKeyToCache(WSPolicyClientControlReference reference, MessageContext mc, WSPolicyInternalException wspie) {
        String address;
        if (reference != null && (address = this.getEndpointURIFromMsg(mc)) != null) {
            String defKey = address + reference.getResource();
            this._acquiredDefinitions.put(defKey, wspie);
        }
    }

    private WSDLProcessor setWSDLProcessorForProviderPolicy(String scopeKey, MessageContext mc) throws WSPolicyInternalException, WSPolicyFormattedException {
        WSDLProcessor wsdlProcessor;
        block48: {
            WSPolicyClientControlReference reference;
            String overriddenURI;
            String endpointURI;
            block50: {
                List<ProviderPolicyAcquisition> acquisitions;
                String defKey;
                block51: {
                    block49: {
                        if (TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.entry(TRACE_COMPONENT, "setWSDLProcessorForProviderPolicy", new Object[]{scopeKey, mc});
                        }
                        endpointURI = this.getEndpointURIFromMsg(mc);
                        wsdlProcessor = this._wsdlProcessors.get(endpointURI);
                        overriddenURI = endpointURI;
                        if (wsdlProcessor != null) break block48;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSDL processor not initialised. Acquiring provider side policy");
                        }
                        reference = null;
                        try {
                            reference = this._clientController.getWSPolicyClientControlReferenceInherited(scopeKey);
                        }
                        catch (Exception e) {
                            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0030", new Object[]{scopeKey, this._clientController.getFileName()}, null), e);
                        }
                        if (reference != null) break block49;
                        if (!TRACE_COMPONENT.isDebugEnabled()) break block50;
                        Tr.debug(TRACE_COMPONENT, "WSPolicyClientControlReference null for " + scopeKey);
                        break block50;
                    }
                    defKey = null;
                    if (mc != null && endpointURI != null) {
                        defKey = endpointURI + reference.getResource();
                        if (this._acquiredDefinitions.containsKey(defKey)) {
                            Object acquiredObj = this._acquiredDefinitions.get(defKey);
                            if (acquiredObj instanceof WSDLProcessor) {
                                wsdlProcessor = (WSDLProcessor)acquiredObj;
                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.debug(TRACE_COMPONENT, "Definition cache hit for " + defKey + " " + wsdlProcessor);
                                }
                            } else {
                                if (acquiredObj instanceof WSPolicyFormattedException) {
                                    throw (WSPolicyFormattedException)acquiredObj;
                                }
                                if (acquiredObj instanceof WSPolicyInternalException) {
                                    throw (WSPolicyInternalException)acquiredObj;
                                }
                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.debug(TRACE_COMPONENT, "Ignoring unexpected Definition cache hit for " + defKey);
                                }
                            }
                        } else if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Definition cache miss for " + defKey);
                        }
                    }
                    if (wsdlProcessor != null) break block50;
                    acquisitions = reference.getProviderPolicyAcquisition();
                    if (acquisitions != null) break block51;
                    if (!TRACE_COMPONENT.isDebugEnabled()) break block50;
                    Tr.debug(TRACE_COMPONENT, "ProviderPolicyAcquisition list null for " + scopeKey);
                    break block50;
                }
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "ProviderPolicyAcquisition list has " + acquisitions.size() + " elements.");
                }
                for (ProviderPolicyAcquisition acquisition : acquisitions) {
                    String providerClass;
                    PolicyProvider pp;
                    block47: {
                        pp = null;
                        providerClass = acquisition.getPolicyAcquisitionClass();
                        if ("com.ibm.ws.wspolicy.acquisition.AcquireViaFile".equals(providerClass)) {
                            pp = new AcquireViaFile();
                        } else if ("com.ibm.ws.wspolicy.acquisition.AcquireViaMex".equals(providerClass)) {
                            pp = new AcquireViaMex();
                        } else if ("com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL".equals(providerClass)) {
                            pp = new AcquireViaQWSDL();
                        } else {
                            try {
                                Class<?> c = Class.forName(providerClass);
                                Object o = c.newInstance();
                                if (!(o instanceof PolicyProvider)) {
                                    throw new Exception("PolicyProvider class " + providerClass + " did not implement " + PolicyProvider.class.getName());
                                }
                                pp = (PolicyProvider)o;
                            }
                            catch (Exception e) {
                                if (!TRACE_COMPONENT.isInfoEnabled()) break block47;
                                Tr.warning(TRACE_COMPONENT, "CWPOL8000", new Object[]{providerClass});
                            }
                        }
                    }
                    if (pp == null) {
                        if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "Unable to instantiate " + providerClass + " trying next ProviderPolicyAcquisition element");
                        continue;
                    }
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Obtaining policy via " + pp.getClass().getName());
                    }
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("messageContext", mc);
                    parameters.put("resourcePattern", scopeKey);
                    List<KeyValuePair> params = acquisition.getParameters();
                    for (KeyValuePair param : params) {
                        parameters.put(param.getKey(), param.getValue());
                        if (!"policyURI".equals(param.getKey())) continue;
                        overriddenURI = param.getValue();
                    }
                    Definition def = null;
                    try {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "PolicyProvider pre-invoke");
                        }
                        def = pp.getProviderPolicy(parameters);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "PolicyProvider post invoke : def " + (def == null ? "null" : "non-null"));
                        }
                    }
                    catch (WSPolicyInternalException wspie) {
                        FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "820", this);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspie);
                        throw wspie;
                    }
                    catch (WSPolicyFormattedException wspfe) {
                        FFDCFilter.processException((Throwable)wspfe, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "824", this);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (WSPolicyException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "827", this);
                        if (e instanceof UnsupportedPolicyElementException) {
                            UnsupportedPolicyElementException upee = (UnsupportedPolicyElementException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0100", new Object[]{overriddenURI, upee.getAttachPointName()}, null), upee);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        if (e instanceof UnsupportedNamespaceException) {
                            UnsupportedNamespaceException une = (UnsupportedNamespaceException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0106", new Object[]{overriddenURI, une.getAttachPointName(), une.getElementQName()}, null), une);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        if (e instanceof PolicyReferenceException) {
                            PolicyReferenceException pre = (PolicyReferenceException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", new Object[]{overriddenURI, pre.getReferenceURI(), pre.getAttachPointName()}, null), pre);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        WSPolicyInternalException wspie = new WSPolicyInternalException(e);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspie);
                        throw wspie;
                    }
                    if (def == null) continue;
                    try {
                        wsdlProcessor = new WSDLProcessor(def);
                        wsdlProcessor.setObtainedFromAddress(overriddenURI);
                        if (defKey != null) {
                            this._acquiredDefinitions.put(defKey, wsdlProcessor);
                        }
                    }
                    catch (UnsupportedPolicyElementException upee) {
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0100", new Object[]{overriddenURI, upee.getAttachPointName()}, null), upee);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (UnsupportedNamespaceException une) {
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0106", new Object[]{overriddenURI, une.getAttachPointName(), une.getElementQName()}, null), une);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (PolicyReferenceException pre) {
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", new Object[]{overriddenURI, pre.getReferenceURI(), pre.getAttachPointName()}, null), pre);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    if (!TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "wsdlProcessor build from definition.");
                    break;
                }
            }
            if (wsdlProcessor != null) {
                this.loadBindings(scopeKey, overriddenURI);
                this._wsdlProcessors.put(endpointURI, wsdlProcessor);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Setting bindings into WSDLProcessor");
                }
                wsdlProcessor.setBindings(this._bindings);
                if (!wsdlProcessor.containsPolicy() && TRACE_COMPONENT.isInfoEnabled()) {
                    Tr.info(TRACE_COMPONENT, "CWPOL0007", new Object[]{overriddenURI});
                }
            } else {
                WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0030", new Object[]{scopeKey, this._clientController.getFileName()}, null), null);
                this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                throw wspfe;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setWSDLProcessorForProviderPolicy", wsdlProcessor);
        }
        return wsdlProcessor;
    }

    private String findLowestAttachPoint(String scopeKey, String operationName, String portName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findLowestAttachPoint", new Object[]{scopeKey, operationName, portName});
        }
        if (operationName == null) {
            if (portName != null && this.hasNoPolicySetAttached(scopeKey)) {
                scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(portName) - 1);
            }
        } else if (this.hasNoPolicySetAttached(scopeKey) && this.hasNoPolicySetAttached(scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(operationName) - 1)) && this.hasNoPolicySetAttached(scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(portName) - 1))) {
            scopeKey = "WebService:/";
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findLowestAttachPoint", new Object[]{scopeKey});
        }
        return scopeKey;
    }

    private boolean hasNoPolicySetAttached(String scopeKey) {
        boolean result;
        boolean bl = result = this.getClientPolicy(scopeKey) == null && this.getClientPolicy(scopeKey + "/" + "request:") == null && this.getClientPolicy(scopeKey + "/" + "response:") == null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "hasNoPolicySetAttached", new Object[]{result});
        }
        return result;
    }

    private PolicyHolder intersectAndMerge(String scopeKey, String operationName, String portName, QName serviceQName, WSDLProcessor wsdlProcessor) throws NullPolicyException, WSPolicyFormattedException, UnknownOperationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectAndMerge", new Object[]{scopeKey, operationName, portName, serviceQName, wsdlProcessor});
        }
        String requestPortName = portName;
        String requestOperationName = operationName;
        PolicyHolder result = new PolicyHolder();
        Policy resultPolicy = null;
        Policy resultInputPolicy = null;
        Policy resultOutPolicy = null;
        String clientScopeKey = this.findLowestAttachPoint(scopeKey, requestOperationName, requestPortName);
        Policy clientPolicy = this.getClientPolicy(clientScopeKey);
        Policy clientinputPolicy = this.getClientPolicy(clientScopeKey + "/" + "request:");
        Policy clientOutputPolicy = this.getClientPolicy(clientScopeKey + "/" + "response:");
        Alternative alternative = null;
        Alternative alternativeInput = null;
        Alternative alternativeOutput = null;
        if (wsdlProcessor.containsPolicy()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "provider WSDL contains WS-Policy");
            }
            if (portName == null) {
                portName = this.getPortName(serviceQName, scopeKey, wsdlProcessor);
            }
            Policy providerPolicy = null;
            Policy providerInputPolicy = null;
            Policy providerOutputPolicy = null;
            try {
                if (operationName == null) {
                    operationName = this.getoperationName(serviceQName, portName, scopeKey, wsdlProcessor);
                }
                try {
                    providerPolicy = this.getProviderEffectivePolicy(serviceQName, portName, operationName, wsdlProcessor);
                }
                catch (UnknownOperationException e) {
                    if (operationName != null && operationName.startsWith("anon")) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "getProviderEffectivePolicy found unknown operation anon* - assuming DII");
                        }
                        operationName = null;
                        providerPolicy = this.getProviderEffectivePolicy(serviceQName, portName, operationName, wsdlProcessor);
                    }
                    throw e;
                }
                providerInputPolicy = wsdlProcessor.getInputMessageEffectivePolicy(serviceQName, portName, operationName);
                providerOutputPolicy = wsdlProcessor.getOutputMessageEffectivePolicy(serviceQName, portName, operationName);
                HashSet<QName> vocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerPolicy, vocabSet);
                Iterator it = vocabSet.iterator();
                while (it.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)it.next())) continue;
                    it.remove();
                }
                this._vocabs.put(scopeKey, vocabSet);
                HashSet<QName> inputVocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerInputPolicy, inputVocabSet);
                Iterator itIn = inputVocabSet.iterator();
                while (itIn.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)itIn.next())) continue;
                    itIn.remove();
                }
                this._vocabs.put(scopeKey + " Input", inputVocabSet);
                HashSet<QName> outputVocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerOutputPolicy, outputVocabSet);
                Iterator itOut = outputVocabSet.iterator();
                while (itOut.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)itOut.next())) continue;
                    itOut.remove();
                }
                this._vocabs.put(scopeKey + " Output", outputVocabSet);
                if (providerPolicy == null) {
                    providerPolicy = this._factory.newEmptyPolicy();
                }
                if (clientPolicy != null) {
                    alternative = clientPolicy.intersectWithClientCapabilities(providerPolicy, this.iterationType, this.intersectionType);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "no client policy found, using provider only policy for scopeKey " + scopeKey);
                    }
                    alternative = providerPolicy.getAlternative(this.iterationType);
                }
                if (alternative != null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "main alternative " + alternative.toString());
                    }
                    resultPolicy = alternative.getAssertions() != null ? this._factory.newPolicy(alternative.getAssertions()) : this._factory.newEmptyPolicy();
                }
                if (providerInputPolicy == null) {
                    providerInputPolicy = this._factory.newEmptyPolicy();
                }
                if ((alternativeInput = clientinputPolicy != null ? clientinputPolicy.intersectWithClientCapabilities(providerInputPolicy, this.iterationType, this.intersectionType) : providerInputPolicy.getAlternative(this.iterationType)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "input alternative " + alternativeInput.toString());
                    }
                    resultInputPolicy = alternativeInput.getAssertions() != null ? this._factory.newPolicy(alternativeInput.getAssertions()) : this._factory.newEmptyPolicy();
                }
                if (providerOutputPolicy == null) {
                    providerOutputPolicy = this._factory.newEmptyPolicy();
                }
                if ((alternativeOutput = clientOutputPolicy != null ? clientOutputPolicy.intersectWithClientCapabilities(providerOutputPolicy, this.iterationType, this.intersectionType) : providerOutputPolicy.getAlternative(this.iterationType)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "output alternative " + alternativeOutput.toString());
                    }
                    resultOutPolicy = alternativeOutput.getAssertions() != null ? this._factory.newPolicy(alternativeOutput.getAssertions()) : this._factory.newEmptyPolicy();
                }
                if (resultPolicy == null || resultInputPolicy == null || resultOutPolicy == null) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Null Policy condition detected");
                    }
                    if (clientOutputPolicy == null && clientinputPolicy == null && clientPolicy == null) {
                        this.handleError104(wsdlProcessor);
                    }
                    this.handleError105(wsdlProcessor, clientPolicy, clientinputPolicy, clientOutputPolicy, providerPolicy, providerInputPolicy, providerOutputPolicy);
                }
                result.setMain(resultPolicy);
                result.setInput(resultInputPolicy);
                result.setOutput(resultOutPolicy);
            }
            catch (UnknownOperationException e) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Skipping virtual operation " + operationName);
                }
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intersectAndMerge");
                }
                throw e;
            }
            catch (PolicyReferenceException pre) {
                String scopePoint = pre.getAttachPointName();
                if (scopePoint == null) {
                    scopePoint = "Service = " + serviceQName != null ? serviceQName.toString() : "";
                    scopePoint = scopePoint + ", Port = " + portName;
                    scopePoint = scopePoint + ", Operation = " + operationName;
                }
                Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress(), pre.getReferenceURI(), scopePoint};
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to resolve PolicyReference", args);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", args, "CWPOL0101E"), pre);
            }
            catch (WSPolicyInternalException wspie) {
                Object[] args = new Object[]{serviceQName == null ? null : serviceQName.toString(), wspie.getCause()};
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSPolicyInternalException", args);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), wspie);
            }
            catch (WSPolicyBindingsException wspbe) {
                Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress()};
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSPolicyInternalException", args);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0300", args, "CWPOL0300E"), wspbe);
            }
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "provider WSDL does not contain WS-Policy - using client only policy");
            }
            try {
                if (clientPolicy != null) {
                    alternative = clientPolicy.getAlternative(this.iterationType);
                    if (alternative != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "main alternative " + alternative.toString());
                        }
                        resultPolicy = alternative.getAssertions() != null ? this._factory.newPolicy(alternative.getAssertions()) : this._factory.newEmptyPolicy();
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "no client policy found, no policy for scopeKey " + scopeKey);
                    }
                    resultPolicy = this._factory.newEmptyPolicy();
                }
                if (clientinputPolicy != null) {
                    alternativeInput = clientinputPolicy.getAlternative(this.iterationType);
                    if (alternativeInput != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "input alternative " + alternativeInput.toString());
                        }
                        resultInputPolicy = alternativeInput.getAssertions() != null ? this._factory.newPolicy(alternativeInput.getAssertions()) : this._factory.newEmptyPolicy();
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "no client input policy found, no input policy for scopeKey " + scopeKey);
                    }
                    resultInputPolicy = this._factory.newEmptyPolicy();
                }
                if (clientOutputPolicy != null) {
                    alternativeOutput = clientOutputPolicy.getAlternative(this.iterationType);
                    if (alternativeOutput != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "output alternative " + alternativeOutput.toString());
                        }
                        resultOutPolicy = alternativeOutput.getAssertions() != null ? this._factory.newPolicy(alternativeOutput.getAssertions()) : this._factory.newEmptyPolicy();
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "no client output policy found, no output policy for scopeKey " + scopeKey);
                    }
                    resultOutPolicy = this._factory.newEmptyPolicy();
                }
            }
            catch (WSPolicyInternalException wspie) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Internal exception detected processing client policy", wspie);
                }
                Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress()};
                throw new NullPolicyException(nls.getFormattedMessage("CWPOL0107", args, "CWPOL0107E"));
            }
            catch (PolicyReferenceException pre) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "PolicyReference exception detected processing client policy", pre);
                }
                Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress()};
                throw new NullPolicyException(nls.getFormattedMessage("CWPOL0107", args, "CWPOL0107E"));
            }
            if (resultPolicy == null || resultInputPolicy == null || resultOutPolicy == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Client-only Null Policy condition detected");
                }
                Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress()};
                throw new NullPolicyException(nls.getFormattedMessage("CWPOL0107", args, "CWPOL0107E"));
            }
            result.setMain(resultPolicy);
            result.setInput(resultInputPolicy);
            result.setOutput(resultOutPolicy);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectAndMerge");
        }
        return result;
    }

    private void handleError104(WSDLProcessor wsdlProcessor) throws NullPolicyException {
        String wsdlStr = wsdlProcessor.getWSDL();
        String unknownAssertions = wsdlProcessor.getUnsupportedAssertions();
        Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress(), wsdlStr, unknownAssertions};
        throw new NullPolicyException(nls.getFormattedMessage("CWPOL0104", args, "CWPOL0104E"));
    }

    private void handleError105(WSDLProcessor wsdlProcessor, Policy clientPolicy, Policy clientInputPolicy, Policy clientOutputPolicy, Policy providerPolicy, Policy providerInputPolicy, Policy providerOutputPolicy) throws NullPolicyException {
        Vector<QName> missingClientOutputAssertions;
        Vector<QName> missingClientInputAssertions;
        String wsdlStr = wsdlProcessor.getWSDL();
        String unknownAssertions = wsdlProcessor.getUnsupportedAssertions();
        StringBuffer missingClientAssertionsStr = new StringBuffer();
        Vector<QName> missingClientAssertions = this.getClientAssertionsUnsupportedByProvider(clientPolicy, providerPolicy);
        if (!missingClientAssertions.isEmpty()) {
            missingClientAssertionsStr.append(missingClientAssertions.toString());
        }
        if (!(missingClientInputAssertions = this.getClientAssertionsUnsupportedByProvider(clientInputPolicy, providerInputPolicy)).isEmpty()) {
            if (missingClientAssertionsStr.length() > 0) {
                missingClientAssertionsStr.append(", ");
            }
            missingClientAssertionsStr.append(missingClientInputAssertions.toString());
        }
        if (!(missingClientOutputAssertions = this.getClientAssertionsUnsupportedByProvider(clientOutputPolicy, providerOutputPolicy)).isEmpty()) {
            if (missingClientAssertionsStr.length() > 0) {
                missingClientAssertionsStr.append(", ");
            }
            missingClientAssertionsStr.append(missingClientOutputAssertions.toString());
        }
        Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress(), wsdlStr, unknownAssertions, missingClientAssertionsStr.toString()};
        throw new NullPolicyException(nls.getFormattedMessage("CWPOL0105", args, "CWPOL0105E"));
    }

    private Vector<QName> getClientAssertionsUnsupportedByProvider(Policy clientPolicy, Policy providerPolicy) {
        Vector<Object> clientAssertions = new Vector();
        Vector<Object> providerAssertions = new Vector();
        Vector<QName> unmatchedAssertions = new Vector<QName>();
        if (clientPolicy != null) {
            clientAssertions = clientPolicy.getVocabulary();
        }
        if (providerPolicy != null) {
            providerAssertions = providerPolicy.getVocabulary();
        }
        for (QName qName : clientAssertions) {
            if (providerAssertions.contains(qName)) continue;
            unmatchedAssertions.add(qName);
        }
        return unmatchedAssertions;
    }

    private void handleTerminalFault(String msg, PolicyException e) {
        this._processingHalted = true;
        this.handleFault(msg, e);
    }

    private void handleFault(String msg, PolicyException e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught " + exceptionName + ": " + exceptionMessage + " when trying to create a new WSPolicyProcessor:" + msg;
        this._processingHaltedException = e;
        Tr.debug(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, message, "1:579:1.3");
    }

    private String getoperationName(QName serviceQName, String portName, String scopeKey, WSDLProcessor wsdlProcessor) throws WSPolicyInternalException {
        String result = null;
        List<String> operations = wsdlProcessor.getOperationNames(serviceQName, portName);
        for (String operationName : operations) {
            Policy clientinputPolicy = this.getClientPolicy(scopeKey + "/" + operationName);
            if (clientinputPolicy != null) continue;
            result = operationName;
            break;
        }
        if (result == null) {
            result = operations.get(0);
        }
        return result;
    }

    private String getPortName(QName serviceQName, String scopeKey, WSDLProcessor wsdlProcessor) {
        String result = null;
        List<String> ports = wsdlProcessor.getPortNames(serviceQName);
        Iterator<String> portIter = ports.iterator();
        String port = null;
        while (portIter.hasNext()) {
            port = portIter.next();
            Policy clientPolicy = this.getClientPolicy(scopeKey + "/" + port);
            if (clientPolicy != null) continue;
            result = port;
            break;
        }
        if (result == null) {
            result = ports.get(0);
        }
        return result;
    }

    private Policy getProviderEffectivePolicy(QName serviceQName, String portName, String operationName, WSDLProcessor wsdlProcessor) throws UnknownOperationException, PolicyReferenceException, WSPolicyFormattedException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderEffectivePolicy", new Object[]{serviceQName, portName, operationName, wsdlProcessor});
        }
        Policy result = null;
        try {
            if (operationName != null) {
                result = wsdlProcessor.getOperationEffectivePolicy(serviceQName, portName, operationName);
            }
            if (portName != null) {
                Policy endpointPolicy = wsdlProcessor.getEndpointEffectivePolicy(serviceQName, portName);
                if (result != null && endpointPolicy != null) {
                    result = result.merge(endpointPolicy);
                } else if (endpointPolicy != null) {
                    result = endpointPolicy;
                }
            }
            Policy servicePolicy = wsdlProcessor.getServiceEffectivePolicy(serviceQName);
            if (result != null && servicePolicy != null) {
                result = result.merge(servicePolicy);
            } else if (servicePolicy != null) {
                result = servicePolicy;
            }
        }
        catch (WSPolicyInternalException wspie) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getProviderEffectivePolicy", wspie);
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0006", new Object[]{wsdlProcessor.getObtainedFromAddress()}, null), null);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderEffectivePolicy ", result);
        }
        return result;
    }

    private Policy getClientPolicy(String scopeKey) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClientPolicy", new Object[]{scopeKey});
        }
        Policy result = null;
        if (this._scopedRequesterPolicies != null) {
            result = this._scopedRequesterPolicies.get(scopeKey);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClientPolicy");
        }
        return result;
    }

    @Override
    public void setRequesterPolicy(String scopeKey, String policyType, String policySetName, PolicyInputStreamHolder policyStream) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setRequesterPolicy", new Object[]{scopeKey, policyType, policySetName});
        }
        try {
            if (this._processingHalted) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "The halt processing flag has been set due to a problem during initialization");
                }
            } else {
                String cacheKey = "PSN:" + policySetName + "PT:" + policyType;
                PolicyHolder policies = this._sourceCache.get(cacheKey);
                if (policies == null) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "About to read WS-Policy");
                    }
                    policies = new PolicyHolder(policyStream);
                }
                if (policies.getMain() != null) {
                    this.addScopedRequesterPolicy(scopeKey, policies.getMain());
                }
                if (policies.getInput() != null) {
                    this.addScopedRequesterPolicy(scopeKey + "/" + "request:", policies.getInput());
                }
                if (policies.getOutput() != null) {
                    this.addScopedRequesterPolicy(scopeKey + "/" + "response:", policies.getOutput());
                }
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "New Policies added to cache");
                }
            }
        }
        catch (WSPolicyInternalException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9997", new Object[]{scopeKey, policyType, policySetName}, "CWPOL9997E"), e);
            this.handleFault("setRequesterPolicy failure", pe);
        }
        catch (PolicyReferenceException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0101", new Object[]{scopeKey, e.getReferenceURI(), e.getAttachPointName()}, "CWPOL0101E"), e);
            this.handleFault("setRequesterPolicy failure", pe);
        }
        catch (UnsupportedNamespaceException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0101", new Object[]{scopeKey, e.getAttachPointName()}, "CWPOL0101E"), e);
            this.handleFault("setRequesterPolicy failure", pe);
        }
        catch (UnsupportedPolicyElementException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0100", new Object[]{scopeKey, e.getAttachPointName()}, "CWPOL0100E"), e);
            this.handleFault("setRequesterPolicy failure", pe);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setRequesterPolicy");
        }
    }

    private void addScopedRequesterPolicy(String scopeKey, Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        Policy currentPolicy;
        if (this._scopedRequesterPolicies == null) {
            this._scopedRequesterPolicies = new HashMap();
        }
        if ((currentPolicy = this._scopedRequesterPolicies.get(scopeKey)) == null) {
            this._scopedRequesterPolicies.put(scopeKey, policy);
        } else {
            this._scopedRequesterPolicies.put(scopeKey, currentPolicy.merge(policy));
        }
    }

    @Override
    public boolean isAttached(String scopeKey, MessageContext mc) throws NullPolicyException, PolicyException, UnknownOperationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isAttached", new Object[]{scopeKey, mc, this});
        }
        boolean result = false;
        try {
            if (this.calculatePolicyAtScopePoint(scopeKey, mc) != null) {
                result = true;
            }
        }
        catch (WSPolicyInternalException e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isAttached", new Object[]{e});
            }
            AxisService service = mc.getAxisService();
            Object[] args = new Object[]{service == null ? null : service.getName(), e};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
        }
        catch (WSPolicyFormattedException e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isAttached", new Object[]{e});
            }
            throw new PolicyException(e.getMessage(), e.getCause());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isAttached", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readWsdlFile(String location) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readWsdlFile", new Object[]{location, this});
        }
        BufferedReader input = null;
        String line = null;
        StringBuffer filecontents = new StringBuffer();
        BufferedInputStream istream = null;
        try {
            FileReader reader = new FileReader(location);
            input = new BufferedReader(reader);
            while ((line = input.readLine()) != null) {
                filecontents.append(line);
                filecontents.append(System.getProperty("line.separator"));
            }
            istream = new BufferedInputStream(new ByteArrayInputStream(filecontents.toString().getBytes()));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.readWsdlFile", "1119", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "readWsdlFile", e);
            }
        }
        finally {
            block17: {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.readWsdlFile", "1126", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block17;
                    Tr.debug(TRACE_COMPONENT, "readWsdlFile", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readWsdlFile", istream);
        }
        return istream;
    }

    private String getEndpointURIFromMsg(MessageContext mc) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointURIFrom", new Object[]{mc});
        }
        if (mc == null) {
            return null;
        }
        String endpointURI = null;
        EndpointReference epr = mc.getTo();
        endpointURI = epr != null ? epr.getAddress() : (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
        if (endpointURI == "") {
            endpointURI = null;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointURIFrom", " " + endpointURI);
        }
        return endpointURI;
    }

    private void getGlobalVocab(Operator oper, Set<QName> vocabSet) {
        Vector ops;
        if (oper != null && (ops = oper.getChildAssertions()) != null) {
            for (PolicyElement child : ops) {
                if (child instanceof Assertion) {
                    Assertion assertion = (Assertion)((Object)child);
                    vocabSet.add(assertion.getAssertionName());
                    continue;
                }
                if (!(child instanceof Operator)) continue;
                this.getGlobalVocab((Operator)child, vocabSet);
            }
        }
    }

    @Override
    public void clearProviderPolicy(MessageContext mc) {
        String endpointURI;
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Clearing provider WS-Policy from WSPolicyProcessor");
        }
        if ((endpointURI = this.getEndpointURIFromMsg(mc)) != null) {
            this._wsdlProcessors.remove(endpointURI);
        }
        this._calculatedPolicies.clear();
        this._acquiredDefinitions.clear();
        this._vocabs.clear();
        this._factory = new PolicyFactory();
        this._policyReader = this._factory.newPolicyReader();
    }

    @Override
    public Map getBindings() {
        if (this._bindings == null) {
            this._bindings = new HashMap();
        }
        return this._bindings;
    }

    @Override
    public void loadRequesterWSPolicy(List referenceList, Map<String, Object> transformOptions) throws PolicyException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadRequesterWSPolicy");
        }
        String resourcePattern = null;
        try {
            for (PolicySetReference reference : referenceList) {
                String policySetName = reference.getName();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "   Policy set name is " + reference.getName());
                }
                if (policySetName == null || policySetName.equals("")) continue;
                List<Resource> resourceList = reference.getResource();
                Iterator<Resource> resources = resourceList.iterator();
                while (resources.hasNext()) {
                    resourcePattern = resources.next().getPattern();
                    if (resourcePattern == null) {
                        if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "loadRequesterWSPolicy", "resourcePattern is null, skip it");
                        continue;
                    }
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "loadRequesterWSPolicy", "Found WS-Policy at scope point: " + resourcePattern);
                    }
                    this.loadPolicySet(resourcePattern, policySetName, referenceList, transformOptions);
                }
            }
        }
        catch (WSPolicyInternalException e) {
            Object[] args = new Object[]{null, e};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
        }
        catch (TransformationException e) {
            Tr.warning(TRACE_COMPONENT, "CWPOL0200", new Object[]{null});
            Object[] args = new Object[]{null};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0200", args, "CWPOL0200E"), e);
        }
        catch (WSPolicyBindingsException e) {
            Object[] args = new Object[]{null};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0300", args, "CWPOL0300E"), e);
        }
        catch (WSPolicySetException e) {
            Object[] args = new Object[]{e.getPolicySetName()};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0301", args, "CWPOL0301E"), e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadRequesterWSPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicySet(String scopeKey, String policySetName, List referenceList, Map<String, Object> transformOptions) throws WSPolicySetException, WSPolicyBindingsException, WSPolicyInternalException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadPolicySet", new Object[]{scopeKey, policySetName});
        }
        List typesInPolicySet = null;
        Set<String> allTypes = this._ppr.getAllDomainTypes();
        try {
            typesInPolicySet = PolicySetAttachmentsImpl.getTypesForPolicySet(policySetName);
        }
        catch (Exception e) {
            WSPolicySetException wspse = new WSPolicySetException(e);
            wspse.setPolicySetName(policySetName);
            throw wspse;
        }
        if (allTypes != null) {
            Iterator<String> iter = allTypes.iterator();
            while (iter.hasNext()) {
                InputStream policyTypeConfig = null;
                String policyType = iter.next();
                try {
                    HashMap<String, Object> transformOptionsWithPSConfig;
                    Object psa;
                    if (typesInPolicySet != null && typesInPolicySet.contains(policyType)) {
                        policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, policyType);
                    }
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "About to call WS-Policy loader for  " + policyType);
                    }
                    if ((psa = (transformOptionsWithPSConfig = new HashMap<String, Object>(transformOptions)).get("com.ibm.ws.wspolicy.PolicySetAttachment")) instanceof WSPolicyAttachmentsImpl) {
                        try {
                            transformOptionsWithPSConfig.put("com.ibm.ws.wspolicy.PolicySetConfiguration", ((WSPolicyAttachmentsImpl)psa).getPolicySet(scopeKey));
                        }
                        catch (Exception e) {
                            WSPolicySetException wspse = new WSPolicySetException(e);
                            wspse.setPolicySetName(policySetName);
                            throw wspse;
                        }
                    }
                    PolicyInputStreamHolder transformedPolicy = this.transformForClientIntersection(scopeKey, policyTypeConfig, policyType, referenceList, transformOptionsWithPSConfig);
                    this.setRequesterPolicy(scopeKey, policyType, policySetName, transformedPolicy);
                }
                finally {
                    try {
                        if (policyTypeConfig != null) {
                            policyTypeConfig.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException reading bindingInputStream ", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2302", this);
                    }
                }
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "Back from WS-Policy load on " + policyType);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadPolicySet");
        }
    }

    private PolicyInputStreamHolder transformForClientIntersection(String scopeKey, InputStream policyTypeConfig, String policyType, List referenceList, Map<String, Object> transformOptions) throws WSPolicyBindingsException, WSPolicyInternalException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientIntersection");
        }
        PolicyInputStreamHolder result = null;
        if (this._transformer == null) {
            this._transformer = WSPolicyFactory.newInstance().createPolicyTransform();
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Calling transform utility ");
        }
        result = this._transformer.transformForClientIntersection(policyTypeConfig, transformOptions, policyType);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientIntersection");
        }
        return result;
    }

    private InputStream getBindingInputStream(String scopeKey, final String policyType, List referenceList) throws WSPolicyBindingsException {
        String bindingScope;
        PolicySetReference psr = null;
        if (referenceList != null) {
            psr = this.findAttachment(scopeKey, this._defaultResourceEvaluator, referenceList);
        }
        final String bindingName = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getName() : null;
        String string = bindingScope = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getScope() : null;
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "bindingName ", bindingName);
        }
        try {
            return (InputStream)ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                public Object run() throws WSPolicyBindingsException {
                    InputStream bindingStream = null;
                    if (bindingName == null) {
                        try {
                            String defaultBindingName = BindingAggregator.getDefaultBindingName("client");
                            bindingStream = BindingAggregator.getDefaultBindingInputStream(policyType, defaultBindingName);
                        }
                        catch (Throwable t) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "unable to obtain the default named binding", t);
                            }
                            throw new WSPolicyBindingsException();
                        }
                    } else if (bindingScope != null && bindingScope.equals("domain")) {
                        bindingStream = BindingAggregator.getGeneralBindingInputStream(policyType, bindingName);
                    } else {
                        String rootDir = WSPolicyProcessorImpl.this._clientControllerFileName.substring(0, WSPolicyProcessorImpl.this._clientControllerFileName.length() - "clientPolicyAttachments.xml".length() - 1);
                        bindingStream = BindingAggregator.getCustomBindingInputStream(rootDir, bindingName, policyType);
                    }
                    return bindingStream;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof WSPolicyBindingsException) {
                throw (WSPolicyBindingsException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WSPolicyBindingsException(e);
        }
    }

    private PolicySetReference findAttachment(String resourceName, ResourceEvaluator resourceEvaluator, List referenceList) {
        String attachmentType = "client";
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findAttachment", resourceName);
        }
        PolicySetReference policyRef = null;
        int matchDistance = Integer.MAX_VALUE;
        PolicySetReference savedPolicyRef = null;
        int savedMatchDistance = Integer.MAX_VALUE;
        if (resourceName != null) {
            if (!resourceName.endsWith("/")) {
                resourceName = resourceName + "/";
            }
            String resourceWithoutModule = resourceName;
            String savedResourceName = resourceName;
            boolean keepSearching = true;
            boolean resourceContainsModule = false;
            if (attachmentType.equals("client") && !resourceName.equals(resourceWithoutModule = this.removeModuleName(resourceName))) {
                resourceContainsModule = true;
            }
            while (keepSearching) {
                Iterator references = referenceList.iterator();
                block1: while (matchDistance != 0 && references.hasNext()) {
                    PolicySetReference reference = (PolicySetReference)references.next();
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Testing attachment id " + reference.getId());
                        Tr.debug(TRACE_COMPONENT, "   Policy set name is " + reference.getName());
                        Tr.debug(TRACE_COMPONENT, "   Binding is " + reference.getPolicySetBinding());
                    }
                    List<Resource> resourceList = reference.getResource();
                    Iterator<Resource> resources = resourceList.iterator();
                    while (resources.hasNext()) {
                        int distance;
                        String resourcePattern = resources.next().getPattern();
                        if (resourcePattern == null) {
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "findAttachment, resourcePattern is null, skip it");
                            continue;
                        }
                        if (!resourcePattern.endsWith("/")) {
                            resourcePattern = resourcePattern + "/";
                        }
                        resourcePattern = this.removeModuleName(resourcePattern);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "resourceName=" + resourceName + ", resourcePattern=" + resourcePattern);
                        }
                        if ((distance = resourceEvaluator.getMatchDistance(resourcePattern, resourceName)) < 0) continue;
                        if (distance < matchDistance) {
                            policyRef = reference;
                            matchDistance = distance;
                        }
                        if (matchDistance != 0) continue;
                        continue block1;
                    }
                }
                if (attachmentType.equals("client")) {
                    if (matchDistance != 0 && resourceContainsModule) {
                        savedPolicyRef = policyRef;
                        savedMatchDistance = matchDistance;
                        resourceName = resourceWithoutModule;
                        resourceContainsModule = false;
                        matchDistance = Integer.MAX_VALUE;
                        if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "match distance = " + savedMatchDistance);
                        Tr.debug(TRACE_COMPONENT, "getting ready to check without moduleName, updated resourceName = " + resourceName);
                        continue;
                    }
                    keepSearching = false;
                    continue;
                }
                keepSearching = false;
            }
            if (attachmentType.equals("client") && savedMatchDistance <= matchDistance) {
                policyRef = savedPolicyRef;
                matchDistance = savedMatchDistance;
                resourceName = savedResourceName;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Closer match, so using policy reference with module name");
                }
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "resourceName is null");
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            if (matchDistance < Integer.MAX_VALUE) {
                Tr.debug(TRACE_COMPONENT, "Found attachment with id, name, and matchDistance of:", new Object[]{policyRef.getId(), policyRef.getName(), new Integer(matchDistance)});
            } else {
                Tr.debug(TRACE_COMPONENT, "Found no attachment");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findAttachment", resourceName);
        }
        return policyRef;
    }

    private String removeModuleName(String resourceName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeModuleName", resourceName);
        }
        String updatedResource = resourceName;
        PolicyResource policyResource = new PolicyResource(resourceName);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resourceName.substring(0, resourceName.indexOf(moduleName)));
            strBuf.append(resourceName.substring(resourceName.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Resource contains module name");
                Tr.debug(TRACE_COMPONENT, "Resource without moduleName is: " + updatedResource);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeModuleName", updatedResource);
        }
        return updatedResource;
    }

    @Override
    public void storeReferenceList(List references) {
        this._referenceList = references;
    }

    /*
     * Loose catch block
     */
    public void loadBindings(String scopeKeyIn, String endpointURI) throws WSPolicyFormattedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadBindings", new Object[]{scopeKeyIn, endpointURI});
        }
        PolicyResource policyResource = new PolicyResource(scopeKeyIn);
        String serviceName = policyResource.getServiceName();
        String moduleName = policyResource.getModuleName();
        String scopeKey = "WebService:/";
        if (moduleName != null) {
            scopeKey = scopeKey + moduleName + ":";
        }
        if (serviceName != null) {
            scopeKey = scopeKey + serviceName.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "scopeKey that will be used to look up bindings is " + scopeKey);
        }
        List allTypes = PolicyTypeAggregator.getExtensions();
        InputStream bindingStream = null;
        for (PolicyTypeLoader loader : allTypes) {
            byte[] byteArray;
            String policyType;
            block33: {
                Object[] args;
                policyType = null;
                try {
                    policyType = loader.getType();
                }
                catch (Exception e) {
                    args = new Object[]{serviceName, e};
                    throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
                }
                if (policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport")) continue;
                try {
                    bindingStream = this.getBindingInputStream(scopeKey, policyType, this._referenceList);
                }
                catch (WSPolicyBindingsException e) {
                    args = new Object[]{endpointURI};
                    throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0300", args, "CWPOL0300E"), e);
                }
                byteArray = null;
                if (bindingStream != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] tempBuffer = new byte[1024];
                    int bytesLen = 0;
                    while ((bytesLen = bindingStream.read(tempBuffer)) != -1) {
                        baos.write(tempBuffer, 0, bytesLen);
                    }
                    byteArray = baos.toByteArray();
                    Object var19_18 = null;
                    try {
                        if (bindingStream != null) {
                            bindingStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException closing bindingInputStream ", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2307", this);
                    }
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                        break block33;
                    }
                    catch (IOException ioe) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException closing temporary bindingOutputStream", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing temporary bindingOutputStrea", "2317", this);
                    }
                    break block33;
                    {
                        catch (IOException ioe) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException reading bindingInputStream ", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2302", this);
                            Object[] args2 = new Object[]{scopeKey};
                            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0301", args2, "CWPOL0301E"), ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        var19_18 = null;
                        try {
                            if (bindingStream != null) {
                                bindingStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException closing bindingInputStream ", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2307", this);
                        }
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException closing temporary bindingOutputStream", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing temporary bindingOutputStrea", "2317", this);
                        }
                        throw throwable;
                    }
                }
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Read default binding for " + policyType);
            }
            this.getBindings().put(policyType, byteArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadBindings");
        }
    }

    private InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, String policyType) throws WSPolicyInternalException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        InputStream result = null;
        if (this._transformer == null) {
            this._transformer = WSPolicyFactory.newInstance().createPolicyTransform();
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Calling transform utility ");
        }
        HashMap<String, Object> transformOptions = new HashMap<String, Object>();
        result = this._transformer.transformForClientConfiguration(policy, transformOptions, policyType);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        return result;
    }

    /*
     * Loose catch block
     */
    @Override
    public PolicySetConfigurationImpl generateQOSProperties(ClassLoader systemCL, String scopeInformation, List<String> typesInPolicySet, List<String> usedTypes, MessageContext mc, final String policySetName) throws NullPolicyException, PolicyException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateQOSProperties");
        }
        PolicySetConfigurationImpl psConfig = new PolicySetConfigurationImpl();
        List extensions = PolicyTypeAggregator.getExtensions();
        VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            PolicyTypeLoader loader;
            block25: {
                String policyType;
                InputStream policyTypeConfig = null;
                loader = (PolicyTypeLoader)iter.next();
                try {
                    policyType = loader.getType();
                }
                catch (Exception e) {
                    AxisService service = mc.getAxisService();
                    Object[] args = new Object[]{service == null ? null : service.getName(), e};
                    throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), new WSPolicyInternalException(e));
                }
                if (!(policyType == null || policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport"))) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "About to call load on " + loader.getClass().getName());
                    }
                    PolicyInputStreamHolder preTransformedPolicy = null;
                    try {
                        preTransformedPolicy = this.calculatePolicy(scopeInformation, policyType, mc);
                    }
                    catch (UnknownOperationException e1) {
                        // empty catch block
                    }
                    try {
                        policyTypeConfig = this.transformForClientConfiguration(preTransformedPolicy, policyType);
                    }
                    catch (WSPolicyInternalException e) {
                        AxisService service = mc.getAxisService();
                        Object[] args = new Object[]{service == null ? null : service.getName(), e};
                        throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
                    }
                    catch (TransformationException e) {
                        AxisService service = mc.getAxisService();
                        String url = null;
                        if (service != null) {
                            url = service.getEndpointURL();
                        }
                        Tr.warning(TRACE_COMPONENT, "CWPOL0200", new Object[]{url});
                        Object[] args = new Object[]{url};
                        throw new PolicyException(nls.getFormattedMessage("CWPOL0200", args, "CWPOL0200E"), e);
                    }
                }
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Processing Non-WSPolicy Policy type : " + policyType);
                }
                if (policyType != null && policySetName != null && !policySetName.equals("") && typesInPolicySet.contains(policyType)) {
                    policyTypeConfig = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                        @Override
                        public InputStream run() {
                            return PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, policyType);
                        }
                    });
                }
                if (policyTypeConfig != null) {
                    loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                    usedTypes.add(policyType);
                    Object var20_22 = null;
                    try {
                        policyTypeConfig.close();
                    }
                    catch (Exception e) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Exception closing inputStream ", e);
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.generateQOSProperties", "2475", this);
                    }
                    break block25;
                    {
                        catch (Exception e) {
                            AxisService service = mc.getAxisService();
                            Object[] args = new Object[]{service == null ? null : service.getName(), e};
                            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), new WSPolicyInternalException(e));
                        }
                    }
                    catch (Throwable throwable) {
                        var20_22 = null;
                        try {
                            policyTypeConfig.close();
                        }
                        catch (Exception e) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Exception closing inputStream ", e);
                            }
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.generateQOSProperties", "2475", this);
                        }
                        throw throwable;
                    }
                }
            }
            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "Back from load on " + loader.getClass().getName());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateQOSProperties");
        }
        return psConfig;
    }
}

