/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.ws.wspolicy.policyset.WSPolicyTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class WSPolicyFactory {
    private static WSPolicyFactory _wsPolicyFactory = null;
    private static final String WSPOLICYPROCESSOR_CLASSNAME = "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl";
    private static final String WSPOLICYTRANSFORMER_CLASSNAME = "com.ibm.ws.wspolicy.policyset.WSPolicyTransformImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyFactory.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public WSPolicyProcessor createPolicyProcessor(String applicationPath, String serviceName, String moduleName) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicyProcessor", new Object[]{applicationPath});
        }
        WSPolicyProcessor result = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> c = loader.loadClass(WSPOLICYPROCESSOR_CLASSNAME);
            Constructor<?> constructor = c.getConstructor(String.class, String.class, String.class);
            result = (WSPolicyProcessor)constructor.newInstance(applicationPath, serviceName, moduleName);
        }
        catch (InstantiationException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (IllegalAccessException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (ClassNotFoundException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (IllegalArgumentException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (InvocationTargetException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (SecurityException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (NoSuchMethodException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicyProcessor");
        }
        return result;
    }

    public static WSPolicyFactory newInstance() {
        if (_wsPolicyFactory == null) {
            _wsPolicyFactory = new WSPolicyFactory();
        }
        return _wsPolicyFactory;
    }

    public WSPolicyTransform createPolicyTransform() throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicyTransform");
        }
        WSPolicyTransform result = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> c = loader.loadClass(WSPOLICYTRANSFORMER_CLASSNAME);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            result = (WSPolicyTransform)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (IllegalAccessException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (ClassNotFoundException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (IllegalArgumentException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (InvocationTargetException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (SecurityException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        catch (NoSuchMethodException e) {
            WSPolicyFactory.traceAndFFDCException(WSPOLICYTRANSFORMER_CLASSNAME, e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicyTransform");
        }
        return result;
    }

    private static void traceAndFFDCException(String className, Exception e) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSPolicyFactory caught Exception", e);
        }
        FFDCFilter.processException(e, className, "146");
        throw new WSPolicyInternalException(e);
    }
}

