/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.attachment.PolicyExtensionRegistry;
import com.ibm.ws.wspolicy.attachment.UsingPolicy;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPolicyProcessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLPolicyProcessor.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Definition _wsdl = null;
    private Service _service = null;
    private QName _serviceName = null;
    private PolicyReader _reader = null;
    private boolean _containsUsingPolicy = false;
    private PolicyContext _context = null;

    public WSDLPolicyProcessor(Definition wsdl, PolicyContext pContext) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSDLPolicyProcessor", new Object[]{wsdl});
        }
        this._context = pContext;
        this.initDefinition(wsdl);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "Policy");
        }
    }

    public WSDLPolicyProcessor(Definition wsdl) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSDLPolicyProcessor", new Object[]{wsdl});
        }
        this._context = new PolicyContext();
        this.initDefinition(wsdl);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "Policy");
        }
    }

    private void initDefinition(Definition wsdl) throws WSPolicyInternalException {
        Map map;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "initDefinition", wsdl);
        }
        if (wsdl == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The WSDL definition was unexpectedly null", wsdl);
            }
            throw new WSPolicyInternalException();
        }
        this._wsdl = wsdl;
        this._reader = InternalUtils.getReader(this._wsdl);
        if (this._reader == null) {
            this._reader = new PolicyFactory(this._context).newPolicyReader();
        }
        if ((map = this._wsdl.getServices()) == null || map.size() != 1) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "A duplicate service name was found");
            }
            throw new WSPolicyInternalException();
        }
        Set set = map.entrySet();
        Iterator iter = set.iterator();
        Map.Entry me = iter.next();
        this._service = (Service)me.getValue();
        this._serviceName = (QName)me.getKey();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "initDefinition");
        }
    }

    public WSDLPolicyProcessor(String wsdlURI, PolicyContext pContext) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSDLPolicyProcessor", new Object[]{wsdlURI});
        }
        this._context = pContext;
        this.initURI(wsdlURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSDLPolicyProcessor");
        }
    }

    public WSDLPolicyProcessor(String wsdlURI) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSDLPolicyProcessor", new Object[]{wsdlURI});
        }
        this._context = new PolicyContext();
        this.initURI(wsdlURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSDLPolicyProcessor");
        }
    }

    public void initURI(String wsdlURI) throws WSPolicyInternalException {
        if (wsdlURI == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.entry(TRACE_COMPONENT, "The WSDL URI was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            PolicyExtensionRegistry er = new PolicyExtensionRegistry(this._context);
            wsdlReader.setExtensionRegistry(er);
            this._wsdl = wsdlReader.readWSDL(wsdlURI);
            Map map = this._wsdl.getServices();
            if (map == null || map.size() != 1) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Duplicate Service Name found");
                }
                throw new WSPolicyInternalException();
            }
            Set set = map.entrySet();
            Iterator iter = set.iterator();
            Map.Entry me = iter.next();
            this._service = (Service)me.getValue();
            this._serviceName = (QName)me.getKey();
        }
        catch (WSDLException we) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Error parsing WSDL");
            }
            throw new WSPolicyInternalException(we);
        }
        this._reader = new PolicyFactory(this._context).newPolicyReader();
    }

    public Definition getDefinition() {
        return this._wsdl;
    }

    public QName getServiceQName() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServiceQName");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServiceQName");
        }
        return this._serviceName;
    }

    public Vector getPortNames() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPortNames");
        }
        Map ports = this._service.getPorts();
        Vector result = null;
        if (ports != null) {
            result = new Vector(ports.keySet());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPortNames");
        }
        return result;
    }

    public Vector getBindingOperationNames(String portName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBindingOperationNames");
        }
        Vector<String> names = new Vector<String>();
        Map ports = this._service.getPorts();
        for (Port tPort : ports.values()) {
            if (!tPort.getName().equals(portName)) continue;
            Binding binding = tPort.getBinding();
            List operations = binding.getBindingOperations();
            for (BindingOperation operation : operations) {
                String operationName;
                if (operation == null || (operationName = operation.getName()) == null) continue;
                names.add(operationName);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "[Service:" + this._serviceName.toString() + "][Port:" + portName + "][Operation:" + operationName + "]");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBindingOperationNames");
        }
        return names;
    }

    public Vector getOperationNames(String portName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOperationNames");
        }
        Vector<String> names = new Vector<String>();
        Map ports = this._service.getPorts();
        for (Port tPort : ports.values()) {
            if (!tPort.getName().equals(portName)) continue;
            Binding binding = tPort.getBinding();
            PortType portType = binding.getPortType();
            List operations = portType.getOperations();
            for (Operation operation : operations) {
                String operationName;
                if (operation == null || (operationName = operation.getName()) == null) continue;
                names.add(operationName);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "[Service:" + this._serviceName.toString() + "][Port:" + portName + "][Operation:" + operationName + "]");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOperationNames");
        }
        return names;
    }

    public Vector<QName> getPortTypeQNames() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPortTypeQNames");
        }
        Vector<QName> result = new Vector<QName>();
        Map portTypes = this._wsdl.getPortTypes();
        for (PortType tPortType : portTypes.values()) {
            if (tPortType == null) continue;
            result.add(tPortType.getQName());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPortTypeQNames");
        }
        return result;
    }

    public QName getPortTypeQName(String portName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPortTypeQName", new Object[]{portName});
        }
        QName pTypeQName = null;
        Map ports = this._service.getPorts();
        for (Port tPort : ports.values()) {
            if (!tPort.getName().equals(portName)) continue;
            Binding tBinding = tPort.getBinding();
            PortType tPortType = tBinding.getPortType();
            pTypeQName = tPortType.getQName();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPortTypeQName", new Object[]{pTypeQName});
        }
        return pTypeQName;
    }

    public Vector getServicePolicies() throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServicePolicies");
        }
        List extensibilityElements = this._service.getExtensibilityElements();
        Vector result = this.handleElement(extensibilityElements);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServicePolicies");
        }
        return result;
    }

    public void addServicePolicy(Vector assertions) throws WSPolicyInternalException {
        Policy policy = new PolicyFactory(this._context).newPolicy();
        policy.setChildAssertions(assertions);
        this.addServicePolicy(policy);
    }

    public void addServicePolicy(Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addServicePolicy", new Object[]{policy});
        }
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        wsdlPt.setServiceAttachPoint(this._service.getQName());
        this.addPolicy(wsdlPt, policy);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addServicePolicy");
        }
    }

    private void addServicePolicy(WSDLAttachPoint scope, Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addServicePolicy", new Object[]{scope, policy});
        }
        this.addUsingPolicy();
        Policy extElem = this.getScopedPolicy(policy, scope);
        this._service.addExtensibilityElement(extElem);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addServicePolicy", "Policy added for scope[" + scope + "]");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addServicePolicy");
        }
    }

    public Vector getEndpointPolicies(String portName) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        wsdlPt.setPortAttachPoint(this._service.getQName(), portName);
        Vector result = this.getEndpointPolicies(wsdlPt);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector getEndpointPolicies(WSDLAttachPoint scope) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Vector result;
        block15: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getEndpointPolicies", new Object[]{scope});
            }
            result = new Vector();
            String attachPointType = scope.getAttachPointType();
            String scopeLevel = scope.getScopeLevel();
            if (attachPointType.equals(PolicyConstants.ATTACH_PORT)) {
                String portName = (String)scope.getValue(PolicyConstants.ATTACH_PORT);
                Port port = this._service.getPort(portName);
                if (port != null) {
                    List extensibilityElements = port.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    break block15;
                } else {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point.  Scope " + scope);
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (attachPointType.equals(PolicyConstants.ATTACH_PORTTYPE)) {
                QName portTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                PortType portType = this._wsdl.getPortType(portTypeQName);
                if (portType != null) {
                    Vector policyURIs = InternalUtils.getPolicyURIs(portType);
                    List extElements = this._wsdl.getExtensibilityElements();
                    result = InternalUtils.getPoliciesFromURIs(extElements, policyURIs);
                    break block15;
                } else {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scope);
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (attachPointType.equals(PolicyConstants.ATTACH_BINDING)) {
                QName bindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                Binding binding = this._wsdl.getBinding(bindingQName);
                if (binding != null) {
                    List extensibilityElements = binding.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    break block15;
                } else {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scope);
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "getEndpointPolicies", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointPolicies");
        }
        return result;
    }

    public void addEndpointPolicy(String portName, Vector assertions) throws WSPolicyInternalException {
        Policy policy = new PolicyFactory(this._context).newPolicy();
        policy.setChildAssertions(assertions);
        this.addEndpointPolicy(portName, policy);
    }

    public void addEndpointPolicy(String portName, Policy policy) throws WSPolicyInternalException {
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        wsdlPt.setPortAttachPoint(this._service.getQName(), portName);
        this.addEndpointPolicy(wsdlPt, policy);
    }

    private void addEndpointPolicy(WSDLAttachPoint scope, Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointPolicy", new Object[]{scope, policy});
        }
        boolean found = false;
        if (policy != null) {
            String attachPointType = scope.getAttachPointType();
            String scopeLevel = scope.getScopeLevel();
            if (attachPointType.equals(PolicyConstants.ATTACH_PORT)) {
                String portName = (String)scope.getValue(PolicyConstants.ATTACH_PORT);
                Port port = this._service.getPort(portName);
                if (port != null) {
                    this.addUsingPolicy();
                    Policy extElem = this.getScopedPolicy(policy, scope);
                    port.addExtensibilityElement(extElem);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "addEndpointPolicy", "Policy added for scope[" + scope + "]");
                    }
                    found = true;
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_PORTTYPE)) {
                QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                PortType portType = this._wsdl.getPortType(myPortTypeQName);
                if (portType != null) {
                    InternalUtils.addURI(portType, policy, this._wsdl.getTargetNamespace());
                    this.addUsingPolicy();
                    Policy extElem = this.getScopedPolicy(policy, scope);
                    InternalUtils.addToDefinition(this._wsdl, extElem);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "addEndpointPolicy", "Policy added at DEFINITION, PolicyURI added at scope[" + scope + "]");
                    }
                    found = true;
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING)) {
                QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                Binding binding = this._wsdl.getBinding(myBindingQName);
                if (binding != null) {
                    this.addUsingPolicy();
                    Policy extElem = this.getScopedPolicy(policy, scope);
                    binding.addExtensibilityElement(extElem);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "addEndpointPolicy", "   Policy added for scope[" + scope + "]");
                    }
                    found = true;
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.error(TRACE_COMPONENT, "addEndpointPolicy", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
                }
                throw new WSPolicyInternalException();
            }
            if (!found) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "addEndpointPolicy", "Unable to find scope[" + scope + "]");
                }
                throw new WSPolicyInternalException();
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointPolicy");
        }
    }

    private Vector getOperationPolicies(WSDLAttachPoint scope) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOperationPolicies", new Object[]{scope});
        }
        Vector result = new Vector();
        String attachPointType = scope.getAttachPointType();
        String scopeLevel = scope.getScopeLevel();
        if (attachPointType.equals(PolicyConstants.ATTACH_OPERATION)) {
            boolean found = false;
            QName portTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
            PortType portType = this._wsdl.getPortType(portTypeQName);
            if (portType != null) {
                List ops = portType.getOperations();
                for (Operation oper : ops) {
                    if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName)) continue;
                    List extensibilityElements = oper.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    found = true;
                }
            }
            if (!found) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scope);
                }
                throw new WSPolicyInternalException();
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_OPERATION)) {
            boolean found = false;
            QName bindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
            Binding binding = this._wsdl.getBinding(bindingQName);
            if (binding != null) {
                List ops = binding.getBindingOperations();
                for (BindingOperation bindOper : ops) {
                    if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName)) continue;
                    List extensibilityElements = bindOper.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    found = true;
                }
            }
            if (!found) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scope);
                }
                throw new WSPolicyInternalException();
            }
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "getOperationPolicies", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOperationPolicies");
        }
        return result;
    }

    public Vector getOperationPolicies(String portName, String operationName) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Binding binding;
        boolean found = false;
        Vector result = new Vector();
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        Port port = this._service.getPort(portName);
        if (port != null && (binding = port.getBinding()) != null) {
            wsdlPt.setBindingOperationAttachPoint(binding.getQName(), operationName);
            result = this.getOperationPolicies(wsdlPt);
            found = true;
        }
        if (!found) {
            String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
            }
            throw new WSPolicyInternalException();
        }
        return result;
    }

    public void addOperationPolicy(String portName, String operationName, Vector assertions) throws WSPolicyInternalException {
        Policy policy = new PolicyFactory(this._context).newPolicy();
        policy.setChildAssertions(assertions);
        this.addOperationPolicy(portName, operationName, policy);
    }

    public void addOperationPolicy(String portName, String operationName, Policy policy) throws WSPolicyInternalException {
        boolean found = false;
        if (policy != null) {
            Binding binding;
            Port port = this._service.getPort(portName);
            if (port != null && (binding = port.getBinding()) != null) {
                WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
                wsdlPt.setBindingOperationAttachPoint(binding.getQName(), operationName);
                this.addOperationPolicy(wsdlPt, policy);
                found = true;
            }
            if (!found) {
                String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
                }
                throw new WSPolicyInternalException();
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
    }

    private void addOperationPolicy(WSDLAttachPoint scope, Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addOperationPolicy", new Object[]{scope, policy});
        }
        boolean found = false;
        if (policy != null) {
            String scopeLevel = scope.getScopeLevel();
            String attachPointType = scope.getAttachPointType();
            if (attachPointType.equals(PolicyConstants.ATTACH_OPERATION)) {
                QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
                PortType portType = this._wsdl.getPortType(myPortTypeQName);
                if (portType != null) {
                    List ops = portType.getOperations();
                    for (Operation op : ops) {
                        if (op == null || !op.getName().equalsIgnoreCase(myOperationName)) continue;
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        op.addExtensibilityElement(extElem);
                        found = true;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addOperationPolicy", "Policy added for scope [" + scope + "]");
                        }
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_OPERATION)) {
                QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
                Binding binding = this._wsdl.getBinding(myBindingQName);
                if (binding.getQName().equals(myBindingQName)) {
                    List ops = binding.getBindingOperations();
                    for (BindingOperation bindOper : ops) {
                        if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName)) continue;
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        bindOper.addExtensibilityElement(extElem);
                        found = true;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addOperationPolicy", "Policy added for scope [" + scope + "]");
                        }
                        break;
                    }
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.error(TRACE_COMPONENT, "addOperationPolicy", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
                }
                throw new WSPolicyInternalException();
            }
            if (!found) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "addOperationPolicy", "Unable to find OPERATION at scope[" + scope + "]");
                }
                throw new WSPolicyInternalException();
            }
            this.addUsingPolicy();
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addOperationPolicy");
        }
    }

    public Vector getOutputMessagePolicies(String portName, String operationName) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Binding binding;
        boolean found = false;
        Vector result = new Vector();
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        Port port = this._service.getPort(portName);
        if (port != null && (binding = port.getBinding()) != null) {
            wsdlPt.setBindingOutputMessageAttachPoint(binding.getQName(), operationName, null);
            result = this.getMessagePolicies(wsdlPt);
            found = true;
        }
        if (!found) {
            String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
            }
            throw new WSPolicyInternalException();
        }
        return result;
    }

    public void addOutputMessagePolicy(String portName, String operationName, Vector assertions) throws WSPolicyInternalException {
        Policy policy = new PolicyFactory(this._context).newPolicy();
        policy.setChildAssertions(assertions);
        this.addOutputMessagePolicy(portName, operationName, policy);
    }

    public void addOutputMessagePolicy(String portName, String operationName, Policy policy) throws WSPolicyInternalException {
        boolean found = false;
        if (policy != null) {
            Binding binding;
            Port port = this._service.getPort(portName);
            if (port != null && (binding = port.getBinding()) != null) {
                WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
                wsdlPt.setBindingOutputMessageAttachPoint(binding.getQName(), operationName, null);
                this.addMessagePolicy(wsdlPt, policy);
                found = true;
            }
            if (!found) {
                String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
                }
                throw new WSPolicyInternalException();
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
    }

    public Vector getInputMessagePolicies(String portName, String operationName) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Binding binding;
        boolean found = false;
        Vector result = new Vector();
        WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
        Port port = this._service.getPort(portName);
        if (port != null && (binding = port.getBinding()) != null) {
            wsdlPt.setBindingInputMessageAttachPoint(binding.getQName(), operationName, null);
            result = this.getMessagePolicies(wsdlPt);
            found = true;
        }
        if (!found) {
            String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
            }
            throw new WSPolicyInternalException();
        }
        return result;
    }

    public void addInputMessagePolicy(String portName, String operationName, Vector assertions) throws WSPolicyInternalException {
        Policy policy = new PolicyFactory(this._context).newPolicy();
        policy.setChildAssertions(assertions);
        this.addInputMessagePolicy(portName, operationName, policy);
    }

    public void addInputMessagePolicy(String portName, String operationName, Policy policy) throws WSPolicyInternalException {
        boolean found = false;
        if (policy != null) {
            Binding binding;
            Port port = this._service.getPort(portName);
            if (port != null && (binding = port.getBinding()) != null) {
                WSDLAttachPoint wsdlPt = new WSDLAttachPoint();
                wsdlPt.setBindingInputMessageAttachPoint(binding.getQName(), operationName, null);
                this.addMessagePolicy(wsdlPt, policy);
                found = true;
            }
            if (!found) {
                String scopeString = "portName[" + portName + "] operationName[" + operationName + "]";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scopeString);
                }
                throw new WSPolicyInternalException();
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
    }

    public Vector getMessagePolicies(WSDLAttachPoint scope) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getMessagePolicies", new Object[]{scope});
        }
        Vector result = new Vector();
        String attachPointType = scope.getAttachPointType();
        String scopeLevel = scope.getScopeLevel();
        boolean found = false;
        if (attachPointType.equals(PolicyConstants.ATTACH_INPUT)) {
            QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
            PortType portType = this._wsdl.getPortType(myPortTypeQName);
            if (portType != null && portType.getQName().equals(myPortTypeQName)) {
                List ops = portType.getOperations();
                for (Operation oper : ops) {
                    Input input;
                    if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (input = oper.getInput()) == null) continue;
                    Vector policyURIs = InternalUtils.getPolicyURIs(input);
                    List extElements = this._wsdl.getExtensibilityElements();
                    result = InternalUtils.getPoliciesFromURIs(extElements, policyURIs);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_OUTPUT)) {
            QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
            PortType portType = this._wsdl.getPortType(myPortTypeQName);
            if (portType.getQName().equals(myPortTypeQName)) {
                List ops = portType.getOperations();
                for (Operation oper : ops) {
                    Output output;
                    if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (output = oper.getOutput()) == null) continue;
                    Vector policyURIs = InternalUtils.getPolicyURIs(output);
                    List extElements = this._wsdl.getExtensibilityElements();
                    result = InternalUtils.getPoliciesFromURIs(extElements, policyURIs);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_FAULT)) {
            QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
            PortType portType = this._wsdl.getPortType(myPortTypeQName);
            if (portType != null && portType.getQName().equals(myPortTypeQName)) {
                List ops = portType.getOperations();
                for (Operation oper : ops) {
                    String myFaultName;
                    Fault fault;
                    if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (fault = oper.getFault(myFaultName = (String)scope.getValue(PolicyConstants.ATTACH_FAULT))) == null) continue;
                    Vector policyURIs = InternalUtils.getPolicyURIs(fault);
                    List extElements = this._wsdl.getExtensibilityElements();
                    result = InternalUtils.getPoliciesFromURIs(extElements, policyURIs);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_INPUT)) {
            QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
            Binding binding = this._wsdl.getBinding(myBindingQName);
            if (binding != null && binding.getQName().equals(myBindingQName)) {
                List ops = binding.getBindingOperations();
                for (BindingOperation bindOper : ops) {
                    BindingInput input;
                    if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (input = bindOper.getBindingInput()) == null) continue;
                    List extensibilityElements = input.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_OUTPUT)) {
            QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
            Binding binding = this._wsdl.getBinding(myBindingQName);
            if (binding != null && binding.getQName().equals(myBindingQName)) {
                List ops = binding.getBindingOperations();
                for (BindingOperation bindOper : ops) {
                    BindingOutput output;
                    if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (output = bindOper.getBindingOutput()) == null) continue;
                    List extensibilityElements = output.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_FAULT)) {
            QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
            String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
            Binding binding = this._wsdl.getBinding(myBindingQName);
            if (binding != null && binding.getQName().equals(myBindingQName)) {
                List ops = binding.getBindingOperations();
                for (BindingOperation bindOper : ops) {
                    String myFaultName;
                    BindingFault fault;
                    if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (fault = bindOper.getBindingFault(myFaultName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_FAULT))) == null) continue;
                    List extensibilityElements = fault.getExtensibilityElements();
                    result = this.handleElement(extensibilityElements);
                    found = true;
                    break;
                }
            }
        } else if (attachPointType.equals(PolicyConstants.ATTACH_MESSAGE)) {
            QName myMessageQName = (QName)scope.getValue(PolicyConstants.ATTACH_MESSAGE);
            Message message = this._wsdl.getMessage(myMessageQName);
            if (message != null) {
                List extensibilityElements = message.getExtensibilityElements();
                result = this.handleElement(extensibilityElements);
                found = true;
            }
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "getMessagePolicies", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
            }
            throw new WSPolicyInternalException();
        }
        if (!found) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to locate policy attach point " + scope);
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getMessagePolicies");
        }
        return result;
    }

    private void addMessagePolicy(WSDLAttachPoint scope, Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addMessagePolicy", new Object[]{scope, policy});
        }
        boolean found = false;
        if (policy != null) {
            String attachPointType = scope.getAttachPointType();
            String scopeLevel = scope.getScopeLevel();
            if (attachPointType.equals(PolicyConstants.ATTACH_INPUT)) {
                QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
                PortType portType = this._wsdl.getPortType(myPortTypeQName);
                if (portType != null && portType.getQName().equals(myPortTypeQName)) {
                    List ops = portType.getOperations();
                    for (Operation oper : ops) {
                        Input input;
                        if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (input = oper.getInput()) == null) continue;
                        InternalUtils.addURI(input, policy, this._wsdl.getTargetNamespace());
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        InternalUtils.addToDefinition(this._wsdl, extElem);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added at DEFINITION, PolicyURI added at scope[" + scope + "]");
                        }
                        found = true;
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_OUTPUT)) {
                QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
                PortType portType = this._wsdl.getPortType(myPortTypeQName);
                if (portType != null && portType.getQName().equals(myPortTypeQName)) {
                    List ops = portType.getOperations();
                    for (Operation oper : ops) {
                        Output output;
                        if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (output = oper.getOutput()) == null) continue;
                        InternalUtils.addURI(output, policy, this._wsdl.getTargetNamespace());
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        InternalUtils.addToDefinition(this._wsdl, extElem);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added at DEFINITION, PolicyURI added at scope[" + scope + "]");
                        }
                        found = true;
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_FAULT)) {
                QName myPortTypeQName = (QName)scope.getValue(PolicyConstants.ATTACH_PORTTYPE);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_OPERATION);
                PortType portType = this._wsdl.getPortType(myPortTypeQName);
                if (portType != null && portType.getQName().equals(myPortTypeQName)) {
                    List ops = portType.getOperations();
                    for (Operation oper : ops) {
                        String myFaultName;
                        Fault fault;
                        if (oper == null || !oper.getName().equalsIgnoreCase(myOperationName) || (fault = oper.getFault(myFaultName = (String)scope.getValue(PolicyConstants.ATTACH_FAULT))) == null) continue;
                        InternalUtils.addURI(fault, policy, this._wsdl.getTargetNamespace());
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        InternalUtils.addToDefinition(this._wsdl, extElem);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added at DEFINITION, PolicyURI added at scope[" + scope + "]");
                        }
                        found = true;
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_INPUT)) {
                QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
                Binding binding = this._wsdl.getBinding(myBindingQName);
                if (binding != null && binding.getQName().equals(myBindingQName)) {
                    List ops = binding.getBindingOperations();
                    for (BindingOperation bindOper : ops) {
                        BindingInput input;
                        if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (input = bindOper.getBindingInput()) == null) continue;
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        input.addExtensibilityElement(extElem);
                        found = true;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added for scope [" + scope + "]");
                        }
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_OUTPUT)) {
                QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
                Binding binding = this._wsdl.getBinding(myBindingQName);
                if (binding != null && binding.getQName().equals(myBindingQName)) {
                    List ops = binding.getBindingOperations();
                    for (BindingOperation bindOper : ops) {
                        BindingOutput output;
                        if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (output = bindOper.getBindingOutput()) == null) continue;
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        output.addExtensibilityElement(extElem);
                        found = true;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added for scope [" + scope + "]");
                        }
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_BINDING_FAULT)) {
                QName myBindingQName = (QName)scope.getValue(PolicyConstants.ATTACH_BINDING);
                String myOperationName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
                Binding binding = this._wsdl.getBinding(myBindingQName);
                if (binding != null && binding.getQName().equals(myBindingQName)) {
                    List ops = binding.getBindingOperations();
                    for (BindingOperation bindOper : ops) {
                        String myFaultName;
                        BindingFault fault;
                        if (bindOper == null || !bindOper.getName().equalsIgnoreCase(myOperationName) || (fault = bindOper.getBindingFault(myFaultName = (String)scope.getValue(PolicyConstants.ATTACH_BINDING_FAULT))) == null) continue;
                        this.addUsingPolicy();
                        Policy extElem = this.getScopedPolicy(policy, scope);
                        fault.addExtensibilityElement(extElem);
                        found = true;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added for scope [" + scope + "]");
                        }
                        break;
                    }
                }
            } else if (attachPointType.equals(PolicyConstants.ATTACH_MESSAGE)) {
                QName myMessageQName = (QName)scope.getValue(PolicyConstants.ATTACH_MESSAGE);
                Message message = this._wsdl.getMessage(myMessageQName);
                this.addUsingPolicy();
                Policy extElem = this.getScopedPolicy(policy, scope);
                message.addExtensibilityElement(extElem);
                found = true;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Policy added for scope [" + scope + "]");
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.error(TRACE_COMPONENT, "addMessagePolicy", "Scope [" + scopeLevel + "] and AttachPointType[" + attachPointType + "] mismatch; problem with WSDLAttachPoint");
                }
                throw new WSPolicyInternalException();
            }
            if (!found) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "addMessagePolicy", "Unable to find scope[" + scope + "]");
                }
                throw new WSPolicyInternalException();
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addMessagePolicy");
        }
    }

    public void addPolicy(PolicyAttachmentScopeElement scope, Policy policy) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPolicy", new Object[]{scope, policy});
        }
        if (scope != null && scope instanceof WSDLAttachPoint) {
            WSDLAttachPoint wsdlPt = (WSDLAttachPoint)scope;
            if (policy != null) {
                String scopeLevel = wsdlPt.getScopeLevel();
                if (scopeLevel.equals(PolicyConstants.SCOPE_SERVICE)) {
                    this.addServicePolicy(wsdlPt, policy);
                } else if (scopeLevel.equals(PolicyConstants.SCOPE_ENDPOINT)) {
                    this.addEndpointPolicy(wsdlPt, policy);
                } else if (scopeLevel.equals(PolicyConstants.SCOPE_OPERATION)) {
                    this.addOperationPolicy(wsdlPt, policy);
                } else if (scopeLevel.equals(PolicyConstants.SCOPE_MESSAGE)) {
                    this.addMessagePolicy(wsdlPt, policy);
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, ">>> Policy is null");
            }
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Scope is either null or not a supported type of PolicyAttachmentScopeElement");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPolicy");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector getPolicies(PolicyAttachmentScopeElement scope) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Vector policies;
        block10: {
            block11: {
                String scopeLevel;
                WSDLAttachPoint wsdlPt;
                block12: {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.entry(TRACE_COMPONENT, "getPolicies", new Object[]{scope});
                    }
                    policies = new Vector();
                    if (scope == null || !(scope instanceof WSDLAttachPoint)) break block11;
                    wsdlPt = (WSDLAttachPoint)scope;
                    scopeLevel = wsdlPt.getScopeLevel();
                    if (scopeLevel.equals(PolicyConstants.SCOPE_SERVICE)) {
                        QName serviceQName = (QName)wsdlPt.getValue(PolicyConstants.ATTACH_SERVICE);
                        if (this._service.getQName().equals(serviceQName)) {
                            policies = this.getServicePolicies();
                            break block10;
                        } else {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "ServiceName in SCOPE[" + serviceQName + "] does not match with SERVICE [" + this._service.getQName() + "]");
                            }
                            throw new WSPolicyInternalException();
                        }
                    }
                    if (!scopeLevel.equals(PolicyConstants.SCOPE_ENDPOINT)) break block12;
                    policies = this.getEndpointPolicies(wsdlPt);
                    break block10;
                }
                if (scopeLevel.equals(PolicyConstants.SCOPE_OPERATION)) {
                    policies = this.getOperationPolicies(wsdlPt);
                    break block10;
                } else if (scopeLevel.equals(PolicyConstants.SCOPE_MESSAGE)) {
                    policies = this.getMessagePolicies(wsdlPt);
                }
                break block10;
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Scope is either null or not a supported type of PolicyAttachmentScopeElement");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicies");
        }
        return policies;
    }

    private Vector handleElement(List extensibilityElements) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (extensibilityElements == null) {
            return null;
        }
        Vector<ExtensibilityElement> policies = new Vector<ExtensibilityElement>();
        for (ExtensibilityElement ee : extensibilityElements) {
            if (ee instanceof Policy) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "handleElement", "   Found Policy as extensibilityElement");
                }
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "handleElement", "   " + ee);
                }
                policies.add(ee);
                continue;
            }
            if (ee instanceof PolicyReference) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "handleElement", "   Found PolicyReference as extensibilityElement");
                }
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "handleElement", "   " + ee);
                }
                policies.add(ee);
                continue;
            }
            ExtensibilityElement p = InternalUtils.extractUnknownElement(this._wsdl, ee, this._reader, this._context);
            if (p == null) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "handleElement", "   Found UnknownElement");
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "handleElement", "   " + p);
            }
            policies.add(p);
        }
        return policies;
    }

    private void addUsingPolicy() {
        if (!this._containsUsingPolicy) {
            boolean foundUsingPolicy = false;
            List extensibilityElements = this._wsdl.getExtensibilityElements();
            Iterator eElementItr = extensibilityElements.iterator();
            while (eElementItr.hasNext() && !foundUsingPolicy) {
                ExtensibilityElement ee = (ExtensibilityElement)eElementItr.next();
                if (!(ee instanceof UsingPolicy)) continue;
                foundUsingPolicy = true;
            }
            if (!foundUsingPolicy) {
                UsingPolicy usingPolicy = new UsingPolicy();
                PolicyFactory factory = new PolicyFactory(this._context);
                PolicyReader reader = factory.newPolicyReader();
                usingPolicy.setPolicyReader(reader);
                this._wsdl.addExtensibilityElement(usingPolicy);
                this._containsUsingPolicy = true;
            }
        }
    }

    protected void writeWSDL(Writer writer) throws WSPolicyInternalException {
        WSDLWriterImpl wsdlWriter = new WSDLWriterImpl();
        try {
            wsdlWriter.writeWSDL(this._wsdl, writer);
        }
        catch (WSDLException e) {
            throw new WSPolicyInternalException(e);
        }
    }

    private Policy getScopedPolicy(Policy pol, WSDLAttachPoint scope) throws WSPolicyInternalException {
        InternalUtils.updateAssertionScope(pol, scope, true);
        return pol;
    }

    public void processPolicies(HashMap ScopedPolicies) throws WSPolicyInternalException {
        if (ScopedPolicies == null) {
            return;
        }
        Set entrySet = ScopedPolicies.entrySet();
        for (Map.Entry mapEntry : entrySet) {
            Vector policies = (Vector)mapEntry.getValue();
            for (int i = 0; i < policies.size(); ++i) {
                Policy policy = (Policy)policies.get(i);
                this.addPolicy((WSDLAttachPoint)mapEntry.getKey(), policy);
            }
        }
    }
}

