/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.PolicySerializer;
import com.ibm.ws.wspolicy.attachment.UsingPolicy;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import com.ibm.ws.wspolicy.policyset.WSDLPolicyProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

public class WSDLPolicyAnnotator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLPolicyAnnotator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Definition _sourceWSDLDefinition = null;
    private HashMap _scopedProviderPoliciesMap = null;
    private OMElement _annotatedWSDLOMElement = null;
    private Definition _annotatedWSDLDefinition = null;
    private AxisService _service = null;
    private HashMap _bindingPolicies = null;

    public WSDLPolicyAnnotator(AxisService service) {
        this._service = service;
    }

    public void addProviderPolicy(WSDLAttachPoint scopepoint, Policy policy) {
        if (policy == null) {
            return;
        }
        Vector<Policy> policies = (Vector<Policy>)this._scopedProviderPoliciesMap.get(scopepoint);
        if (policies == null) {
            policies = new Vector<Policy>();
            policies.add(policy);
            this._scopedProviderPoliciesMap.put(scopepoint, policies);
        } else {
            policies.add(policy);
        }
    }

    public void addWSDLBindingPolicy(List policies, String portName) throws WSPolicyInternalException {
        if (policies == null || portName == null) {
            return;
        }
        if (this._bindingPolicies == null) {
            this._bindingPolicies = new HashMap();
        }
        try {
            for (Policy policy : policies) {
                Vector<Policy> currentPolicies = (Vector<Policy>)this._bindingPolicies.get(portName);
                if (currentPolicies == null) {
                    currentPolicies = new Vector<Policy>();
                    this._bindingPolicies.put(portName, currentPolicies);
                }
                currentPolicies.add(policy);
            }
        }
        catch (Exception e) {
            throw new WSPolicyInternalException(e);
        }
    }

    public OMElement getAnnotatedProviderWSDL() throws WSPolicyInternalException {
        if (this._sourceWSDLDefinition == null) {
            this._sourceWSDLDefinition = this.getWSDLFromAxisService();
        }
        if (this._sourceWSDLDefinition == null) {
            throw new WSPolicyInternalException();
        }
        if (this._bindingPolicies != null) {
            this.generateBindingScopePoints();
        }
        this._annotatedWSDLDefinition = this._sourceWSDLDefinition;
        WSDLPolicyProcessor wsdlPolicyProcessor = new WSDLPolicyProcessor(this._annotatedWSDLDefinition);
        wsdlPolicyProcessor.processPolicies(this._scopedProviderPoliciesMap);
        this._annotatedWSDLDefinition = wsdlPolicyProcessor.getDefinition();
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ExtensionRegistry er = this._annotatedWSDLDefinition.getExtensionRegistry();
            this.registerWSPSerializers(er);
            writer.writeWSDL(this._annotatedWSDLDefinition, outStream);
            this._annotatedWSDLOMElement = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(outStream.toByteArray()))).getDocumentElement();
        }
        catch (XMLStreamException e) {
        }
        catch (FactoryConfigurationError e) {
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        return this._annotatedWSDLOMElement;
    }

    private void generateBindingScopePoints() throws WSPolicyInternalException {
        QName serviceQName = null;
        Parameter parameter = this._service.getParameter("WSDL_SERVICE_QNAME");
        if (parameter == null) {
            parameter = this._service.getParameter("WSDL_SERVICE_QNAME");
        }
        serviceQName = (QName)parameter.getValue();
        Service service = null;
        Map services = this._sourceWSDLDefinition.getServices();
        Iterator serviceItr = services.values().iterator();
        while (serviceItr.hasNext() && !(service = (Service)serviceItr.next()).getQName().equals(serviceQName)) {
        }
        if (service == null) {
            throw new WSPolicyInternalException();
        }
        Set portNames = this._bindingPolicies.keySet();
        for (String portName : portNames) {
            Binding binding;
            Port port = service.getPort(portName);
            if (port == null) {
                Map allports = service.getPorts();
                port = (Port)allports.values().iterator().next();
            }
            if ((binding = port.getBinding()) == null) {
                throw new WSPolicyInternalException();
            }
            WSDLAttachPoint scope = new WSDLAttachPoint();
            scope.setBindingAttachPoint(binding.getQName());
            Vector policies = (Vector)this.getScopedProviderPoliciesMap().get(scope);
            if (policies == null) {
                policies = (Vector)this._bindingPolicies.get(portName);
                this._scopedProviderPoliciesMap.put(scope, policies);
                continue;
            }
            policies.addAll((Vector)this._bindingPolicies.get(portName));
        }
    }

    public HashMap getScopedProviderPoliciesMap() {
        if (this._scopedProviderPoliciesMap == null) {
            this._scopedProviderPoliciesMap = new HashMap();
        }
        return this._scopedProviderPoliciesMap;
    }

    private Definition cloneDefinition(Definition definition) throws WSDLException {
        Definition result = null;
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLWriter writer = factory.newWSDLWriter();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        writer.writeWSDL(definition, outStream);
        String resultstring = outStream.toString();
        WSDLReader resder = factory.newWSDLReader();
        result = resder.readWSDL(resultstring);
        return result;
    }

    private Definition getWSDLFromAxisService() {
        Definition result = null;
        Parameter wsdlParam = this._service.getParameter("wsdl4jDefinition");
        if (wsdlParam != null) {
            result = (Definition)wsdlParam.getValue();
        }
        return result;
    }

    protected void setSourceDefinition(Definition definition) {
        this._sourceWSDLDefinition = definition;
    }

    protected HashMap getProviderPoliciesMap() {
        if (this._scopedProviderPoliciesMap == null) {
            this._scopedProviderPoliciesMap = new HashMap();
        }
        return this._scopedProviderPoliciesMap;
    }

    protected void setProviderPoliciesMap(HashMap policies) {
        this._scopedProviderPoliciesMap = policies;
    }

    protected AxisService getAxisservice() {
        return this._service;
    }

    protected void setAxisservice(AxisService service) {
        this._service = service;
    }

    public void registerWSPSerializers(ExtensionRegistry extReg) {
        PolicySerializer ser = new PolicySerializer();
        extReg.registerSerializer(Definition.class, PolicyConstants.WSP_USINGPOLICY_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Definition.class, PolicyConstants.WSP_USINGPOLICY_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Definition.class, PolicyConstants.WSP_USINGPOLICY_ELEMENT_QNAME, UsingPolicy.class);
        extReg.registerSerializer(Definition.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Definition.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Definition.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Definition.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Definition.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Definition.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Service.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Service.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Service.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Service.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Service.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Service.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Port.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Port.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Port.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Port.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Port.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Port.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Binding.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Binding.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Binding.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Binding.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Binding.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Binding.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(BindingOperation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingOperation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingOperation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(BindingOperation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingOperation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingOperation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(BindingInput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingInput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingInput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(BindingInput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingInput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingInput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(BindingOutput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingOutput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingOutput.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(BindingOutput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingOutput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingOutput.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(BindingFault.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingFault.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingFault.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(BindingFault.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(BindingFault.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(BindingFault.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Types.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Types.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Types.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Types.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Types.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Types.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Message.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Message.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Message.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Message.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Message.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Message.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Part.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Part.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Part.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Part.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Part.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Part.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerSerializer(Operation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Operation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Operation.class, PolicyConstants.WSP_POL_ELEMENT_QNAME, Policy.class);
        extReg.registerSerializer(Operation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.registerDeserializer(Operation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, ser);
        extReg.mapExtensionTypes(Operation.class, PolicyConstants.WSP_POLREF_ELEMENT_QNAME, PolicyReference.class);
        extReg.registerExtensionAttributeType(Input.class, PolicyConstants.QNAME_POLICYURIS, 0);
        extReg.registerExtensionAttributeType(Output.class, PolicyConstants.QNAME_POLICYURIS, 0);
        extReg.registerExtensionAttributeType(Fault.class, PolicyConstants.QNAME_POLICYURIS, 0);
        extReg.registerExtensionAttributeType(PortType.class, PolicyConstants.QNAME_POLICYURIS, 0);
    }
}

