/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import com.ibm.ws.wspolicy.operators.Operator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;

public class PolicyTypeDomainIntegrator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyTypeDomainIntegrator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private PolicyFactory _factory = new PolicyFactory();

    public Vector pullOutSubPolicies(Vector policies) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "pullOutSubPolicies");
        }
        Vector result = new Vector();
        for (int i = 0; i < policies.size(); ++i) {
            Policy policy = (Policy)policies.get(i);
            Vector justAssertions = new Vector();
            Vector childAssertions = policy.getChildAssertions();
            for (int j = 0; j < childAssertions.size(); ++j) {
                Object policyElement = childAssertions.get(j);
                if (policyElement instanceof Policy) {
                    result.add(policyElement);
                    continue;
                }
                if (policyElement instanceof Assertion) {
                    QName qname = ((Assertion)policyElement).getAssertionName();
                    if (qname != null && "SupportingTokens".equals(qname.getLocalPart())) {
                        Policy subPolicy = ((AssertionImpl)policyElement).getPolicy();
                        String id = subPolicy.getId();
                        Policy newPolicy = this._factory.newEmptyPolicy();
                        Vector newAsserions = new Vector();
                        newPolicy.setChildAssertions(newAsserions);
                        newAsserions.add(policyElement);
                        newPolicy.setId(id);
                        result.add(newPolicy);
                        continue;
                    }
                    justAssertions.add(policyElement);
                    continue;
                }
                justAssertions.add(policyElement);
            }
            if (justAssertions.size() <= 0) continue;
            Policy newPolicy = this._factory.newPolicy();
            result.add(newPolicy);
            Vector newPolicyAssertions = this.generateEmptyNormalizedPolicyElements(newPolicy);
            newPolicyAssertions.addAll(justAssertions);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "pullOutSubPolicies");
        }
        return result;
    }

    public Policy restoreIDFromAttributes(List assertions) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "restoreIDFromAttributes");
        }
        Policy result = this._factory.newPolicy();
        Vector alternativeAssertions = null;
        Operator requestSign = null;
        Operator requestEnc = null;
        Operator responseSign = null;
        Operator responseEnc = null;
        for (int i = 0; i < assertions.size(); ++i) {
            DefaultAssertion assertion = (DefaultAssertion)assertions.get(i);
            String id = assertion.getAttribute(PolicyConstants.POLICY_ID);
            if (id != null && id.length() > 0) {
                Vector<DefaultAssertion> childAssertions;
                Policy subPolicy;
                QName name = assertion.getQName();
                if (name.getLocalPart().equals("SupportingTokens")) {
                    Vector<DefaultAssertion> children;
                    subPolicy = assertion.getPolicy();
                    if (subPolicy != null) {
                        subPolicy.setId(id);
                    }
                    if ((children = result.getChildAssertions()) == null) {
                        children = new Vector<DefaultAssertion>();
                        result.setChildAssertions(children);
                    }
                    children.add(assertion);
                    continue;
                }
                assertion.removeAttribute(PolicyConstants.POLICY_ID);
                if (id.equals("request:app_signparts")) {
                    if (requestSign == null) {
                        requestSign = this._factory.newPolicy();
                        ((Policy)requestSign).setId("request:app_signparts");
                        alternativeAssertions.add(requestSign);
                    }
                    if ((childAssertions = requestSign.getChildAssertions()) == null) {
                        childAssertions = new Vector<DefaultAssertion>();
                        requestSign.setChildAssertions(childAssertions);
                    }
                    childAssertions.add(assertion);
                    continue;
                }
                if (id.equals("request:app_encparts")) {
                    if (requestEnc == null) {
                        requestEnc = this._factory.newPolicy();
                        ((Policy)requestEnc).setId("request:app_encparts");
                        alternativeAssertions.add(requestEnc);
                    }
                    if ((childAssertions = requestEnc.getChildAssertions()) == null) {
                        childAssertions = new Vector<DefaultAssertion>();
                        requestEnc.setChildAssertions(childAssertions);
                    }
                    childAssertions.add(assertion);
                    continue;
                }
                if (id.equals("response:app_signparts")) {
                    if (responseSign == null) {
                        responseSign = this._factory.newPolicy();
                        ((Policy)responseSign).setId("response:app_signparts");
                        alternativeAssertions.add(responseSign);
                    }
                    if ((childAssertions = responseSign.getChildAssertions()) == null) {
                        childAssertions = new Vector<DefaultAssertion>();
                        responseSign.setChildAssertions(childAssertions);
                    }
                    childAssertions.add(assertion);
                    continue;
                }
                if (id.equals("response:app_encparts")) {
                    if (responseEnc == null) {
                        responseEnc = this._factory.newPolicy();
                        ((Policy)responseEnc).setId("response:app_encparts");
                        alternativeAssertions.add(responseEnc);
                    }
                    if ((childAssertions = responseEnc.getChildAssertions()) == null) {
                        childAssertions = new Vector();
                        responseEnc.setChildAssertions(childAssertions);
                    }
                    childAssertions.add(assertion);
                    continue;
                }
                subPolicy = this._factory.newPolicy();
                subPolicy.setId(id);
                Vector<DefaultAssertion> childAssertions2 = new Vector<DefaultAssertion>();
                childAssertions2.add(assertion);
                subPolicy.setChildAssertions(childAssertions2);
                alternativeAssertions.add(subPolicy);
                continue;
            }
            if (alternativeAssertions == null) {
                alternativeAssertions = this.generateEmptyNormalizedPolicyElements(result);
            }
            alternativeAssertions.add(assertion);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "restoreIDFromAttributes");
        }
        return result;
    }

    public void processIDInformation(Vector policies) {
        for (int i = 0; i < policies.size(); ++i) {
            Policy policy = (Policy)policies.get(i);
            String id = policy.getId();
            this.policyIDToAttribute(policy, id);
        }
    }

    private void policyIDToAttribute(Operator operator, String id) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "policyIDToAttribute");
        }
        Vector children = operator.getChildAssertions();
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (child instanceof Policy) {
                Policy subPolicy = (Policy)child;
                String subID = subPolicy.getId();
                this.policyIDToAttribute(subPolicy, subID);
                continue;
            }
            if (child instanceof DefaultAssertion) {
                DefaultAssertion assertion = (DefaultAssertion)child;
                if (id == null || id.length() <= 0 || !id.startsWith("request:") && !id.startsWith("response:")) continue;
                assertion.addAttribute(PolicyConstants.POLICY_ID, id);
                continue;
            }
            if (!(child instanceof Operator)) continue;
            this.policyIDToAttribute((Operator)child, id);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "policyIDToAttribute");
        }
    }

    private Vector generateEmptyNormalizedPolicyElements(Policy policy) {
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AllOperator ao = new AllOperator();
        vEO.add(ao);
        Vector alternativeAssertions = new Vector();
        ao.setChildAssertions(alternativeAssertions);
        policy.setChildAssertions(topLevelAssertion);
        return alternativeAssertions;
    }
}

