/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.operators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.domain.Assertion;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operator
implements PolicyElement {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Operator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private QName _qName;
    private Vector _childAssertions = new Vector();
    private transient Policy _owningPolicy;
    private PolicyContext _context;
    private Element _element;

    protected Operator() {
    }

    public String toString() {
        String result = this.getQName().getLocalPart();
        return result;
    }

    public Vector getChildAssertions() {
        return this._childAssertions;
    }

    public Element getDomElement() {
        return this._element;
    }

    public void setChildAssertions(Vector children) {
        this.setChildAssertions(children, true);
    }

    public void setChildAssertions(Vector children, boolean resetNid) {
        this._childAssertions = children;
        Policy pol = this.getOwningPolicy();
        if (pol != null && resetNid) {
            pol.signalAmended();
        }
    }

    public Vector<PolicyElement> getLeafChildren() {
        Vector<PolicyElement> result = new Vector<PolicyElement>();
        Vector children = this.getChildAssertions();
        for (int i = 0; i < children.size(); ++i) {
            PolicyElement child = (PolicyElement)children.get(i);
            if (child instanceof Assertion) {
                result.add(child);
                continue;
            }
            if (child instanceof Operator) {
                Operator composite = (Operator)child;
                result.addAll(composite.getLeafChildren());
                continue;
            }
            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "getLeafChildren", "Unsupported child assertion ignored " + child.getClass().getName());
        }
        return result;
    }

    protected void cloneLeafAssertions(HashMap clonedAssertions) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cloneLeafAssertions", clonedAssertions);
        }
        Vector oldAssertions = this.getChildAssertions();
        Vector thisClonedAssertions = new Vector();
        for (int i = 0; i < oldAssertions.size(); ++i) {
            Object assertion = oldAssertions.get(i);
            if (assertion instanceof Operator) {
                ((Operator)assertion).cloneLeafAssertions(clonedAssertions);
            } else if (assertion instanceof Assertion) {
                assertion = clonedAssertions.get(assertion);
            }
            thisClonedAssertions.add(assertion);
        }
        this.setChildAssertions(thisClonedAssertions);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "cloneLeafAssertions");
        }
    }

    @Override
    public QName getQName() {
        return this._qName;
    }

    public Policy getOwningPolicy() {
        return this._owningPolicy;
    }

    public void setOwningPolicy(Policy policy) {
        this._owningPolicy = policy;
    }

    public PolicyContext getContext() {
        return this._context;
    }

    public void setContext(PolicyContext pContext) {
        this._context = pContext;
    }

    public void setQName(QName qName) {
        this._qName = qName;
    }

    public void setDomElement(Element domElem) {
        this._element = domElem;
    }
}

