/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.lightweight;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.Parameter;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyExternalizerImpl
implements WSPolicyExternalizer.WSPolicyExternalizerInterface {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyExternalizerImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    @Override
    public Assertion createAssertion(QName name, Map<QName, String> attrs, List<Parameter> parameters, boolean isIgnorable, WSPolicyExternalizer.Policy nestedPolicy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAssertion", new Object[]{name, attrs, parameters, isIgnorable, nestedPolicy, this});
        }
        DefaultAssertion assertion = null;
        assertion = nestedPolicy != null ? new DefaultNestingAssertion(name) : new DefaultAssertion(name);
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                assertion.addAttribute((QName)entry.getKey(), (String)entry.getValue());
            }
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                assertion.setParameter(parameter);
            }
        }
        assertion.setIgnorable(isIgnorable);
        if (nestedPolicy != null) {
            Policy p = this.createPolicy(nestedPolicy);
            assertion.setPolicy(p);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAssertion", assertion);
        }
        return assertion;
    }

    @Override
    public void writePolicy(WSPolicyExternalizer.Policy lwpolicy, OutputStream sink) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicy", new Object[]{lwpolicy, sink, this});
        }
        Policy policy = this.createPolicy(lwpolicy);
        PolicyWriter pw = new PolicyFactory().newPolicyWriter();
        pw.writePolicy(policy, sink);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicy");
        }
    }

    private Policy createPolicy(WSPolicyExternalizer.Policy lwpolicy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicy", new Object[]{lwpolicy, this});
        }
        Vector<ExactlyOneOperator> baseElements = new Vector<ExactlyOneOperator>();
        ExactlyOneOperator eoo = new ExactlyOneOperator();
        baseElements.add(eoo);
        Vector<AllOperator> altOperator = new Vector<AllOperator>();
        for (WSPolicyExternalizer.Alternative alternative : lwpolicy) {
            altOperator.add(this.createAll(alternative));
        }
        eoo.setChildAssertions(altOperator);
        Policy policy = new PolicyFactory().newPolicy(baseElements);
        policy.normalize();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicy", policy);
        }
        return policy;
    }

    private AllOperator createAll(WSPolicyExternalizer.Alternative alternative) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAll", new Object[]{alternative, this});
        }
        AllOperator ao = new AllOperator();
        Vector<DefaultAssertion> children = new Vector<DefaultAssertion>();
        for (Assertion a : alternative) {
            DefaultAssertion da = null;
            da = a instanceof WSPolicyExternalizer.NestingAssertion ? new DefaultNestingAssertion((DefaultAssertion)a) : (DefaultAssertion)a;
            children.add(da);
        }
        ao.setChildAssertions(children);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAll", ao);
        }
        return ao;
    }

    @Override
    public WSPolicyExternalizer.Policy readPolicy(InputStream is) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicy", new Object[]{is, this});
        }
        PolicyFactory pf = new PolicyFactory();
        Vector<Policy> policies = pf.newPolicyReader().readPolicies(is);
        PolicyImpl result = new PolicyImpl();
        for (Policy policy : policies) {
            WSPolicyExternalizer.Policy alternatives = this.convertFullPolicyToLightweightPolicy(policy);
            for (WSPolicyExternalizer.Alternative a : alternatives) {
                result.add(a);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicy", result);
        }
        return result;
    }

    private WSPolicyExternalizer.Policy convertFullPolicyToLightweightPolicy(Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertFullPolicyToLightweightPolicy", new Object[]{policy, this});
        }
        PolicyImpl result = new PolicyImpl();
        policy.normalize();
        for (Alternative a : policy.getAlternatives()) {
            AlternativeImpl alternative = new AlternativeImpl();
            for (Assertion as : a.getAssertions()) {
                DefaultAssertion das = (DefaultAssertion)as;
                if (das.containsNestedAssertions()) {
                    alternative.add(new DefaultNestingAssertion(das));
                    continue;
                }
                alternative.add(as);
            }
            result.add(alternative);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertFullPolicyToLightweightPolicy", result);
        }
        return result;
    }

    @Override
    public WSPolicyExternalizer.Alternative createAlternative(Assertion ... assertions) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAlternative", new Object[]{assertions, this});
        }
        AlternativeImpl alternative = new AlternativeImpl();
        for (Assertion a : assertions) {
            alternative.add(a);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public WSPolicyExternalizer.Policy createPolicy(WSPolicyExternalizer.Alternative ... alternatives) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicy", new Object[]{alternatives, this});
        }
        PolicyImpl policy = new PolicyImpl();
        for (WSPolicyExternalizer.Alternative a : alternatives) {
            policy.add(a);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicy", policy);
        }
        return policy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlternativeImpl
    extends ArrayList<Assertion>
    implements WSPolicyExternalizer.Alternative {
        private AlternativeImpl() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolicyImpl
    extends ArrayList<WSPolicyExternalizer.Alternative>
    implements WSPolicyExternalizer.Policy {
        private PolicyImpl() {
        }
    }

    private class DefaultNestingAssertion
    extends DefaultAssertion
    implements WSPolicyExternalizer.NestingAssertion {
        public DefaultNestingAssertion(QName qName) {
            super(qName);
        }

        public DefaultNestingAssertion(DefaultAssertion da) {
            super(da.getAssertionName());
            this.setIgnorable(da.isIgnorable());
            Iterator attrNames = da.getAttributeNames();
            while (attrNames.hasNext()) {
                QName name = (QName)attrNames.next();
                this.setAttribute(name, da.getAttributeValue(name));
            }
            Iterator paramNames = da.getAllParameterNames();
            while (paramNames.hasNext()) {
                QName name = (QName)paramNames.next();
                Iterator params = da.getParameters(name);
                while (params.hasNext()) {
                    this.setParameter((Parameter)params.next());
                }
            }
            this.setPolicy(da.getPolicy());
        }

        public WSPolicyExternalizer.Policy getNestedPolicy() throws PolicyReferenceException, WSPolicyInternalException {
            return WSPolicyExternalizerImpl.this.convertFullPolicyToLightweightPolicy(this.getPolicy());
        }
    }
}

