/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.domain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.DefaultAssertionMerger;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyProviderRegistry {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyProviderRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static PolicyProviderRegistry _instance = null;
    private final Map<QName, WSPolicyAssertionProcessor> _assertionProcessorQNames = new ConcurrentHashMap<QName, WSPolicyAssertionProcessor>();
    private final List<QName> _behaviorMergeQNames = new CopyOnWriteArrayList<QName>();
    private final List<QName> _behaviorSupportQNames = new CopyOnWriteArrayList<QName>();
    private final List<QName> _providerVocabRequiredQNames = new CopyOnWriteArrayList<QName>();
    private final Map<Assertion, Boolean> _vocabAssertions = new ConcurrentHashMap<Assertion, Boolean>();
    private final Map<Assertion, Boolean> _supportAssertions = new ConcurrentHashMap<Assertion, Boolean>();
    private final List<QName> _clientCapabilityIsConditional = new CopyOnWriteArrayList<QName>();
    private final Map<String, WSPolicyAssertionProcessor> _assertionProcessorsByType = new ConcurrentHashMap<String, WSPolicyAssertionProcessor>();
    private final DefaultAssertionMerger _defaultAssertionMerger = new DefaultAssertionMerger();
    private final Map<String, String> _namespace2PolicyType = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PolicyProviderRegistry getInstance() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getInstance");
        }
        Class<PolicyProviderRegistry> clazz = PolicyProviderRegistry.class;
        synchronized (PolicyProviderRegistry.class) {
            if (_instance == null) {
                _instance = new PolicyProviderRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getInstance");
            }
            return _instance;
        }
    }

    private void processDomainInformation(WSPolicyAssertionProcessor assertionProcessor) throws WSPolicyInternalException {
        List<QName> clientCapabilityIsConditional;
        List<QName> vocabRequired;
        List<QName> merges;
        List<QName> supports;
        List<QName> qNames;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processDomainInformation", new Object[]{assertionProcessor});
        }
        if ((qNames = assertionProcessor.getSupportedWSPolicyAssertions()) != null) {
            this.anyDuplicateSupportedQNames(qNames);
            Iterator<QName> iter = qNames.iterator();
            QName qName = null;
            while (iter.hasNext()) {
                qName = iter.next();
                this._assertionProcessorQNames.put(qName, assertionProcessor);
                String nameSpace = qName.getNamespaceURI();
                if (this._namespace2PolicyType.get(nameSpace) != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "adding new namespace to domain mapping, ", new Object[]{nameSpace, assertionProcessor.getType()});
                }
                this._namespace2PolicyType.put(nameSpace, assertionProcessor.getType());
            }
            this._assertionProcessorsByType.put(assertionProcessor.getType(), assertionProcessor);
        }
        if ((supports = assertionProcessor.getWSPolicyAssertionsWithSupportBehaviour()) != null) {
            this._behaviorSupportQNames.addAll(supports);
        }
        if ((merges = assertionProcessor.getWSPolicyAssertionsWithCombineBehaviour()) != null) {
            this._behaviorMergeQNames.addAll(merges);
        }
        if ((vocabRequired = assertionProcessor.getProviderVocabularyRequired()) != null) {
            this._providerVocabRequiredQNames.addAll(vocabRequired);
        }
        if ((clientCapabilityIsConditional = assertionProcessor.getAssertionsWithConditionalClientCapability()) != null) {
            this._clientCapabilityIsConditional.addAll(clientCapabilityIsConditional);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processDomainInformation");
        }
    }

    private PolicyProviderRegistry() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicyProviderRegistry CTOR");
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyassertionprocessor");
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Found " + elements.length + " extensions for " + "com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyassertionprocessor");
        }
        boolean found = elements.length > 0;
        ArrayList<WSPolicyAssertionProcessor> extensions = new ArrayList<WSPolicyAssertionProcessor>();
        if (found) {
            this.addExtensions(extensions, elements);
        } else {
            elements = registry.getConfigurationElementsFor("com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyassertionprocessor");
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Found " + elements.length + " extensions for " + "com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyassertionprocessor");
            }
            this.addExtensions(extensions, elements);
        }
        try {
            for (WSPolicyAssertionProcessor assertionProcessor : extensions) {
                this.processDomainInformation(assertionProcessor);
            }
        }
        catch (WSPolicyInternalException pe) {
            // empty catch block
        }
        Iterator daIter = Service.providers(WSPolicyAssertionProcessor.class);
        while (daIter != null && daIter.hasNext()) {
            try {
                WSPolicyAssertionProcessor assertionProcessor;
                assertionProcessor = (WSPolicyAssertionProcessor)daIter.next();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "PolicyProviderRegistry", "UnitTestAssertionProcessor found " + assertionProcessor.getClass().getName());
                }
                this.processDomainInformation(assertionProcessor);
            }
            catch (ServiceConfigurationError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyProviderRegistry.PolicyProviderRegistry", "160", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "PolicyProviderRegistry", "PolicyDomain class could not be found " + e.toString());
            }
            catch (NoClassDefFoundError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyProviderRegistry.PolicyProviderRegistry", "166", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "PolicyProviderRegistry", "PolicyDomain class could not be found " + e.toString());
            }
            catch (WSPolicyException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyProviderRegistry.PolicyProviderRegistry", "224", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "PolicyProviderRegistry", "Duplicate Domain information found " + e.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicyProviderRegistry CTOR");
        }
    }

    private boolean anyDuplicateSupportedQNames(List<QName> qNames) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "anyDuplicateSupportedQNames", new Object[]{qNames});
        }
        boolean result = false;
        Iterator<QName> iter = qNames.iterator();
        QName qName = null;
        while (iter.hasNext()) {
            qName = iter.next();
            if (!this._assertionProcessorQNames.containsKey(qName)) continue;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Duplicate QName found in supported list " + qName.toString());
            }
            throw new WSPolicyInternalException();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "anyDuplicateSupportedQNames", new Object[]{result});
        }
        return result;
    }

    public WSPolicyAssertionProcessor findSupportingWSPolicyProcessor(QName assertionQN) {
        WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(assertionQN);
        return processor;
    }

    public String getPreferredPrefix(QName assertionQN) {
        if (assertionQN != null) {
            if ("http://www.w3.org/ns/ws-policy".equals(assertionQN.getNamespaceURI())) {
                return "wsp";
            }
            WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(assertionQN);
            return processor == null ? null : processor.getPreferredPrefix(assertionQN);
        }
        return null;
    }

    public boolean hasMergeBehavior(QName qName) {
        return this._behaviorMergeQNames.contains(qName);
    }

    public boolean hasSupportBehavior(QName qName) {
        return this._behaviorSupportQNames.contains(qName);
    }

    public DefaultAssertionMerger getDefaultAssertionMerger() {
        return this._defaultAssertionMerger;
    }

    public WSPolicyAssertionProcessor getWSPolicyProcessor(Assertion assertion) {
        QName qn = assertion.getAssertionName();
        WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(qn);
        return processor;
    }

    public void setWSPolicyProcessor(QName qn, WSPolicyAssertionProcessor processor) {
        this._assertionProcessorQNames.put(qn, processor);
    }

    public boolean isSupported(AssertionImpl assertion, Map bindings) throws WSPolicyBindingsException {
        return this.isSupported(assertion, PolicyConstants.FILTER_SUPPORTED, bindings);
    }

    public boolean isSupported(AssertionImpl assertion, String supportType, Map bindings) throws WSPolicyBindingsException {
        boolean result = false;
        if (assertion.containsNestedAssertions()) {
            Policy nestedPolicy = assertion.getPolicy();
            Vector nestedassertions = nestedPolicy.getAllAssertions();
            for (int i = 0; i < nestedassertions.size(); ++i) {
                result = this.isSupported((AssertionImpl)nestedassertions.get(i), supportType, bindings);
                if (result) continue;
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Assertion not supported " + ((AssertionImpl)nestedassertions.get(i)).getQName());
                }
                return result;
            }
        }
        result = this.verifySupport(assertion, supportType, bindings);
        return result;
    }

    private void setAssertionSupport(Assertion assertion, String supportType, boolean result) {
        if (supportType.equals(PolicyConstants.FILTER_SUPPORTED)) {
            this._supportAssertions.put(assertion, result);
        } else if (supportType.equals(PolicyConstants.FILTER_VOCABULARY)) {
            this._vocabAssertions.put(assertion, result);
        }
    }

    private Boolean getAssertionSupport(Assertion assertion, String supportType) {
        Boolean result = null;
        if (supportType.equals(PolicyConstants.FILTER_SUPPORTED)) {
            result = this._supportAssertions.get(assertion);
        } else if (supportType.equals(PolicyConstants.FILTER_VOCABULARY)) {
            result = this._vocabAssertions.get(assertion);
        }
        return result;
    }

    private boolean verifySupport(Assertion assertion, String sLevel, Map bindings) throws WSPolicyBindingsException {
        boolean result = false;
        if (sLevel.equals(PolicyConstants.FILTER_LOGICAL)) {
            result = true;
        } else if (sLevel.equals(PolicyConstants.FILTER_VOCABULARY)) {
            Boolean value = this.getAssertionSupport(assertion, sLevel);
            if (value != null) {
                result = value;
            } else {
                WSPolicyAssertionProcessor processor = this.getWSPolicyProcessor(assertion);
                if (processor != null) {
                    List<QName> wholeVocabulary = processor.getSupportedWSPolicyAssertions();
                    result = wholeVocabulary.contains(assertion.getAssertionName());
                } else {
                    if (!assertion.isIgnorable()) {
                        result = false;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, ">>> VOCABULARY for ASSERTION[" + assertion.getAssertionName() + "] = " + result + ": No declared PolicyDomain");
                        }
                    } else {
                        result = true;
                    }
                    this.setAssertionSupport(assertion, PolicyConstants.FILTER_VOCABULARY, result);
                }
            }
        } else if (sLevel.equals(PolicyConstants.FILTER_SUPPORTED)) {
            Boolean value = this.getAssertionSupport(assertion, sLevel);
            if (value != null) {
                result = value;
            } else {
                WSPolicyAssertionProcessor processor = this.getWSPolicyProcessor(assertion);
                if (processor != null) {
                    if (this.hasSupportBehavior(assertion.getAssertionName())) {
                        if (TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.debug(TRACE_COMPONENT, ">>> Registered SUPPORT behavior, calling WSPolicyProcessor");
                        }
                        result = processor.supports(assertion, bindings);
                    } else {
                        List<QName> wholeVocabulary = processor.getSupportedWSPolicyAssertions();
                        result = wholeVocabulary.contains(assertion.getAssertionName());
                    }
                } else {
                    if (!assertion.isIgnorable()) {
                        result = false;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, ">>> SUPPORT for ASSERTION[" + assertion.getAssertionName() + "] = " + result + ": No declared PolicyDomain");
                        }
                    } else {
                        result = true;
                    }
                    this.setAssertionSupport(assertion, PolicyConstants.FILTER_SUPPORTED, result);
                }
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "verifySupport", "Unknown filter support" + sLevel);
        }
        return result;
    }

    public List<Assertion> getAssertionsForPolicyTypeFromAlternative(String policyType, Alternative alternative) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAssertionsForPolicyTypeFromAlternative", new Object[]{policyType, alternative});
        }
        ArrayList<Assertion> result = new ArrayList<Assertion>();
        Vector<Assertion> assertions = alternative.getAssertions();
        for (int i = 0; i < assertions.size(); ++i) {
            String namespace;
            Assertion assertion = assertions.get(i);
            QName qName = assertion.getAssertionName();
            if (qName == null || (namespace = qName.getNamespaceURI()) == null) continue;
            String pType = this._namespace2PolicyType.get(namespace);
            if (pType != null && !"".equals(pType) && pType.equals(policyType)) {
                result.add(assertion);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "Found Assertion: " + qName.getLocalPart());
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "Skip Assertion : " + qName.getLocalPart());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAssertionsForPolicyTypeFromAlternative", result);
        }
        return result;
    }

    public WSPolicyAssertionProcessor getAssertionProcessorByType(String type) {
        return this._assertionProcessorsByType.get(type);
    }

    public Set<String> getAllDomainTypes() {
        return this._assertionProcessorsByType.keySet();
    }

    public String getPolicyType(String namespace) {
        String result = this._namespace2PolicyType.get(namespace);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getPolicyType", result);
        }
        return result;
    }

    public boolean isProviderVocabularyRequired(QName qn) {
        boolean result = this._providerVocabRequiredQNames.contains(qn);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isProviderVocabularyRequired", result);
        }
        return result;
    }

    public boolean isClientCapability(QName qn, Policy policy) {
        boolean result = true;
        if (this._clientCapabilityIsConditional.contains(qn)) {
            Vector<QName> vocab = policy.getVocabulary();
            String nsURI = qn.getNamespaceURI();
            for (QName qn2 : vocab) {
                if (!nsURI.equals(qn2.getNamespaceURI())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void addExtensions(List<WSPolicyAssertionProcessor> extensions, IConfigurationElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            try {
                String classname = elements[i].getValue();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Found " + classname);
                }
                Class<?> loaderClass = Class.forName(classname);
                Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                WSPolicyAssertionProcessor wspap = (WSPolicyAssertionProcessor)constructor.newInstance(new Object[0]);
                extensions.add(wspap);
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wspolicy.domain.PolicyProviderRegistry", "827", this);
            }
        }
    }
}

