/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.domain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.WSPolicyFactory;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.Parameter;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAssertionMerger
implements WSPolicyAssertionProcessor {
    private static final TraceComponent tc = Tr.register(DefaultAssertionMerger.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static WSPolicyFactory _wspFactory = WSPolicyFactory.instance();

    @Override
    public Assertion combine(Assertion assertion1, Assertion assertion2) {
        QName qn;
        QName qn2;
        Assertion assertion = _wspFactory.createAssertion(assertion1.getAssertionName());
        Iterator it1 = assertion1.getAllParameterNames();
        Vector<QName> v1 = new Vector<QName>();
        Iterator it2 = assertion2.getAllParameterNames();
        while (it1.hasNext()) {
            qn2 = (QName)it1.next();
            v1.add(qn2);
            Iterator itp1 = assertion1.getParameters(qn2);
            Iterator itp2 = assertion2.getParameters(qn2);
            Parameter p = (Parameter)itp1.next();
            Parameter merged = _wspFactory.createParameter(qn2, p.getParameterValue());
            merged = this.mergeParameters(merged, itp1);
            if (merged == null) {
                return null;
            }
            if ((merged = this.mergeParameters(merged, itp2)) == null) {
                return null;
            }
            assertion.setParameter(merged);
        }
        while (it2.hasNext()) {
            qn2 = (QName)it2.next();
            if (v1.contains(qn2)) continue;
            Iterator itp2 = assertion2.getParameters(qn2);
            Parameter p = (Parameter)itp2.next();
            Parameter merged = _wspFactory.createParameter(qn2, p.getParameterValue());
            if ((merged = this.mergeParameters(merged, itp2)) != null) continue;
            return null;
        }
        Iterator ita1 = assertion1.getAttributeNames();
        Iterator ita2 = assertion2.getAttributeNames();
        while (ita1.hasNext()) {
            qn = (QName)ita1.next();
            assertion.setAttribute(qn, assertion1.getAttributeValue(qn));
        }
        while (ita2.hasNext()) {
            qn = (QName)ita2.next();
            String attrStr1 = assertion1.getAttributeValue(qn);
            String attrStr2 = assertion2.getAttributeValue(qn);
            if (attrStr1 != null) {
                if (attrStr1.equals(attrStr2)) continue;
                return null;
            }
            assertion.setAttribute(qn, attrStr2);
        }
        return assertion;
    }

    @Override
    public List<QName> getSupportedWSPolicyAssertions() {
        return new ArrayList<QName>();
    }

    @Override
    public List<QName> getWSPolicyAssertionsWithCombineBehaviour() {
        return new ArrayList<QName>();
    }

    private Parameter mergeParameters(Parameter merged, Iterator itp) {
        String mergedValue = merged.getParameterValue();
        QName qn = merged.getParameterName();
        while (itp.hasNext()) {
            boolean nullMergedValue;
            Parameter p = (Parameter)itp.next();
            String value = p.getParameterValue();
            boolean nullValue = value == null || value.equals("");
            boolean bl = nullMergedValue = mergedValue == null || mergedValue.equals("");
            if (nullValue && nullMergedValue) continue;
            if (!nullValue && !nullMergedValue) {
                if (mergedValue.equals(value)) continue;
                return null;
            }
            if (!nullMergedValue) continue;
            merged = _wspFactory.createParameter(qn, value);
            mergedValue = merged.getParameterValue();
        }
        return merged;
    }

    @Override
    public List<QName> getWSPolicyAssertionsWithSupportBehaviour() {
        return new ArrayList<QName>();
    }

    @Override
    public boolean supports(Assertion assertion, Map bindings) {
        return true;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, Map<String, Object> transformOptions) throws WSPolicyInternalException {
        return null;
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions) throws WSPolicyInternalException {
        return null;
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(InputStream policy, Map<String, Object> transformOptions) throws WSPolicyInternalException {
        return null;
    }

    @Override
    public List<Integer> getAssertionAttachPoints(QName assertionQName) {
        return null;
    }

    @Override
    public WSPolicyPreferenceResolver getWSPolicyPreferenceResolver() {
        return null;
    }

    @Override
    public List<QName> getProviderVocabularyRequired() {
        return null;
    }

    @Override
    public List<QName> getAssertionsWithConditionalClientCapability() {
        return null;
    }

    @Override
    public String getPreferredPrefix(QName assertionQName) {
        return null;
    }
}

