/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.digest;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.digest.DefaultPolicyDigest;
import com.ibm.ws.wspolicy.digest.PolicyDigest;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

public class PolicyDigestRegistry {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyDigestRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Map<URI, PolicyDigest> digests = new Hashtable<URI, PolicyDigest>();

    protected PolicyDigestRegistry() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicyDigestRegistry");
        }
        DefaultPolicyDigest dpd = new DefaultPolicyDigest();
        Vector elements = dpd.getSupportedURIs();
        for (int i = 0; i < elements.size(); ++i) {
            URI key = (URI)elements.get(i);
            this.digests.put(key, dpd);
            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "PolicyDigestRegistry", "Adding " + dpd.getClass().getName() + " for " + key.toString());
        }
        Iterator dIter = Service.providers(PolicyDigest.class);
        while (dIter != null && dIter.hasNext()) {
            try {
                PolicyDigest ds = (PolicyDigest)dIter.next();
                elements = ds.getSupportedURIs();
                for (int i = 0; i < elements.size(); ++i) {
                    URI key = (URI)elements.get(i);
                    this.digests.put(key, ds);
                    if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "PolicyDigestRegistry", "Adding " + key.getClass().getName() + " for " + key.toString());
                }
            }
            catch (ServiceConfigurationError e) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "PolicyDigestRegistry", "PolicyDigest calss could not be found");
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyDigestRegistry.PolicyDigestRegistry", "102", this);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicyDigestRegistry");
        }
    }

    public void registerDigestAlgorithm(URI uri, PolicyDigest policyDigest) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "registerDigestAlgorithm", new Object[]{uri, policyDigest});
        }
        this.digests.put(uri, policyDigest);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "registerDigestAlgorithm");
        }
    }

    public PolicyDigest getPolicyDigest(URI algorithm) throws WSPolicyInternalException {
        PolicyDigest pd;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyDigest", "algorithm[" + algorithm + "]");
        }
        if ((pd = this.digests.get(algorithm)) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Policy Digest Algorithm is null");
            }
            throw new WSPolicyInternalException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyDigest", pd);
        }
        return pd;
    }
}

