/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.digest;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import org.xml.sax.InputSource;

class DigestUtil
implements PolicyConstants {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(DigestUtil.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    static String policyFileLocation = "http://localhost/policy/PolicyReferenceCreation.xml";
    static String policyId = "MixedNested";

    public static void main(String[] args) {
        try {
            PolicyReader reader = new PolicyFactory().newPolicyReader();
            URL url = new URL(policyFileLocation);
            Vector pols = reader.readPolicies(url.openStream());
            Policy policyRead = null;
            for (int i = 0; i < pols.size(); ++i) {
                Policy polTemp = pols.elementAt(i);
                if (!polTemp.getId().equals(policyId)) continue;
                policyRead = polTemp;
            }
            URI alg = new URI(PolicyConstants.DEFAULT_DIGEST_ALGORITHM);
            String digest = reader.calculateDigest(policyRead, alg);
            System.out.println(digest);
            InputStream inStream = url.openStream();
            InputSource iSrc = new InputSource(inStream);
            pols = reader.readPolicies(iSrc);
            for (int i = 0; i < pols.size(); ++i) {
                Policy polTemp = (Policy)pols.elementAt(i);
                if (!polTemp.getId().equals(policyId)) continue;
                policyRead = polTemp;
            }
            digest = reader.calculateDigest(policyRead, alg);
            System.out.println(digest);
            String byName = "http://localhost/policy/PolicyReferenceReader_ResolveOnRead.xml#Referenced";
            URI byNameURI = new URI(byName);
            policyRead = reader.readPolicy(byNameURI);
            digest = reader.calculateDigest(policyRead, alg);
            System.out.println(digest);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.wspolicy.DigestUtil.main", "92");
        }
    }

    private static URI buildURI(String policyFileName) {
        URI uri;
        block4: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "buildURI", policyFileName);
            }
            uri = null;
            try {
                String sep = System.getProperty("file.separator");
                String fullFile = "." + sep + "META-INF" + sep + policyFileName;
                File file = new File(fullFile);
                uri = file.toURI();
            }
            catch (Exception ex) {
                if (!TRACE_COMPONENT.isEntryEnabled()) break block4;
                Tr.debug(TRACE_COMPONENT, "Broken:" + ex.toString());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildURI", uri);
        }
        return uri;
    }
}

