/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.digest;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.misc.BASE64Encoder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.digest.PolicyDigest;
import com.ibm.ws.wssecurity.xss4j.domutil.Digest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import org.w3c.dom.Node;

public class DefaultPolicyDigest
implements PolicyDigest {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(DefaultPolicyDigest.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static BASE64Encoder _encoder;
    private Vector<URI> _supportedUris = new Vector(1);

    protected DefaultPolicyDigest() {
        try {
            URI uri = new URI(PolicyConstants.DEFAULT_DIGEST_ALGORITHM);
            this._supportedUris.add(uri);
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.DefaultPolicyDigest.DefaultPolicyDigest", "74", this);
        }
    }

    public String getDigest(URI uri, Node node) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getDigest", new Object[]{uri, node});
        }
        if (!this._supportedUris.contains(uri)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Digest algorithm not recognised.", new Object[]{uri});
            }
            throw new WSPolicyInternalException();
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            if (_encoder == null) {
                _encoder = new BASE64Encoder();
            }
        }
        catch (NoSuchAlgorithmException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.DefaultPolicyDigest.getDigest", "101", this);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Algorithm for digest does not exist");
            }
            throw new WSPolicyInternalException();
        }
        byte[] calcDigest = Digest.getDigest((MessageDigest)md, (Node)node);
        String encode = _encoder.encodeBuffer(calcDigest).trim();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getDigest", "digest[" + encode + "]");
        }
        return encode;
    }

    public Vector getSupportedURIs() {
        return this._supportedUris;
    }
}

