/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeDeserializer;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeSerializer;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLScopeSerializer
implements PolicyAttachmentScopeSerializer,
PolicyAttachmentScopeDeserializer {
    private static final TraceComponent tc = Tr.register(WSDLScopeSerializer.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public PolicyAttachmentScopeElement unmarshall(Element element, QName elementType) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unmarshall", new Object[]{element, elementType, this});
        }
        WSDLAttachPoint wap = new WSDLAttachPoint();
        NamedNodeMap nnm = element.getAttributes();
        for (int k = 0; k < nnm.getLength(); ++k) {
            Node nn = nnm.item(k);
            wap.addNameSpace(nn.getLocalName(), nn.getNodeValue());
        }
        NodeList appliesNodeList = element.getChildNodes();
        for (int k = 0; k < appliesNodeList.getLength(); ++k) {
            boolean matchingBraces;
            Node wapNode = appliesNodeList.item(k);
            if (!wapNode.hasChildNodes()) continue;
            Node n = wapNode.getFirstChild();
            String prefix = n.getPrefix();
            String value = n.getNodeValue();
            int colon = value.indexOf(":");
            int openCurlyBrace = value.indexOf("{");
            int closeCurlyBrace = value.indexOf("}");
            boolean bl = matchingBraces = openCurlyBrace != -1 && closeCurlyBrace != -1;
            if (prefix != null) {
                String namespace = wap.getNameSpaceValue(prefix);
                QName q = new QName(namespace, n.getNodeName());
                wap.addValue(wapNode.getLocalName(), q);
                continue;
            }
            if (colon != -1 && !matchingBraces) {
                String prefix1 = value.substring(0, colon);
                String namespace = wap.getNameSpaceValue(prefix1);
                QName q = new QName(namespace, value.substring(colon + 1));
                wap.addValue(wapNode.getLocalName(), q);
                continue;
            }
            if (colon != -1 && matchingBraces) {
                QName q = new QName(value.substring(openCurlyBrace + 1, closeCurlyBrace), value.substring(closeCurlyBrace + 1));
                wap.addValue(wapNode.getLocalName(), q);
                continue;
            }
            wap.addValue(wapNode.getLocalName(), value);
        }
        if (wap.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unmarshall", null);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unmarshall", wap);
        }
        return wap;
    }

    public void marshall(PolicyAttachmentScopeElement scopeElement, QName elementType, Writer writer) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshall", new Object[]{scopeElement, elementType, writer, this});
        }
        try {
            writer.write("<" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_WSDLATTACHPOINT + "\n");
            Vector<String> nameSpaceKeys = ((WSDLAttachPoint)scopeElement).getNameSpaces();
            for (String key : nameSpaceKeys) {
                writer.write(PolicyConstants.TAG_XMLNS + ":" + key + "=\"" + ((WSDLAttachPoint)scopeElement).getNameSpaceValue(key) + "\"\n");
            }
            writer.write(">\n");
            Vector<String> attachPointKeys = ((WSDLAttachPoint)scopeElement).getValueNames();
            for (String key : attachPointKeys) {
                writer.write("<" + PolicyConstants.TAG_WSP + ":" + key + ">" + ((WSDLAttachPoint)scopeElement).getValue(key) + "</" + PolicyConstants.TAG_WSP + ":" + key + ">\n");
            }
            writer.write("</" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_WSDLATTACHPOINT + ">\n");
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.WSDLScopeSerializer.marshall", "147", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshall");
        }
    }

    public Vector getSupportedElementType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedElementType", this);
        }
        Vector<QName> result = new Vector<QName>();
        QName wsdlAttachPoint = new QName("http://www.w3.org/ns/ws-policy", "WSDLAttachPoint");
        result.add(wsdlAttachPoint);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedElementType", result);
        }
        return result;
    }
}

