/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyIncompatiblePolicyAttachments;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ElementExtensible;

public class WSDLNodeWrapper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLNodeWrapper.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    static Policy _emptyPolicy = new PolicyFactory().newPolicy();
    static PolicyFactory _pFact = new PolicyFactory();
    ElementExtensible _node = null;
    List<Policy> _policyList = new ArrayList<Policy>();
    Policy _policyAtNode = null;
    List<String> _policySetWrapperNames = new ArrayList<String>();

    public WSDLNodeWrapper(ElementExtensible node) {
        this._node = node;
    }

    public void addPolicy(Policy policy, String policySetWrapperName) {
        if (!this._policySetWrapperNames.contains(policySetWrapperName)) {
            this._policyList.add(policy);
            this._policyAtNode = policy;
            this._policySetWrapperNames.add(policySetWrapperName);
        }
    }

    public void resolvePolicy() throws WSPolicyIncompatiblePolicyAttachments, WSPolicyInternalException {
        if (this._policyList.size() > 1) {
            Policy policyA = this._policyList.remove(0);
            Policy policyB = this._policyList.remove(0);
            Policy policyC = null;
            if (policyA != null || policyB != null) {
                if (policyA == null) {
                    policyA = _emptyPolicy;
                }
                if (policyB == null) {
                    policyB = _emptyPolicy;
                }
                try {
                    policyC = policyA.intersectForPublish(policyB);
                    if (policyC == null) {
                        WSPolicyIncompatiblePolicyAttachments wspipa = new WSPolicyIncompatiblePolicyAttachments(new Object[]{policyA, policyB});
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "resolvePolicy", wspipa);
                        }
                        FFDCFilter.processException((Throwable)wspipa, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "70", this);
                        throw wspipa;
                    }
                }
                catch (WSPolicyInternalException wspie) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "resolvePolicy", wspie);
                    }
                    FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "74", this);
                    throw wspie;
                }
                catch (PolicyReferenceException pre) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "resolvePolicy", pre);
                    }
                    FFDCFilter.processException((Throwable)pre, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "79", this);
                    throw new WSPolicyInternalException(pre);
                }
            }
            this._policyList.add(0, policyC);
            this.resolvePolicy();
        }
        if (this._policyList.size() > 0) {
            this._policyAtNode = this._policyList.get(0);
        }
    }

    public ElementExtensible getWSDLNode() {
        return this._node;
    }

    public void decorateWSDL(Definition def, String uri) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "decorateWSDL");
        }
        if (this._policyAtNode != null && this._node != null) {
            String uriStr = UUID.randomUUID().toString();
            URI idURI = null;
            try {
                idURI = new URI("#" + uriStr);
            }
            catch (URISyntaxException e) {
                WSPolicyInternalException wspie = new WSPolicyInternalException(e);
                FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "70", this);
                throw wspie;
            }
            this._policyAtNode.setId(uriStr);
            def.addExtensibilityElement(this._policyAtNode);
            PolicyReference policyRef = _pFact.newPolicyReference(idURI);
            this._node.addExtensibilityElement(policyRef);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "decorateWSDL");
        }
    }
}

