/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLAttachPoint
implements PolicyAttachmentScopeElement {
    private static final TraceComponent tc = Tr.register(WSDLAttachPoint.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private HashMap<String, Serializable> attachPoints = new HashMap();
    private HashMap<String, String> nameSpaces = new HashMap();
    String _scopeLevel = "";
    String _attachPoint = "";
    private static final String[] ATTACHPOINT_LABELS = new String[]{PolicyConstants.ATTACH_SERVICE, PolicyConstants.ATTACH_PORT, PolicyConstants.ATTACH_PORTTYPE, PolicyConstants.ATTACH_BINDING, PolicyConstants.ATTACH_OPERATION, PolicyConstants.ATTACH_INPUT, PolicyConstants.ATTACH_OUTPUT, PolicyConstants.ATTACH_FAULT, PolicyConstants.ATTACH_BINDING_OPERATION, PolicyConstants.ATTACH_BINDING_INPUT, PolicyConstants.ATTACH_BINDING_OUTPUT, PolicyConstants.ATTACH_BINDING_FAULT, PolicyConstants.ATTACH_MESSAGE};
    private int cachedHashCode = 0;
    private QName elementType = new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.TAG_WSDLATTACHPOINT);

    public void addValue(String key, String value) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addValue", new Object[]{key, value, this});
        }
        this.cachedHashCode = 0;
        try {
            key = this.checkKeyValue(key);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.WSDLAttachPoint.addValue", "146", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Key is " + key);
            }
            throw new WSPolicyInternalException();
        }
        if (this.attachPoints.containsKey(key)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Key is already contained in attachPoints " + key);
            }
            throw new WSPolicyInternalException();
        }
        this.attachPoints.put(key, (Serializable)((Object)value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addValue");
        }
    }

    public void addValue(String key, QName qname) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addValue", new Object[]{key, qname, this});
        }
        this.cachedHashCode = 0;
        try {
            key = this.checkKeyValue(key);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.WSDLAttachPoint.addValue", "174", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Key is " + key);
            }
            throw new WSPolicyInternalException();
        }
        if (this.attachPoints.containsKey(key)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Key is already contained in attachPoints " + key);
            }
            throw new WSPolicyInternalException();
        }
        this.attachPoints.put(key, qname);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addValue");
        }
    }

    public Vector<String> getValueNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueNames", this);
        }
        Vector<String> result = new Vector<String>(this.attachPoints.keySet());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueNames", result);
        }
        return result;
    }

    public Vector<String> getNameSpaces() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameSpaces", this);
        }
        Vector<String> keys = new Vector<String>(this.nameSpaces.keySet());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameSpaces", keys);
        }
        return keys;
    }

    public String getNameSpaceValue(String key) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameSpaceValue", new Object[]{key, this});
        }
        String value = null;
        if (!this.nameSpaces.containsKey(key = key.toLowerCase())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WSDLAttachPoint does not contain a value for the key " + key);
            }
            throw new WSPolicyInternalException();
        }
        value = this.nameSpaces.get(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameSpaceValue", value);
        }
        return value;
    }

    public Object getValue(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getValue", new Object[]{key, this});
        }
        Serializable value = null;
        if (!this.attachPoints.containsKey(key)) {
            return null;
        }
        value = this.attachPoints.get(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getValue", value);
        }
        return value;
    }

    public void clearAllValues() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllValues", this);
        }
        this.cachedHashCode = 0;
        this.attachPoints.clear();
        this._scopeLevel = "";
        this._attachPoint = "";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllValues");
        }
    }

    public boolean isEmpty() {
        return this.attachPoints.isEmpty();
    }

    private String checkKeyValue(String key) throws WSPolicyInternalException {
        String retVal = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyValue", new Object[]{key, this});
        }
        if (key.equalsIgnoreCase(PolicyConstants.ATTACH_SERVICE)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key is already contained in attachPoints " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_SERVICE;
            this._scopeLevel = PolicyConstants.SCOPE_SERVICE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_PORT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_PORT;
            this._scopeLevel = PolicyConstants.SCOPE_ENDPOINT;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_PORTTYPE)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_PORTTYPE;
            this._scopeLevel = PolicyConstants.SCOPE_ENDPOINT;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_BINDING)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_BINDING;
            this._scopeLevel = PolicyConstants.SCOPE_ENDPOINT;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_OPERATION)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_OPERATION;
            this._scopeLevel = PolicyConstants.SCOPE_OPERATION;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_INPUT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_INPUT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_OUTPUT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_OUTPUT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_FAULT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_FAULT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_BINDING_OPERATION)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_BINDING_OPERATION;
            this._scopeLevel = PolicyConstants.SCOPE_OPERATION;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_BINDING_INPUT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_BINDING_INPUT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_BINDING_OUTPUT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_BINDING_OUTPUT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_BINDING_FAULT)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_BINDING_FAULT;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else if (key.equalsIgnoreCase(PolicyConstants.ATTACH_MESSAGE)) {
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING) || this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT) || this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
                }
                throw new WSPolicyInternalException();
            }
            retVal = PolicyConstants.ATTACH_MESSAGE;
            this._scopeLevel = PolicyConstants.SCOPE_MESSAGE;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "An invalid combination of attach points or an attach point name has been attempted. " + key);
            }
            throw new WSPolicyInternalException();
        }
        this._attachPoint = retVal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyValue", retVal);
        }
        return retVal;
    }

    public boolean equals(Object attachPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{attachPoint, this});
        }
        if (attachPoint instanceof WSDLAttachPoint) {
            if (this.hashCode() == ((WSDLAttachPoint)attachPoint).hashCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "equals", Boolean.TRUE);
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", Boolean.FALSE);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", Boolean.FALSE);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        StringBuffer hashBase = new StringBuffer();
        for (int i = 0; i < ATTACHPOINT_LABELS.length; ++i) {
            Serializable val = this.attachPoints.get(ATTACHPOINT_LABELS[i]);
            if (val == null) continue;
            hashBase.append(ATTACHPOINT_LABELS[i].trim() + "/" + val.toString().trim() + "");
        }
        this.cachedHashCode = hashBase.toString().toUpperCase().hashCode();
        return this.cachedHashCode;
    }

    public void addNameSpace(String key, String value) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addNameSpace", new Object[]{key, value, this});
        }
        if (this.attachPoints.containsKey(key = key.toLowerCase())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Key is already contained in attachPoints " + key);
            }
            throw new WSPolicyInternalException();
        }
        this.nameSpaces.put(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addNameSpace");
        }
    }

    public void removeNameSpace(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNameSpace", new Object[]{key, this});
        }
        if (this.nameSpaces.containsKey(key = key.toLowerCase())) {
            this.nameSpaces.remove(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNameSpace");
        }
    }

    public void clearNameSpaces() {
        this.nameSpaces.clear();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < ATTACHPOINT_LABELS.length; ++i) {
            Serializable val = this.attachPoints.get(ATTACHPOINT_LABELS[i]);
            if (val == null) continue;
            result.append("[" + ATTACHPOINT_LABELS[i].trim() + ":" + val.toString().trim() + "]");
        }
        return result.toString();
    }

    public void validate(Definition definition) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{definition, this});
        }
        if (this.attachPoints.containsKey(PolicyConstants.ATTACH_SERVICE)) {
            this.ValidateServiceElement(definition);
        } else if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORTTYPE)) {
            this.ValidatePortTypeElement(definition);
        } else if (this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING)) {
            this.ValidateBindingElement(definition);
        } else if (this.attachPoints.containsKey(PolicyConstants.ATTACH_MESSAGE)) {
            this.ValidateMessageElement(definition);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private void ValidateServiceElement(Definition definition) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateServiceElement");
        }
        QName serviceQName = (QName)this.getValue(PolicyConstants.ATTACH_SERVICE);
        String portName = (String)this.getValue(PolicyConstants.ATTACH_PORT);
        Service service = null;
        Port port = null;
        Map<QName, Service> services = InternalUtils.getServices(definition);
        boolean isPort = false;
        if (serviceQName == null && services.size() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("serviceQName", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        service = serviceQName == null && services.size() == 1 ? (Service)services.values().toArray()[0] : services.get(serviceQName);
        if (service == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("service", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        if (this.attachPoints.containsKey(PolicyConstants.ATTACH_PORT)) {
            isPort = true;
            Map ports = service.getPorts();
            if (portName == null && ports.size() != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
            port = portName == null && ports.size() == 1 ? (Port)ports.values().toArray()[0] : (Port)ports.get(portName);
            if (port == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
        }
        this.clearAllValues();
        this.addValue(PolicyConstants.ATTACH_SERVICE, service.getQName());
        if (isPort) {
            this.addValue(PolicyConstants.ATTACH_PORT, port.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateServiceElement");
        }
    }

    private void ValidatePortTypeElement(Definition definition) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidatePortTypeElement");
        }
        QName portTypeQName = (QName)this.getValue(PolicyConstants.ATTACH_PORTTYPE);
        String operationName = (String)this.getValue(PolicyConstants.ATTACH_OPERATION);
        String inputName = (String)this.getValue(PolicyConstants.ATTACH_INPUT);
        String outputName = (String)this.getValue(PolicyConstants.ATTACH_OUTPUT);
        String faultName = (String)this.getValue(PolicyConstants.ATTACH_FAULT);
        PortType portType = null;
        Operation operation = null;
        Input input = null;
        Output output = null;
        Fault fault = null;
        Map<QName, PortType> portTypes = InternalUtils.getPortTypes(definition);
        boolean isOperation = false;
        boolean isInput = false;
        boolean isOutput = false;
        boolean isFault = false;
        if (portTypeQName == null && portTypes.size() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The portType is ambiguous");
            }
            throw new WSPolicyInternalException();
        }
        portType = portTypeQName == null && portTypes.size() == 1 ? (PortType)portTypes.values().toArray()[0] : portTypes.get(portTypeQName);
        if (portType == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portType", null, portTypeQName.toString(), null, null));
            }
            throw new WSPolicyInternalException();
        }
        if (this.attachPoints.containsKey(PolicyConstants.ATTACH_OPERATION)) {
            isOperation = true;
            List operations = portType.getOperations();
            if (operationName == null && operations.size() != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portTypeOperation", null, portTypeQName.toString(), null, null));
                }
                throw new WSPolicyInternalException();
            }
            if (operationName == null && operations.size() == 1) {
                operation = (Operation)operations.get(0);
            } else {
                for (int i = 0; i < operations.size() && !(operation = (Operation)operations.get(i)).getName().equals(operationName); ++i) {
                }
            }
            if (operation == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portTypeOperation", null, portTypeQName.toString(), null, null));
                }
                throw new WSPolicyInternalException();
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_INPUT)) {
                isInput = true;
                input = operation.getInput();
                if (input.getName() != null && inputName != null && !input.getName().equals(inputName)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portTypeInput", null, portTypeQName.toString(), null, null));
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_OUTPUT)) {
                isOutput = true;
                output = operation.getOutput();
                if (output != null && output.getName() != null && outputName != null && !output.getName().equals(outputName)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portTypeOutput", null, portTypeQName.toString(), null, null));
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_FAULT)) {
                isFault = true;
                fault = operation.getFault(faultName);
                if (faultName != null && !fault.getName().equals(faultName)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("portTypeFault", null, portTypeQName.toString(), null, null));
                    }
                    throw new WSPolicyInternalException();
                }
            }
        }
        this.clearAllValues();
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portType.getQName());
        if (isOperation) {
            this.addValue(PolicyConstants.ATTACH_OPERATION, operation.getName());
            if (isInput) {
                this.addValue(PolicyConstants.ATTACH_INPUT, inputName);
            } else if (isOutput) {
                this.addValue(PolicyConstants.ATTACH_OUTPUT, outputName);
            } else if (isFault) {
                this.addValue(PolicyConstants.ATTACH_FAULT, fault.getName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidatePortTypeElement");
        }
    }

    private void ValidateBindingElement(Definition definition) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateBindingElement");
        }
        QName bindingQName = (QName)this.getValue(PolicyConstants.ATTACH_BINDING);
        String bindingOperationName = (String)this.getValue(PolicyConstants.ATTACH_BINDING_OPERATION);
        String bindingInputName = (String)this.getValue(PolicyConstants.ATTACH_BINDING_INPUT);
        String bindingOutputName = (String)this.getValue(PolicyConstants.ATTACH_BINDING_OUTPUT);
        String bindingFaultName = (String)this.getValue(PolicyConstants.ATTACH_BINDING_FAULT);
        Binding binding = null;
        BindingOperation bindingOperation = null;
        BindingInput bindingInput = null;
        BindingOutput bindingOutput = null;
        BindingFault bindingFault = null;
        Map<QName, Binding> bindings = InternalUtils.getBindings(definition);
        boolean isOperation = false;
        boolean isInput = false;
        boolean isOutput = false;
        boolean isFault = false;
        if (bindingQName == null && bindings.size() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The binding is ambiguous");
            }
            throw new WSPolicyInternalException();
        }
        if (bindingQName == null && bindings.size() == 1) {
            Set<QName> keys = bindings.keySet();
            binding = bindings.get(keys.toArray()[0]);
        } else {
            binding = bindings.get(bindingQName);
        }
        if (binding == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("binding", null, bindingQName.toString(), null, null));
            }
            throw new WSPolicyInternalException();
        }
        if (this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OPERATION)) {
            isOperation = true;
            List operations = binding.getBindingOperations();
            if (bindingOperationName == null && operations.size() != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("bindingOperation", null, bindingQName.toString(), null, null));
                }
                throw new WSPolicyInternalException();
            }
            bindingOperation = bindingOperationName == null && operations.size() == 1 ? (BindingOperation)operations.get(0) : binding.getBindingOperation(bindingOperationName, null, null);
            if (bindingOperation == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("bindingOperation", null, bindingQName.toString(), bindingOperationName, null));
                }
                throw new WSPolicyInternalException();
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_INPUT)) {
                isInput = true;
                bindingInput = bindingOperation.getBindingInput();
                if (bindingInput.getName() != null && bindingInputName != null && !bindingInput.getName().equals(bindingInputName) && bindingOperation == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("bindingInput", null, bindingQName.toString(), bindingOperationName, bindingInputName));
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_OUTPUT)) {
                isOutput = true;
                bindingOutput = bindingOperation.getBindingOutput();
                if (bindingOutput != null && bindingOutput.getName() != null && bindingOutputName != null && !bindingOutput.getName().equals(bindingOutputName) && bindingOperation == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("bindingOutput", null, bindingQName.toString(), bindingOperationName, bindingOutputName));
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (this.attachPoints.containsKey(PolicyConstants.ATTACH_BINDING_FAULT)) {
                isFault = true;
                bindingFault = bindingOperation.getBindingFault(bindingFaultName);
                if (bindingFaultName != null && !bindingFault.getName().equals(bindingFaultName)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("bindingFault", null, bindingQName.toString(), bindingOperationName, bindingFaultName));
                    }
                    throw new WSPolicyInternalException();
                }
            }
        }
        this.clearAllValues();
        this.addValue(PolicyConstants.ATTACH_BINDING, binding.getQName());
        if (isOperation) {
            this.addValue(PolicyConstants.ATTACH_BINDING_OPERATION, bindingOperation.getName());
            if (isInput) {
                this.addValue(PolicyConstants.ATTACH_BINDING_INPUT, bindingInputName);
            } else if (isOutput) {
                this.addValue(PolicyConstants.ATTACH_BINDING_OUTPUT, bindingOutputName);
            } else if (isFault) {
                this.addValue(PolicyConstants.ATTACH_BINDING_FAULT, bindingFault.getName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateBindingElement");
        }
    }

    private void ValidateMessageElement(Definition definition) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateMessageElement");
        }
        QName messageQName = (QName)this.getValue(PolicyConstants.ATTACH_MESSAGE);
        Map<QName, Message> messages = InternalUtils.getMessages(definition);
        Message message = null;
        if (messageQName == null && messages.size() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The message Qname is ambiguous");
            }
            throw new WSPolicyInternalException();
        }
        message = messageQName == null && messages.size() == 1 ? (Message)messages.values().toArray()[0] : messages.get(messageQName);
        if (message == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified WSDL attachment point cannot be found in this WSDL or in any referenced WSDLs", InternalUtils.traceStringWSDLNode("messageQName", null, null, messageQName.toString(), null));
            }
            throw new WSPolicyInternalException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateMessageElement");
        }
    }

    @Override
    public QName getElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(QName elementType) {
        this.elementType = elementType;
    }

    public String getScopeLevel() {
        return this._scopeLevel;
    }

    public String getAttachPointType() {
        return this._attachPoint;
    }

    public void setServiceAttachPoint(QName serviceQName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceAttachPoint", new Object[]{serviceQName, this});
        }
        this.addValue(PolicyConstants.ATTACH_SERVICE, serviceQName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceAttachPoint");
        }
    }

    public void setPortAttachPoint(QName serviceQName, String portName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortAttachPoint", new Object[]{serviceQName, portName, this});
        }
        this.addValue(PolicyConstants.ATTACH_SERVICE, serviceQName);
        this.addValue(PolicyConstants.ATTACH_PORT, portName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortAttachPoint");
        }
    }

    public void setPortTypeAttachPoint(QName portTypeQName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortTypeAttachPoint", new Object[]{portTypeQName, this});
        }
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portTypeQName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortTypeAttachPoint");
        }
    }

    public void setPortTypeOperationAttachPoint(QName portTypeQName, String operationName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortTypeOperationAttachPoint", new Object[]{portTypeQName, operationName, this});
        }
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portTypeQName);
        this.addValue(PolicyConstants.ATTACH_OPERATION, operationName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortTypeOperationAttachPoint");
        }
    }

    public void setPortTypeInputMessageAttachPoint(QName portTypeQName, String operationName, String inputName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortTypeInputMessageAttachPoint", new Object[]{portTypeQName, operationName, inputName, this});
        }
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portTypeQName);
        this.addValue(PolicyConstants.ATTACH_OPERATION, operationName);
        if (inputName == null || inputName.equals("")) {
            inputName = operationName + "Request";
        }
        this.addValue(PolicyConstants.ATTACH_INPUT, inputName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortTypeInputMessageAttachPoint");
        }
    }

    public void setPortTypeOutputMessageAttachPoint(QName portTypeQName, String operationName, String outputName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortTypeOutputMessageAttachPoint", new Object[]{portTypeQName, operationName, outputName, this});
        }
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portTypeQName);
        this.addValue(PolicyConstants.ATTACH_OPERATION, operationName);
        if (outputName == null || outputName.equals("")) {
            outputName = operationName + "Response";
        }
        this.addValue(PolicyConstants.ATTACH_OUTPUT, outputName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortTypeOutputMessageAttachPoint");
        }
    }

    public void setPortTypeFaultMessageAttachPoint(QName portTypeQName, String operationName, String faultName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortTypeFaultMessageAttachPoint", new Object[]{portTypeQName, operationName, faultName, this});
        }
        this.addValue(PolicyConstants.ATTACH_PORTTYPE, portTypeQName);
        this.addValue(PolicyConstants.ATTACH_OPERATION, operationName);
        this.addValue(PolicyConstants.ATTACH_FAULT, faultName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortTypeFaultMessageAttachPoint");
        }
    }

    public void setBindingAttachPoint(QName bindingQName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBindingAttachPoint", new Object[]{bindingQName, this});
        }
        this.addValue(PolicyConstants.ATTACH_BINDING, bindingQName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBindingAttachPoint");
        }
    }

    public void setBindingOperationAttachPoint(QName bindingQName, String bindingOperationName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBindingOperationAttachPoint", new Object[]{bindingQName, bindingOperationName, this});
        }
        this.addValue(PolicyConstants.ATTACH_BINDING, bindingQName);
        this.addValue(PolicyConstants.ATTACH_BINDING_OPERATION, bindingOperationName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBindingOperationAttachPoint");
        }
    }

    public void setBindingInputMessageAttachPoint(QName bindingQName, String bindingOperationName, String bindingInputName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBindingInputMessageAttachPoint", new Object[]{bindingQName, bindingOperationName, bindingInputName, this});
        }
        this.addValue(PolicyConstants.ATTACH_BINDING, bindingQName);
        this.addValue(PolicyConstants.ATTACH_BINDING_OPERATION, bindingOperationName);
        if (bindingInputName == null || bindingInputName.equals("")) {
            bindingInputName = bindingOperationName + "Request";
        }
        this.addValue(PolicyConstants.ATTACH_BINDING_INPUT, bindingInputName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBindingInputMessageAttachPoint");
        }
    }

    public void setBindingOutputMessageAttachPoint(QName bindingQName, String bindingOperationName, String bindingOutputName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBindingOutputMessageAttachPoint", new Object[]{bindingQName, bindingOperationName, bindingOutputName, this});
        }
        this.addValue(PolicyConstants.ATTACH_BINDING, bindingQName);
        this.addValue(PolicyConstants.ATTACH_BINDING_OPERATION, bindingOperationName);
        if (bindingOutputName == null || bindingOutputName.equals("")) {
            bindingOutputName = bindingOperationName + "Response";
        }
        this.addValue(PolicyConstants.ATTACH_BINDING_OUTPUT, bindingOutputName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBindingOutputMessageAttachPoint");
        }
    }

    public void setBindingFaultMessageAttachPoint(QName bindingQName, String bindingOperationName, String bindingFaultName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBindingFaultMessageAttachPoint", new Object[]{bindingQName, bindingOperationName, bindingFaultName, this});
        }
        this.addValue(PolicyConstants.ATTACH_BINDING, bindingQName);
        this.addValue(PolicyConstants.ATTACH_BINDING_OPERATION, bindingOperationName);
        this.addValue(PolicyConstants.ATTACH_BINDING_FAULT, bindingFaultName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBindingFaultMessageAttachPoint");
        }
    }

    public void setMessageAttachPoint(QName messageQName) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageAttachPoint", new Object[]{messageQName, this});
        }
        this.addValue(PolicyConstants.ATTACH_MESSAGE, messageQName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageAttachPoint");
        }
    }
}

