/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyIncorrectScopePointAttachment;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import com.ibm.ws.wspolicy.operators.Operator;
import com.ibm.ws.wspolicy.policyset.WSPolicyTransformImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetWrapper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicySetWrapper.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final String _policySetName;
    private final String _bindingName;
    private final String _bindingScope;
    private final List<PolicyElement> _peList;
    private final List<List<Integer>> _attachList;
    private static final WSPolicyTransformImpl _transformer = new WSPolicyTransformImpl();
    private static final PolicyFactory _policyFactory = new PolicyFactory();
    private static final PolicyReader _policyReader = _policyFactory.newPolicyReader();
    private static final PolicyProviderRegistry _ppr = PolicyProviderRegistry.getInstance();

    public PolicySetWrapper(String policySetName, String bindingName, String bindingScope, String pathName, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicySetWrapper CTOR", new Object[]{policySetName, bindingName});
        }
        this._policySetName = policySetName;
        this._bindingName = bindingName;
        this._bindingScope = bindingScope;
        this._peList = new ArrayList<PolicyElement>();
        this._attachList = new ArrayList<List<Integer>>();
        List types = null;
        try {
            types = PolicySetAttachmentsImpl.getTypesForPolicySet(this._policySetName);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.exit(TRACE_COMPONENT, "exception getting types for PolicySet", new Object[]{this._policySetName, e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "120", this);
            throw new WSPolicyInternalException();
        }
        if (types == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR - no policyTypes in policySet");
            }
            return;
        }
        ClassLoader appCL = this.getClass().getClassLoader();
        ClassLoader systemCL = this.getClass().getClassLoader();
        PolicySetConfiguration psCfg = PolicyTypeAggregator.getPolicySetConfiguration(systemCL, policySetName, types);
        psCfg.setPolicyTypeConfiguration("attachmentType", "application");
        BindingAggregator.getCustomBinding(pathName, bindingName, appCL, systemCL, psCfg, types, "application", bindingScope);
        this.init(psCfg, uri);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR");
        }
    }

    public PolicySetWrapper(PolicySetConfiguration psCfg, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicySetWrapper CTOR", new Object[]{psCfg, uri});
        }
        this._policySetName = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY");
        this._bindingName = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY");
        this._bindingScope = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY");
        this._peList = new ArrayList<PolicyElement>();
        this._attachList = new ArrayList<List<Integer>>();
        this.init(psCfg, uri);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR");
        }
    }

    public void init(PolicySetConfiguration psCfg, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        try {
            Set<String> allTypes = _ppr.getAllDomainTypes();
            Iterator<String> typeIterator = allTypes.iterator();
            HashMap<String, Object> transformOptions = new HashMap<String, Object>();
            transformOptions.put("com.ibm.ws.wspolicy.PolicySetConfiguration", psCfg);
            transformOptions.put("com.ibm.ws.wspolicy.URI", uri);
            while (typeIterator.hasNext()) {
                Integer attachPt;
                Iterator<Integer> it;
                WSPolicyIncorrectScopePointAttachment wspispa;
                List<Integer> otherAttachList;
                Assertion otherAssertion;
                WSPolicyIncorrectScopePointAttachment wspispa2;
                Iterator<PolicyElement> iter;
                WSPolicyInternalException wspie;
                Vector<PolicyElement> v;
                ExactlyOneOperator eo;
                List<Integer> tempAttachList;
                Assertion assertion;
                Vector<Policy> vp;
                String policyType = typeIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "init processing policyType", new Object[]{policyType});
                }
                if (policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport") || policyType.equals("WSAddressing")) {
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "skipping policyType", new Object[]{policyType});
                    continue;
                }
                Policy mainPolicy = null;
                Policy inputPolicy = null;
                Policy outputPolicy = null;
                WSPolicyAssertionProcessor wspap = _ppr.getAssertionProcessorByType(policyType);
                if (wspap == null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "unable to obtain the assertion processor for policyType ", policyType);
                    }
                    WSPolicyInternalException wspie2 = new WSPolicyInternalException();
                    FFDCFilter.processException((Throwable)wspie2, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "163", this);
                    throw wspie2;
                }
                PolicyInputStreamHolder psih = _transformer.transformForPublish(transformOptions, policyType);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Processing policies ", new Object[]{psih.getMain(), psih.getInput(), psih.getOutput()});
                }
                if (psih.getMain() != null && (vp = _policyReader.readPolicies(psih.getMain())) != null && !vp.isEmpty()) {
                    mainPolicy = vp.get(0);
                }
                if (psih.getInput() != null && (vp = _policyReader.readPolicies(psih.getInput())) != null && !vp.isEmpty()) {
                    inputPolicy = vp.get(0);
                }
                if (psih.getOutput() != null && (vp = _policyReader.readPolicies(psih.getOutput())) != null && !vp.isEmpty()) {
                    outputPolicy = vp.get(0);
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "policies after merge of type ", new Object[]{mainPolicy, inputPolicy, outputPolicy});
                }
                List<PolicyElement> peList = null;
                if (mainPolicy != null) {
                    peList = this.getWrappedAssertions(mainPolicy);
                    for (PolicyElement pe : peList) {
                        assertion = null;
                        tempAttachList = null;
                        if (pe instanceof Assertion) {
                            assertion = (Assertion)((Object)pe);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                            }
                            tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                        } else if (pe instanceof ExactlyOneOperator) {
                            eo = (ExactlyOneOperator)pe;
                            v = eo.getLeafChildren();
                            if (v.isEmpty()) {
                                wspie = new WSPolicyInternalException();
                                FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "262", this);
                                throw wspie;
                            }
                            iter = v.iterator();
                            assertion = (Assertion)((Object)iter.next());
                            tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                            if (tempAttachList == null) {
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                                }
                                wspispa2 = new WSPolicyIncorrectScopePointAttachment(assertion);
                                FFDCFilter.processException((Throwable)wspispa2, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "272", this);
                                throw wspispa2;
                            }
                            while (iter.hasNext()) {
                                otherAssertion = (Assertion)((Object)iter.next());
                                otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getAssertionName());
                                if (otherAttachList == null) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getAssertionName());
                                    }
                                    WSPolicyIncorrectScopePointAttachment wspispa3 = new WSPolicyIncorrectScopePointAttachment(otherAssertion);
                                    FFDCFilter.processException((Throwable)wspispa3, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "282", this);
                                    throw wspispa3;
                                }
                                tempAttachList.retainAll(otherAttachList);
                            }
                        }
                        if (tempAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                            }
                            wspispa = new WSPolicyIncorrectScopePointAttachment(mainPolicy);
                            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "295", this);
                            throw wspispa;
                        }
                        if (!(tempAttachList.contains(2) || tempAttachList.contains(3) || tempAttachList.contains(1) || tempAttachList.contains(0))) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion in main policy not have cannot be attached to an Endpoint, Service or Operation Policy Subject", assertion.getAssertionName());
                            }
                            wspispa = new WSPolicyIncorrectScopePointAttachment(mainPolicy);
                            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "305", this);
                            throw wspispa;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "attachList ", new Object[]{tempAttachList.toString()});
                        }
                        it = tempAttachList.iterator();
                        while (it.hasNext()) {
                            attachPt = it.next();
                            if (!this.isMessageSubject(attachPt)) continue;
                            it.remove();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "after attachList ", new Object[]{tempAttachList.toString()});
                        }
                        this._peList.add(pe);
                        this._attachList.add(tempAttachList);
                    }
                }
                if (inputPolicy != null) {
                    peList = this.getWrappedAssertions(inputPolicy);
                    for (PolicyElement pe : peList) {
                        assertion = null;
                        tempAttachList = null;
                        if (pe instanceof Assertion) {
                            assertion = (Assertion)((Object)pe);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                            }
                            tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                        } else if (pe instanceof ExactlyOneOperator) {
                            eo = (ExactlyOneOperator)pe;
                            v = eo.getLeafChildren();
                            if (v.isEmpty()) {
                                wspie = new WSPolicyInternalException();
                                FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "343", this);
                                throw wspie;
                            }
                            iter = v.iterator();
                            assertion = (Assertion)((Object)iter.next());
                            tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                            if (tempAttachList == null) {
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                                }
                                wspispa2 = new WSPolicyIncorrectScopePointAttachment(assertion);
                                FFDCFilter.processException((Throwable)wspispa2, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "353", this);
                                throw wspispa2;
                            }
                            while (iter.hasNext()) {
                                otherAssertion = (Assertion)((Object)iter.next());
                                otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getAssertionName());
                                if (otherAttachList == null) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getAssertionName());
                                    }
                                    WSPolicyIncorrectScopePointAttachment wspispa4 = new WSPolicyIncorrectScopePointAttachment(otherAssertion);
                                    FFDCFilter.processException((Throwable)wspispa4, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "363", this);
                                    throw wspispa4;
                                }
                                tempAttachList.retainAll(otherAttachList);
                            }
                        }
                        if (tempAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                            }
                            wspispa = new WSPolicyIncorrectScopePointAttachment(inputPolicy);
                            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "375", this);
                            throw wspispa;
                        }
                        if (!tempAttachList.contains(4)) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion in input policy cannot be attached to the bindingInput", assertion.getAssertionName());
                            }
                            wspispa = new WSPolicyIncorrectScopePointAttachment(inputPolicy);
                            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "381", this);
                            throw wspispa;
                        }
                        it = tempAttachList.iterator();
                        while (it.hasNext()) {
                            attachPt = it.next();
                            if (attachPt.equals(4)) continue;
                            it.remove();
                        }
                        this._peList.add(pe);
                        this._attachList.add(tempAttachList);
                    }
                }
                if (outputPolicy == null) continue;
                peList = this.getWrappedAssertions(outputPolicy);
                for (PolicyElement pe : peList) {
                    assertion = null;
                    tempAttachList = null;
                    if (pe instanceof Assertion) {
                        assertion = (Assertion)((Object)pe);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                        }
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                    } else if (pe instanceof ExactlyOneOperator) {
                        eo = (ExactlyOneOperator)pe;
                        v = eo.getLeafChildren();
                        if (v.isEmpty()) {
                            wspie = new WSPolicyInternalException();
                            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "413", this);
                            throw wspie;
                        }
                        iter = v.iterator();
                        assertion = (Assertion)((Object)iter.next());
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getAssertionName());
                        if (tempAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                            }
                            wspispa2 = new WSPolicyIncorrectScopePointAttachment(assertion);
                            FFDCFilter.processException((Throwable)wspispa2, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "421", this);
                            throw wspispa2;
                        }
                        while (iter.hasNext()) {
                            otherAssertion = (Assertion)((Object)iter.next());
                            otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getAssertionName());
                            if (otherAttachList == null) {
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getAssertionName());
                                }
                                WSPolicyIncorrectScopePointAttachment wspispa5 = new WSPolicyIncorrectScopePointAttachment(otherAssertion);
                                FFDCFilter.processException((Throwable)wspispa5, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "431", this);
                                throw wspispa5;
                            }
                            tempAttachList.retainAll(otherAttachList);
                        }
                    }
                    if (tempAttachList == null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getAssertionName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(outputPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "442", this);
                        throw wspispa;
                    }
                    if (!tempAttachList.contains(5)) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion in output policy cannot be attached to the bindingOutput", assertion.getAssertionName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(outputPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "448", this);
                        throw wspispa;
                    }
                    it = tempAttachList.iterator();
                    while (it.hasNext()) {
                        attachPt = it.next();
                        if (attachPt.equals(5)) continue;
                        it.remove();
                    }
                    this._peList.add(pe);
                    this._attachList.add(tempAttachList);
                }
            }
        }
        catch (PolicyReferenceException pre) {
            WSPolicyInternalException wspie = new WSPolicyInternalException(pre);
            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "467", this);
            throw wspie;
        }
        catch (UnsupportedPolicyElementException upe) {
            WSPolicyInternalException wspie = new WSPolicyInternalException(upe);
            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "471", this);
            throw wspie;
        }
        catch (UnsupportedNamespaceException une) {
            WSPolicyInternalException wspie = new WSPolicyInternalException(une);
            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "475", this);
            throw wspie;
        }
    }

    private List<PolicyElement> getWrappedAssertions(Operator oper) {
        List<Object> result = null;
        if (oper instanceof ExactlyOneOperator) {
            Vector children = oper.getChildAssertions();
            if (children.size() == 1) {
                PolicyElement child = (PolicyElement)children.get(0);
                if (child instanceof Operator) {
                    result = this.getWrappedAssertions((Operator)child);
                } else if (child instanceof AssertionImpl) {
                    result = new ArrayList();
                    result.add(child);
                }
            }
            if (result == null) {
                result = new ArrayList();
                result.add(oper);
            }
        } else if (oper instanceof AllOperator) {
            result = new ArrayList<Operator>();
            Vector children = oper.getChildAssertions();
            for (int i = 0; i < children.size(); ++i) {
                PolicyElement child = (PolicyElement)children.get(i);
                if (child instanceof Assertion) {
                    result.add(child);
                    continue;
                }
                if (!(child instanceof Operator)) continue;
                result.addAll(this.getWrappedAssertions((Operator)child));
            }
        }
        return result;
    }

    private boolean isMessageSubject(int attachpoint) {
        if (attachpoint == 4 || attachpoint == 5) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isMessageSubject", new Object[]{true});
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isMessageSubject", new Object[]{false});
        }
        return false;
    }

    public String getName() {
        String name = this._policySetName + "/" + this._bindingName + "/" + this._bindingScope;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getName", new Object[]{name});
        }
        return name;
    }

    public List<PolicyElement> getPolicyElementList() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyElementList", new Object[]{this._policySetName, this._bindingName});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyElementList", new Object[]{this._peList});
        }
        return this._peList;
    }

    public List<List<Integer>> getAttachPointList() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAttachPointList", new Object[]{this._policySetName, this._bindingName});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAttachPointList", new Object[]{this._attachList});
        }
        return this._attachList;
    }
}

