/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.attachment.SpikedMessage;
import com.ibm.ws.wspolicy.attachment.UsingPolicy;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.ws.wspolicy.utils.dom.PolicyDOMUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final TraceComponent tc = Tr.register(PolicySerializer.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final long serialVersionUID = 1L;
    private transient PolicyFactory factory;
    private transient PolicyWriter writer;
    private transient PolicyReader reader;
    private boolean readerCached = false;
    private transient PolicyContext _context = null;
    private transient PolicyWriterContext format;

    public PolicySerializer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySerializer");
        }
        this._context = new PolicyContext();
        this.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicySerializer");
        }
    }

    public PolicySerializer(PolicyContext pContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySerializer", pContext);
        }
        this._context = pContext;
        this.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicySerializer", this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._context = new PolicyContext();
        this.init();
    }

    private void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init", this);
        }
        this.factory = new PolicyFactory(this._context);
        this.writer = this.factory.newPolicyWriter();
        this.writer.setResolveReferences(false);
        if (this._context != null) {
            this.format = (PolicyWriterContext)this._context.getProperty("SerializerFormatting");
        }
        if (this.format == null) {
            this.format = new PolicyWriterContext();
        }
        this.format.setOmitXmlDecl(true);
        this.format.setIndenting(true);
        this.format.setLineSeparator("\n");
        if (this._context != null) {
            this._context.setProperty("SerializerFormatting", this.format);
        }
        this.reader = this.factory.newPolicyReader();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    @Override
    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshall", new Object[]{parentType, elementType, extension, pw, def, extReg, this});
        }
        if (extension == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "marshall");
            }
            return;
        }
        if (elementType.getLocalPart().equals(PolicyConstants.USING_POLICY) && elementType.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy")) {
            pw.print(PolicyConstants.USING_POLICY_XML);
        } else if (elementType.equals(SpikedMessage.SpikedMessageQName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "marshalling a SpikedMessage");
            }
            HashMap<String, String> namespaces2prefix = this.getDeclaredNamespaces(def);
            String wsdlPrefix = namespaces2prefix.get("http://schemas.xmlsoap.org/wsdl/");
            String spikeStr = null;
            String formattedString = ((SpikedMessage)extension).getFormattedString();
            spikeStr = wsdlPrefix == null ? "<wsdl:documentation xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"> " + formattedString + " </wsdl:documentation>" : (wsdlPrefix.equals("") ? "<documentation> " + formattedString + " </documentation>" : "<" + wsdlPrefix + ":documentation xmlns:" + wsdlPrefix + "=\"http://schemas.xmlsoap.org/wsdl/\"> " + formattedString + " </" + wsdlPrefix + ":documentation>");
            pw.print(spikeStr);
        } else {
            try {
                HashMap<String, String> namespaces2prefix = this.getDeclaredNamespaces(def);
                int indent = this.calculateIndent(parentType);
                PolicyContext policyContext = new PolicyContext();
                policyContext.setProperty("DeclaredNamespaces", namespaces2prefix);
                PolicyWriterContext newFormat = new PolicyWriterContext(this.format);
                newFormat.setIndentLevel(indent);
                policyContext.setProperty("SerializerFormatting", newFormat);
                if (extension instanceof UnknownExtensibilityElement) {
                    ExtensibilityElement p = InternalUtils.extractUnknownElement(def, extension, this.reader, policyContext);
                    this.writer.writePolicy((Policy)p, pw, policyContext);
                } else {
                    this.writer.writePolicy((Policy)extension, pw, policyContext);
                }
            }
            catch (WSPolicyException pe) {
                FFDCFilter.processException((Throwable)pe, this.getClass() + ".marshall", "186", this);
                throw new WSDLException("PARSER_ERROR", "Exception thrown parsing WS-Policy Extensibility Element", pe);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshall");
        }
    }

    private HashMap<String, String> getDeclaredNamespaces(Definition def) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeclaredNamespaces", new Object[]{def, this});
        }
        HashMap<String, String> namespace2prefix = new HashMap<String, String>();
        Map prefix2namespace = def.getNamespaces();
        Set p2nsESet = prefix2namespace.entrySet();
        for (Map.Entry entry : p2nsESet) {
            String prefix = (String)entry.getKey();
            String namespace = (String)entry.getValue();
            namespace2prefix.put(namespace, prefix);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeclaredNamespaces", namespace2prefix);
        }
        return namespace2prefix;
    }

    private int calculateIndent(Class parentType) {
        int indentCount = 1;
        if (parentType.equals(Message.class)) {
            indentCount = 2;
        } else if (parentType.equals(Definition.class)) {
            indentCount = 1;
        } else if (parentType.equals(PortType.class)) {
            indentCount = 2;
        } else if (parentType.equals(Operation.class)) {
            indentCount = 3;
        } else if (parentType.equals(Input.class)) {
            indentCount = 4;
        } else if (parentType.equals(Output.class)) {
            indentCount = 4;
        } else if (parentType.equals(Fault.class)) {
            indentCount = 4;
        } else if (parentType.equals(Binding.class)) {
            indentCount = 2;
        } else if (parentType.equals(BindingOperation.class)) {
            indentCount = 3;
        } else if (parentType.equals(BindingInput.class)) {
            indentCount = 4;
        } else if (parentType.equals(BindingFault.class)) {
            indentCount = 4;
        } else if (parentType.equals(BindingOutput.class)) {
            indentCount = 4;
        } else if (parentType.equals(Service.class)) {
            indentCount = 2;
        } else if (parentType.equals(Port.class)) {
            indentCount = 3;
        }
        return indentCount;
    }

    @Override
    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unmarshall", new Object[]{parentType, elementType, el, def, extReg, this});
        }
        Policy result = null;
        if (elementType.equals(PolicyConstants.WSP_POL_ELEMENT_QNAME) || elementType.equals(PolicyConstants.WSP_POLREF_ELEMENT_QNAME)) {
            try {
                if (!this.readerCached) {
                    this.cacheReader(def);
                }
                this.reader.setLocation(def.getDocumentBaseURI());
                if (elementType.equals(PolicyConstants.WSP_POL_ELEMENT_QNAME)) {
                    result = this.reader.readPolicy(el);
                }
                result = new PolicyReference(this._context, null);
                PolicyDOMUtils.parseAttributes(result, el);
                ((PolicyReference)result).setReader(this.reader);
            }
            catch (WSPolicyException pe) {
                FFDCFilter.processException((Throwable)pe, this.getClass() + "unmarshall", "290", this);
                throw new WSDLException("PARSER_ERROR", "Exception thrown parsing WS-Policy Extensibility Element", pe);
            }
        } else if (elementType.equals(PolicyConstants.WSP_USINGPOLICY_ELEMENT_QNAME)) {
            UsingPolicy usingPolicy = new UsingPolicy();
            usingPolicy.setPolicyReader(this.reader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unmarshall");
            }
            return usingPolicy;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unmarshall", result);
        }
        return result;
    }

    private void cacheReader(Definition definition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheReader", new Object[]{definition, this});
        }
        boolean foundExisting = false;
        List eeList = definition.getExtensibilityElements();
        if (eeList != null) {
            for (ExtensibilityElement ee : eeList) {
                if (!(ee instanceof UsingPolicy)) continue;
                UsingPolicy usingPolicy = (UsingPolicy)ee;
                this.reader = usingPolicy.getPolicyReader();
                foundExisting = true;
                break;
            }
        }
        if (!foundExisting) {
            UsingPolicy usingPolicy = new UsingPolicy();
            usingPolicy.setPolicyReader(this.reader);
            usingPolicy.setSerialize(false);
            definition.addExtensibilityElement(usingPolicy);
        }
        this.readerCached = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheReader");
        }
    }
}

